package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @ClassName: IpGoodsEvaluationPageDto
 * @Author: liujunfeng
 * @Date: 2019/10/29 16:55
 * @description:
 */
@Data
public class IpGoodsEvaluationPageDto extends BasePageDto{

    @ApiModelProperty(value = "评论人ID" )
    private String evaluationId;

    @ApiModelProperty(value = "评论人名称" )
    private String evaluationName;

    @ApiModelProperty(value = "评论时间" )
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date evaluationDate;

    @ApiModelProperty(value = "订单商品id" )
    private Long ordergoodsId;

    @ApiModelProperty(value = "订单id" )
    private Long orderId;

    @ApiModelProperty(value = "商品id" )
    private Long goodsId;

    @ApiModelProperty(value = "商品名称" )
    private String goodsName;

    @ApiModelProperty(value = "综合评分(1.极差,2.失望,3.一般,4.满意,5.惊喜)" )
    private String comprehensiveScore;

    @ApiModelProperty(value = "商品资料(1.极差,2.失望,3.一般,4.满意,5.惊喜)" )
    private String goodsData;

    @ApiModelProperty(value = "物流效率(1.极差,2.失望,3.一般,4.满意,5.惊喜)" )
    private String logisticsEfficiency;

    @ApiModelProperty(value = "问题描述" )
    private String problemDescribe;

    @ApiModelProperty(value = "照片url" )
    private String pictureUrl;

    @ApiModelProperty(value = "是否为追评(Y，N)" )
    private String additional;

    @ApiModelProperty(value = "评论ID" )
    private Integer additionalId;

}
