package com.ekingwin.bas.cloud.goods.service.impl;

import com.ekingwin.bas.cloud.dao.*;
import com.ekingwin.bas.cloud.dto.IpGoodsSearchDto;
import com.ekingwin.bas.cloud.dto.IpGoodsSolrDto;
import com.ekingwin.bas.cloud.entity.IpGoodProcess;
import com.ekingwin.bas.cloud.entity.IpGoodsImg;
import com.ekingwin.bas.cloud.entity.IpGoodsPrice;
import com.ekingwin.bas.cloud.entity.IpSearchHistory;
import com.ekingwin.bas.cloud.goods.dao.SupplierGoodsDao;
import com.ekingwin.bas.cloud.goods.dao.entity.Supplier;
import com.ekingwin.bas.cloud.goods.dao.entity.SupplierGoods;
import com.ekingwin.bas.cloud.goods.dto.SupplierGoodsDetail;
import com.ekingwin.bas.cloud.goods.dto.SupplierGoodsDto;
import com.ekingwin.bas.cloud.goods.service.SupplierGoodsService;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.util.*;
import com.ekingwin.bas.cloud.vo.GoodsDeatilVo;
import com.ekingwin.bas.cloud.vo.GoodsSupplierInfoVo;
import com.ekingwin.bas.cloud.vo.IpGoodsPriceVo;
import com.ekingwin.bas.cloud.vo.IpGoodsSuppliersVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
@Primary
public class SupplierGoodsServiceImpl implements SupplierGoodsService  {
    private Logger logger = LoggerFactory.getLogger(SupplierGoodsServiceImpl.class);
    @Value("${dataSourceName}")
    private String basUrl;

    @Value("${goods.solr.queryData}")
    private String queryData;
    @Value("${goods.baseurl}")
    private String baseurl;
    @Value("${goods.detailurl}")
    private String filePath;
    @Value("${goods.baseurls}")
    private String baseurls;
    @Autowired
    private IpGoodsImgMapper ipGoodsImgMapper;
    @Autowired
    private IpGoodsSolrMapper ipGoodsSolrMapper;
    @Autowired
    private IpGoodsMapper goodsMapper;
    @Autowired
    private IpGoodsSuppliersMapper ipGoodsSuppliersMapper;
    @Autowired
    private IpGoodsPriceMapper ipGoodsPriceMapper;
    @Autowired
    private SupplierGoodsDao supplierGoodsDao;
    @Autowired
    private IpSearchHistoryMapper ipSearchHistoryMapper;

    @Override
    public String getsQueryData(IpGoodsSearchDto ipGoodsSearchDto) throws Exception{

        IpGoodsSolrDto ipGoodsSolrDto = new IpGoodsSolrDto();
        ipGoodsSolrDto.setPageNo(ipGoodsSearchDto.getPageIndex());
        ipGoodsSolrDto.setPageSize(ipGoodsSearchDto.getPageSize());
        //关键字
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getKeyword())){
            ipGoodsSolrDto.setJiucaiyun_keywords(ipGoodsSearchDto.getKeyword());
            //保存搜索记录
            this.saveSearchHistory(ipGoodsSearchDto);
        }
        //分类ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getCategoryid())){
            String categoryid=ipGoodsSearchDto.getCategoryid();
            //一级
            if (ipGoodsSearchDto.getCategoryGrade()==0 || ipGoodsSearchDto.getCategoryGrade()==1){
                List<String> cateList=ipGoodsSolrMapper.getCategoryId(ipGoodsSearchDto);
                if (cateList !=null && cateList.size()>0){
                    categoryid=String.join(",",cateList);
                }
            }
            ipGoodsSolrDto.setJiucaiyun_catalog(categoryid);
        }
        //品牌
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getBrand())){
            ipGoodsSolrDto.setJiucaiyun_brand(ipGoodsSearchDto.getBrand());
        }
        //商品所属类型
        String categoryType = ipGoodsSearchDto.getCategoryType();
        if (StringUtils.isNotEmpty(categoryType)){
            categoryType=categoryType;
        }else{
            if (StringUtils.isEmpty(ipGoodsSearchDto.getCustomerType())){
                categoryType="XM";

            }else {
                categoryType=ipGoodsSearchDto.getCustomerType();
            }
        }
        ipGoodsSolrDto.setJiucaiyun_ftnpjc(categoryType);


        //商品类型
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getFtnpconfiguration())){
            ipGoodsSolrDto.setJiucaiyun_ftnpconfiguration(ipGoodsSearchDto.getFtnpconfiguration());
        }
        //类型
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getType())){
            ipGoodsSolrDto.setJiucaiyun_type(ipGoodsSearchDto.getType());
        }
        //供应商ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getSuppliernum())){
            ipGoodsSolrDto.setJiucaiyun_suppliernum(ipGoodsSearchDto.getSuppliernum());
        }

        //供应商ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getSupplierid())){
            ipGoodsSolrDto.setJiucaiyun_supplierid(ipGoodsSearchDto.getSupplierid());
        }

        //供应商ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getModel())){
            ipGoodsSolrDto.setJiucaiyun_model(ipGoodsSearchDto.getModel());
        }
        String floorPrice=ipGoodsSearchDto.getFloorPrice();
        String ceilingPrice=ipGoodsSearchDto.getCeilingPrice();
        String jiucaiyunPrice="*";
        if(StringUtils.isNotEmpty(floorPrice)&&
                StringUtils.isNotEmpty(ceilingPrice)){
            jiucaiyunPrice=floorPrice+"-"+ceilingPrice;
        }else if(StringUtils.isNotEmpty(floorPrice)&&StringUtils.isEmpty(ceilingPrice)){
            jiucaiyunPrice=floorPrice;
        }else if(StringUtils.isEmpty(floorPrice)&&StringUtils.isNotEmpty(ceilingPrice)){
            jiucaiyunPrice="0-"+ceilingPrice;
        }
        ipGoodsSolrDto.setJiucaiyun_price(jiucaiyunPrice);

        String orderName=ipGoodsSearchDto.getOrderName();

        if (StringUtils.isNotEmpty(orderName)){
            if (orderName.equals("sales") ) {
                ipGoodsSolrDto.setJiucaiyun_salesvolume_order(ipGoodsSearchDto.getOrderRule());
            } else if (orderName.equals("price")) {
                ipGoodsSolrDto.setJiucaiyun_price_order(ipGoodsSearchDto.getOrderRule());
            }
        }


        //判断是否开启岗位验证
        String isJobVerification=ipGoodsSearchDto.getIsJobVerification();
        String custType=ipGoodsSearchDto.getCustType();

        String salaes="";
        //开启岗位验证,判断是否是外部用户默认为外部用户
        String companyId=ipGoodsSearchDto.getCompanyId();
        if (StringUtils.isNotEmpty(custType)&& !custType.equals("Y") && !"GR".equals(categoryType)) {
            if (isJobVerification.equals("Y")){
                salaes=ipGoodsSolrMapper.getParentTree(basUrl,companyId);
            }else{
                List<String> uersOrg=this.getUserOrg(ipGoodsSearchDto.getUserid(),companyId);
                if (uersOrg !=null && uersOrg.size()>0){
                    salaes=String.join(",",uersOrg);
                }
            }
        }
        ipGoodsSolrDto.setJiucaiyun_permission(salaes);
        String jsonStr= JSONObject.fromObject(ipGoodsSolrDto).toString();
        logger.info(jsonStr);
        String result= HttpXmlClient.post1(jsonStr,queryData);
        return  result;
    }
    @Override
    public Supplier  queryData(SupplierGoodsDto supplierGoodsDto) throws Exception {

        Supplier supplier =supplierGoodsDao.querySupplier(supplierGoodsDto);
        PageHelper.startPage(supplierGoodsDto.getPagenum(),supplierGoodsDto.getPagesize());
        List<Map<String,Object>> list=supplierGoodsDao.querySupplierGoods(supplierGoodsDto);

        if(supplier!=null&&list!=null&&list.size()>0){
            for(Map<String,Object> map:list){
               map.put("path",baseurl+ map.get("path"));
            }
           supplier.setGoodsList(list);
       }
        return  supplier;
    }

    @Override
    public GoodsDeatilVo getGoodsDetail(SupplierGoodsDetail supplierGoodsDetail) throws Exception {
        GoodsDeatilVo goodsDeatilVo = null;
        if (StringUtils.isNotEmpty(supplierGoodsDetail.getGoodsId())) {
            goodsDeatilVo = this.getGoodsDetailByGoodsId(supplierGoodsDetail.getGoodsId(), null);
        }
        if (goodsDeatilVo != null) {
            Map<String, Object> goodsMap = goodsDeatilVo.getGoodsMap();
            if (StringUtils.isNotEmpty(goodsMap.get("supplierid"))) {
                String supplierid = goodsMap.get("supplierid").toString();
                GoodsSupplierInfoVo goodsSuppliersById = ipGoodsSuppliersMapper.getGoodsSuppliersById(supplierid);
                goodsSuppliersById.setSuppliernum(supplierid);
                goodsDeatilVo.setSupplierInfo(goodsSuppliersById);
            }
        }
        return goodsDeatilVo;

    }




    private void saveSearchHistory(IpGoodsSearchDto ipGoodsSearchDto){
        IpSearchHistory ipSearchHistory =new IpSearchHistory();
        ipSearchHistory.setInputdate(DateUtils.format(new Date(),DateUtils.DATE_TIME_PATTERN));
        ipSearchHistory.setState("Y");
        ipSearchHistory.setKeyword(ipGoodsSearchDto.getKeyword());
        ipSearchHistory.setInputperson(ipGoodsSearchDto.getUserid());
        ipSearchHistory.setResultnum(0);
        ipSearchHistory.setBasUrl(basUrl);
        ipSearchHistoryMapper.insertSelective(ipSearchHistory);
    }
    /**
     * 获取当前登录人所在组织
     * @param userId
     * @return
     */
    private List<String> getUserOrg(String userId,String companyId){
        List<String> stringList=null;
        Set<String> orgStr = new HashSet<String>();
        String string=ipGoodsSolrMapper.getTree(basUrl,companyId);
        if (StringUtils.isNotEmpty(string)){
            String [] sts=string.split(",");
            if (sts.length>0){
                for (String st : sts) {
                    orgStr.add(st);
                }
            }
        }
        String strs=ipGoodsSolrMapper.getParentTree(basUrl,companyId);
        if (StringUtils.isNotEmpty(strs)){
            String [] sts=strs.split(",");
            if (sts.length>0){
                for (String st : sts) {
                    orgStr.add(st);
                }
            }
        }
        stringList=new ArrayList<>(orgStr);
        return  stringList;
    }
    /**
     * 根据商品获取详情
     *
     * @param goodId
     * @return
     * @throws Exception
     */
    private GoodsDeatilVo getGoodsDetailByGoodsId(Long goodId, String goodsnum) throws Exception {
        GoodsDeatilVo goodsDeatilVo = new GoodsDeatilVo();
        Map<String, Object> map = this.getGoodsMap(goodId, goodsnum);
        if(StringUtils.isNotEmpty(map)){
            //获取商品详情
            if (StringUtils.isNotEmpty(map.get("details"))) {
                String detailPath = map.get("details").toString();
                //获取商品1详情
                String detail = ReadTxtUtil.readFile(filePath + detailPath);
                if (!detail.contains(baseurl)) {
                    detail = detail.replaceAll(baseurls, baseurl);
                }
                goodsDeatilVo.setDetails(detail);
            }


            //获取规格参数
            if (StringUtils.isNotEmpty(map.get("description"))) {
                String descriptionPath = map.get("description").toString();
                //获取规格参数
                String description = ReadTxtUtil.readFile(filePath + descriptionPath);
                if (!description.contains(baseurl)) {
                    description = description.replaceAll(baseurls, baseurl);
                }
                goodsDeatilVo.setDescription(description);
            }


            goodsDeatilVo.setGoodsMap(map);

            //获取图片
            IpGoodsImg ipGoodsImg = ipGoodsImgMapper.selectByGoodsid(goodId);
            if (ipGoodsImg != null) {
                goodsDeatilVo.setUrlid(ipGoodsImg.getGoodsimgid());
            }

            //获取图片path
            List<String> urlPath = ipGoodsImgMapper.selectImgPath(goodId);
            List<String> utlPathList = new ArrayList<String>();
            if (urlPath != null && urlPath.size() > 0) {
                for (String s : urlPath) {
                    utlPathList.add(baseurl + s);
                }
            }
            goodsDeatilVo.setUrlpath(utlPathList);

            /**
             * 获取商品价格
             */
            //goodsDeatilVo.setPriceList(this.getAllGoodsPrice(goodId));

            /**
             * 获取运费信息
             */
           // goodsDeatilVo.setSuppliersList(this.getAllGoodsSupplier(goodId));


            goodsDeatilVo.setGoodsId(goodId);
        }else{
            throw  new BusinessException(500,"该商品信息存在异常，请联系管理员!");
        }
        //
        return goodsDeatilVo;
    }
    /**
     * 获取商品运费
     *
     * @param goodId
     * @return
     * @throws Exception
     */
    private List<IpGoodsSuppliersVo> getAllGoodsSupplier(Long goodId) throws Exception {
        List<IpGoodsSuppliersVo> ipGoodsPrices = ipGoodsSuppliersMapper.selectByGoodsId(goodId);
        return ipGoodsPrices;
    }
    /**
     * 获取商品价格
     *
     * @param goodId
     * @return
     * @throws Exception
     */
    private List<IpGoodsPriceVo> getAllGoodsPrice(Long goodId) throws Exception {
        List<IpGoodsPrice> ipGoodsPrices = ipGoodsPriceMapper.getDetailByGoodsid(goodId);
        List<IpGoodsPriceVo> ipGoodsPriceVoList = new ArrayList<IpGoodsPriceVo>();
        if (ipGoodsPrices != null && ipGoodsPrices.size() > 0) {
            IpGoodsPriceVo ipGoodsPriceVo = null;
            for (IpGoodsPrice goodsPrice : ipGoodsPrices) {
                ipGoodsPriceVo = new IpGoodsPriceVo();
                MapObjUtil.copy(goodsPrice, ipGoodsPriceVo);
                ipGoodsPriceVo.setPriceId(goodsPrice.getId().toString());
                ipGoodsPriceVoList.add(ipGoodsPriceVo);
            }
        }
        return ipGoodsPriceVoList;
    }
    /**
     * 获取商品详情
     *
     * @param goodId
     * @param goodsnum
     * @return
     */
    private Map<String, Object> getGoodsMap(Long goodId, String goodsnum) {
        Map<String, Object> map = null;
        if (StringUtils.isNotEmpty(goodsnum)) {
            map = goodsMapper.getGoodsDetailByNum(goodsnum);
        } else {
            map = goodsMapper.getGoodsDetail(goodId);
        }
        return map;
    }
}

