package com.ekingwin.bas.cloud.protal.service;

import com.ekingwin.bas.cloud.protal.dto.AdvertiseListDto;
import com.ekingwin.bas.cloud.protal.dto.SalesListDto;
import com.ekingwin.bas.cloud.protal.dto.SupplierPageMessageDto;
import com.ekingwin.bas.cloud.protal.vo.*;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface ICommodityManagementService {
    /**
     * 销售量排行榜
     */
    PageInfo SalesList(SalesListVo salesListVo);


    /**
     * 销售量排行榜首页显示
     * @param salesListDto
     * @return
     */
    Result TheHomepage(List<SalesListDto> salesListDto);

    /**
     * 销售量排行榜商品分类
     * @param goodsClassifyVo
     * @return
     */
    Result GoodsClassify(GoodsClassifyVo goodsClassifyVo);

    /**
     * 开票信息和收货地址列表接口
     * @param invoiceShipAddressListVo
     * @return
     */
    PageInfo InvoiceShipAddressList(InvoiceShipAddressListVo invoiceShipAddressListVo);

    /**
     * 开票信息和收货地址列表接口新增中的子接口查询公司名
     * @param invoiceShipAddressListVo
     * @return
     */
    PageInfo InvoiceShipAddressAddCompany(InvoiceShipAddressListVo invoiceShipAddressListVo);

    /**
     * 开票信息和收货地址列表接口新增
     * @param shipAddressAddVo
     * @param
     */
    Result invoiceShipAddressAdd(InvoiceShipAddressAddVo shipAddressAddVo);

    /**
     * 开票信息和收货地址列表接口编辑
     * @param shipAddressAddVo
     * @return
     */
    Result invoiceShipAddressUpdate(InvoiceShipAddressAddVo shipAddressAddVo);

    /**
     * 开票信息和收货地址列表接口删除
     * @param shipAddressAddVo
     * @return
     */
    Result invoiceShipAddressDelete(InvoiceShipAddressAddVo shipAddressAddVo);

    /**
     * 广告位列表查询接口
     * @param advertiseListVo
     * @return
     */
    PageInfo AdvertiseList(AdvertiseListVo advertiseListVo);



    /**
     * 广告位列表新增子接口广告位编号查询
     * @return
     */
    Result AdvertiseAddCode();



    /**
     * 广告位列表新增
     * @return
     */
    Result AdvertiseAdd(AdvertiseAddVo advertiseAddVo);

    /**
     * 广告位列表编辑
     * @param advertiseAddVo
     * @return
     */
    Result AdvertiseUpdate(AdvertiseAddVo advertiseAddVo);

    /**
     * 广告位列表删除
     * @param advertiseAddVo
     * @return
     */
    Result AdvertiseDelete(AdvertiseAddVo advertiseAddVo);

    /**
     * 商品库商品分类
     * @param goodsClassifyVo
     * @return
     */
    Result GoodsClassifys(GoodsClassifyVo goodsClassifyVo);

    /**
     * 通威商品库查询
     * @param goodsBrandListVo
     * @return
     */
    PageInfo GoodsBrandList(GoodsBrandListVo goodsBrandListVo);

    /**
     * 商品库新增中基本信息子接口的商品名称查询
     * @param materielImportVo
     * @return
     */
    PageInfo MaterielImport(MaterielImportVo materielImportVo);

    /**
     * 商品库新增中基本信息子接口的供应商名称查询
     * @param supplierMaterielVo
     * @return
     */
    PageInfo querySupplierMateriel(SupplierMaterielVo supplierMaterielVo);

    /**
     * 商品库新增销售区域查询
     * @param goodsClassifyVo
     * @return
     */
    Result querySalesareaName(GoodsClassifyVo goodsClassifyVo);

    /**
     * 商品库更改状态为下架
     * @param goodsBrandSoldOutVo
     * @return
     */
    Result GoodsBrandSoldOut(GoodsBrandSoldOutVo goodsBrandSoldOutVo);

    /**
     * 商品库更改状态为上架发起
     * @param goodsBrandSoldOutVo
     * @return
     */
    Result GoodsBrandOnTheAudit(GoodsBrandOnTheAuditVo goodsBrandSoldOutVo);

    /**
     * 商品库更改状态为上架审批回传
     * @param map
     * @return
     */
    Result goodsUpOrDownProcessRest_PS(Map<String, Object> map);

    /**
     * 通威商品库新增
     * @param goodsBrandAddVo
     * @return
     */
    Result GoodsBrandAdd(GoodsBrandAddVo goodsBrandAddVo);

    /**
     * 通威商品库编辑
     * @param goodsBrandAddVo
     * @return
     */
    Result GoodsBrandUpdate(GoodsBrandAddVo goodsBrandAddVo);

    /**
     * 图片上传
     * @param inputStream
     * @param name
     * @param fileMeta
     * @return
     */
    Result FileUploaded(InputStream inputStream, String name, Map<String, String[]> fileMeta);


    /**
     * 通威商品库查看
     * @param id
     * @return
     */
    Result GoodsQueryOne(Integer id);

}
