package com.ekingwin.bas.cloud.protal.service.Impl;

import com.ekingwin.bas.cloud.protal.dao.SupplierListMessageMapper;
import com.ekingwin.bas.cloud.protal.dto.SupplierListMessageDto;
import com.ekingwin.bas.cloud.protal.dto.SupplierPageMessageDto;
import com.ekingwin.bas.cloud.protal.service.ISupplierListMessageService;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Primary
public class SupplierListMessageServiceImpl implements ISupplierListMessageService {


    @Autowired
    private SupplierListMessageMapper supplierListMessageMapper;



    /**
     * 查询供应商在售商品全部信息
     *
     * @param
     * @return
     */
    @Override
    public List<SupplierListMessageDto> querySupplierListMessageAll() {
        ArrayList list = new ArrayList();
        String goods = "[]";
        List<SupplierListMessageDto> supplierListMessageDto = supplierListMessageMapper.querySupplierListMessageAll();
        for (int i = 0; i < supplierListMessageDto.size(); i++) {
            SupplierListMessageDto listMessageDto = supplierListMessageDto.get(i);
            listMessageDto.setGoods(goods);
            list.add(listMessageDto);
        }
        return list;
    }

    /**
     * 根据供应商名称或者编码模糊查询供应商信息
     * @param
     * @return
     */
    @Override
    public PageInfo querySupplierBasicMessageByFullnameOrNum(SupplierPageMessageDto supplierPageMessageDto) {
       PageHelper.startPage(supplierPageMessageDto.getPageNum(),supplierPageMessageDto.getPageSize());
            ArrayList list = new ArrayList();
            String goods = "[]";
        List<SupplierListMessageDto> supplierListMessageDtos = supplierListMessageMapper.querySupplierBasicMessageByFullnameOrNum(supplierPageMessageDto);
        for (int i = 0; i < supplierListMessageDtos.size(); i++) {
                SupplierListMessageDto supplierListMessageDto = supplierListMessageDtos.get(i);
                supplierListMessageDto.setGoods(goods);
                list.add(supplierListMessageDto);
            }
        PageInfo pageInfo = new PageInfo<>(list);
            return pageInfo;

    }
}





