package com.ekingwin.bas.cloud.quartz.underframe.service.impl;

import com.ekingwin.bas.cloud.dto.IpGoodsLogsQuartzDto;
import com.ekingwin.bas.cloud.dto.IpGoodsQuartzDto;
import com.ekingwin.bas.cloud.quartz.underframe.dao.UnderFrameDao;
import com.ekingwin.bas.cloud.quartz.underframe.service.UnderFrameService;
import com.ekingwin.bas.cloud.service.IpGoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @ClassName: UnderFrameServiceImpl
 * @Author: liujunfeng
 * @Date: 2020/1/14 11:05
 * @description:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class UnderFrameServiceImpl implements UnderFrameService {

    @Autowired
    UnderFrameDao underFrameDao;

    @Autowired
    IpGoodsService ipGoodsService;

    @Override
    public void updateGoodsTask() throws Exception {
        List<IpGoodsQuartzDto> goodsQuartzDtoList = underFrameDao.selectGoods();
        if (goodsQuartzDtoList != null && goodsQuartzDtoList.size() >0){
            IpGoodsLogsQuartzDto goodsLogsQuartzDto;
            for (IpGoodsQuartzDto goodsQuartzDto : goodsQuartzDtoList){
                //更新商品
                underFrameDao.updateGoods(goodsQuartzDto.getId());
                goodsLogsQuartzDto = new IpGoodsLogsQuartzDto();
                goodsLogsQuartzDto.setGoodsid(goodsQuartzDto.getId());
                goodsLogsQuartzDto.setOperatetype("失效");
                goodsLogsQuartzDto.setOperatedate(new Date());
                goodsLogsQuartzDto.setPrice(goodsQuartzDto.getPrice());
                goodsLogsQuartzDto.setSuccessdate(goodsQuartzDto.getSuccessdate());
                goodsLogsQuartzDto.setSubmitpeople("系统到期");
                goodsLogsQuartzDto.setSubmitpeoplename("系统到期");
                goodsLogsQuartzDto.setSalesarea(goodsQuartzDto.getSalesarea());
                goodsLogsQuartzDto.setSalesareaname(goodsQuartzDto.getSalesareaname());
                //商品操作日志记录
                underFrameDao.saveGoodsLogs(goodsLogsQuartzDto);
                if (goodsQuartzDto.getFtnpjc() == null || "XM".equals(goodsQuartzDto.getFtnpjc())) {
                    //同步SAP
                    ipGoodsService.initGoodsSapId("03", String.valueOf(goodsQuartzDto.getId()),"X");
                }
            }
        }
    }
}
