package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpGoodFavoriteMapper;
import com.ekingwin.bas.cloud.dto.IpGoodFavoriteSearchDto;
import com.ekingwin.bas.cloud.service.IpGoodFavoriteService;
import com.ekingwin.bas.cloud.vo.IpGoodFavoriteSearchVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:商品收藏
 * @author: zhangjie
 * @create: 2019-08-08 17:33
 **/
@Service
@Primary
public class IpGoodFavoriteServiceImpl implements IpGoodFavoriteService {


    @Autowired
    private IpGoodFavoriteMapper ipGoodFavoriteMapper;

    @Value("${goods.baseurl}")
    private String baseurl;

    /**
     * 获取收藏列表
     * @param ipGoodFavoriteSearchDto
     * @return
     */
    @Override
    public PageInfo<IpGoodFavoriteSearchVo> getGoodsFavorite(IpGoodFavoriteSearchDto ipGoodFavoriteSearchDto) {
        ipGoodFavoriteSearchDto.setGoodsPath(baseurl);
        PageHelper.startPage(ipGoodFavoriteSearchDto.getPagenum(),ipGoodFavoriteSearchDto.getPagesize());
        List<IpGoodFavoriteSearchVo> goodFootMapperGoodFoot =ipGoodFavoriteMapper.getGoodFavorite(ipGoodFavoriteSearchDto);
        PageInfo<IpGoodFavoriteSearchVo>  pageInfo=new PageInfo<>(goodFootMapperGoodFoot);
        return  pageInfo;
    }
}
