package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpGoodsMapper;
import com.ekingwin.bas.cloud.dao.IpGoodsSolrMapper;
import com.ekingwin.bas.cloud.dao.IpSearchHistoryMapper;
import com.ekingwin.bas.cloud.dto.IpGoodsSearchDto;
import com.ekingwin.bas.cloud.dto.IpGoodsSolrDto;
import com.ekingwin.bas.cloud.dto.IpLicensornameDto;
import com.ekingwin.bas.cloud.entity.IpSearchHistory;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.service.IpGoodsSolrService;
import com.ekingwin.bas.cloud.util.DateUtils;
import com.ekingwin.bas.cloud.util.HttpXmlClient;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.IpLicensornameVo;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-26 10:11
 **/
@Service
@Primary
public class IpGoodsSolrServiceImpl implements IpGoodsSolrService {

    private Logger logger = LoggerFactory.getLogger(IpGoodsSolrServiceImpl.class);


    @Value("${dataSourceName}")
    private String basUrl;
    @Autowired
    private IpGoodsSolrMapper ipGoodsSolrMapper;

    @Value("${goods.solr.queryData}")
    private String queryData;

    @Autowired
    private IpGoodsMapper ipGoodsMapper;

    @Autowired
    private IpSearchHistoryMapper ipSearchHistoryMapper;

    @Override
    public String getsSolrData(IpGoodsSearchDto ipGoodsSearchDto) throws Exception{

        IpGoodsSolrDto ipGoodsSolrDto = new IpGoodsSolrDto();
        ipGoodsSolrDto.setPageNo(ipGoodsSearchDto.getPageIndex());
        ipGoodsSolrDto.setPageSize(ipGoodsSearchDto.getPageSize());
        //关键字
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getKeyword())){
            ipGoodsSolrDto.setJiucaiyun_keywords(ipGoodsSearchDto.getKeyword());
            //保存搜索记录
            this.saveSearchHistory(ipGoodsSearchDto);
        }
        //分类ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getCategoryid())){
            String categoryid=ipGoodsSearchDto.getCategoryid();
            //一级
            if (ipGoodsSearchDto.getCategoryGrade()==0 || ipGoodsSearchDto.getCategoryGrade()==1){
                List<String> cateList=ipGoodsSolrMapper.getCategoryId(ipGoodsSearchDto);
                if (cateList !=null && cateList.size()>0){
                    categoryid=String.join(",",cateList);
                }
            }
            ipGoodsSolrDto.setJiucaiyun_catalog(categoryid);
        }
        //品牌
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getBrand())){
            ipGoodsSolrDto.setJiucaiyun_brand(ipGoodsSearchDto.getBrand());
        }
        //商品所属类型
        String categoryType = ipGoodsSearchDto.getCategoryType();
        if (StringUtils.isNotEmpty(categoryType)){
            categoryType=categoryType;
        }else{
            if (StringUtils.isEmpty(ipGoodsSearchDto.getCustomerType())){
                categoryType="XM";

            }else {
                categoryType=ipGoodsSearchDto.getCustomerType();
            }
        }
        ipGoodsSolrDto.setJiucaiyun_ftnpjc(categoryType);


        //商品类型
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getFtnpconfiguration())){
            ipGoodsSolrDto.setJiucaiyun_ftnpconfiguration(ipGoodsSearchDto.getFtnpconfiguration());
        }
        //类型
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getType())){
            ipGoodsSolrDto.setJiucaiyun_type(ipGoodsSearchDto.getType());
        }
        //供应商ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getSuppliernum())){
            ipGoodsSolrDto.setJiucaiyun_suppliernum(ipGoodsSearchDto.getSuppliernum());
        }

        //供应商ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getSupplierid())){
            ipGoodsSolrDto.setJiucaiyun_supplierid(ipGoodsSearchDto.getSupplierid());
        }

        //供应商ID
        if (StringUtils.isNotEmpty(ipGoodsSearchDto.getModel())){
            ipGoodsSolrDto.setJiucaiyun_model(ipGoodsSearchDto.getModel());
        }
        String floorPrice=ipGoodsSearchDto.getFloorPrice();
        String ceilingPrice=ipGoodsSearchDto.getCeilingPrice();
        String jiucaiyunPrice="*";
        if(StringUtils.isNotEmpty(floorPrice)&&
                StringUtils.isNotEmpty(ceilingPrice)){
            jiucaiyunPrice=floorPrice+"-"+ceilingPrice;
        }else if(StringUtils.isNotEmpty(floorPrice)&&StringUtils.isEmpty(ceilingPrice)){
            jiucaiyunPrice=floorPrice;
        }else if(StringUtils.isEmpty(floorPrice)&&StringUtils.isNotEmpty(ceilingPrice)){
            jiucaiyunPrice="0-"+ceilingPrice;
        }
        ipGoodsSolrDto.setJiucaiyun_price(jiucaiyunPrice);

        String orderName=ipGoodsSearchDto.getOrderName();

        if (StringUtils.isNotEmpty(orderName)){
            if (orderName.equals("sales") ) {
                ipGoodsSolrDto.setJiucaiyun_salesvolume_order(ipGoodsSearchDto.getOrderRule());
            } else if (orderName.equals("price")) {
                ipGoodsSolrDto.setJiucaiyun_price_order(ipGoodsSearchDto.getOrderRule());
            }
        }


        //判断是否开启岗位验证
        String isJobVerification=ipGoodsSearchDto.getIsJobVerification();
        String custType=ipGoodsSearchDto.getCustType();

        String salaes="";
        //开启岗位验证,判断是否是外部用户默认为外部用户
        String companyId=ipGoodsSearchDto.getCompanyId();
        if (StringUtils.isNotEmpty(custType)&& !custType.equals("Y") && !"GR".equals(categoryType)) {
            if (isJobVerification.equals("Y")){
                salaes=ipGoodsSolrMapper.getParentTree(basUrl,companyId);
            }else{
                List<String> uersOrg=this.getUserOrg(ipGoodsSearchDto.getUserid(),companyId);
                if (uersOrg !=null && uersOrg.size()>0){
                    salaes=String.join(",",uersOrg);
                }
            }
        }
        ipGoodsSolrDto.setJiucaiyun_permission(salaes);
        String jsonStr= JSONObject.fromObject(ipGoodsSolrDto).toString();
        logger.info(jsonStr);
        String result=HttpXmlClient.post1(jsonStr,queryData);
        return  result;
    }


    /**
     * 获取当前登录人所在组织
     * @param userId
     * @return
     */
    private List<String> getUserOrg(String userId,String companyId){
        List<String> stringList=null;
            Set<String> orgStr = new HashSet<String>();
                String string=ipGoodsSolrMapper.getTree(basUrl,companyId);
                if (StringUtils.isNotEmpty(string)){
                    String [] sts=string.split(",");
                    if (sts.length>0){
                        for (String st : sts) {
                            orgStr.add(st);
                        }
                    }
                }
                String strs=ipGoodsSolrMapper.getParentTree(basUrl,companyId);
                if (StringUtils.isNotEmpty(strs)){
                    String [] sts=strs.split(",");
                    if (sts.length>0){
                        for (String st : sts) {
                            orgStr.add(st);
                        }
                    }
                }
            stringList=new ArrayList<>(orgStr);
        return  stringList;
    }

    /**
     * 获取商品的授权区域
     */
    @Override
    public List<IpLicensornameVo>  getLicensorname(IpLicensornameDto ipLicensornameDto){
        //获取三级分类
        String categoryId=ipGoodsMapper.getGoodsThreeCategory(ipLicensornameDto.getId());
        if (StringUtils.isEmpty(categoryId)){
         throw  new BusinessException(500,"未获取到商品信息");
        }
        ipLicensornameDto.setCategoryId(categoryId);
        ipLicensornameDto.setBaseUrl(basUrl);
        //判断是否开启岗位验证
        String isJobVerification=ipLicensornameDto.getIsJobVerification();
        String custType=ipLicensornameDto.getCustType();
        String salaes="";
        //开启岗位验证

        if (isJobVerification.equals("Y")){
            salaes=ipGoodsSolrMapper.getParentTree(basUrl,ipLicensornameDto.getCompanyId());
            String [] salaess=salaes.split(",");
            salaes=String.join("|",salaess);
        }else{
            List<String> uersOrg=this.getUserOrg(ipLicensornameDto.getUserid(),ipLicensornameDto.getCompanyId());
            if (uersOrg !=null && uersOrg.size()>0){
                salaes=String.join("|",uersOrg);
            }
        }

        if (custType.equals("Y")){
            salaes="";
        }else{
            if (StringUtils.isEmpty(salaes)){
                throw  new BusinessException(500,"未获取到用户信息");
            }
        }
        ipLicensornameDto.setSalaes(salaes);

        List<IpLicensornameVo> licensornameVos=ipGoodsSolrMapper.getLicensorname(ipLicensornameDto);

        return licensornameVos;
    }


    private void saveSearchHistory(IpGoodsSearchDto ipGoodsSearchDto){
        IpSearchHistory ipSearchHistory =new IpSearchHistory();
        ipSearchHistory.setInputdate(DateUtils.format(new Date(),DateUtils.DATE_TIME_PATTERN));
        ipSearchHistory.setState("Y");
        ipSearchHistory.setKeyword(ipGoodsSearchDto.getKeyword());
        ipSearchHistory.setInputperson(ipGoodsSearchDto.getUserid());
        ipSearchHistory.setResultnum(0);
        ipSearchHistory.setBasUrl(basUrl);
        ipSearchHistoryMapper.insertSelective(ipSearchHistory);
    }

}
