package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-27 17:43
 **/
@Data
@ApiModel("商品价格")
public class IpGoodsPriceVo {

    @ApiModelProperty(value = "价格ID")
    private Long id;

    @ApiModelProperty(value = "客户类型",required = true)
    private String custType;

    @ApiModelProperty(value = "客户类型标识",required = true)
    private String custCode;

    @ApiModelProperty(value = "企业ID",required = true)
    private String companyId;

    @ApiModelProperty(value = "企业名称",required = true)
    private String companyName;

    @ApiModelProperty(value = "价格类型",required = true)
    private String priceType;

    @ApiModelProperty(value = "价格标识",required = true)
    private String priceCode;

    @ApiModelProperty(value = "含税价格",required = true)
    private BigDecimal taxPrice;

    @ApiModelProperty(value = "不含税价格",required = true)
    private BigDecimal notaxPrice;


    @ApiModelProperty(value = "调价额度",required = false)
    private BigDecimal modifyPrice;

    @ApiModelProperty(value = "颜色",required = false)
    private String speciColor;

    @ApiModelProperty(value = "型号",required = false)
    private String speciModel;

    @ApiModelProperty(value = "尺寸",required = false)
    private String speciSize;

    @ApiModelProperty(value = "其他",required = false)
    private String speciOther;

    @ApiModelProperty(value = "税率",required = false)
    private String taxrate;

    @ApiModelProperty(value = "含税单价",required = false)
    private String allPrice;

    @ApiModelProperty(value = "不含税单价",required = false)
    private String allOutPrice;

    @ApiModelProperty(value = "销售价格",required = false)
    private String freightprice;

    @ApiModelProperty(value = "库存",required = false)
    private String stock;

    @ApiModelProperty(value = "是否默认",required = false)
    private String isDefault;

    @ApiModelProperty(value = "商品价格主数据")
    private String priceId;
}
