package com.ekingwin.bas.cloud.web;


import com.ekingwin.bas.cloud.dto.GoodsCategoryDto;
import com.ekingwin.bas.cloud.dto.GoodsCategoryTreeDto;
import com.ekingwin.bas.cloud.dto.IpGoodsCategoryDto;
import com.ekingwin.bas.cloud.dto.SaveGoodsCategoryDto;
import com.ekingwin.bas.cloud.service.IClassifyServie;
import com.ekingwin.bas.cloud.service.impl.IpGoodsServiceImpl;
import com.ekingwin.bas.cloud.util.BackResult;
import com.ekingwin.bas.cloud.util.PublicJsonObject;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.GoodsCategoryTreeVo;
import com.ekingwin.bas.cloud.vo.IpGoodsCategoryDetailVo;
import com.ekingwin.bas.cloud.vo.IpThirdCategoryInfoVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/classify")
@Api(tags = "物资分类管理", description = "物资分类管理", value = "物资分类管理")
public class ClassifyController {

    @Resource
    private IClassifyServie iClassifyServie;

    @Autowired
    private IpGoodsServiceImpl ipGoodsService;

   @PostMapping(value = "/getThirdClassify")
   @ApiOperation(value = "根据供应商获取物资三级分类",notes = "根据供应商获取物资三级分类")
   public Result getThirdClassify(@RequestBody IpGoodsCategoryDto ipGoodsCategoryDto) throws Exception{
     PageInfo classifyList = iClassifyServie.getThirdClassify(ipGoodsCategoryDto);
     return Result.ok(classifyList);
   }

   @PostMapping(value = "/getGoodsCategoryInfo")
   @ApiOperation(value = "获取商品三级分类",notes = "获取商品三级分类")
   public Result getGoodsCategoryInfo(@RequestBody IpGoodsCategoryDto ipGoodsCategoryDto) throws Exception{
       List<IpGoodsCategoryDetailVo> categoryDetailVoList = iClassifyServie.getThirdClassifyBy(ipGoodsCategoryDto);
     return Result.ok(categoryDetailVoList);
   }

   @PostMapping(value = "/getThirdGoodsInfo/{categoryId}")
    @ApiOperation(value = "获取每一级分类的详情",notes = "获取每一级分类的详情")
    public Result getThirdGoodsInfo(@PathVariable(value = "categoryId") String categoryId) throws Exception{
       IpThirdCategoryInfoVo  ipThirdCategoryInfoVo = iClassifyServie.getGoodsCategoryInfo(categoryId);
       return Result.ok(ipThirdCategoryInfoVo);
   }


   @PostMapping(value = "/saveCategoryInfo")
    @ApiOperation(value = "新增修改分类信息",notes = "新增分类详情")
    public Result saveOrUpdateCategoryInfo(@RequestBody SaveGoodsCategoryDto saveGoodsCategoryDto) throws Exception{
       iClassifyServie.saveOrUpdateCategoryInfo(saveGoodsCategoryDto);
       if (StringUtils.isNotEmpty(saveGoodsCategoryDto.getId())){
           //更新商品表对应的分类信息
           GoodsCategoryDto param = new GoodsCategoryDto();
           param.setCategoryId(saveGoodsCategoryDto.getId());
           ipGoodsService.updateGoodsCategory(param);
       }
       return Result.ok();
   }

   @PostMapping(value = "/deleteCategoryInfo/{goodsCategoryid}")
   @ApiOperation(value = "删除分类信息",notes = "删除分类信息")
    public Result deleteCategoryInfo(@PathVariable(value = "goodsCategoryid")String categoryId) throws Exception{
       iClassifyServie.deleteCategoryInfo(categoryId);
       return Result.ok();
   }

   @PostMapping(value = "getGoodsCategoryInfoByLevel")
   @ApiOperation(value = "根据查询等级获取分类等级",notes = "根据查询等级获取分类等级")
   public Result getGoodsCategoryInfoByLevel(@RequestBody IpGoodsCategoryDto ipGoodsCategoryDto) throws Exception{
       List<IpGoodsCategoryDetailVo> categoryDetailVoList = iClassifyServie.getGoodsCategoryInfoByLevel(ipGoodsCategoryDto);
       return Result.ok(categoryDetailVoList);
   }


    @PostMapping(value = "getGoodsCategoryTree")
    @ApiOperation(value = "根据分类id和供应商编码获取销售区域",notes = "根据分类id和供应商编码获取销售区域")
    public Result getGoodsCategoryTree(@RequestBody GoodsCategoryTreeDto goodsCategoryTreeDto) throws Exception{
        List<GoodsCategoryTreeVo> categoryDetailVoList = iClassifyServie.getGoodsCategoryTree(goodsCategoryTreeDto);
        return Result.ok(categoryDetailVoList);
    }

    @ApiOperation("获取商品分类")
    @RequestMapping(value = "/getAllGoodsCategInfo", method = RequestMethod.GET)
    public BackResult getAllGoodsCategInfo(@RequestParam(value = "companyid") String companyid)throws Exception{
        List<Map<String, Object>> portalAuthority = iClassifyServie.getAllGoodsCategInfo( companyid);
        return PublicJsonObject.jsonObject(portalAuthority);
    }

}
