package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpGoodFavoriteSearchDto;
import com.ekingwin.bas.cloud.service.IpGoodFavoriteService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpGoodFavoriteSearchVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-08-08 15:34
 **/
@RestController
@RequestMapping(value = "/goodsFavorite/")
@Api(tags = "商品收藏", description = "商品收藏", value = "商品收藏")
public class IpGoodFavoriteController {

    @Autowired
    private IpGoodFavoriteService ipGoodFavoriteService;



    @ApiOperation(value = "查询收藏商品", notes = "查询收藏商品",response = IpGoodFavoriteSearchVo.class)
    @PostMapping(value = "/getGoodsFavorite")
    public Result getGoodsFavorite(@RequestBody IpGoodFavoriteSearchDto ipGoodsSearchDto) throws  Exception{
        PageInfo<IpGoodFavoriteSearchVo> pageInfo=ipGoodFavoriteService.getGoodsFavorite(ipGoodsSearchDto);
        return  Result.ok(pageInfo);
    }
}
