package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpGoodFootSearchDto;
import com.ekingwin.bas.cloud.service.IpGoodFootService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.IpGoodFootSearchVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-08-08 15:34
 **/
@RestController
@RequestMapping(value = "/goodsFoot/")
@Api(tags = "商品足迹", description = "商品足迹", value = "商品足迹")
public class IpGoodFootController {

    @Autowired
    private IpGoodFootService ipGoodFootService;



    @ApiOperation(value = "查询浏览足迹", notes = "查询浏览足迹",response = IpGoodFootSearchVo.class)
    @PostMapping(value = "/getGoodsFoot")
    public Result getGoodsFoot(@RequestBody IpGoodFootSearchDto ipGoodsSearchDto) throws  Exception{
        PageInfo<IpGoodFootSearchVo> pageInfo=ipGoodFootService.getGoodsFoot(ipGoodsSearchDto);
        return  Result.ok(pageInfo);
    }
}
