package com.ekingwin.bas.cloud.enrollment.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import com.ekingwin.bas.cloud.dataDictionary.dto.DataDictionaryOptionDto;
import com.ekingwin.bas.cloud.dataDictionary.service.IDataDictionaryOptionService;
import com.ekingwin.bas.cloud.enrollment.dao.EnrollmentCodeDao;
import com.ekingwin.bas.cloud.enrollment.dao.EnrollmentDao;
import com.ekingwin.bas.cloud.enrollment.dao.entity.Enrollment;
import com.ekingwin.bas.cloud.enrollment.dao.entity.EnrollmentCode;
import com.ekingwin.bas.cloud.enrollment.dto.EnrollmentCodeDto;
import com.ekingwin.bas.cloud.enrollment.service.IEnrollmentCodeService;
import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;
import com.ekingwin.bas.cloud.mail.dto.MailInfoDto;
import com.ekingwin.bas.cloud.mail.service.IMailService;
import com.ekingwin.bas.cloud.util.StringUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Primary
@Service
public class EnrollmentCodeServiceImpl extends BaseService implements IEnrollmentCodeService {
	@Autowired
	private EnrollmentCodeDao dao;
	
	@Autowired
	private EnrollmentDao enrollmentDao;
	
	@Autowired
	@Qualifier(value = "mailServiceImpl")
	private IMailService mailService;
	
	@Autowired
	@Qualifier(value = "dataDictionaryOptionServiceImpl")
	private IDataDictionaryOptionService dataDictionaryOptionService;
	@Override
	public boolean save(EnrollmentCodeDto object) throws BasException {
		try {
			String email = object.getEmail();
			
			List<Map<String, Object>> employeeList = enrollmentDao.getEmployeeByMobilephoneEmpuidEmail(email);
			if(employeeList.size()>0){
				throw new BasException("邮箱已经是九彩云账号，请直接登陆！");
			}
			try {
				Map<String, Object> params =  new  HashMap<String, Object>();
				List<String> receivers = new ArrayList<String>();
				List<String> list = new ArrayList<String>();
				receivers.add(object.getEmail());
				Date nowtime = new Date();
				
				String code=""+nowtime.getTime();
				String p = "";
				// 获取code，注册信息ID+当前时间
				List<Enrollment> enrollmentList = enrollmentDao.getByMobilephone(object.getMobilephone());
				if(enrollmentList.size()>0){
					code = enrollmentList.get(0).getId()+nowtime.getTime();
				}
				//对code进行MD5加密
				MessageDigest digest = MessageDigest.getInstance("MD5");
	            byte[] result = digest.digest(code.getBytes());
	            StringBuffer buffer = new StringBuffer();
	            // 把每一个byte 做一个与运算 0xff;
	            for (byte b : result) {
	                // 与运算
	                int number = b & 0xff;// 加盐 暂时不做
	                String str = Integer.toHexString(number);
	                if (str.length() == 1) {
	                    buffer.append("0");
	                }
	                buffer.append(str);
	            }
	            // 标准的md5加密后的结果
	            code = buffer.toString();
	            //对code进行再次MD5加密，获取P值
	            result = digest.digest(code.getBytes());
	            buffer = new StringBuffer();
	            // 把每一个byte 做一个与运算 0xff;
	            for (byte b : result) {
	                // 与运算
	                int number = b & 0xff;// 加盐 暂时不做
	                String str = Integer.toHexString(number);
	                if (str.length() == 1) {
	                    buffer.append("0");
	                }
	                buffer.append(str);
	            }
	            // 标准的md5加密后的结果
	            p = buffer.toString();
	            
	            
	            List<DataDictionaryOptionDto> dataDictionaryOptionDtoList= dataDictionaryOptionService.getByDictionaryen("jcycompanyinfo");
	            String url = StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "jcywebsiteurl"))+ "/organization/user/view/finish-data.html";
	            url+="?code="+code+"&p="+p;
	            params.put("url", url);
				params.put("email", StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "email")));
				params.put("tel", StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "tel")));
				params.put("fax", StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "fax")));
				params.put("empuid", object.getMobilephone());
				params.put("companyurl", StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "companyurl")));
				MailInfoDto mail = new MailInfoDto();
				mail.setParams(params);
				mail.setTemplate("enrollmentCodeTemplate.ftl");
				mail.setReceivers(receivers);
				mail.setSubject("九彩云账号激活");
				mail.setBcc(list);
				mail.setCc(list);
				object.setCode(code);
				save(object, EnrollmentCode.class, dao);
				mailService.sendMailWithTemplate(mail );
				enrollmentDao.updateEmailByMobilephone(object.getMobilephone(),email);
				
			} catch (Exception e) {
				throw new BasException("邮件发送失败");
			}
			
		} catch (Exception e) {
			throw new BasException(e.getMessage());
		}
		return false;
	}

	@Override
	public boolean delete(String id) throws BasException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public PageCriteria<EnrollmentCodeDto> query(QueryDTO query) throws BasException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EnrollmentCodeDto get(String id) throws BasException {
		EnrollmentCodeDto enrollmentCodeDto = get(EnrollmentCodeDto.class, id,
				dao);
		return enrollmentCodeDto;
	}

	@Override
	public BaseResult<EnrollmentCodeDto> verificationcode(EnrollmentCodeDto enrollmentCodeDto) throws BasException {
		BaseResult<EnrollmentCodeDto> baseResult = new BaseResult<EnrollmentCodeDto>();
		baseResult.setTimestamp(String.valueOf(new Date().getTime()));
		baseResult.setPath(WebUtils.getRequest().getRequestURI());
		String code = enrollmentCodeDto.getCode();
		String p = enrollmentCodeDto.getP();
		try {
			if(code==null || p == null ){
				baseResult.setStatus("500");
				baseResult.setMessage("请求参数错误！");
				return baseResult;
			}
			String codemd5 = "";
			//对code进行MD5加密
			MessageDigest digest = MessageDigest.getInstance("MD5");
	        byte[] result = digest.digest(code.getBytes());
	        StringBuffer buffer = new StringBuffer();
	        // 把每一个byte 做一个与运算 0xff;
	        for (byte b : result) {
	            // 与运算
	            int number = b & 0xff;// 加盐 暂时不做
	            String str = Integer.toHexString(number);
	            if (str.length() == 1) {
	                buffer.append("0");
	            }
	            buffer.append(str);
	        }
	        // 标准的md5加密后的结果
	        codemd5 = buffer.toString();
	        if(!p.equals(codemd5)){
	        	baseResult.setStatus("500");
				baseResult.setMessage("请求参数错误！");
				return baseResult;
	        }
	        
	        
	        
	        List<EnrollmentCode> enrollmentCodeList= enrollmentDao.getEnrollmentCodeByCode(code);
	        if(enrollmentCodeList.size()!=1){
	        	baseResult.setStatus("500");
				baseResult.setMessage("请求参数错误！");
				return baseResult;
	        }else{
	        	EnrollmentCode enrollmentCode= enrollmentCodeList.get(0);
	        	EnrollmentCodeDto newenrollmentCodeDto = new EnrollmentCodeDto();
	        	super.commonBuild(newenrollmentCodeDto, enrollmentCode);
	        	Date createon = newenrollmentCodeDto.getCreateon();
	        	if(createon==null){
	        		baseResult.setStatus("500");
					baseResult.setMessage("请求参数错误！");
					return baseResult;
	        	}
	        	List<DataDictionaryOptionDto> dataDictionaryOptionDtoList= dataDictionaryOptionService.getByDictionaryenAndOptionValue("jcycompanyinfo","emailverificationhour");
	        	String emailverificationhour = StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "emailverificationhour"));
	        	if("".equals(emailverificationhour)){
	        		emailverificationhour = "48";
	        	}
	        	Long hour = 48L;
        		try {
        			hour = Long.parseLong(emailverificationhour);
				} catch (Exception e) {
					// TODO: handle exception
				}
        		Date nowTime = new Date();
        		
        		if(nowTime.getTime() - hour*60*60*1000 -createon.getTime()>0){
        			baseResult.setStatus("300");
					baseResult.setMessage("此链接已失效，请重新填写注册信息！");
					return baseResult;
        		}
        		
        		// 根据注册用户手机号获取注册信息
    	        List<Enrollment> enrollmentList = enrollmentDao.getEnrollmentByMobilephone(newenrollmentCodeDto.getMobilephone());
    	        if(enrollmentList.size()!=1){
    	        	baseResult.setStatus("500");
    				baseResult.setMessage("请求参数错误！");
    				return baseResult;
    	        }
    	        if("1".equals(enrollmentList.get(0).getFinishenrollment())){
    	        	baseResult.setStatus("301");
    				baseResult.setMessage("此手机号已完成注册！");
    				return baseResult;
    	        }
    	        
    	        baseResult.setStatus("200");
    			baseResult.setData(newenrollmentCodeDto);
				return baseResult;
	        }
	        
	        
		} catch (Exception e) {
			baseResult.setStatus("500");
			baseResult.setMessage(e.getMessage());
		}
		
		
		return baseResult;
	}


}
