package com.ekingwin.bas.cloud.enrollment.service.impl;

import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import com.ekingwin.bas.cloud.dataDictionary.dto.DataDictionaryOptionDto;
import com.ekingwin.bas.cloud.dataDictionary.service.IDataDictionaryOptionService;
import com.ekingwin.bas.cloud.enrollment.dao.EnrollmentDao;
import com.ekingwin.bas.cloud.enrollment.dao.entity.Enrollment;
import com.ekingwin.bas.cloud.enrollment.dto.EnrollmentCodeDto;
import com.ekingwin.bas.cloud.enrollment.dto.EnrollmentDto;
import com.ekingwin.bas.cloud.enrollment.service.IEnrollmentCodeService;
import com.ekingwin.bas.cloud.enrollment.service.IEnrollmentService;
import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;
import com.ekingwin.bas.cloud.org.dto.OrganizationDto;
import com.ekingwin.bas.cloud.org.service.IOrganizationService;
import com.ekingwin.bas.cloud.org.service.IOrganizationUserService;
import com.ekingwin.bas.cloud.rolejcy.dto.RolejcyDto;
import com.ekingwin.bas.cloud.rolejcy.dto.RolejcyEmployeeDto;
import com.ekingwin.bas.cloud.rolejcy.service.IRolejcyEmployeeService;
import com.ekingwin.bas.cloud.rolejcy.service.IRolejcyService;
import com.ekingwin.bas.cloud.tenant.dto.TenantDto;
import com.ekingwin.bas.cloud.tenant.dto.TenantEmployeeDto;
import com.ekingwin.bas.cloud.tenant.dto.TenantOrganizationDto;
import com.ekingwin.bas.cloud.tenant.service.ITenantEmployeeService;
import com.ekingwin.bas.cloud.tenant.service.ITenantOrganizationService;
import com.ekingwin.bas.cloud.tenant.service.ITenantService;
import com.ekingwin.bas.cloud.user.dto.UserDto;
import com.ekingwin.bas.cloud.user.service.IUserMetaService;
import com.ekingwin.bas.cloud.util.StringUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;



@Primary
@Service
public class EnrollmentServiceImpl extends BaseService implements IEnrollmentService {
	@Autowired
	private EnrollmentDao dao;
	
	@Autowired
	@Qualifier(value = "rolejcyServiceImpl")
	private IRolejcyService rolejcyService;
	
	@Autowired
	@Qualifier(value = "rolejcyEmployeeServiceImpl")
	private IRolejcyEmployeeService rolejcyEmployeeService;
	
	@Autowired
	@Qualifier(value = "enrollmentCodeServiceImpl")
	private IEnrollmentCodeService enrollmentCodeService;
	
	@Autowired
	@Qualifier(value = "userMetaServiceImpl")
	private IUserMetaService userService;
	
	@Autowired
	@Qualifier(value = "tenantServiceImpl")
	private ITenantService tenantService;
	
	@Autowired
	@Qualifier(value = "tenantOrganizationImpl")
	private ITenantOrganizationService tenantOrganizationService;
	
	@Autowired
	@Qualifier(value = "tenantEmployeeServiceImpl")
	private ITenantEmployeeService tenantEmployeeService;
	
	@Autowired
	@Qualifier(value = "dataDictionaryOptionServiceImpl")
	private IDataDictionaryOptionService dataDictionaryOptionService;
	
	@Autowired
	@Qualifier(value="organizationServiceImpl")
	private IOrganizationService orgService;
	
	
	@Autowired
	@Qualifier(value="organizationUserServiceImpl")
	private IOrganizationUserService organizationUserService;
	
	
	@Override
	public boolean save(EnrollmentDto object) throws BasException {
		
		List<Map<String, Object>> employeeList = dao.getEmployeeByMobilephone(object.getMobilephone());
		if(employeeList.size()>0){
			throw new BasException("此手机号已经是九彩云账号，请直接登陆！");
		}
		List<Enrollment> enrollmentList = dao.getByMobilephone(object.getMobilephone());
		if(enrollmentList.size()>0){
			String id = enrollmentList.get(0).getId();
			object.setId(id);
		}
		object.setFinishenrollment("0");
		save(object, Enrollment.class, dao);
		return false;
	}

	@Override
	public boolean delete(String id) throws BasException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public PageCriteria<EnrollmentDto> query(QueryDTO query) throws BasException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EnrollmentDto get(String id) throws BasException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BaseResult<EnrollmentDto> enrollment(EnrollmentDto enrollmentDto) throws BasException {
		BaseResult<EnrollmentDto> baseResult = new BaseResult<EnrollmentDto>();
		baseResult.setTimestamp(String.valueOf(new Date().getTime()));
		baseResult.setPath(WebUtils.getRequest().getRequestURI());
		String mobilephone = enrollmentDto.getMobilephone();
		String code = enrollmentDto.getCode();
		String codeid = enrollmentDto.getCodeid();
		String p = enrollmentDto.getP();
		String creditcode = enrollmentDto.getCreditcode();
		String password = enrollmentDto.getPassword();
		log.info("passwordnew=========================================="+password);
		try {
			if(code==null || p == null || creditcode==null ){
				baseResult.setStatus("500");
				baseResult.setMessage("请求参数错误！");
				return baseResult;
			}
			String codemd5 = "";
			//对code进行MD5加密
			MessageDigest digest = MessageDigest.getInstance("MD5");
	        byte[] result = digest.digest(code.getBytes());
	        StringBuffer buffer = new StringBuffer();
	        // 把每一个byte 做一个与运算 0xff;
	        for (byte b : result) {
	            // 与运算
	            int number = b & 0xff;// 加盐 暂时不做
	            String str = Integer.toHexString(number);
	            if (str.length() == 1) {
	                buffer.append("0");
	            }
	            buffer.append(str);
	        }
	        // 标准的md5加密后的结果
	        codemd5 = buffer.toString();
	        if(!p.equals(codemd5)){
	        	baseResult.setStatus("500");
				baseResult.setMessage("请求参数错误！");
				return baseResult;
	        }
	        EnrollmentCodeDto enrollmentCodeDto = enrollmentCodeService.get(codeid);
	        if(!code.equals(enrollmentCodeDto.getCode())){
	        	baseResult.setStatus("500");
				baseResult.setMessage("请求参数错误！");
				return baseResult;
	        }
	        
	        // 根据注册用户手机号获取注册信息
	        List<Enrollment> enrollmentList = dao.getEnrollmentByMobilephone(mobilephone);
	        if(enrollmentList.size()!=1){
	        	baseResult.setStatus("500");
				baseResult.setMessage("请求参数错误！");
				return baseResult;
	        }
	        
	        TenantDto tenantDto = tenantService.getByCreditcode(creditcode);
	        if(tenantDto!=null){
	        	baseResult.setStatus("500");
				baseResult.setMessage("您所填写的信用代码已被注册，请重新核对或者联系工作人员！");
				return baseResult;
	        }
	        
	        List<Map<String, Object>> employeeList = dao.getEmployeeByMobilephone(mobilephone);
			if(employeeList.size()>0){
				baseResult.setStatus("301");
				baseResult.setMessage("此手机号已经是九彩云账号，请直接登陆！");
				return baseResult;
			}
	        
			 //保存注册信息
	        EnrollmentDto newenrollmentDto = new EnrollmentDto();
	        super.commonBuild(newenrollmentDto,  enrollmentList.get(0));
	        if(password==null||"".equals(password)){
	        	password = newenrollmentDto.getPassword();
	        	log.info("passwordold=========================================="+password);
	        }
	        newenrollmentDto.setCompanyfullname(enrollmentDto.getCompanyfullname());
	        newenrollmentDto.setCreditcode(enrollmentDto.getCreditcode());
	        newenrollmentDto.setEmployeecount(enrollmentDto.getEmployeecount());
	        newenrollmentDto.setUserscount(enrollmentDto.getUserscount());
	        newenrollmentDto.setIndustryclassify(enrollmentDto.getIndustryclassify());
	        newenrollmentDto.setCorporatewebsite(enrollmentDto.getCorporatewebsite());
	        newenrollmentDto.setDocumentphotoid(enrollmentDto.getDocumentphotoid());
	        newenrollmentDto.setFinishenrollment("1");
	        newenrollmentDto.setPassword("");
	        save(newenrollmentDto, Enrollment.class, dao);
	        
	        //保存租户公司信息
	        tenantDto = new TenantDto();
	        
	        tenantDto.setCity(newenrollmentDto.getCity());
	        tenantDto.setFullname(newenrollmentDto.getCompanyfullname());
	        tenantDto.setName(newenrollmentDto.getCompanyname());
	        tenantDto.setCorporatewebsite(newenrollmentDto.getCorporatewebsite());
	        tenantDto.setDocumentphotoid(newenrollmentDto.getDocumentphotoid());
	        tenantDto.setEmployeecount(newenrollmentDto.getEmployeecount());
	        tenantDto.setIndustryclassify(newenrollmentDto.getIndustryclassify());
	        tenantDto.setRemarks(newenrollmentDto.getRemarks());
	        tenantDto.setUserscount(newenrollmentDto.getUserscount());
	        tenantDto.setCreditcode(creditcode);
	        tenantDto.setActualuserscount(newenrollmentDto.getUserscount());
	        tenantService.save(tenantDto);
	        
	        log.info(tenantDto.toString());
	        tenantDto = tenantService.getByCreditcode(creditcode);
	        String tenantid = tenantDto.getId();
	        // 保存人员数据
	        // 人员数据保存到数据库
	        // 获取人员编码
	        TenantEmployeeDto tenantEmployeeDto = new TenantEmployeeDto();
	        tenantEmployeeDto.setTenantid(tenantid);
	        tenantEmployeeDto.setMobilephone(mobilephone);
	        tenantEmployeeService.save(tenantEmployeeDto);
	        tenantEmployeeDto = tenantEmployeeService.getByMobilephone(mobilephone);
	        String empuid = tenantEmployeeDto.getId(); 
	        
	        
	        UserDto userDto = new UserDto() ;
	        userDto.setCnname(newenrollmentDto.getName());
	        userDto.setEmpuid(newenrollmentDto.getMobilephone());
	        userDto.setMobilephone(newenrollmentDto.getMobilephone());
	        userDto.setEmail(newenrollmentDto.getEmail());
			userDto.setEmpuid(empuid);
			userDto.setEmpid(empuid);
			userDto.setEmail(newenrollmentDto.getEmail());
			userDto.setDisplayname(newenrollmentDto.getName());
			userDto.setTenantid(tenantid);
			userDto.setBusinesstype("01");
	        userService.save(userDto);
			
			//人员数据同步到IDAP
			Map<String, String> map = new HashMap<String, String>();
	        map.put("gidNumber", "100");
			map.put("homeDirectory", "/home/admin");
			map.put("sn", userDto.getEmpuid());
			map.put("uid", userDto.getEmpuid());
			map.put("uidNumber", "200");
			map.put("mail", userDto.getEmail());
			map.put("mobile", userDto.getMobilephone());
			map.put("givenName", userDto.getCnname());
			map.put("displayName", userDto.getDisplayname());
			if(password==null||"".equals(password)){
				password = "ab1234" ;
				log.info("passwordab1234=========================================="+password);
	        }
	        userService.saveToLdap(userDto, map ,password);
	        //初始化角色信息
	        initRoleInfo(tenantDto, empuid);
	        //初始化组织-- 初始化公司
	        initOrganizationInfo(tenantDto, empuid);
			baseResult.setStatus("200");
	        baseResult.setData(newenrollmentDto);
		} catch (Exception e) {
			baseResult.setStatus("500");
			baseResult.setMessage(e.getMessage());
		}
		return baseResult;
	}
	
	private void initRoleInfo(TenantDto tenantDto,String empuid){
		try {
			String tenantid = tenantDto.getId();
			String name = tenantDto.getFullname();
			// 初始化角色
			List<DataDictionaryOptionDto> dataDictionaryOptionDtoList= dataDictionaryOptionService.getByDictionaryen("roleinfo");
			// 初始化哪些角色
	        String initroles = StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "initroles"));
	        if(initroles==null||"".equals(initroles)){
	        	initroles = "管理员,普通用户,需求员,采购员,对账员";
	        }
	        initroles = initroles.replaceAll("，", ",");
	        String[] initroless = initroles.split(",");
	        
	        //默认角色
	        String defaultroles = StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "defaultroles"));
	        if(defaultroles==null||"".equals(defaultroles)){
	        	defaultroles = "普通用户";
	        }
	        defaultroles = defaultroles.replaceAll("，", ",");
	        String[] defaultrolesss = defaultroles.split(",");
	        
	        
	      //管理员角色
	        String adminroles = StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "adminroles"));
	        if(adminroles==null||"".equals(adminroles)){
	        	adminroles = "管理员";
	        }
	        adminroles = adminroles.replaceAll("，", ",");
	        String[] adminroless = adminroles.split(",");
	        
	        
	        for(int i = 0 ; i < initroless.length ; i++ ){
	        	String initrole = initroless[i];
	        	
	        	List<RolejcyDto> rolejcyDtoList = rolejcyService.getByNameAndTenantid(initrole, tenantid);
	        	RolejcyDto rolejcyDto = null;
	        	if(rolejcyDtoList.size()==0 ){
	        		rolejcyDto = new RolejcyDto();
	        		rolejcyDto.setTenantid(tenantid);
	        		rolejcyDto.setCreateby(empuid);
	        		rolejcyDto.setIsdelete("N");
	        		rolejcyDto.setIsdefault("N");
	        		rolejcyDto.setName(initrole);
	        		rolejcyDto.setDescription("初始化角色");
	        		rolejcyDto.setCreateby(empuid);
	        		if(defaultroles.contains(initrole)){
	        			rolejcyDto.setIsdefault("Y");
	        		}
	        		rolejcyService.save(rolejcyDto);
	        	}
	        }
	        
	        for(int i = 0 ; i < adminroless.length ; i++ ){
	        	String adminrole = adminroless[i];
	        	List<RolejcyDto> rolejcyDtoList = rolejcyService.getByNameAndTenantid(adminrole, tenantid);
	        	RolejcyDto rolejcyDto = null;
	        	if(rolejcyDtoList.size()>0 ){
	        		rolejcyDto = rolejcyDtoList.get(0);
	        		RolejcyEmployeeDto rolejcyEmployeeDto = rolejcyEmployeeService.getByRoleidAndUserid(rolejcyDto.getId(), empuid);
	        		if(rolejcyEmployeeDto==null){
	        			rolejcyEmployeeDto = new RolejcyEmployeeDto();
	        			rolejcyEmployeeDto.setIsdelete("N");
	        			rolejcyEmployeeDto.setRoleid(rolejcyDto.getId());
	        			rolejcyEmployeeDto.setState("2");
	        			rolejcyEmployeeDto.setUserid(empuid);
	        			rolejcyEmployeeDto.setCreateby(empuid);
	        			rolejcyEmployeeService.save(rolejcyEmployeeDto);
	        		}
	        	}
	        }
	        for(int i = 0 ; i < defaultrolesss.length ; i++ ){
	        	String defaultrole = defaultrolesss[i];
	        	List<RolejcyDto> rolejcyDtoList = rolejcyService.getByNameAndTenantid(defaultrole, tenantid);
	        	RolejcyDto rolejcyDto = null;
	        	if(rolejcyDtoList.size()>0){
	        		rolejcyDto = rolejcyDtoList.get(0);
	        		// 建立人员角色关系
	        		RolejcyEmployeeDto rolejcyEmployeeDto = rolejcyEmployeeService.getByRoleidAndUserid(rolejcyDto.getId(), empuid);
	        		if(rolejcyEmployeeDto==null){
	        			rolejcyEmployeeDto = new RolejcyEmployeeDto();
	        			rolejcyEmployeeDto.setIsdelete("N");
	        			rolejcyEmployeeDto.setRoleid(rolejcyDto.getId());
	        			rolejcyEmployeeDto.setState("2");
	        			rolejcyEmployeeDto.setUserid(empuid);
	        			rolejcyEmployeeService.save(rolejcyEmployeeDto);
	        		}
	        		
	        	}
	        }
			//初始化权限--管理拥有所有菜单权限
			
			
		} catch (Exception e) {
			log.info(e.getMessage());
		}
		
	}
	
	
	private void initOrganizationInfo(TenantDto tenantDto,String empuid){
		try {
			String tenantid = tenantDto.getId();
			String fullname = tenantDto.getFullname();
			String name = tenantDto.getName();
			List<TenantOrganizationDto> tenantOrganizationList = tenantService.getTenantOrganizationByTenantid(tenantid);
			if(tenantOrganizationList.size()>0 ){
				return ;
			}
			// 保存公司信息
			OrganizationDto organizationDto = new OrganizationDto();
			organizationDto.setName(name.toString());
			organizationDto.setType("1");
			organizationDto.setFullname(fullname);
			organizationDto.setPid("1");
			organizationDto.setIsdelete("N");
    		orgService.save(organizationDto);
    		//保存公司-租户公司对应关系
    		TenantOrganizationDto tenantOrganizationDto = new TenantOrganizationDto();
    		tenantOrganizationDto.setOrganizationid(organizationDto.getId());
    		tenantOrganizationDto.setTenantid(tenantid);
    		tenantOrganizationDto.setCreateby(empuid);
    		tenantOrganizationService.save(tenantOrganizationDto);
    		
    		
			
			// 初始化组织信息
			List<DataDictionaryOptionDto> dataDictionaryOptionDtoList= dataDictionaryOptionService.getByDictionaryen("initorganization");
			// 默认岗位信息
	        String initorganization = StringUtils.objectToString(dataDictionaryOptionService.getOptionTextByValue(dataDictionaryOptionDtoList, "initorganization"));
	        if(initorganization!=null){
	        	saveOrganizationInfo(initorganization, organizationDto.getId(), empuid);
	        }
		} catch (Exception e) {
			log.info(e.getMessage());
		}
		
	}

	public void saveOrganizationInfo(String jsonstr ,String pid,String empuid) throws BasException {
		JSONArray jsonArray = JSONArray.fromObject(jsonstr);
        if(jsonArray!=null){
        	for(int i = 0 ; i < jsonArray.size() ; i++ ){
        		Object object = jsonArray.get(i);
        		JSONObject jsonobject=JSONObject.fromObject(object);
        		Object name = jsonobject.get("name");
        		Object type = jsonobject.get("type");
        		if(name!=null&&type!=null&&!"".equals(name.toString().trim())&&!"".equals(type.toString().trim())){
        			OrganizationDto organizationDto = new OrganizationDto();
        			organizationDto.setName(name.toString());
        			organizationDto.setType(type.toString());
        			organizationDto.setPid(pid);
        			organizationDto.setIsdelete("N");
            		orgService.save(organizationDto);
            		Object defaultpost = jsonobject.get("defaultpost");
            		Object mainpost = jsonobject.get("mainpost");
            		
            		if("Y".equals(defaultpost)&&"3".equals(type.toString())){
            			if("Y".equals(mainpost)){
            				// 保存人员-岗位
                			organizationUserService.insertOrupdate(empuid, organizationDto.getId(), "P");
            			}else{
            				// 保存人员-岗位
                			organizationUserService.insertOrupdate(empuid, organizationDto.getId(), "M");
            			}
            			
            		}
            		Object childs = jsonobject.get("childs");
            		if(childs!=null){
            			saveOrganizationInfo(childs.toString(), organizationDto.getId(), empuid);
            		}
        		}
        	}
        }
		
	}
	
	@Override
	public void test() throws BasException {
		String empuid = "1000000501";
		BaseResult<UserDto> user = userService.get(empuid);
		if(user!=null){
			UserDto userDto = user.getData();
			String mobilephone = userDto.getMobilephone();
			if(mobilephone!=null){
				TenantEmployeeDto tenantEmployeeDto = tenantEmployeeService.getByMobilephone(mobilephone);
				if(tenantEmployeeDto!=null){
					TenantDto tenantDto = new TenantDto();
					tenantDto.setId("100000501");
					tenantDto.setFullname("重庆才杨");
					tenantDto.setName("重庆才杨");
					initOrganizationInfo(tenantDto, empuid);
				}
				
			}
			
		}
		
	}

}
