package com.ekingwin.bas.cloud.enrollment.web;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ekingwin.bas.cloud.dataDictionary.dto.DataDictionaryOptionDto;
import com.ekingwin.bas.cloud.dataDictionary.service.IDataDictionaryOptionService;
import com.ekingwin.bas.cloud.enrollment.dto.EnrollmentCodeDto;
import com.ekingwin.bas.cloud.enrollment.dto.EnrollmentDto;
import com.ekingwin.bas.cloud.enrollment.service.IEnrollmentCodeService;
import com.ekingwin.bas.cloud.enrollment.service.IEnrollmentService;
import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping("/public/enrollment")
@Api("租户注册信息")
public class EnrollmentController {
	@Autowired
	@Qualifier(value = "enrollmentServiceImpl")
	private IEnrollmentService enrollmentService;
	
	@Autowired
	@Qualifier(value = "enrollmentCodeServiceImpl")
	private IEnrollmentCodeService enrollmentCodeService;
	
	@Autowired
	@Qualifier(value = "dataDictionaryOptionServiceImpl")
	private IDataDictionaryOptionService dataDictionaryOptionService;
	
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation("注册用户基本信息保存")
	public  BaseResult<EnrollmentDto>   save(@RequestBody EnrollmentDto enrollmentDto) throws Exception {
		BaseResult<EnrollmentDto> baseResult = new BaseResult<EnrollmentDto>();
		baseResult.setTimestamp(String.valueOf(new Date().getTime()));
		baseResult.setPath(WebUtils.getRequest().getRequestURI());
		try {
			enrollmentService.save(enrollmentDto);
			baseResult.setStatus("200");
			baseResult.setData(enrollmentDto);
		} catch (Exception e) {
			baseResult.setStatus("500");
			baseResult.setMessage(e.getMessage());
		}
		return baseResult;
		
	}
	@RequestMapping(value = "/emailverification", method = RequestMethod.POST)
	@ApiOperation("发送账号激活邮件")
	public  BaseResult<EnrollmentCodeDto>   emailverification(@RequestBody EnrollmentCodeDto enrollmentCodeDto) throws Exception {
		BaseResult<EnrollmentCodeDto> baseResult = new BaseResult<EnrollmentCodeDto>();
		baseResult.setTimestamp(String.valueOf(new Date().getTime()));
		baseResult.setPath(WebUtils.getRequest().getRequestURI());
		try {
			enrollmentCodeService.save(enrollmentCodeDto);
			baseResult.setStatus("200");
			baseResult.setData(enrollmentCodeDto);
		} catch (Exception e) {
			baseResult.setStatus("500");
			baseResult.setMessage(e.getMessage());
		}
		return baseResult;
		
	}
	
	@RequestMapping(value = "/verificationcode", method = RequestMethod.POST)
	@ApiOperation("验证邮箱验证码的有效性")
	public  BaseResult<EnrollmentCodeDto>  verificationcode(@RequestBody EnrollmentCodeDto enrollmentCodeDto) throws Exception {
		return enrollmentCodeService.verificationcode(enrollmentCodeDto);
	}
	
	
	@RequestMapping(value = "/enrollment", method = RequestMethod.POST)
	@ApiOperation("完善信息，进行注册")
	public  BaseResult<EnrollmentDto>  enrollment(@RequestBody EnrollmentDto enrollmentDto) throws Exception {
		return enrollmentService.enrollment(enrollmentDto);
	}
	
	@RequestMapping(value = "/getindustryclassify", method = RequestMethod.GET)
	@ApiOperation("根据数据字典的英文名(编码)，获取选项")
	public  List<DataDictionaryOptionDto>   getOptionByDictionaryen() throws Exception {
		return dataDictionaryOptionService.getByDictionaryen("industryclassify");
	}
	
	
	@RequestMapping(value = "/test", method = RequestMethod.GET)
	@ApiOperation("根据数据字典的英文名(编码)，获取选项")
	public  void  test() throws Exception {
		enrollmentService.test();
	}
	
	
}
