const os = require('os');
const path = require('path');
const chalk = require('chalk');
const webpack = require("webpack");
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
const {
  BundleAnalyzerPlugin
} = require('webpack-bundle-analyzer')

const dllPath = path.join(__dirname, '../dll');

module.exports = {
  entry: {
    vendor: [
      'vue',
      'vue-router',
      'vuex',
      'axios'
    ]
  },
  output: {
    path: dllPath,
    filename: "[name].js",
    library: "_dll_[name]"
  },
  plugins: [
    new webpack.DllPlugin({
      name: "_dll_[name]",
      path: path.join(__dirname, '../dll','manifest.json'),
      context: __dirname
    }),
    new BundleAnalyzerPlugin({
      analyzerMode: 'static'
    }),
    new UglifyJsPlugin({
      uglifyOptions: {
        ie8: false,
        ecma: 8,
        mangle: true,
        output: { comments: false },
        compress: { warnings: false }
      },
      sourceMap: false,
      cache: true,
      parallel: os.cpus().length * 2
    })
  ]
}
