//
//  CustomerServiewHttpCmd+Response.m
//  MobilePortal
//
//  Created by caiyang on 2020/4/7.
//  Copyright © 2020 yin chen. All rights reserved.
//

#import "CustomerServiewHttpCmd+Response.h"
#import "CustomerServiewHttpCmd.h"
#import "CustomerServiewHttpResult.h"

@protocol CustomerServiewHttpResultDataOrderListItem;
@interface CustomerServiewHttpResultDataOrderListItem : JSONModel
@property NSString<Optional>*id;
@property NSString<Optional>*folderid;
@property NSString<Optional>*title;
@property NSString<Optional>*status;
@property NSString<Optional>*createon;
@property NSString<Optional>*createby;
@property NSString<Optional>*orderType;
@property NSString<Optional>*createbyname;
@property NSString<Optional>*type;
@property NSString<Optional>*homeshow;
@property NSString<Optional>*sort;
@property NSString<Optional>*pid;
@end
@implementation CustomerServiewHttpResultDataOrderListItem
@synthesize description;
@end

@protocol CustomerServiewHttpResultDataOrderList;
@interface CustomerServiewHttpResultDataOrderList : JSONModel
@property NSString<Optional>*orderType;
@property NSString<Optional>*orderId;
@property NSString<Optional>*pages;
@property NSMutableArray<Optional,CustomerServiewHttpResultDataOrderListItem> *questions;
@property NSString<Optional>*imageCategory;
@property NSString<Optional>*orderTypeimageurl;
@end
@implementation CustomerServiewHttpResultDataOrderList
@synthesize description;
@end


@protocol CustomerServiewHttpResultData;
@interface CustomerServiewHttpResultData : JSONModel
@property NSMutableArray<Optional,CustomerServiewHttpResultDataOrderList> *orderList;
@end
@implementation CustomerServiewHttpResultData
@synthesize description;
@end


@interface CustomerServiewHttpResult()
@property CustomerServiewHttpResultData *data;
@end

@implementation CustomerServiewHttpCmd (Response)

- (void)onRequestSuccess:(id)request code:(NSInteger)code{
    
    [self.result setResultState:kRequestResultSuccess];
    NSDictionary *dic = (NSDictionary *)request;
    CustomerServiewHttpResult *result = [[CustomerServiewHttpResult alloc]init];
    result = (CustomerServiewHttpResult *)self.result;
    if (code>199&&code<299) {
        [self.result setResultState:kRequestResultSuccess];
        NSError *error;
        result.data = [[CustomerServiewHttpResultData alloc]initWithDictionary:dic error:(NSError **)&error];
        if(error){
            [self onRequestFailed:error];
            return;
        }
    }else{
        NSString *memo = [dic objectForKey:@"error_description"];
        [self.result setResultState:kRequestResultFail];
        [self.result setErrMsg:memo];
        NSLog(@"code :%ld errormsg:%@",(long)code,memo);
    }
}

- (void)onRequestFailed:(NSError *)error{
    NSLog(@"Error===%@",error);
    [self.result setErrMsg:[error localizedDescription]];
    [self.result setResultState:kRequestResultFail];
}

@end
@implementation CustomerServiewHttpResult
- (NSMutableArray *)getCustomerServiewHttpResult{
    NSMutableArray *httpArray = [NSMutableArray array];
    for (int index = 0; index < self.data.orderList.count; index ++) {
        CustomerServiewHttpModel *model = [[CustomerServiewHttpModel alloc]init];
        CustomerServiewHttpResultDataOrderList *httpModel = self.data.orderList[index];
        model.orderType = [self getNilString:httpModel.orderType];
        model.orderId = [self getNilString:httpModel.orderId];
        model.imageCategory = [self getNilString:httpModel.imageCategory];
        model.orderTypeimageurl = [self getNilString:httpModel.orderTypeimageurl];
        for (int i = 0; i < httpModel.questions.count; i ++) {
            CustomerServiewHttpResultDataOrderListItem *itemHttpModel = httpModel.questions[i];
            CustomerServiewListModel *itemModel = [[CustomerServiewListModel alloc]init];
            itemModel.id = [self getNilString:itemHttpModel.id];
            itemModel.folderid = [self getNilString:itemHttpModel.folderid];
            itemModel.title = [self getNilString:itemHttpModel.title];
            itemModel.status = [self getNilString:itemHttpModel.status];
            itemModel.createon = [self getNilString:itemHttpModel.createon];
            itemModel.createby = [self getNilString:itemHttpModel.createby];
            itemModel.createbyname = [self getNilString:itemHttpModel.createbyname];
            itemModel.type = [self getNilString:itemHttpModel.type];
            itemModel.homeshow = [self getNilString:itemHttpModel.homeshow];
            itemModel.sort = [self getNilString:itemHttpModel.sort];
            itemModel.pid = [self getNilString:itemHttpModel.pid];
            [model.questions addObject:itemModel];
        }
        [httpArray addObject:model];
    }
    return httpArray;
}

@end
