import Vue from 'vue'
import Router from 'vue-router'
import store from '@/store'
import todo from './todo'
// 销售执行情况
import saleSituation from './saleSituation'
// 我的订单
import myOrder from './myOrder'
// 我的发票
import myInvoice from './myInvoice'
import { GetQueryString } from '@/utils/common'
// http://mobileportal.shaphar.com:8020/SYERP/newerp/#/requireGoods
Vue.use(Router)

const routerList = [
  {
    path: '/',
    redirect: '/myOrder'
  },
  ...todo,
  ...saleSituation,
  ...myOrder,
  ...myInvoice
]

const router = new Router({
  mode: 'hash',
  routes: routerList
})

router.beforeEach((to, from, next) => {
  document.title = to.meta.title
  store.commit('setNavBar', {
    title: to.meta.title,
    leftArrow: true,
    rightText: '',
    rightClick: null,
    rightIcon: null,
    leftIcon: null
  })
  let {uid} = store.getters.getUserInfo
  if (to.meta && to.meta.auth && !uid) {
    next('/login')
  } else {
    next()
  }
  if (process.env.HOST_URL.indexOf('com') === -1) {
    let linkInfo = {
      userId: GetQueryString('userId'), // APP用户的登录ID
      sysUserId: GetQueryString('sysUserId'), // 当前系统的UserId
      sysOrgName: GetQueryString('sysOrgName').replace('%2F', '/'), // 当前系统的部门名称
      sysType: GetQueryString('sysType'), // 系统的类型
      docId: GetQueryString('docId'), // 文档ID
      userName: GetQueryString('userName'), // 当前系统的用户名称
      title: GetQueryString('title'), // 页面的标题
      sysCompanyName: GetQueryString('sysCompanyName'), // 系统的公司名称
      sysCompanyId: GetQueryString('sysCompanyId'), // 系统的公司ID
      sysOrgService: GetQueryString('sysOrgService'), // 获取当前系统的部门组织服务的地址
      sysOrgId: GetQueryString('sysOrgId'), // 当前系统的部门ID
      sysDbSource: GetQueryString('sysDbSource'), // 当前系统的数据源
      tmsTestDb: GetQueryString('tmsTestDb'), // TMS的测试数据源
      omsTestDb: GetQueryString('omsTestDb'), // OMS的测试数据源
      appTestDb: GetQueryString('appTestDb'), // APP的测试数据源
      cmsTestDb: GetQueryString('cmsTestDb'), // CMS的测试数据源
      appRealDb: GetQueryString('appTestDb'), // APP的正式数据源
      cmsRealDb: GetQueryString('cmsTestDb'), // CMS的正式数据源
      tmsRealDb: GetQueryString('tmsTestDb'), // TMS的正式数据源
      omsRealDb: GetQueryString('omsTestDb'), // OMS的正式数据源
      messageId: GetQueryString('messageId'), // 消息id
      msgId: GetQueryString('msgId') // 安卓消息id
    }
    store.commit('setLinkInfo', linkInfo)
    console.log(linkInfo)
  } else {
    let linkInfo = {
      userId: GetQueryString('userId'), // APP用户的登录ID
      sysUserId: GetQueryString('sysUserId'), // 当前系统的UserId
      sysOrgName: GetQueryString('sysOrgName').replace('%2F', '/'), // 当前系统的部门名称
      sysType: GetQueryString('sysType'), // 系统的类型
      docId: GetQueryString('docId'), // 文档ID
      userName: GetQueryString('userName'), // 当前系统的用户名称
      title: GetQueryString('title'), // 页面的标题
      sysCompanyName: GetQueryString('sysCompanyName'), // 系统的公司名称
      sysCompanyId: GetQueryString('sysCompanyId'), // 系统的公司ID
      sysOrgService: GetQueryString('sysOrgService'), // 获取当前系统的部门组织服务的地址
      sysOrgId: GetQueryString('sysOrgId'), // 当前系统的部门ID
      sysDbSource: GetQueryString('sysDbSource'), // 当前系统的数据源
      tmsTestDb: GetQueryString('tmsRealDb'), // TMS的测试数据源
      omsTestDb: GetQueryString('omsRealDb'), // OMS的测试数据源
      appTestDb: GetQueryString('appRealDb'), // APP的测试数据源
      cmsTestDb: GetQueryString('cmsRealDb'), // CMS的测试数据源
      appRealDb: GetQueryString('appRealDb'), // APP的正式数据源
      cmsRealDb: GetQueryString('cmsRealDb'), // CMS的正式数据源
      tmsRealDb: GetQueryString('tmsRealDb'), // TMS的正式数据源
      omsRealDb: GetQueryString('omsRealDb'), // OMS的正式数据源
      messageId: GetQueryString('messageId'), // 消息id
      msgId: GetQueryString('msgId') // 安卓消息id
    }
    store.commit('setLinkInfo', linkInfo)
  }
})
export default router
// linkInfo = {
//   userId: GetQueryString('userId'), // APP用户的登录ID
//   sysUserId: GetQueryString('sysUserId'), // 当前系统的UserId
//   sysOrgName: GetQueryString('sysOrgName'), // 当前系统的部门名称
//   sysType: GetQueryString('sysType'), // 系统的类型
//   docId: GetQueryString('docId'), // 文档ID
//   userName: GetQueryString('userName'), // 当前系统的用户名称
//   title: GetQueryString('title'), // 页面的标题
//   sysCompanyName: GetQueryString('sysCompanyName'), // 系统的公司名称
//   sysCompanyId: GetQueryString('sysCompanyId'), // 系统的公司ID
//   sysOrgService: GetQueryString('sysOrgService'), // 获取当前系统的部门组织服务的地址
//   sysOrgId: GetQueryString('sysOrgId'), // 当前系统的部门ID
//   sysDbSource: GetQueryString('sysDbSource'), // 当前系统的数据源
//   tmsTestDb: GetQueryString('tmsTestDb'), // TMS的测试数据源
//   omsTestDb: GetQueryString('omsTestDb'), // OMS的测试数据源
//   appTestDb: GetQueryString('appTestDb'), // APP的测试数据源
//   cmsTestDb: GetQueryString('cmsTestDb'), // CMS的测试数据源
//   appRealDb: GetQueryString('appRealDb'), // APP的正式数据源
//   cmsRealDb: GetQueryString('cmsRealDb'), // CMS的正式数据源
//   tmsRealDb: GetQueryString('tmsRealDb'), // TMS的正式数据源
//   omsRealDb: GetQueryString('omsRealDb') // OMS的正式数据源
// }
