import Vue from 'vue'
import Vuex from 'vuex'
Vue.use(Vuex)
// 进行接口暴露，暴露一个Vuex的store仓库的实例对象
const store = new Vuex.Store({
  // state只进行数据的设置，取值不用this.$store.state
  state: {
    useInfo: {
      uid: '11'
    }, // 用户信息
    navBar: {
      show: true,
      leftArrow: true,
      fixed: true,
      border: true,
      title: '',
      leftText: '返回',
      rightText: '',
      rightIcon: null,
      leftIcon: null,
      leftClick: null,
      rightClick: null
    }, // 导航栏配置
    linkInfo: {} // url参数
  },
  // getters只用来取值，不进行任何值的变化的操作
  getters: {
    getUserInfo (state) {
      return state.useInfo || {}
    },
    getLinkInfo (state) {
      return state.linkInfo || {}
    }
  },
  // mutations是vuex中唯一进行数据修改的地方
  // mutations只支持同步的数据变化操作，它不支持异步的数据变化操作
  // 进行调用mutations需要用到commit
  mutations: {
    setUserInfo (state, payload) {
      state.useInfo = payload
    },
    setNavBar(state, navBar) {
      state.navBar = Object.assign(state.navBar, navBar)
    },
    setLinkInfo (state, payload) {
      state.linkInfo = payload
    }
  },
  // 可以通过actions进行异步操作的处理，但是actions中需要调用mutations中的方法来进行数据的修改
  actions: {
  }
})
export default store
