import Vue from 'vue'
import App from './App'
import router from './router'
import store from './store'
import filter from './filters'
import 'lib-flexible'
import Container from '@/components/Container'
import './assets/styles/common_vant.scss'
import './assets/styles/common.scss'
import 'font-awesome/css/font-awesome.min.css'

// import './assets/styles/variable.scss'

import { Button, Toast, Field, Row, Col, NavBar, Search, Uploader, Empty,
  List, PullRefresh, Popup, Cell, CellGroup, Tab, Tabs, Collapse, Divider, IndexBar, IndexAnchor,
  CollapseItem, Icon, Image, RadioGroup, Radio, DatetimePicker, Step, Steps, Card, Swipe, SwipeItem,
  Slider, DropdownMenu, DropdownItem, Grid, GridItem, Tag, ImagePreview, Loading, Checkbox, CheckboxGroup, SwipeCell, Dialog, Stepper } from 'vant'
Vue.use(Button).use(Icon).use(Field).use(Row).use(Col).use(NavBar).use(CellGroup).use(Empty)
  .use(Toast).use(Search).use(List).use(PullRefresh).use(Popup).use(Cell).use(Tab).use(Tabs)
  .use(Collapse).use(CollapseItem).use(Image).use(RadioGroup).use(Radio).use(DatetimePicker)
  .use(Steps).use(Step).use(Card).use(Swipe).use(SwipeItem).use(Slider).use(DropdownMenu)
  .use(DropdownItem).use(Grid).use(GridItem).use(Tag).use(ImagePreview).use(Divider).use(Loading)
  .use(Checkbox).use(CheckboxGroup).use(SwipeCell).use(IndexBar).use(IndexAnchor).use(Uploader).use(Dialog)
  .use(Stepper)

Vue.use(Container)
Object.keys(filter).forEach(k => Vue.filter(k, filter[k]))

// import Vant from 'vant'
// import 'vant/lib/index.css'

// Vue.use(Vant)

Vue.config.productionTip = false
/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  render: h => h(App)
})
// 监听
Vue.prototype.$EventBus = new Vue();
