const filter = {
  formatMoney(value) {
    if (value) {
      value = Number(value)
      return value.toFixed(2)
    }
  },
  // 千分位
  separator (val, str, str2) {
    str = !str ? '' : str
    str2 = !str2 ? '' : str2
    if (val) {
      return str + (val + '').replace(/(\d{1,3})(?=(\d{3})+(?:$|\.))/g, '$1,') + str2
    } else {
      return str + '0.00' + str2
    }
  },
  toFix(value, num) {
    if (value) {
      value = Number(value)
      return value.toFixed(num)
    } else {
      let res = '0'
      for (let i= 0 ;i <num;i++){
        if(i===0){
         res = res + ".0"
        }else {
          res = res + "0"
        }
      }
      return res
    }
  },
  // 将时间戳转日期格式的过滤器
  dateFormat(dataStr) {
      var time = new Date(dataStr);
      function timeAdd0(str) {
        if (str < 10) {
          str = '0' + str;
        }
        return str
      }
      var y = time.getFullYear();
      var m = time.getMonth() + 1;
      var d = time.getDate();
      var h = time.getHours();
      var mm = time.getMinutes();
      var s = time.getSeconds();
      // return y + '-' + timeAdd0(m) + '-' + timeAdd0(d) + ' ' + timeAdd0(h) + ':' + timeAdd0(mm) + ':' + timeAdd0(s);
      return timeAdd0(m) + '-' + timeAdd0(d) + ' ' + timeAdd0(h) + ':' + timeAdd0(mm);
  }
}
export default filter
