import { fetch } from '../../utils/utils.js'
var username = JSON.parse(localStorage.getItem('portalCurrentUserInfo') || '{}').empuid

/**
 * 获取规章制度树
 * @date 2021-10-11
 * @param {object}} data
 * @returns {fetch}
 */
export function getRuleIframeTree (data) {
  return fetch({
    url: '/regulation/getRegulationFolderCopy/' + data,
    method: 'get'
  })
}

// 获取规章制度树（带权限）
export function foldertreezd (id) {
  return fetch({
    url: `/regulation/getRegulationFolderCopy/${id}`,
    method: 'get'
  })
}


export function getBooksList (data) {
  return fetch({
    url: '/regulation/queryCopy?username=' + username,
    method: 'post',
    data
  })
}

/**
 * 查询章节
 * @date 2021-10-11
 * @param {any} docid
 * @returns {any}
 */
export function queryChapters (docid) {
  return fetch({
    url: `/regulation/queryChapters/${docid}`,
    method: 'get'
  })
}

/**
 * 获取组织树
 * @date 2021-10-11
 * @param {any} docid
 * @returns {any}
 */

export function getTreeNode (id, frameVersionId) {
  return fetch({
    url: '/frameVersion/getTreeNode/' + id + '/' + frameVersionId,
    method: 'post'
  })

}/**
 * 获取记录
 * @date 2021-10-11
 * @param {any} docid
 * @returns {any}
 */

export function recordQuery(data) {
  return fetch({
    url: `/element/process/record/query`,
    method: 'post',
    data
  })
}
/**
 * 查询是否发布
 * @date 2021-10-11
 * @param {any} docid
 * @returns {any}
 */

export function getRecentPublished(data) {
  return fetch({
    url: `/listrelease/queryCopy`,
    method: 'post',
    data
  })
}
