const path = require('path');
const glob = require('glob');
const webpack = require("webpack")

const { merge } = require('webpack-merge');
const rules = require('./webpack.rules.js');


/***
 * 获取指定路径下的入口文件
 * @function getEntries
 * @param globPath
 * ***/
function getEntries(globPath) {
  const files = glob.sync(globPath),
    entries = {};
  files.forEach(function (filepath) {
    const split = filepath.split('/');
    const name = split[split.length - 2];
    entries[name] = './' + filepath;
  });
  return entries;
}


const entries = getEntries('src/*/index.js');

module.exports = merge(rules,{
  mode: "development",
  entry: entries,
  output: {                                                 // 出口文件
    path: path.resolve(__dirname, '../dist'),         // 出口文件位置，一定要是绝对路径
    filename: '[name]/index.[chunkhash].js',      // 出口文件名
    // publicPath: '//cdn.com/'    // 上线的地址

  },
  devServer: {
    port: 8080,             // 监听端口
    open: true,
    openPage: 'designer/BaseNewPage.html',
    compress: true,        // gzip压缩
    inline: true,
    proxy: { // 配置多个代理(配置一个 proxy: 'http://localhost:4000' )
      '/bpabpmapi': {
        target: 'http://jiucaiyunbpm.jiucaiyun.cn',
        changeOrigin: true,
        logLevel: 'debug'
      }
    }
  }
})
