const path = require('path');
const glob = require('glob');
const CopyPlugin = require('copy-webpack-plugin')
const CompressionWebpackPlugin = require('compression-webpack-plugin');
const { merge } = require('webpack-merge');
const rules = require('./webpack.rules.js');
const BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin;


/***
 * 获取指定路径下的入口文件
 * @function getEntries
 * @param globPath
 * ***/
function getEntries(globPath) {
  const files = glob.sync(globPath),
    entries = {};
  files.forEach(function (filepath) {
    const split = filepath.split('/');
    const name = split[split.length - 2];
    entries[name] = './' + filepath;
  });
  return entries;
}


function getTemplate(globPath) {
  const files = glob.sync(globPath),
    entries = [];
  files.forEach(function (filepath, index) {
    const split = filepath.split('/');
    const template = `./${filepath.substring(0, filepath.lastIndexOf('.js'))}.html`
    const name = split[split.length - 2];
    //entries[name] = './' + filepath;
    // console.log(index)
    entries[index] = {}
    entries[index].name = name;
  });
  return entries;
}

const entries = getEntries('src/*/index.js');
const Template = getTemplate('src/*/index.js');
//console.log('getTemplate',Template)
let plugin;
// Object.keys(entries).forEach(function(name) {
//     plugin = {
//         filename: name + '.html',
//         template: './public/index.html',
//         inject: true,
//         chunks: [name]
//     };
//     //webpackConfig.plugins.push(plugin);
// })

/***
 * 生成html 参数配置
 * @function setHtmlPluginConfig
 * ***/

function setHtmlPluginConfig(arrayString) {
  let entryArray = arrayString
  if (!Array.isArray(entryArray)) {
    console.log("请确保entry是一个数组")
    return []
  }
  let plugin = []
  entryArray.map(function (item, index) {
    //console.log('item',item,index)

    plugin.push(
      new CopyPlugin({
        patterns: [
          {
            from: 'designer/**/**',
            to: `./`
          },
          {
            from: 'processChart/**/**',
            to: `./designer/`
          },
          {
            from: 'print.html',
            to: `./designer/`
          },
          {
            from: 'printpreview.html',
            to: `./designer/`
          },
          {
            from: 'orgEcharts.html',
            to: `./designer/`
          }
          // {
          //   from: 'designer/i18n/*',
          //   to: item.name
          // },
          // {
          //   from: 'designer/js/*',
          //   to: item.name
          // },
          // {
          //   from: 'designer/css/**/*',
          //   to: item.name
          // },
          // {
          //   from: 'designer/shadow/*',
          //   to: item.name
          // },
          // {
          //   from: 'designer/toolsImg/*',
          //   to: item.name
          // }
        ]
      })
    )
  })
  return plugin
}
//生成 html-webpack-plugin 循环参数配置
let htmlPlugin = setHtmlPluginConfig(Template)


module.exports = merge(rules,{
  mode: "production",
  entry: entries,
  output: {                                                 // 出口文件
    path: path.resolve(__dirname, '../dist'),         // 出口文件位置，一定要是绝对路径
    filename: '[name]/index.[hash].js',      // 出口文件名
    // publicPath: '//cdn.com/'    // 上线的地址

  },
  plugins: [
    ...htmlPlugin,
    //   new BundleAnalyzerPlugin({
    //     analyzerMode: 'server',
    //     //  将在“服务器”模式下使用的主机启动HTTP服务器。
    //     analyzerHost: '127.0.0.1',
    //     //  将在“服务器”模式下使用的端口启动HTTP服务器。
    //     analyzerPort: 8888,
    //     //  路径捆绑，将在`static`模式下生成的报告文件。
    //     //  相对于捆绑输出目录。
    //     reportFilename: 'report.html',
    //     //  模块大小默认显示在报告中。
    //     //  应该是`stat`，`parsed`或者`gzip`中的一个。
    //     //  有关更多信息，请参见“定义”一节。
    //     defaultSizes: 'parsed',
    //     //  在默认浏览器中自动打开报告
    //     openAnalyzer: true,
    //     //  如果为true，则Webpack Stats JSON文件将在bundle输出目录中生成
    //     generateStatsFile: true,
    //     //  如果`generateStatsFile`为`true`，将会生成Webpack Stats JSON文件的名字。
    //     //  相对于捆绑输出目录。
    //     statsFilename: 'stats.json',
    //     //  stats.toJson（）方法的选项。
    //     //  例如，您可以使用`source：false`选项排除统计文件中模块的来源。
    //     //  在这里查看更多选项：https：  //github.com/webpack/webpack/blob/webpack-1/lib/Stats.js#L21
    //     statsOptions: null,
    //     logLevel: 'info' // 日志级别。可以是'信息'，'警告'，'错误'或'沉默'。
    // })
  ]
})
