const MiniCssExtractPlugin = require("mini-css-extract-plugin");
const htmlWebpackPlugin = require('html-webpack-plugin');
const { VueLoaderPlugin } = require('vue-loader')

const glob = require('glob');

function getTemplate(globPath) {
  const files = glob.sync(globPath),
    entries = [];
  files.forEach(function (filepath, index) {
    const split = filepath.split('/');
    const template = `./${filepath.substring(0, filepath.lastIndexOf('.js'))}.html`
    const name = split[split.length - 2];
    //entries[name] = './' + filepath;
    // console.log(index)
    entries[index] = {}
    entries[index].name = name;
    entries[index].src = './' + filepath;
    entries[index].template = template;
    // entries[index].template = './BaseNewPage.html';
  });
  return entries;
}

const Template = getTemplate('src/*/index.js');

/***
 * 生成html 参数配置
 * @function setHtmlPluginConfig
 * ***/

 function setHtmlPluginConfig(arrayString) {
  let entryArray = arrayString
  if (!Array.isArray(entryArray)) {
    // console.log("请确保entry是一个数组")
    return []
  }
  let plugin = []
  entryArray.map(function (item, index) {

    plugin.push(
      new htmlWebpackPlugin({
        inject: true,
        chunks: [item.name],
        //template: temp,
        template: item.template,

        filename: item.name + "/BaseNewPage.html",
        minify: {
          removeComments: true,
          collapseWhitespace: false,
          removeRedundantAttributes: true,
          useShortDoctype: true,
          removeEmptyAttributes: true,
          removeStyleLinkTypeAttributes: true,
          keepClosingSlash: true,
          minifyJS: true,
          minifyCSS: true,
          minifyURLs: true,
        }
      })
    )
  })
  return plugin
}
//生成 html-webpack-plugin 循环参数配置
let htmlPlugin = setHtmlPluginConfig(Template)

module.exports = {
  plugins: [
    new VueLoaderPlugin(),
    ...htmlPlugin,
    new MiniCssExtractPlugin({
      // Options similar to the same options in webpackOptions.output
      // both options are optional
      filename: "[name].css",
      chunkFilename: "[id].css"
    }),
    // new webpack.ProvidePlugin({
    //   $: "jquery",
    //   jQuery: "jquery",
    //   jquery: "jquery",
    //   "window.jQuery": "jquery"
    // })
  ],
  stats: { children: false },
  module: {
    strictExportPresence: true,
    rules: [
      {
        test: /\.vue$/,
        loader: 'vue-loader',
        // options: vueLoaderConfig
      },
      {
        test: /\.css$/,
        use: [
          'vue-style-loader',
          MiniCssExtractPlugin.loader,  // replace ExtractTextPlugin.extract({..})
          "css-loader"
        ]
      },
      {
        test: /\.(sass|scss)$/,
        use: [
          'style-loader',
          'css-loader',
          'sass-loader',
          // {
          //   loader: 'sass-resources-loader',
          //   options: {
          //     // Provide path to the file with resources
          //     // resources: './src/designer/assets/styles/index.scss',

          //     // Or array of paths
          //     resources: [
          //       './src/designer/assets/styles/index.scss',
          //       './src/designer/assets/styles/common.scss',
          //       './src/designer/assets/styles/element-variables.scss',
          //       './src/designer/assets/styles/reset.scss',
          //       './src/designer/assets/styles/variable.scss',
          //     ]
          //   },
          // }
        ]
      },
      {
        test: /\.js$/,
        loader: 'babel-loader',
        exclude: /node_modules/
      },
      {
        test: /\.(png|svg|jpg|gif)$/,
        //use: ['file-loader']
        use: [
          {
            // url-loader内置了file-loader
            loader: 'url-loader',
            options: {
              limit: 8192,    // 小于8k的图片自动转成base64格式，并且不会存在实体图片
              outputPath: 'images/'   // 图片打包后存放的目录
            }
          }
        ]
      },
      {
        test: /\.(eot|ttf|woff|woff2)(\?\S*)?$/,
        use: ['file-loader']
     }
      // {
      //   test: /\.scss$/,
      //   loaders: ['style-loader', 'css-loader', 'sass-loader'],
      // },
    ]
  }
}
