/**
 * cookie操作
 */
var getCookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        var path = options.path ? '; path=' + options.path : '';
        var domain = options.domain ? '; domain=' + options.domain : '';
        var s = [cookie, expires, path, domain, secure].join('');
        var secure = options.secure ? '; secure' : '';
        var c = [name, '=', encodeURIComponent(value)].join('');
        var cookie = [c, expires, path, domain, secure].join('')
        document.cookie = cookie;
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};

/**
 * 获取浏览器语言类型
 * @return {string} 浏览器国家语言
 */
var getNavLanguage = function(){
    if(navigator.appName == "Netscape"){
        var navLanguage = navigator.language;
        return navLanguage;
    }
    return false;
}

/**
 * 设置语言类型： 默认为中文
 */
var i18nLanguage = "zh-CN";

/*
设置一下网站支持的语言种类
 */
var webLanguage = ['zh-CN', 'en'];



/**
 * 动态dom的翻译数据准备
 *
 */
var vmi18n = {
    "zh-CN":{
        tabsList: ['流程基本属性', '流程支持文件', '流程绩效', '关键风险控制点', '关键成功要素 ', '业务规则', '流程活动说明', '审批记录'],
        stateList:{published:'已发布',new:'新建',obsolete:'作废',locked:'锁定',Editing:'修改中',enable:'启用',unallowable:'禁用'},
        fields:{
            firstPage:'第一页',
            previousPage:'上一页',
            nextPage:'下一页',
            lastPage:'末页',
            currentPageNum:'当前是第',
            page:'页',
            altogether:'共',
            check:'选择',
            checkall:'全选',
        }
    },
    "en":{
        tabsList: ['basic parameters','support files','KPI','KCP','KSP','business rule','activity description','approval history'],
        stateList:{published:'published',new:'new',obsolete:'obsolete',locked:'locked',Editing:'Editing',enable:'enable',unallowable:'unallowable'},
        fields:{
            firstPage:'first',
            previousPage:'pre',
            nextPage:'next',
            lastPage:'last',
            currentPageNum:'The current page number is',
            page:'',
            altogether:'there are altogether',
            check:'check',
            checkall:'check all'

        }
    }
}

/**
 * 执行页面i18n方法
 * @return
 */

var execI18n = function(){
    /*
    获取一下资源文件名
     */
    var optionEle = $("#i18n_pagename");
    if (optionEle.length < 1) {
        console.log("未找到页面名称元素，请在页面写入\n <meta id=\"i18n_pagename\" content=\"页面名(对应语言包的语言文件名)\">");
        return false;
    };

    if (getCookie("lan-local")) {
        i18nLanguage = getCookie("lan-local");
    }

    // else {
    //     // 获取浏览器语言
    //     var navLanguage = getNavLanguage();
    //     if (navLanguage) {
    //         // 判断是否在网站支持语言数组里
    //         var charSize = $.inArray(navLanguage, webLanguage);
    //         if (charSize > -1) {
    //             i18nLanguage = navLanguage;
    //             // 存到缓存中
    //             getCookie("lan-local",navLanguage);
    //         };
    //     } else{
    //         console.log("not navigator");
    //         return false;
    //     }
    // }


    /* 需要引入 i18n 文件*/
    if ($.i18n == undefined) {
        console.log("请引入i18n js 文件")
        return false;
    };

    /*
    这里需要进行i18n的翻译
     */
    jQuery.i18n.properties({
        name : 'flow_edit', //资源文件名称
        path : 'i18n/', //资源文件路径
        mode : 'map', //用Map的方式使用资源文件中的值 'both'
        language : i18nLanguage,
        // async: false,
        callback : function() {//加载成功后设置显示内容
            // var insertEle = $(".i18n");
            // console.log(".i18n 写入中...");
            // console.log($.i18n.prop("acrosSwimLane"))
            // insertEle.each(function() {
            //     // 根据i18n元素的 name 获取内容写入
            //     $(this).html($.i18n.prop($(this).attr('name')));
            // });
            // console.log("写入完毕");
            //
            // console.log(".i18n-input 写入中...");
            // var insertInputEle = $(".i18n-input");
            // insertInputEle.each(function() {
            //     var selectAttr = $(this).attr('selectattr');
            //     if (!selectAttr) {
            //         selectAttr = "value";
            //     };
            //     $(this).attr(selectAttr, $.i18n.prop($(this).attr('selectname')));
            // });
            // console.log("写入完毕");
        }
    });

}

/*执行I18n翻译*/
execI18n();

/*页面执行加载执行*/
$(function(){


    // /*将语言选择默认选中缓存中的值*/
    // $("#language option[value="+i18nLanguage+"]").attr("selected",true);
    //
    // /* 选择语言 */
    // $("#language").bind('change', function() {
    //     var language = $(this).children('option:selected').val();
    //     getCookie("userLanguage",language,{
    //         expires: 30,
    //         path:''
    //     });
    //     location.reload();
    // });

});
