import {
  changeAppovalType,
  isCurClass,
  newFunction,
  paginationsss,
  sortTopLeft,
  computeGuidesForElement,
  mousePosition,
  delCookie,
  getCookie,
  setCookie,
  changeContrast,
  contrastInfoNavagationPage,
  getContrastInfo,
  addDataTableContrast,
  initProcessTreeCopy,
  getProcessCopy,
  uuid,
  ToolsConfigJson,
  leftNav,
  headerBtn,
  childProcess,
  processTabMenu,
  propsSetDialog,
  propsActivity
} from './jsComponents/page/page'
import element from 'element-ui'

import {
  getParam,
  baseUrl,
  bpmurl,
  pageurl,
  isSameData } from './jsComponents/utils/utils'

  import { getCategory } from './jsComponents/api/userDefined'

import { showLoading, hideLoading } from './jsComponents/utils/loading'

( async function (window, $, undefined) {
  // 导航线 --------------------------开始
  var MIN_DISTANCE = 8; //捕获的最小距离
  var guides = []; // 没有可用的引导
  var innerOffsetX, innerOffsetY;
  // 导航线 --------------------------结束

  /**
   * 存储新增的折线id
   * */
  var newLineId = "";

  var isIE678 = !+"\v1";
  var useSVG = isIE678 ? 0 : 1;
  // var useSVG = 1
  var SVG_NS = 'http://www.w3.org/2000/svg';
  var url = 'url';

  // 之前未定义的报错变量
  let tmp, tmps, tmpss;
  let json, dataIndex, dataName;

  /**
   * 流程图主入口
   *
   * @param {document}
   *            el 流程图父元素
   * @param {object}
   *            options 创建流程图属性
   */
  //构造函数GooFlow
  function GooFlow($el, options) {
    // this在构造函数中时指向该构造函数GooFlow，但是在ajax中时指向window
    var me = this;
    me.id = getParam("id");
    me.listid = getParam("listid");
    me.liststate = getParam("state");

    // 存储状态
    me.storeDataState = 'self'

    // 存储滚动条的值
    me.storeScroll = {
      top: 0,
      left: 0
    }

    me.$container = $el;
    me.$head = null;

    me.$tools = null;
    me.$toolsBox = null;
    me.$switchGroup = null;

    me.$work = null;
    me.$workArea = null;
    me.$draw = null;
    me.newid = undefined;

    me.setIntervalSave = null;
    // 放大倍数
    me.scaleTo = 1;
    me.show_r = 1;
    // ajax接口请求地址
    me.baseUrl = baseUrl;


    // 打印跳转地址
    me.htmlUrl = pageurl;

    // 存储添加泳道的id
    me.storeSwimlaneId = null;


    // 记录鼠标点击的位置
    me.startPos = [];

    me.EditEnum = {
      // 选择状态
      SELECT: 1,

      // 连接线状态
      LINE: 2

    }

    // 默认编辑状态
    me.isEdit = options.isEdit;

    // 属性只读
    me.isReadAttr = options.isReadAttr;

    let processInfo = sessionStorage.getItem('processInfo') ? JSON.parse(sessionStorage.getItem('processInfo')) : {}

    // 默认编辑状态
    window.isEditAttr = processInfo.isReadAttr === 'true' ? false : me.isEdit;

    // 默认为选择状态
    me.editType = me.EditEnum.SELECT;

    // 默认为选择状态 ---- 虚线
    me.editDottedType = me.EditEnum.SELECT;

    // copy内容
    me.copyItem = [];


    // copy内容的id
    me.copyId = [];


    // 存储所有生成的控件
    me.controls = {};

    // 存储所有生成的连接线
    me.lines = {};

    // 存储所有生成的泳道
    me.swimlanes = {}

    // 当前聚焦的控件/线/泳道 ID
    me.curId = [];
    // 上下游流程初始化的id  数组
    me.upDownProcessList = [];
    // 下游流程 当添加泳道的时候，下游流程跟着泳道移动
    me.instantTop = 500;
    // 泳道初始宽度
    me.swimLineWidth = 100;
    me.swimLineYWidth = 220;
    // me.swimMaxLineWidth = 400;
    me.swimMaxLineWidth = 2000;
    me.swimMinLineWidth = 100;

    // 获取username
    me.username = getCookie("username")

    me.historyVersion = [] // 流程所有历史版本
    me.selectedCurrentVersion = {} // 选中的当前版本数据
    me.selectedCompareVersion = {} // 选中的比对版本数据
    me.compareVersionList = [] // 对比流程 数据
    me.isAllCompareVersionList = [] // 对比流程 是否全部 数据
    me.messageFileType = [] // 信息文档类型

    if (!options.swimMember) {
      jq.ajax({
        type: "POST",
        url: me.baseUrl + "/listhistory/getMyJson/" + me.listid + '?username=' + me.username,
        data: id,
        cache: false,
        dataType: 'json',
        processData: false,
        async: false,// 此处设为同步 是为了获取加载好的数据的泳道的高度
        success: function (data) {
          var swimlaneTwo = data.data.swimlane;
          if (swimlaneTwo) {
            setCookie('qiehuan', swimlaneTwo)
          } else {
            setCookie('qiehuan', 'swimlaneX')
          }
          location.reload()
        }
      });
    }
    // 泳道竖头部的高度
    me.swimYheight = options.swimMember !== 'swimlaneY' ? 35 : 90

    // 泳道横头部的宽度度
    me.swimXwidth = options.swimMember !== 'swimlaneY' ? 115 : 90

    // 初始化可视区高度
    me.initSvgHeight = me.swimLineWidth * 7;

    // 初始化可视区宽度
    me.initSvgWidth = 2718;

    // 存储数据
    me.storeData = [];

    // 存储上游流程的选择的数据
    me.storeUpgressData = [];

    // 判断是否有上下游流程
    me.isUpDownProcess = true;

    me.rectItems = []; // 存取框选的内容

    me.begintop = '' // 记录框选的框 移动前的位置

    me.beginleft = ''

    me.rectLines = [] // 框选移动的线

    // 判断是否移动泳道横和泳道竖
    me.referIfMove = false;

    me.category = {}

    // 要复制流程图的数据
    me.copyChartData = null;
    me.copyCode = null;
    jq.ajax({
      type: "Get",
      url: me.baseUrl + '/modelLegend/get/1',
      data: {},
      async: false,// 此处设为同步 是为了获取加载好的数据的泳道的高度
      success: async function (data) {
        console.log(data)
        options.toolsPath = data.data.name === 'shadow' ? 'shadow' : 'toolsImg'
        const res = await getCategory()
        if (res && res.length) {
          me.category = res[0]
        }
        // Object.entries(ToolsConfig).map(v => {
        //   ToolsConfig[v[0]].category = res[0]
        // })
        // ToolsConfig.processTaskService.category = res[1]
      }
    })
    // ctrl + z list，撤销
    me.ctrlZlist = [];
    // ctrl + y list 反撤销
    me.ctrlYlist = [];
    me.options = {
      haveHead: true,
      haveTools: true,
      editable: true,
      color: {
        // line: '#555555',
        line: '#090909',
        mark: '#ff3300'
      },
      toolsGroup: null,
      toolsPath: 'toolsImg',
      swimlane: ['x', 'y']
    }
    // 获取图例风格id
    me.myJsonId = ''
    jq.ajax({
      type: "Get",
      url: me.baseUrl + '/modelIcon/getAllStyle',
      data: {},
      async: false,// 此处设为同步 是为了获取加载好的数据的泳道的高度
      success: function (data) {
        console.log(data)
        for (var i = 0; i < data.data.length; ++i) {
          if (options.toolsPath === 'shadow' && data.data[i].styleName === '彩色') {
            me.myJsonId = data.data[i].id
          } else if (options.toolsPath === 'toolsImg' && data.data[i].styleName === '黑白') {
            me.myJsonId = data.data[i].id
          }
        }
      }
    })
    // 根据权限查询图例
    jq.ajax({
      type: "POST",
      url: me.baseUrl + '/modelIcon/queryTree',
      contentType: 'application/json;',
      data: JSON.stringify({
        "attr":{},
        "filters":[{"key":"styleId","opt":"EQ","type":"S","value": me.myJsonId}],
        "sort":"asc",
        "orderby":"sort",
        "pageNum":1,
        "pageSize":9999
      }),
      async: false,// 此处设为同步 是为了获取加载好的数据的泳道的高度
      success: function (data) {
        console.log(data, ToolsConfigJson)
        let showIconDataAll = []
        data.data.forEach(item => {
          showIconDataAll = showIconDataAll.concat([
            ...item.modelIconTree
          ])
        })
        var showIconData = showIconDataAll.filter((x, index, self) => { // 去除type重复的图例
          var arrids = []
          showIconDataAll.forEach((item, i) => {
            arrids.push(item.type)
          })
          const ret = arrids.indexOf(x.type) === index
          return ret
        })
        for (var key in ToolsConfigJson) {
          for (var i = 0; i < showIconData.length; ++i) {
            if (showIconData[i].type === ToolsConfigJson[key].type) {
              ToolsConfigJson[key].iconPath = me.baseUrl + '/bpm/attachment/download/' + showIconData[i].iconId + '?attachmentType=bpm'
              ToolsConfigJson[key].baseType = showIconData[i].iconClassify
            }
          }
        }
        me.options.toolsGroup =[{
          controls: showIconData.map(item => {
            if (item.status === 1) {
              return item.type
            }
          })
        }]
        console.log(showIconData, 9999)
      }
    })

    jq.extend(me.options, options);



    me._init();
  }

  window.GooFlow = GooFlow
  GooFlow.prototype = {
    // 处理放大之后，横纵泳道的变化
    changeScaleLine: function (bool, fn) {
      var me = this;
      // 修改工作区间的宽高
      jq(".GooFlow_workArea").css({
        "width": me.initSvgWidth * me.scaleTo,
        "height": me.initSvgHeight * me.scaleTo,
        "left": me.swimXwidth * me.scaleTo,
        "top": me.swimYheight * me.scaleTo
      })
      // 修改连线的svg的宽高
      jq(".GooFlow_workArea svg").css("transform", "scale(" + me.scaleTo + ")")

      // 包含泳道的容器
      jq(".swimlane-box").css({
        "width": (me.initSvgWidth + me.swimXwidth + 50) * me.scaleTo,
        "height": (me.initSvgHeight + me.swimYheight + (me.swimYheight == 90 ? 0 : 35)) * me.scaleTo
      })

      //-----------------------泳道横----------------------------------------------开始
      // 缩小泳道横和泳道竖的变大变小的选择框
      jq(".swimlaneX .ui-resizable-handle").css({
        "width": me.swimXwidth * me.scaleTo
      })
      // 横泳道的父容器
      jq(".swimlaneX-list").css({
        "width": (me.initSvgWidth + me.swimXwidth + (me.swimYheight == 90 ? 35 : 0)) * me.scaleTo,
        "height": me.initSvgHeight * me.scaleTo,
        "margin-top": me.swimYheight * me.scaleTo
      })

      //-----------------------泳道横----------------------------------------------结束

      //-----------------------泳道竖----------------------------------------------开始
      // 缩小泳道横和泳道竖的变大变小的选择框
      jq(".swimlaneY .ui-resizable-handle").css({
        "height": me.swimYheight * me.scaleTo
      })

      jq(".swimlaneY-list").css({
        "width": me.initSvgWidth * me.scaleTo,
        "height": (me.initSvgHeight + me.swimYheight + (me.swimYheight == 90 ? 0 : 35)) * me.scaleTo,
        "margin-left": me.swimXwidth * me.scaleTo
      })


      // 绘制泳道竖背景图的部分
      jq(".swimlaneY .rightImgPart").css({
        "height": me.swimYheight * me.scaleTo
      })

      jq(".swimlaneY .rightImgPart div").css({
        'border': (me.swimYheight * me.scaleTo) / 2 + 'px solid #fff',
        'border-left-width': 10 * me.scaleTo + 'px',
        'border-left-color': 'transparent',
        'border-right-width': 0
      })

      jq(".swimlaneY .leftImgPart").css({
        "height": me.swimYheight * me.scaleTo
      })
      jq(".swimlaneY .leftImgPart div").css({
        'border': (me.swimYheight * me.scaleTo) / 2 + 'px solid #fff',
        'border-left-width': 10 * me.scaleTo + 'px',
        'border-top-color': 'transparent',
        'border-right-width': 0,
        'border-bottom-color': 'transparent'
      })

      jq(".swimlaneY .surChooseLeaders").css({
        "width": 16 * me.scaleTo
      })
      jq(".swimlaneY .surChooseLeadersAdd").css({
        "width": 25 * me.scaleTo - 7 > 0 ? 25 * me.scaleTo - 7 : 2
      })
      jq(".swimlaneY .swimlane-title").css({
        "height": me.swimYheight * me.scaleTo
      })

      jq(".swimlaneY .swimlane-content").css({
        "height": (me.initSvgHeight + me.swimYheight) * me.scaleTo
      })
      jq(".swimlaneY .surChooseLeaders").css({
        "top": 58 * me.scaleTo + me.storeScroll.top,
        "height": 20 * me.scaleTo
      })
      jq(".swimlaneY .surChooseLeadersAdd").css({
        "top": 58 * me.scaleTo + me.storeScroll.top,
        "height": 18 * me.scaleTo
      })

      jq(".swimlaneX .surChooseLeaders").css({
        "left": 85 * me.scaleTo + me.storeScroll.left,
        "width": 16 * me.scaleTo,
        "height": 20 * me.scaleTo
      })
      jq(".swimlaneX .surChooseLeadersAdd").css({
        "left": (85 * me.scaleTo + me.storeScroll.left) - 75 > 0 ? (85 * me.scaleTo + me.storeScroll.left) - 75 : 2,
        "width": (25 * me.scaleTo) - 7,
        "height": (25 * me.scaleTo) - 7,
      })
      //-----------------------泳道竖----------------------------------------------结束

      for (var key in me.swimlanes) {
        jq("#" + key).css("width", me.swimlanes[key].width * me.scaleTo)
        jq("#" + key).css("height", me.swimlanes[key].height * me.scaleTo)
        //-----------------------泳道竖----------------------------------------------开始
        if (me.swimlanes[key].type === 'swimlaneY') {
          me.swimlanes[key].height = me.initSvgHeight + me.swimYheight + (me.swimYheight === 90 ? 0 : 35);
          if (me.swimYheight === 90) {
            jq("#" + key + ".swimlaneY .swimlane-title").css({
              "width": me.swimlanes[key].width * me.scaleTo,
              "height": me.swimYheight * me.scaleTo
            })
            jq(".swimlaneY .swimlane-title .showMemberTitle").css({
              "width": ((me.swimlanes[key].width * me.scaleTo) - 10) / me.scaleTo,
              "transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)",
              "-ms-transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)"
            })
          } else {
            jq("#" + me.swimlanes[key].id + ".swimlaneY .swimlane-title span").css({
              "transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)",
              "-ms-transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)",
              "width": (me.swimlanes[key].width - 20)
            })
            jq("#" + me.swimlanes[key].id + " .timeLine").css({
              "transform": 'scale(' + me.scaleTo + ')',
              "width": me.swimlanes[key].width
            })
          }
        }
        //-----------------------泳道竖----------------------------------------------结束
        //-----------------------泳道横----------------------------------------------开始
        if (me.swimlanes[key].type === 'swimlaneX') {
          if (me.swimYheight === 90) {
            jq("#" + key + ".swimlaneX .swimlane-title").css({
              "width": 90 * me.scaleTo,
              "height": me.swimlanes[key].height * me.scaleTo
            })
            jq(".swimlaneX .swimlane-title span").css({
              "width": ((90 * me.scaleTo) - 10) / me.scaleTo,
              "transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)",
              "-ms-transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)"
            })
            jq("#" + me.swimlanes[key].id + " .timeLine").css({
              "transform": 'scale(' + me.scaleTo + ')',
              "height": me.swimlanes[key].height
            })
          } else {
            jq("#" + key + ".swimlaneX .swimlane-title").css({
              "width": me.swimXwidth * me.scaleTo,
              "height": me.swimlanes[key].height * me.scaleTo
            })
            jq(".swimlaneX .swimlane-title .showMemberTitle").css({
              "width": ((me.swimXwidth * me.scaleTo) - 10) / me.scaleTo,
              "transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)",
              "-ms-transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)"
            })
          }
        }
        //-----------------------泳道横----------------------------------------------结束
      }
      if (fn) {
        fn()
      }
      // console.log(me.controls[keyCon].bindSwimYOffsetX);
      // console.log(me.controls[keyCon].bindSwimYId);

      for (var keyCon in me.controls) {
        if (me.controls[keyCon].bindSwimYId) {
          me.controls[keyCon].bindSwimYOffsetX = jq("#" + me.controls[keyCon].bindSwimYId).position().left
          me.controls[keyCon].bindSwimYOffsetY = jq("#" + me.controls[keyCon].bindSwimYId).position().top
        }
        if (me.controls[keyCon].bindSwimXId) {
          me.controls[keyCon].bindSwimXOffsetX = jq("#" + me.controls[keyCon].bindSwimXId).position().left
          me.controls[keyCon].bindSwimXOffsetY = jq("#" + me.controls[keyCon].bindSwimXId).position().top
        }
      }
    },


    // 画图区高度计算
    computedHeight: function (fn) {

      var me = this;
      var sumHeight = 0;
      for (var key in me.swimlanes) {
        if (me.swimlanes[key].type === 'swimlaneX') {
          sumHeight += parseFloat(me.swimlanes[key].height)
        }
      }
      me.initSvgHeight = sumHeight
      jq(".swimlaneY-list, .swimlane-box").css('height', sumHeight + me.swimYheight + (me.swimYheight == 90 ? 0 : 35))
      jq(".swimlaneX-list").css('height', sumHeight)
      jq(".GooFlow_workArea").css({
        "height": me.initSvgHeight * me.scaleTo
      })

      jq(".GooFlow_workArea svg").css({
        "width": me.initSvgWidth,
        "height": (parseFloat(jq(".GooFlow_workArea").css("height"))) / me.scaleTo
      })
      for (var key in me.swimlanes) {
        if (me.swimlanes[key].type === 'swimlaneY') {
          me.swimlanes[key].height = me.initSvgHeight + me.swimYheight + (me.swimYheight == 90 ? 0 : 35);
          var arr = Object.keys(me.swimlanes);
          jq("#" + me.swimlanes[key].id).css("height", me.swimlanes[key].height * me.scaleTo);
          jq("#" + me.swimlanes[key].id + " .swimlane-content").css("height", ((me.initSvgHeight + me.swimYheight)) * me.scaleTo);
        }
        jq("#" + key + ".swimlaneX .swimlane-title").css({
          "height": me.swimlanes[key].height * me.scaleTo
        })
        jq("#" + key + ".swimlaneY .swimlane-title span").css({
          "width": (me.swimlanes[key].width - 20)
        })
      }
      me.computedApproveTime(me)
      if (fn) {
        fn()
      }
    },

    // 计算审批时间
    computedApproveTime: function (me) {
      for (var key in me.swimlanes) {
        if (me.swimlanes[key].type === 'swimlaneY') {
          let swimlaneYTime = 0
          for (var cons in me.controls) {
            if (me.controls[cons].bindSwimYId == me.swimlanes[key].id && !!me.controls[cons].time && !isNaN(me.controls[cons].time)) {
              //console.log(me.controls[cons].time)
              swimlaneYTime += Number(me.controls[cons].time)
            }
          }
          //console.log(me.swimlanes[key].id, swimlaneYTime)
          jq("#" + me.swimlanes[key].id + " .timeLine").html(swimlaneYTime)
        }
      }
    },

    // 画图区宽度计算
    computedWidth: function (fn) {
      var me = this;
      var duanWidth = 0;
      for (var i = 0; i < jq(".swimlaneY-list .swimlaneY").length; i++) {
        duanWidth += me.swimlanes[jq(".swimlaneY-list .swimlaneY").eq(i).attr("id")].width
      }
      for (var i = 0; i < jq(".swimlaneX-list .swimlaneX").length; i++) {
        me.swimlanes[jq(".swimlaneX-list .swimlaneX").eq(i).attr("id")].width = duanWidth + me.swimXwidth + (me.swimYheight == 90 ? 35 : 0);
        jq(".swimlaneX-list .swimlaneX").eq(i).css("width", (duanWidth + me.swimXwidth + (me.swimYheight == 90 ? 35 : 0)) * me.scaleTo)
      }
      jq(".GooFlow_workArea").css({
        "width": duanWidth * me.scaleTo
      })
      jq(".GooFlow_workArea svg").css({
        "width": duanWidth / me.scaleTo
      })

      jq(".swimlaneY-list").css({
        "width": duanWidth * me.scaleTo
      })
      jq(".swimlaneX-list").css({
        "width": (duanWidth + me.swimXwidth + 50 + (me.swimYheight == 90 ? 35 : 0)) * me.scaleTo
      })
      jq(".swimlane-box").css({
        "width": (duanWidth + me.swimXwidth + 50 + (me.swimYheight == 90 ? 35 : 0)) * me.scaleTo
      })

      me.initSvgWidth = duanWidth
      if (fn) {
        fn()
      }
    },

    constructor: GooFlow,

    _init: function () {
      var me = this;
      if (this.options.haveHead) {
        this._initHeadBtns();
      }


      this._initTools()
      this.username = getCookie("username");
      //console.log(this.username)
      // 到时候产生删除
      //
      // if (!this.username) {
      //     window.parent.logoutbpa();
      //     return false;
      // }
      this._initleticon()

      this._initWorkArea();
      this._initAttrGroups();
      this._initLayout();
      this._initContextMenu();
      if (!!me.isEdit) {
        this._initLeftRightBtn();
      }


      jQuery.support.cors = true;
      jq.ajax({
        type: 'POST',
        url: me.baseUrl + '/modellist/get/' + me.listid + '?username=' + me.username,
        data: {},
        async: false,
        success: function (res) {
          console.log('555',res)
          me.storeData = res
        },
        error: function (err) {
          console.log(err)
        }
      })


      let processInfo = sessionStorage.getItem('processInfo') ? JSON.parse(sessionStorage.getItem('processInfo')) : {}

      // 属性只读
      me.isReadAttr = 'true';

      // me.isEdit = processInfo.isReadAttr === 'true' ? false : me.isEdit;

      // me.isEditAttr = processInfo.isReadAttr === 'true' ? false : me.isEdit;


      if (this.id && !!me.isEdit) {
        clearInterval(this.setIntervalSave);
        // this.setIntervalSave = setInterval(function(){
        //     me.onBtnSaveClick(true, function () {
        //         //console.log('60s保存成功!')
        //     })
        // }, 60000);
      }
    },

    /**
     * 初始化头部功能按钮
     */
    _initHeadBtns: function () {
      var me = this
      this.$container.addClass('GooFlow');
      console.log(getCookie('storeChangeState'), 'getCookie(storeChangeState)')
      if (this.options.toolBtns && this.options.toolBtns.length > 0) {
        // if (!getParam("isReadAttr")) {
        //   console.log(headerBtn.renderHeaderBtn, 'renderHeaderBtn')
        //   tmpss = headerBtn.renderHeaderBtn
        // }
        if (!getParam("isReadAttr") && getCookie('storeChangeState') !== 'publish') {
          console.log(headerBtn.renderHeaderBtn, 'renderHeaderBtn')
          tmp = headerBtn.btn;
          // headerBtn.renderHeaderBtn('#headerBtn');
        } else {
          tmp = ''
        }

        tmps = "<span id='head_2_item1' class='head_2_item'><select id='selectVal' class='itemsselect'><option value='0.50'>50%</option><option value='0.75'>75%</option><option value='1'>100%</option><option value='1.25'>125%</option><option value='1.5'>150%</option><option value='1.75'>175%</option><option value='2'>200%</option></select></span>";
          // " <span  id='head_2_item2' class='ico_Norma'>" + jq.i18n.prop("fitToScreen") + "</span>";
        // <span  id='head_2_item3' class='ico_full'>填充屏幕</span>

        if (window.isEditAttr === false) {
          tmp = ''
          for (var i = 0; i < this.options.toolBtns.length; ++i) {
            if (this.options.toolBtns[i].name == 'scaleNormal') {
              tmps += "<a href='javascript:void(0)' title='" + this.options.toolBtns[i].title + "' type='" + this.options.toolBtns[i].name + "' id='btn_" + this.options.toolBtns[i].name.split(" ")[0] + "' class='GooFlow_head_btn'><i style='background-image: url(./img/" +
                'ico_' + this.options.toolBtns[i].name + ".png);background-repeat: no-repeat;background-size:100% 100%;' class='ico_" + this.options.toolBtns[i].name + "'/><span class='ico_" + this.options.toolBtns[i].name + "'  style='font-size: 12px;color: #333;padding-right: 2px;display: inline-block;'>" + this.options.toolBtns[i].title + "</span></a>";
            }
          }
        } else {
          for (var i = 0; i < this.options.toolBtns.length; ++i) {
            if (
              !this.isEdit &&
              (this.options.toolBtns[i].name == 'save' ||
                this.options.toolBtns[i].name == 'issue' ||
                this.options.toolBtns[i].name == 'copy' ||
                this.options.toolBtns[i].name == 'verticalCenter' ||
                this.options.toolBtns[i].name == 'ctrlz' ||
                this.options.toolBtns[i].name == 'ctrly' ||
                this.options.toolBtns[i].name == 'leftAlign' ||
                this.options.toolBtns[i].name == 'rightAlign' ||
                this.options.toolBtns[i].name == 'horizonCenter' ||
                this.options.toolBtns[i].name == 'topAlign' ||
                this.options.toolBtns[i].name == 'bottomAlign' ||
                this.options.toolBtns[i].name == 'backlist' ||
                this.options.toolBtns[i].name == 'full' ||
                this.options.toolBtns[i].name == 'print' ||
                this.options.toolBtns[i].name == 'qiehuan' ||
                this.options.toolBtns[i].name == 'verify' ||
                this.options.toolBtns[i].name == 'qiehuanbgimg' ||
                this.options.toolBtns[i].name == 'versionContrast' ||
                this.options.toolBtns[i].name == 'AutoCoding' ||
                this.options.toolBtns[i].name == 'procFunAllocation')

            ) continue;
            if (getParam("isReadAttr") === 'true' && (this.options.toolBtns[i].name == 'change' ||
                // this.options.toolBtns[i].name == 'save' ||
                // this.options.toolBtns[i].name == 'temporalit' ||
                this.options.toolBtns[i].name == 'import')) continue;
            if (this.options.toolBtns[i].name == 'save' ||
              this.options.toolBtns[i].name == 'temporalit' ||
              this.options.toolBtns[i].name == 'copy' ||
              this.options.toolBtns[i].name == 'change' ||
              this.options.toolBtns[i].name == 'derive' ||
              this.options.toolBtns[i].name == 'import' ||
              this.options.toolBtns[i].name == 'issue' ||
              this.options.toolBtns[i].name == 'print' ||
              this.options.toolBtns[i].name == 'help'

            ) {
              // if ( this.options.toolBtns[i].name == 'ctrlz' ||
              // this.options.toolBtns[i].name == 'ctrly' ||
              // this.options.toolBtns[i].name == 'help') {
              //   tmp += "<a href='javascript:void(0)' style='float: right' title='" + this.options.toolBtns[i].title + "' type='" + this.options.toolBtns[i].name + "' id='btn_" + this.options.toolBtns[i].name.split(" ")[0] + "' class='GooFlow_head_btn'><span class='ico_" +
              //   this.options.toolBtns[i].name + "'><img style='vertical-align: middle;height: 98%;margin-right: 4px' src=" + "./img/" + 'ico_' + this.options.toolBtns[i].name + ".png" + "></img>" + this.options.toolBtns[i].title + "</span></a>";; //加入自定义按钮带图标
              // } else {
                tmp += "<a href='javascript:void(0)' title='" + this.options.toolBtns[i].title + "' type='" + this.options.toolBtns[i].name + "' id='btn_" + this.options.toolBtns[i].name.split(" ")[0] + "' class='GooFlow_head_btn'><span class='ico_" +
                this.options.toolBtns[i].name + "'>" + this.options.toolBtns[i].title + "</span></a>"; //加入自定义按钮
              // }
            } else {
              tmps += "<a href='javascript:void(0)' title='" + this.options.toolBtns[i].title + "' type='" + this.options.toolBtns[i].name + "' id='btn_" + this.options.toolBtns[i].name.split(" ")[0] + "' class='GooFlow_head_btn'><i style='background-image: url(./img/" +
                // 'ico_' + this.options.toolBtns[i].name + ".png);background-repeat: no-repeat;background-size:100% 100%;' class='ico_" + this.options.toolBtns[i].name + "'/></a>"; //加入自定义按钮
                'ico_' + this.options.toolBtns[i].name + ".png);background-repeat: no-repeat;background-size:100% 100%;' class='ico_" + this.options.toolBtns[i].name + "'/><span class='ico_" + this.options.toolBtns[i].name + "'  style='font-size: 12px;color: #333;padding-right: 2px;display: inline-block;'>" + this.options.toolBtns[i].title + "</span></a>"; //加入自定义按钮
              }
          }
        }

        this.$head = jq('<div class="GooFlow_head"></div>');
        this.$head_2 = jq('<div class="GooFlow_head_2"></div>');
        this.$head.append(jq(tmp));
        this.$head_2.append(jq(tmps));

        this.$container.append(this.$head);
        this.$container.append(this.$head_2);

        // this.$container.append(jq('<div class="dialogItem"></div>'));
        if (!getParam("isReadAttr") && getCookie('storeChangeState') !== 'publish') {

          headerBtn.renderHeaderBtn('#headerBtn');
        }else {
          if(!window.location.href.indexOf('isRead=no')){
            jq('.GooFlow_head_2').hide();
            setTimeout(function(){
              jq('#GooFlow_work').css({
                marginTop: '30px'
              })
              jq('#processTabMenu,.attrWrapper').css({
                marginTop: 0
              })
            },2000)
          }
        }

      }
      jq("#selectVal").val("1")
      this.$head.on("click", {
        inthis: this
      }, function (e) {
        if (!e) e = window.event;
        var tar = e.target;
        console.log(tar)
        if (tar.tagName == "DIV") return;
        else if (tar.tagName == "A") tar = tar.childNodes[0];

        // FIREFOX
        if (tar.tagName == "OPTION") {
          if (This.onScaleMaxClick != null) This.onScaleMaxClick();
          return
        }
        var This = e.data.inthis;
        //定义顶部操作栏按钮的事件
        switch (jq(tar).attr("class")) {
          case "ico_save":
            if (This.onBtnSaveClick != null) This.onBtnSaveClick(null, null, 'ico_save');
            break;
          case "ico_temporalit":
            if (This.onBtnSaveClick != null) This.onBtnSaveClick(null, null, 'ico_temporalit');
            break;
          case "ico_reload":
            if (This.onFreshClick != null) This.onFreshClick();
            break;
          case "ico_print":
            if (This.onPrintClick != null) This.onPrintClick();
            break;
          case "ico_full":
            if (This.onFullScreenClick != null) This.onFullScreenClick();
            break;
          case "ico_scaleMin":
            if (This.onScaleMinClick != null) This.onScaleMinClick();
            break;
          case "ico_scaleMax":
            if (This.onScaleMaxClick != null) This.onScaleMaxClick();
            break;
          case "ico_voice":
            if (This.onVoiceClick != null) This.onVoiceClick();
            break;
          case "ico_issue":
            if (This.onIssueClick != null) This.onIssueClick();
            break;
          case "ico_ctrlz":
            if (This.onCtrlzClick != null) This.onCtrlzClick();
            break;
          case "ico_ctrly":
            if (This.onCtrlyClick != null) This.onCtrlyClick();
            break;
          case "ico_help":
            if (This.onHelpClick != null) This.onHelpClick();
              break;
          case "ico_scaleNormal":
            if (This.onNormalClick != null) This.onNormalClick();
            break;
          case "ico_copy":
            if (This.onCopyChartClick != null) This.onCopyChartClick();
            break;
          case "ico_verticalCenter":
            if (This.onVerticalCenterClick != null) This.onVerticalCenterClick();
            break;
          case "ico_leftAlign":
            if (This.onLeftAlignClick != null) This.onLeftAlignClick();
            break;
          case "ico_rightAlign":
            if (This.onRightAlignClick != null) This.onRightAlignClick();
            break;
          case "ico_horizonCenter":
            if (This.onHorizonCenterClick != null) This.onHorizonCenterClick();
            break;
          case "ico_topAlign":
            if (This.onTopAlignClick != null) This.onTopAlignClick();
            break;
          case "ico_bottomAlign":
            if (This.onBottomAlignClick != null) This.onBottomAlignClick();
            break;
          case "ico_backlist":
            if (This.onBacklistClick != null) This.onBacklistClick();
            break;
          case "ico_change":
            if (This.onChangeClick != null) This.onChangeClick();
            break;
          case "ico_qiehuan":
            if (This.onChangeClick != null) This.onQiehuanClick();
            break;
          case "ico_verify":
            if (This.onVerifyClick != null) This.onVerifyClick();
            break;
          case "ico_qiehuanbgimg":
            if (This.onChangeBgImgClick != null) This.onChangeBgImgClick();
            break;
          case "ico_derive":
            if (This.oneduceClick != null) This.oneduceClick();
            break;
          case "ico_versionContrast":
            if (This.contrastClick != null) This.contrastClick();
            break;
          case "ico_AutoCoding":
            if (This.autoCodingClick != null) This.autoCodingClick();
            break;
          case "ico_procFunAllocation":
            if (This.procFunAllocationClick != null) This.procFunAllocationClick();
            break;

        }
      });
      this.$head_2.on("click", {
        inthis: this
      }, function (e) {
        if (!e) e = window.event;
        var tar = e.target;
        console.log(tar.tagName)
        if (tar.className == 'itemsselect') {
          // me.onItemsselectClick()
          me.onScaleMaxClick()
        }
        if (tar.className == 'ico_Norma') {
          me.onNormalClick()
        }
        if (tar.className == 'ico_full') {
          me.onFullScreenClick()
        }
        if (tar.tagName == "DIV") return;
        else if (tar.tagName == "A") tar = tar.childNodes[0];
        var This = e.data.inthis;

        // FIREFOX
        if (tar.tagName == "OPTION") {
          if (This.onScaleMaxClick != null) This.onScaleMaxClick();
          return
        }

        //定义顶部操作栏按钮的事件
        switch (jq(tar).attr("class")) {
          case "ico_save":
            if (This.onBtnSaveClick != null) This.onBtnSaveClick(null, null, 'ico_save');
            break;
          case "ico_temporalit":
            if (This.onBtnSaveClick != null) This.onBtnSaveClick(null, null, 'ico_temporalit');
            break;
          case "ico_reload":
            if (This.onFreshClick != null) This.onFreshClick();
            break;
          case "ico_print":
            if (This.onPrintClick != null) This.onPrintClick();
            break;
          case "ico_full":
            if (This.onFullScreenClick != null) This.onFullScreenClick();
            break;
          case "ico_scaleMin":
            if (This.onScaleMinClick != null) This.onScaleMinClick();
            break;
          case "ico_scaleMax":
            if (This.onScaleMaxClick != null) This.onScaleMaxClick();
            break;
          case "ico_voice":
            if (This.onVoiceClick != null) This.onVoiceClick();
            break;
          case "ico_issue":
            if (This.onIssueClick != null) This.onIssueClick();
            break;
            case "ico_ctrlz":
              if (This.onCtrlzClick != null) This.onCtrlzClick();
              break;
            case "ico_ctrly":
              if (This.onCtrlyClick != null) This.onCtrlyClick();
              break;
            case "ico_help":
              if (This.onHelpClick != null) This.onHelpClick();
                break;
          case "ico_scaleNormal":
            if (This.onNormalClick != null) This.onNormalClick();
            break;
          case "ico_copy":
            if (This.onCopyChartClick != null) This.onCopyChartClick();
            break;
          case "ico_verticalCenter":
            if (This.onVerticalCenterClick != null) This.onVerticalCenterClick();
            break;
          case "ico_leftAlign":
            if (This.onLeftAlignClick != null) This.onLeftAlignClick();
            break;
          case "ico_rightAlign":
            if (This.onRightAlignClick != null) This.onRightAlignClick();
            break;
          case "ico_horizonCenter":
            if (This.onHorizonCenterClick != null) This.onHorizonCenterClick();
            break;
          case "ico_topAlign":
            if (This.onTopAlignClick != null) This.onTopAlignClick();
            break;
          case "ico_bottomAlign":
            if (This.onBottomAlignClick != null) This.onBottomAlignClick();
            break;
          case "ico_backlist":
            if (This.onBacklistClick != null) This.onBacklistClick();
            break;
          case "ico_change":
            if (This.onChangeClick != null) This.onChangeClick();
            break;
          case "ico_qiehuan":
            if (This.onChangeClick != null) This.onQiehuanClick();
            break;
          case "ico_verify":
            if (This.onVerifyClick != null) This.onVerifyClick();
            break;
          case "ico_qiehuanbgimg":
            if (This.onChangeBgImgClick != null) This.onChangeBgImgClick();
            break;
          case "ico_derive":
            if (This.oneduceClick != null) This.oneduceClick();
            break;
          case "ico_versionContrast":
            if (This.contrastClick != null) This.contrastClick();
            break;
          case "ico_AutoCoding":
            if (This.autoCodingClick != null) This.autoCodingClick();
            break;
          case "ico_procFunAllocation":
            if (This.procFunAllocationClick != null) This.procFunAllocationClick();
            break;

        }
      });

      //--------------------------------头部按钮区域----------------------------开始
      // 缩小
      me.onScaleMinClick = function (fn) {
        if (me.scaleTo == 0.5) {
          me.alertBox("已经不能在缩小了！", "warning");
          return false;
        }
        me.scaleTo = (parseFloat(me.scaleTo) - 0.1).toFixed(1);
        me.computedHeight(function () {
          jq(".GooFlow_workArea .control").css("transform", "scale(" + me.scaleTo + ")")
          for (var key in me.controls) {
            jq("#" + key).css("left", me.controls[key].left * me.scaleTo)
            jq("#" + key).css("top", me.controls[key].top * me.scaleTo)
          }
          me.changeScaleLine(true, fn);
        });
      };
      // 放大
      me.onScaleMaxClick = function () {
        var myselect = document.getElementById("selectVal");
        var index = myselect.selectedIndex;
        var indexVal = myselect.options[index].value
        //console.log('me.scaleTo', indexVal)
        me.scaleTo = indexVal;
        //console.log('me.scaleTo', me.scaleTo)
        me.computedHeight(function () {
          jq(".GooFlow_workArea .control").css("transform", "scale(" + me.scaleTo + ")");
          for (var key in me.controls) {
            me.controls[key].$el.css("left", me.controls[key].left * me.scaleTo)
            me.controls[key].$el.css("top", me.controls[key].top * me.scaleTo)
          }
          me.changeScaleLine(true);
        });
      };


      me.onBtnSaveClick = function (bool, fn, type, bpmid) {
        console.log(8)
        me.blurItem()
        // 获取生成图的接送数据
        var json = me.getToJSON();
        var inputids = [];
        var outputids = [];
        let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
        for (var i = 0; i < json.controls.length; i++) {
          if (json.controls[i]) {
            if ((json.controls[i].top + json.controls[i].height) < (parseFloat(jq(".swimlaneX-list .swimlaneX:first").css("height")) / basFlow.scaleTo)) {
              if (json.controls[i].processGroup && json.controls[i].processGroup[0]) {
                inputids.push(json.controls[i].processGroup[0].id)
              }
            }
            else if ((json.controls[i].top) > (jq(".swimlaneX-list .swimlaneX:last").position().top / basFlow.scaleTo)) {
              if (json.controls[i].processGroup && json.controls[i].processGroup[0]) {
                outputids.push(json.controls[i].processGroup[0].id)
              }
            }
          }
        }
        var tempArr = [];
        var referArr = {}
        for (var i = 0; i < json.controls.length; i++) {
          if (type !== 'ico_temporalit' && !processInfo.processType) {
            if (json.controls[i].splitType == 'downProcess' || json.controls[i].splitType == 'upProcess') {
              if (!json.controls[i].processGroup.length) {
                basFlow.alertBox(jq.i18n.prop("needProcess") + "! ", 'danger');
                return false;
              }
            }
          }
          if (json.controls[i].type == 'processStart' || json.controls[i].type == 'processEnd') {
            if (!!referArr[json.controls[i].type]) {
              referArr[json.controls[i].type].ids.push(json.controls[i].id)
            } else {
              referArr[json.controls[i].type] = {
                name: json.controls[i].type,
                ids: [json.controls[i].id]
              }
            }
          }
          // getCookie('qiehuanbgimg') != 'bg_img_white' 切换成没有网格时 去除提示
          if (type !== 'ico_temporalit' && !processInfo.processType) {
            if (
              ((!json.controls[i].bindSwimXId && getCookie('qiehuanbgimg') != 'bg_img_white') ||
                (!json.controls[i].bindSwimYId && getCookie('qiehuanbgimg') != 'bg_img_white')) &&
              json.controls[i].type != 'spliceGroup' &&
              json.controls[i].type != 'note' &&
              json.controls[i].type.indexOf('enterprise') == -1
            ) {
              basFlow.alertBox(json.controls[i].name + jq.i18n.prop("lineWarn") + "! ", 'danger');
              return false;
            }
          }
          if (json.controls[i].type == 'processTask' || json.controls[i].type == 'processIt') {
            if (type !== 'ico_temporalit' && !processInfo.processType) {
              if ((!json.controls[i].bindSwimXId && getCookie('qiehuanbgimg') != 'bg_img_white') && !bool) {
                basFlow.alertBox(jq.i18n.prop("tooltipData") + "! ", 'danger');
                return false;
              }
            }
            for (var j = 0; j < json.swimlanes.length; j++) {
              console.log('json', 1, json.swimlanes)

              if (json.controls[i].bindSwimXId == json.swimlanes[j].id) {
                //console.log(json.controls[i], json.swimlanes[j])
                json.controls[i].SwimlaneName = json.swimlanes[j].name;
                json.controls[i].DeptName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
                json.controls[i].StationName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
                tempArr.push(json.controls[i]);
                break;
              }
            }
          }
          if (type !== 'ico_temporalit' && !processInfo.processType) {
            if (json.controls[i].type == 'processTask') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'processStart') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'processEnd') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'exclusiveGateway') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'processGateway') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
          }
        }

        if (type !== 'ico_temporalit' && !processInfo.processType) {

          // if (!referArr['processStart']) {
          //   basFlow.alertBox(jq.i18n.prop("needStart") + "! ", 'danger');
          //   return false;
          // }
          // if (!referArr['processEnd']) {
          //   basFlow.alertBox(jq.i18n.prop("needEnd") + "! ", 'danger');
          //   return false;
          // }
          //console.log(json)
          var referLines = { 'processStart': false, 'processEnd': false }
          console.log('json.linesjson.linesjson.linesjson.lines', json.lines)
          for (var i = 0; i < json.lines.length; i++) {
            if (
              referArr['processStart'] &&
              referArr['processStart'].ids &&
              (
                json.lines[i].from == referArr['processStart'].ids[0] ||
                json.lines[i].to == referArr['processStart'].ids[0]
              )
            ) {
              referLines.processStart = true
            }
            if (
              referArr['processEnd'] &&
              referArr['processEnd'].ids &&
              (
                json.lines[i].from == referArr['processEnd'].ids[0] ||
                json.lines[i].to == referArr['processEnd'].ids[0]
              )
            ) {
              referLines.processEnd = true
            }
          }

          // if (!referLines.processStart) {
          //   basFlow.alertBox(jq.i18n.prop("needStartLine") + "! ", 'danger');
          //   return false;
          // }
          // if (!referLines.processEnd) {
          //   basFlow.alertBox(jq.i18n.prop("needEndLine") + "! ", 'danger');
          //   return false;
          // }
        }
        if (json.controls && json.controls.length > 0) {
          json.controls.forEach(item => {
            delete item.processGroupList
            // delete item.messageFileType

          })
        }
        var JSONval = JSON.stringify(json);
        var swimlane = getCookie("qiehuan")
        me.saveProcessFlow(false, function () {
          console.log('saveHistory', json)
          jq.ajax({
            type: "POST",
            url: basFlow.baseUrl + "/listhistory/saveHistory?username=" + basFlow.username,
            contentType: 'application/json;',
            data: JSON.stringify({
              "listid": getParam("id"),
              "json": JSONval,
              "inputname": inputids.length == 0 ? '' : inputids.join(","),
              "outputname": outputids.length == 0 ? '' : outputids.join(","),
              "activityname": JSON.stringify({ "name": tempArr }),
              "swimid": me.listid,
              "swimlane": swimlane,
            }),
            success: function (data) {
              if (bool) {
                if (!!fn) {
                  fn(data)
                }
                return false
              }
              //console.log(data)
              if (typeof data === 'string') {
                basFlow.alertBox(data, 'danger');
              }
              if (data) {
                basFlow.alertBox(type === 'ico_temporalit' ? '暂存成功！' : "保存成功！", 'success');
                sessionStorage.setItem('chartJson', JSONval)
              } else {
                basFlow.alertBox(type === 'ico_temporalit' ? '暂存失败' : "保存失败！", 'danger');
              }
              if (bpmid) {
                window.getProcessJson('Update')
              }
            }
          })
          if (json.controls && json.controls.length > 0) {
            let nodeList = json.controls.map(item => {
              let enterpriseStandardFile = item.enterpriseStandardFile && item.enterpriseStandardFile.length > 0 ? item.enterpriseStandardFile.map(val => val.id) : []
              return {
                keyid: item.id,
                docids: enterpriseStandardFile
              }
            })
            jq.ajax({
              type: "POST",
              url: basFlow.baseUrl + "/standardRele/nodeSave  ",
              contentType: 'application/json;',
              data: JSON.stringify({
                "listid": me.id,
                "nodeList": nodeList
              }),
              success: function (data) {
              }
            })
          }
        })

      };
      window.onBtnSaveClick = me.onBtnSaveClick
      // 用来给vue页面判断流程图是否存在节点
      me.isNodesInProcess = function (bool, fn, type) {
        console.log(1)
        me.blurItem()
        // 获取生成图的接送数据
        var json = me.getToJSON();
        var inputids = [];
        var outputids = [];
        let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
        for (var i = 0; i < json.controls.length; i++) {
          if (json.controls[i]) {
            if ((json.controls[i].top + json.controls[i].height) < (parseFloat(jq(".swimlaneX-list .swimlaneX:first").css("height")) / basFlow.scaleTo)) {
              if (json.controls[i].processGroup && json.controls[i].processGroup[0]) {
                inputids.push(json.controls[i].processGroup[0].id)
              }
            }
            else if ((json.controls[i].top) > (jq(".swimlaneX-list .swimlaneX:last").position().top / basFlow.scaleTo)) {
              if (json.controls[i].processGroup && json.controls[i].processGroup[0]) {
                outputids.push(json.controls[i].processGroup[0].id)
              }
            }
          }
        }
        var tempArr = [];
        var referArr = {}
        for (var i = 0; i < json.controls.length; i++) {
          if (type !== 'ico_temporalit' && !processInfo.processType) {
            if (json.controls[i].splitType == 'downProcess' || json.controls[i].splitType == 'upProcess') {
              if (!json.controls[i].processGroup.length) {
                basFlow.alertBox(jq.i18n.prop("needProcess") + "! ", 'danger');
                return false;
              }
            }
          }
          if (json.controls[i].type == 'processStart' || json.controls[i].type == 'processEnd') {
            if (!!referArr[json.controls[i].type]) {
              referArr[json.controls[i].type].ids.push(json.controls[i].id)
            } else {
              referArr[json.controls[i].type] = {
                name: json.controls[i].type,
                ids: [json.controls[i].id]
              }
            }
          }
          // getCookie('qiehuanbgimg') != 'bg_img_white' 切换成没有网格时 去除提示
          if (type !== 'ico_temporalit' && !processInfo.processType) {
            if (
              ((!json.controls[i].bindSwimXId && getCookie('qiehuanbgimg') != 'bg_img_white') ||
                (!json.controls[i].bindSwimYId && getCookie('qiehuanbgimg') != 'bg_img_white')) &&
              json.controls[i].type != 'spliceGroup' &&
              json.controls[i].type != 'note' &&
              json.controls[i].type.indexOf('enterprise') == -1
            ) {
              basFlow.alertBox(json.controls[i].name + jq.i18n.prop("lineWarn") + "! ", 'danger');
              return false;
            }
          }
          if (json.controls[i].type == 'processTask' || json.controls[i].type == 'processIt') {
            if (type !== 'ico_temporalit' && !processInfo.processType) {
              if ((!json.controls[i].bindSwimXId && getCookie('qiehuanbgimg') != 'bg_img_white') && !bool) {
                basFlow.alertBox(jq.i18n.prop("tooltipData") + "! ", 'danger');
                return false;
              }
            }
            for (var j = 0; j < json.swimlanes.length; j++) {
              console.log('json', 1, json.swimlanes)

              if (json.controls[i].bindSwimXId == json.swimlanes[j].id) {
                //console.log(json.controls[i], json.swimlanes[j])
                json.controls[i].SwimlaneName = json.swimlanes[j].name;
                json.controls[i].DeptName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
                json.controls[i].StationName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
                tempArr.push(json.controls[i]);
                break;
              }
            }
          }
          if (type !== 'ico_temporalit' && !processInfo.processType) {
            if (json.controls[i].type == 'processTask') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'processStart') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'processEnd') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'exclusiveGateway') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
            if (json.controls[i].type == 'processGateway') {
              for (var j = 0; j < json.controls.length; j++) {
                if (
                  (json.controls[j].type == 'processGateway' && json.controls[j].name === json.controls[i].name && json.controls[j].id !== json.controls[i].id) ||
                  (json.controls[j].type == 'processTask' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processStart' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'processEnd' && json.controls[j].name === json.controls[i].name) ||
                  (json.controls[j].type == 'exclusiveGateway' && json.controls[j].name === json.controls[i].name)
                ) {
                  basFlow.alertBox(jq.i18n.prop("taskNoName") + "\"" + json.controls[i].name + "\"" + jq.i18n.prop("noRepeat") + "! ", 'danger');
                  return false;
                }
              }
            }
          }
        }

        if (type !== 'ico_temporalit' && !processInfo.processType) {
          // if (!referArr['processStart']) {
          //   basFlow.alertBox(jq.i18n.prop("needStart") + "! ", 'danger');
          //   return false;
          // }
          // if (!referArr['processEnd']) {
          //   basFlow.alertBox(jq.i18n.prop("needEnd") + "! ", 'danger');
          //   return false;
          // }
          //console.log(json)
          console.log('json.linesjson.linesjson.linesjson.lines', referArr['processStart'])
          var referLines = { 'processStart': false, 'processEnd': false }
          for (var i = 0; i < json.lines.length; i++) {
            if (
              referArr['processStart'] &&
              referArr['processStart'].ids &&
              (
                json.lines[i].from == referArr['processStart'].ids[0] ||
                json.lines[i].to == referArr['processStart'].ids[0]
              )
            ) {
              referLines.processStart = true
            }
            if (
              referArr['processEnd'] &&
              referArr['processEnd'].ids &&
              (
                json.lines[i].from == referArr['processEnd'].ids[0] ||
                json.lines[i].to == referArr['processEnd'].ids[0]
              )
            ) {
              referLines.processEnd = true
            }
          }

          // if (!referLines.processStart) {
          //   basFlow.alertBox(jq.i18n.prop("needStartLine") + "! ", 'danger');
          //   return false;
          // }
          // if (!referLines.processEnd) {
          //   basFlow.alertBox(jq.i18n.prop("needEndLine") + "! ", 'danger');
          //   return false;
          // }
        }
        return true;
      }
      window.isNodesInProcess = me.isNodesInProcess
       // 绘图json
      me.chartJson = function () {
        var json = me.getToJSON();
        for (var i = 0; i < json.controls.length; i++) {
          if (json.controls[i].type == 'processTask' || json.controls[i].type == 'processIt') {
            for (var j = 0; j < json.swimlanes.length; j++) {
              if (json.controls[i].bindSwimXId == json.swimlanes[j].id) {
                //console.log(json.controls[i], json.swimlanes[j])
                json.controls[i].SwimlaneName = json.swimlanes[j].name;
                json.controls[i].DeptName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
                json.controls[i].StationName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
              }
            }
          }
        }

        if (json.controls && json.controls.length > 0) {
          json.controls.forEach(item => {
            delete item.processGroupList
            delete item.messageFileType
          })
        }
        return  json
      },
      window.chartJson = me.chartJson
      // 刷新
      me.onFreshClick = function () {
        location.reload();
      };
      // jq(".modalDialogVersions").on("click", ".confirmVersion", function () {
      //     me.version = ''
      //     if (jq(".modalDialogVersions .versionRadio:checked").val()) {
      //         me.version = 'redeploy@' + jq(".modalDialogVersions .versionRadio:checked").val()
      //         me.onIssueClickSave()
      //     } else {
      //         basFlow.alertBox("请选择重新部署的版本！", 'danger');
      //     }
      // }),
      //     jq(".modalDialogVersions").on("click", ".saveVersion", function () {
      //         me.version = ''
      //         me.onIssueClickSave()
      //     }),
      //发布
      this.onIssueClickSave = function () {
        // var me = this
        // this.onBtnSaveClick(true, function () {
        //     window.parent.openBpmUrl(me.liststate, me.listid, me.id, 'directbpm')
        // })
        var json = basFlow.getToJSON();
        var inputids = [];
        var outputids = [];
        for (var i = 0; i < json.controls.length; i++) {
          if (json.controls[i]) {
            if ((json.controls[i].top + json.controls[i].height) < (parseFloat(jq(".swimlaneX-list .swimlaneX:first").css("height")) / basFlow.scaleTo)) {
              if (json.controls[i].processGroup && json.controls[i].processGroup[0]) {
                inputids.push(json.controls[i].processGroup[0].id)
              }
              else if ((json.controls[i].top) > (jq(".swimlaneX-list .swimlaneX:last").position().top / basFlow.scaleTo)) {
                if (json.controls[i].processGroup && json.controls[i].processGroup[0]) {
                  outputids.push(json.controls[i].processGroup[0].id)
                }
              }
            }
          }

          var tempArr = [];
          for (var i = 0; i < json.controls.length; i++) {
            if (json.controls[i].type == 'processTask' || json.controls[i].type == 'processIt') {
              if (!json.controls[i].bindSwimXId) {
                basFlow.alertBox(jq.i18n.prop("tooltipData") + "! ", 'danger');
                return false;
              }
              for (var j = 0; j < json.swimlanes.length; j++) {
                console.log('json', 2, json.swimlanes)
                if (json.controls[i].bindSwimXId == json.swimlanes[j].id) {
                  //console.log(json.swimlanes[j])
                  json.controls[i].SwimlaneName = json.swimlanes[j].name;
                  json.controls[i].DeptName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
                  json.controls[i].StationName = !json.swimlanes[j].depts.length ? '' : json.swimlanes[j].depts.map(function (item) { return item.name + '(' + item.upLeveldeptname + (!item.deptTopname ? '' : (',' + item.deptTopname)) + ')' }).join(',');
                  tempArr.push(json.controls[i]);
                  break;
                }
              }
            }
          }
        }
        var JSONval = JSON.stringify(json);
        jq('#bg-loading').show()

        jq.ajax({
          type: "POST",
          url: basFlow.baseUrl + "/listhistory/saveBPM?username=" + basFlow.username,
          contentType: 'application/json;',
          data: JSON.stringify({
            "listid": me.id,
            "json": JSONval,
            "inputname": inputids.length == 0 ? '' : inputids.join(","),
            "outputname": outputids.length == 0 ? '' : outputids.join(","),
            "activityname": JSON.stringify({ "name": tempArr }),
            "swimid": me.listid,
            'versionType': me.version
          }),
          success: function (data) {
            if (data) {
              jq(".modalDialogVersions").hide();
              jq('#bg-loading').hide()
              basFlow.alertBox("发布成功！", 'success');
            } else {
              basFlow.alertBox("发布失败！", 'danger');
            }

          }
        });
        me.onBtnSaveClick()
      };
      // 发布
      me.onIssueClick = function () {
        //console.log(me.id)
        jq.ajax({
          type: "POST",
          url: basFlow.baseUrl + "/listhistory/getBpmPublishedList/" + me.id + "?username=" + basFlow.username,
          contentType: 'application/json;',
          success: function (data) {
            if (data.length === 0) {
              me.onIssueClickSave()
            } else {
              var doTData = doT.template(jq('#versions-tem').text())
              jq('#versionsTable').html(doTData({ list: data }))
              jq(".modalDialogVersions").show();
            }
          }
        });
      };
      // 发布
      me.onIssueClick = function () {
        var me = this
        jq.ajax({
          type: "GET",
          url: basFlow.baseUrl + "/modelapprove/get/4",
          contentType: 'application/json;',
          success: function (response) {
            //console.log(response)
            if (response.code === 200) {
              if (!response.data) return false;
              if (response.data.choosed === 'direct') {
                me.confirmBox('确认要发布吗? ', function () {
                  me.onBtnSaveClick(true, function () {
                    // window.parent.openBpmUrl('5', me.listid, me.id, 'direct')
                    jq.ajax({
                      type: "POST",
                      url: basFlow.baseUrl + "/modellist/releaseCopy?username=" + basFlow.username,
                      contentType: 'application/json;',
                      data: JSON.stringify({
                        "id": me.listid,
                      }),
                      success: function (response) {
                        //console.log('response发布', response);
                        if (response.code === 200) {
                          basFlow.alertBox("发布成功！", 'success');
                          me.upDateProcessState()
                          if (!response.data) return false;
                        }
                      }
                    })
                  })
                })
              } else {
                jq.ajax({
                  type: "GET",
                  url: basFlow.baseUrl + "/modellist/releaseVerification/" + me.listid,
                  contentType: 'application/json;',
                  success: function (rt) {
                    if (rt.code === 200) {
                      jq.ajax({
                        type: "GET",
                        url: basFlow.baseUrl + "/userModel/getCurrentUserPost",
                        contentType: 'application/json;',
                        success: function (res) {
                          if (res.status === '200' && res.data) {
                            var str = "";
                            str += "<select>";
                            for (var i = 0; i < res.data.length; i++) {//该数组为嵌套数组[[xx],[xx],[xx]]形式
                              str += " <option title=" + res.data[i].id + ">" + res.data[i].name + "</option>";
                            }
                            str += "</select>";
                            //console.log(str)
                            jq("#postSelectWrap").html(str)

                            jq(".modalDialogPost").show();
                          }
                        }
                      });
                    } else {
                      me.alertBox(rt.msg, 'danger');
                    }
                  }
                });
              }
            }
          }
        });

      };
      // 撤回
      me.onCtrlzClick = function () {
        var backLastItem;
              if (me.ctrlZlist.length == 0) {
                return;
              }
              console.log("ctrl+z", me.ctrlZlist)
              backLastItem = me.ctrlZlist[me.ctrlZlist.length - 1];
              if (backLastItem.type == 'control') {
                if (backLastItem.method == 'add') {
                  me.ctrlYlist.push({
                      method: 'del',
                      type: 'control',
                      data: me.controls[backLastItem.id],
                      id: backLastItem.id
                  })
                me.delControl(backLastItem.id);
              } else if (backLastItem.method == 'del') {
                  me.ctrlYlist.push({
                      method: 'add',
                      type: 'control',
                      id: backLastItem.id,
                      data: backLastItem.data
                  })
                me.addControl(backLastItem.data);
              } else if (backLastItem.method == 'move') {
                //console.log(backLastItem)
                  me.ctrlYlist.push({
                      method: 'move',
                      type: 'control',
                      id: backLastItem.id,
                      data: {
                          ids: backLastItem.id,
                          controls: JSON.parse(JSON.stringify(me.controls)),
                          lines: JSON.parse(JSON.stringify(me.lines))
                      }
                  })
                  me.moveControl(backLastItem);
              }
            } else if (backLastItem.type == 'line') {
              if (backLastItem.method == 'add') {
                  me.ctrlYlist.push({
                      method: 'del',
                      type: 'line',
                      data: JSON.parse(JSON.stringify(me.lines[backLastItem.id])),
                      id: backLastItem.id
                  })
                me.delLine(backLastItem.id);
              } else if (backLastItem.method == 'del') {
                  me.ctrlYlist.push({
                      method: 'add',
                      type: 'line',
                      id: GooFlow.getUID('LINE'),
                      data: JSON.parse(JSON.stringify(backLastItem.data))
                  })
                me.addLine(backLastItem.data);
              }
            }
            else if (backLastItem.type == 'swimlane') {
              if (backLastItem.method == 'add') {
                  me.ctrlYlist.push({
                      method: 'del',
                      type: 'swimlane',
                      data: JSON.parse(JSON.stringify(me.swimlanes[backLastItem.id])),
                      id: backLastItem.id
                  })
                me.delSwimlane(backLastItem.id);
              } else if (backLastItem.method == 'del') {
                  me.ctrlYlist.push({
                      method: 'add',
                      type: 'swimlane',
                      data: JSON.parse(JSON.stringify(me.swimlanes[obj.id])),
                      id: backLastItem.data.id
                  })
                  me.addSwimlane(backLastItem.type == 'swimlaneY' ? 'y' : 'x', backLastItem.type == 'swimlaneY' ? '泳道竖' : '泳道', backLastItem.data);
                }
              }
              //console.log(me.ctrlZlist)
              me.ctrlZlist = me.ctrlZlist.splice(0, me.ctrlZlist.length - 2);
      };
      // 重做
      me.onCtrlyClick = function () {
        var advanceLastItem;
              if (me.ctrlYlist.length == 0) {
                  return;
              }
              console.log("ctrl+y")
              advanceLastItem = me.ctrlYlist[me.ctrlYlist.length - 1];
              console.log(me.ctrlYlist, advanceLastItem)

              if (advanceLastItem.type == 'control') {
                  if (advanceLastItem.method == 'add') {
                      me.delControl(advanceLastItem.id);
                  } else if (advanceLastItem.method == 'del') {
                      me.addControl(advanceLastItem.data);
                  } else if (advanceLastItem.method == 'move') {
                      console.log(advanceLastItem, me.controls)
                      me.moveControl(advanceLastItem);
                  }
              } else if (advanceLastItem.type == 'line') {
                  if (advanceLastItem.method == 'add') {
                      me.delLine(advanceLastItem.id);
                  } else if (advanceLastItem.method == 'del') {
                      me.addLine(advanceLastItem.data);
                  }
              }
              else if (advanceLastItem.type == 'swimlane') {
                  if (advanceLastItem.method == 'add') {
                      me.delSwimlane(advanceLastItem.id);
                  } else if (advanceLastItem.method == 'del') {
                      me.addSwimlane(advanceLastItem.type == 'swimlaneY' ? 'y' : 'x', advanceLastItem.type == 'swimlaneY' ? '泳道竖' : '泳道', advanceLastItem.data);
                  }
              }
              me.ctrlYlist = me.ctrlYlist.splice(0, me.ctrlYlist.length - 1);
              console.log(me.ctrlYlist)
      };
      // 帮助
      me.onHelpClick = function () {

      };
      me.upDateProcessState = function() {
        // jq.ajax({
        //   type: "POST",
        //   url: basFlow.baseUrl + "/modellist/queryCopy?username=" + basFlow.username,
        //   contentType: 'application/json;',
        //   data: JSON.stringify( {
        //     filters: [{ key: "modelid", value: getParam("treeId") }],
        //     orderby: "createon",
        //     pageNum: 1,
        //     pageSize: 10,
        //     sort: "desc",
        //   }),
        //   success: function (res) {
        //     if (!res.data) return false;
        //     let val = res.data.list[0];
        //     let obj = {
        //           id: val.bpmid,
        //           listid: val.id,
        //           treeId: getParam("treeId"),
        //           processName: val.name,
        //           username: '',
        //           processNum: val.code,
        //           state: val.state,
        //           isRead: 'no',
        //           item: val,
        //           treeData: sessionStorage.getItem('processInfo').treeData || {}
        //     }
            let processInfo = JSON.parse(sessionStorage.getItem('processInfo'))
            processInfo.state = '1'
            processInfo.item.state = '1'
            let processTabMenu = JSON.parse(sessionStorage.getItem('processTabMenu')) || []
            if (processTabMenu) {
                processTabMenu.forEach(item => {
                  if (item.listid === processInfo.listid) {
                    item = processInfo
                  }
                })
            }
            sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
            sessionStorage.setItem('processInfo', JSON.stringify(processInfo))
            window.getProcessJson('Update')
        //   }
        // })
      };
      jq(".modalDialogPost .confirmModelPost").on("click", function () {
        let value = jq("#postSelectWrap").find("option:selected").attr("title")
        let url = `${me.htmlUrl}/#/processForm/start?name=流程审批管理流程&processName=LCSPGLLC&projectName=LCSPGLLC&pid=${value}&listId=${me.listid}`
        window.open(url, '_blank')
      })

      jq(".chooseModalDialogPost").on("click", function () {
        jq(".modalDialogPost").hide(); // 选择工具
      })

      // 打印
      me.onPrintClick = function () {
        if (!!me.isEdit) {
          this.onBtnSaveClick();
        }
        this.saveProcessFlow(true);
      };

      //保存打印图片的html片段
      me.saveProcessFlow = function (bool, fn) {
        //console.log(this);

        var me = this;

        var processName = getParam("processName");
        //console.log(getParam)
        //console.log(processName)
        var username = getParam("username");
        var processnum = getParam("processNum");

        this.onNormalClick(function () {
          jQuery.support.cors = true;
          jq.ajax({
            type: "POST",
            url: basFlow.baseUrl + "/modelhtml/saveHtml?username=" + basFlow.username,
            contentType: 'application/json;',
            data: JSON.stringify({
              "id": getParam("id"),
              "json": jq("#basGooFlow").html(),
              "listid": me.listid,
              "name": processName,
              "num": processnum,
              "userid": me.username
            }),
            success: function (data) {
              jq.ajax({
                type: "POST",
                url: basFlow.baseUrl + "/modellist/updateModelListAndListBpmState",
                contentType: 'application/json;',
                data: JSON.stringify({
                  "listid": me.listid
                }),
                success: function (data) {
                }
              })
              if (bool) {
                window.open(basFlow.htmlUrl + '/leftMenu/printpreview.html?id=' + me.id + '&listid=' + me.listid + '&processName=' + processName + '&userid=' + me.username + '&processNum=' + processnum + '&treeId=' + getParam('treeId'));
              } else {
                if (!!fn) {
                  fn()
                }
              }
            }
          })
        })
      };
      // 缩小
      me.onScaleMinClick = function (fn) {
        if (me.scaleTo == 0.5) {
          me.alertBox("已经不能在缩小了！", "warning");
          return false;
        }
        me.scaleTo = (parseFloat(me.scaleTo) - 0.1).toFixed(1);
        me.computedHeight(function () {
          jq(".GooFlow_workArea .control").css("transform", "scale(" + me.scaleTo + ")")
          for (var key in me.controls) {
            jq("#" + key).css("left", me.controls[key].left * me.scaleTo)
            jq("#" + key).css("top", me.controls[key].top * me.scaleTo)
          }
          me.changeScaleLine(true, fn);
        });
      };

      // 恢复正常
      me.onNormalClick = function (fn) {
        jq("#selectVal").val("1")
        me.scaleTo = 1;
        me.computedHeight(function () {
          jq(".GooFlow_workArea .control").css("transform", "scale(" + me.scaleTo + ")")
          for (var key in me.controls) {
            jq("#" + key).css("left", me.controls[key].left * me.scaleTo)
            jq("#" + key).css("top", me.controls[key].top * me.scaleTo)
          }
          me.changeScaleLine(true, fn);
        });
      };

      // 放大
      // me.onScaleMaxClick = function () {
      //     me.scaleTo = (parseFloat(me.scaleTo) + 0.1).toFixed(1);
      //     me.computedHeight(function () {
      //         jq(".GooFlow_workArea .control").css("transform", "scale(" + me.scaleTo + ")");
      //         for (var key in me.controls) {
      //             jq("#" + key).css("left", me.controls[key].left * me.scaleTo)
      //             jq("#" + key).css("top", me.controls[key].top * me.scaleTo)
      //         }
      //         me.changeScaleLine(true);
      //     });
      // };

      // 全屏
      me.onFullScreenClick = function () {
        if (jq('#basGooFlow').attr('class').indexOf("fullEditor") > -1) {
          jq('#basGooFlow').removeClass("fullEditor");
        } else {
          jq('#basGooFlow').addClass("fullEditor");
        }
      };

      // 复制流程图
      me.onCopyChartClick = function () {
        var me = this
        jq("#treeProcessCopy").html('');
        var processInnerHtml5 = doT.template(jq("#modalTable").text());
        jq("#processTableCopy").append(processInnerHtml5({
          list: [],
          totalpages: 0
        }))

        jq.ajax({
          type: "post",
          url: me.baseUrl + "/modeltree/getTreeNodeWithoutAuth/0?username=" + basFlow.username,
          success: function (data) {
            for (var i = 0; i < data.length; i++) {
              data[i].isParent = data[i].isparent;
            }
            initProcessTreeCopy(data, me)
          }
        })
        // jq(".modalDialogProcessCopy").show();
        jq(".modalDialogProcessCopy").css("display", "block");
      };

      jq(".modalDialogProcessCopy #searchOrgProcess2").on("click", function () {
        let name = jq('#searchOrg_Input2').val()
        if (!name) {
          jq.ajax({
            type: "post",
            url: me.baseUrl + "/modeltree/getTreeNodeWithoutAuth/0?username=" + basFlow.username,
            success: function (data) {
              for (var i = 0; i < data.length; i++) {
                data[i].isParent = data[i].isparent;
              }
              initProcessTreeCopy(data, basFlow)
            }
          })
        } else {
          jq.ajax({
            type: "post",
            url: basFlow.baseUrl + "/modeltree/getTreeNodeByNameWithoutAuthCopy",
            contentType: "application/json",
            data: JSON.stringify({
              name: name
            }),
            success: function (data) {
              initProcessTreeCopy(data.data, basFlow)
            }
          })
        }
      })

      // 垂直居中
      me.onVerticalCenterClick = function () {
        if (!me.curId.length) {
          basFlow.alertBox("您没有选择节点!", 'danger');
          return false
        }
        var tempOffset = {
          left: me.controls[me.curId[0]].left + me.controls[me.curId[0]].width / 2
        }
        for (var i = 0; i < me.curId.length; i++) {
          if (!i) continue
          me.ctrlZlist.push({
            method: 'move',
            type: 'control',
            id: me.curId[i],
            data: {
              ids: me.curId[i],
              controls: JSON.parse(JSON.stringify(me.controls)),
              lines: JSON.parse(JSON.stringify(me.lines))
            }
          })
          me.controls[me.curId[i]].left = (tempOffset.left - me.controls[me.curId[i]].width / 2) * me.scaleTo
          me.controls[me.curId[i]].top = me.controls[me.curId[i]].top * me.scaleTo
          jq("#" + me.controls[me.curId[i]].id).css("left", me.controls[me.curId[i]].left);
          me.resetLines(me.curId[i], me.controls[me.curId[i]])
        }
      };

      // 左对齐
      me.onLeftAlignClick = function () {
        if (!me.curId.length) {
          me.alertBox("您没有选择节点!", 'danger');
          return false
        }
        var tempOffset = {
          left: me.controls[me.curId[0]].left
        }
        for (var i = 0; i < me.curId.length; i++) {
          if (!i) continue
          me.ctrlZlist.push({
            method: 'move',
            type: 'control',
            id: me.curId[i],
            data: {
              ids: me.curId[i],
              controls: JSON.parse(JSON.stringify(me.controls)),
              lines: JSON.parse(JSON.stringify(me.lines))
            }
          })
          me.controls[me.curId[i]].left = tempOffset.left * me.scaleTo
          me.controls[me.curId[i]].top = me.controls[me.curId[i]].top * me.scaleTo
          jq("#" + me.controls[me.curId[i]].id).css("left", me.controls[me.curId[i]].left);
          me.resetLines(me.curId[i], me.controls[me.curId[i]])
        }
      };

      // 右对齐
      me.onRightAlignClick = function () {
        if (!me.curId.length) {
          me.alertBox("您没有选择节点!", 'danger');
          return false
        }
        var tempOffset = {
          left: me.controls[me.curId[0]].left + me.controls[me.curId[0]].width
        }
        for (var i = 0; i < me.curId.length; i++) {
          if (!i) continue
          me.ctrlZlist.push({
            method: 'move',
            type: 'control',
            id: me.curId[i],
            data: {
              ids: me.curId[i],
              controls: JSON.parse(JSON.stringify(me.controls)),
              lines: JSON.parse(JSON.stringify(me.lines))
            }
          })
          me.controls[me.curId[i]].left = (tempOffset.left - me.controls[me.curId[i]].width) * me.scaleTo
          me.controls[me.curId[i]].top = me.controls[me.curId[i]].top * me.scaleTo
          jq("#" + me.controls[me.curId[i]].id).css("left", me.controls[me.curId[i]].left);
          me.resetLines(me.curId[i], me.controls[me.curId[i]])
        }
      };

      // 横向居中对齐
      me.onHorizonCenterClick = function () {
        if (!me.curId.length) {
          me.alertBox("您没有选择节点!", 'danger');
          return false
        }
        var tempOffset = {
          top: me.controls[me.curId[0]].top + me.controls[me.curId[0]].height / 2
        }
        for (var i = 0; i < me.curId.length; i++) {
          if (!i) continue
          me.ctrlZlist.push({
            method: 'move',
            type: 'control',
            id: me.curId[i],
            data: {
              ids: me.curId[i],
              controls: JSON.parse(JSON.stringify(me.controls)),
              lines: JSON.parse(JSON.stringify(me.lines))
            }
          })
          me.controls[me.curId[i]].top = (tempOffset.top - me.controls[me.curId[i]].height / 2) * me.scaleTo
          me.controls[me.curId[i]].left = me.controls[me.curId[i]].left * me.scaleTo
          jq("#" + me.controls[me.curId[i]].id).css("top", me.controls[me.curId[i]].top);
          me.resetLines(me.curId[i], me.controls[me.curId[i]])
        }
      };

      //顶对齐
      me.onTopAlignClick = function () {
        if (!me.curId.length) {
          me.alertBox("您没有选择节点!", 'danger');
          return false
        }
        var tempOffset = {
          top: me.controls[me.curId[0]].top
        }
        for (var i = 0; i < me.curId.length; i++) {
          if (!i) continue
          me.ctrlZlist.push({
            method: 'move',
            type: 'control',
            id: me.curId[i],
            data: {
              ids: me.curId[i],
              controls: JSON.parse(JSON.stringify(me.controls)),
              lines: JSON.parse(JSON.stringify(me.lines))
            }
          })
          me.controls[me.curId[i]].top = tempOffset.top * me.scaleTo
          me.controls[me.curId[i]].left = me.controls[me.curId[i]].left * me.scaleTo
          jq("#" + me.controls[me.curId[i]].id).css("top", me.controls[me.curId[i]].top);
          me.resetLines(me.curId[i], me.controls[me.curId[i]])
        }
      };

      // 底对齐
      me.onBottomAlignClick = function () {
        if (!me.curId.length) {
          me.alertBox("您没有选择节点!", 'danger');
          return false
        }
        var tempOffset = {
          top: me.controls[me.curId[0]].top + me.controls[me.curId[0]].height
        }
        for (var i = 0; i < me.curId.length; i++) {
          if (!i) continue
          me.ctrlZlist.push({
            method: 'move',
            type: 'control',
            id: me.curId[i],
            data: {
              ids: me.curId[i],
              controls: JSON.parse(JSON.stringify(me.controls)),
              lines: JSON.parse(JSON.stringify(me.lines))
            }
          })
          me.controls[me.curId[i]].top = (tempOffset.top - me.controls[me.curId[i]].height) * me.scaleTo
          me.controls[me.curId[i]].left = me.controls[me.curId[i]].left * me.scaleTo
          jq("#" + me.controls[me.curId[i]].id).css("top", me.controls[me.curId[i]].top);
          me.resetLines(me.curId[i], me.controls[me.curId[i]])
        }
      }


      //返回列表
      me.onBacklistClick = function () {
        if (!me.username) {
          window.parent.logoutbpa();
          return false;
        }
        // onBtnSaveClick保存功能的函数
        // basFlow.onBtnSaveClick(true, function (data) {
        // if(data){
        me.saveProcessFlow(false, function () {
          window.parent.exitFullScreen();
        });
        // 	}else {
        // 		basFlow.alertBox("保存失败！",'danger');
        // 	}
        // })
      }

      // 切换数据-切换到已发布
      me.onChangeClick = function () {

        if (getCookie('storeChangeState') === 'publish') {
          setCookie('storeChangeState', 'self')
        } else {
          setCookie('storeChangeState', 'publish')
        }
        if (!!me.setIntervalSave) {
          clearInterval(me.setIntervalSave);
        }
        location.reload()
      }


      // 切换泳道
      me.onQiehuanClick = function () {
        //console.log(1212)
        me.confirmBox('切换需要刷新页面,数据可能会丢失,确定要执行该操作吗?', function () {
          if (getCookie('qiehuan') === 'swimlaneX') {
            //console.log(1);
            setCookie('qiehuan', 'swimlaneY')
          } else {
            //console.log(2);
            setCookie('qiehuan', 'swimlaneX')
          }
          if (!!me.setIntervalSave) {
            clearInterval(me.setIntervalSave);
          }
          location.reload()
        })
      }


      // 流程图校验
      me.onVerifyClick = function () {
        // var lines = JSON.parse(JSON.stringify(me.getToJSON().lines))
        // var controls = JSON.parse(JSON.stringify(me.controls))
        // //console.log(lines)
        // //console.log(controls)
        // var lineDatas = []
        // for (var i = 0 ; i < lines.length; i++ ) {
        //     var obj = {
        //         id: lines[i].from,
        //         pid: null,
        //         children: []
        //     }
        //     var count = 0
        //     for (var j = 0 ; j < lines.length; j++ ) {
        //         if(obj.id === lines[j].to) {
        //             count ++
        //         }
        //     }
        //     if (!count) {
        //         lineDatas.push(obj)
        //     }
        // }

        // //console.log(lineDatas)
        // nestedData(lineDatas)
        // //console.log(lineDatas)

        // function nestedData(data) {
        //     for (var i = 0 ; i < data.length; i++ ) {
        //         for (var j = 0 ; j < lines.length; j++ ) {
        //             //console.log(!referData(lines[j].to, data))
        //             if (data[i].id === lines[j].from && !referData(lines[j].to, data)) {
        //                 data[i].children.push({
        //                     id: lines[j].to,
        //                     pid: data[i].id,
        //                     children: []
        //                 })
        //             }
        //         }
        //         //console.log(data[i].children)
        //         if (!data[i].children.length) {
        //             return false;
        //         }
        //         // nestedData(data[i].children)
        //     }
        // }

        // function referData(id, data) {
        //     for (var i = 0 ; i < data.length; i++ ) {
        //         if (id === data[i].id) {
        //             return true
        //         } else {
        //             if (!data[i].children.length) return false
        //             referData(id, data[i].children)
        //         }
        //     }
        // }


        // var $verifyProcessData = doT.template(jq("#verifyProcessTable").text());
        // jq(".modalDialogProcessTable .dialog_wrapper").append($verifyProcessData({
        //     list: versionData
        // }));
        // jq(".modalDialogProcessTable").show()
      }
      // 导入上传
      me.importClick = function () {
        // jq('#importFile, .importFile').click()

      }
      //  导出
      me.oneduceClick = function () {
        //console.log(123123);
        //console.log(me);

        jq.ajax({
          type: "post",
          // url: me.baseUrl + "/modeltree/getTreeNodeWithoutAuth/0?username=" + basFlow.username,
          url: me.baseUrl + "/importWord/importCopy?username=" + basFlow.username,
          data: JSON.stringify({
            id: me.id,
            json: '',
            listid: me.listid,
            name: '',
            num: '',
            userid: '',
            language: 'zh-CN'
          }),
          dataType: 'json',
          async: false,
          contentType: "application/json;",
          success: function (data) {
            if (data.code === 200) {
              window.open(data.data)
            } else {
              me.alertBox(data.msg, 'danger');
            }
          }
        })
      }

      // 打开引用流程
      me.openReferenceFlow = function () {
        var keyCtrlList = jq(".aboutProcess").serializeArray();
        var data = {
          listid: me.id,
          keyid: id
        };
        for (var i = 0; i < keyCtrlList.length; i++) {
          data[keyCtrlList[i].name] = keyCtrlList[i].value;
        }
        console.log(me.controls[me.copyIdTemp], me.controls[me.copyIdTemp].processGroup[0].id)
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/modellist/QueryListIdAndBpmId/' + me.controls[me.copyIdTemp].processGroup[0].id + '?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(data),
          async: false,
          success: function (res) {
            if (res.data.length > 0) {
              // window.open(basFlow.htmlUrl + '/leftMenu/BaseNewPage.html?id=' + res.data[0].BPMID + '&listid=' + res.data[0].LISTID + '&userid=' + me.username + '&treeId=' + res.data[0].MODELID + '&isReadAttr=true');

              jq.ajax({
                type: "POST",
                url: basFlow.baseUrl + "/modellist/queryProcessDesignListInfo/" + res.data[0].MODELID + '?username=' + basFlow.username,
                data: JSON.stringify({
                    fullFilters: [
                    {
                        filters: [
                        {
                            key: "code",
                            opt: "LIKE",
                            type: "S",
                            value: '',
                            logic: "or",
                        },
                        {
                            key: "name",
                            opt: "LIKE",
                            type: "S",
                            value: '',
                            logic: "or",
                        },
                        ],
                        logic: "and",
                    },
                    ],
                    logic: "and",
                    pageNum: 1,
                    pageSize: 10,
                }),
                contentType: 'application/json;',
                async: false,
                success: function (resp) {
                    let treeInfo = resp.data.list[0]
                    // let obj = {
                    //     id: treeInfo.bpmid,
                    //     listid: treeInfo.id,
                    //     treeId: getParamUrl('treeId'),
                    //     processName: treeInfo.name,
                    //     username: '',
                    //     processNum: treeInfo.code,
                    //     state: treeInfo.state,
                    //     isRead: 'no',
                    //     item: treeInfo,
                    //   }
                    let treeData = {}
                    jq.ajax({
                        type: "POST",
                        url: basFlow.baseUrl + "/listhistory/getAllTreeCopy?username=" + basFlow.username,
                        data: JSON.stringify({
                            id: res.data[0].MODELID,
                            state: "0"
                        }),
                        contentType: 'application/json;',
                        async: false,
                        success: function (rt) {
                            treeInfo.rank = rt.data.level || ''
                        }
                    })
                    let obj = {
                        id: res.data[0].BPMID,
                        listid: res.data[0].LISTID,
                        treeId: res.data[0].MODELID,
                        processName: me.controls[me.copyIdTemp].processGroup[0].name,
                        username: me.username,
                        processNum: treeInfo.code,
                        state: treeInfo.state,
                        isReadAttr: 'true',
                        item: treeInfo,
                        treeData: treeInfo
                    }
                    let processTabMenu = JSON.parse(sessionStorage.getItem('processTabMenu')) || []
                    let tabMenus = processTabMenu.map(item => item.listid).join(',')
                    if (tabMenus.indexOf(obj.listid) === -1) {
                        processTabMenu.push(obj)
                    }
                    sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
                    sessionStorage.setItem('processInfo', JSON.stringify(obj))
                    // setTimeout(function() {
                    window.getProcessJson('Update')
                    // }, 500)
                  }
              })

              return false
            } else {
              me.alertBox("流程未发布! ", 'danger');
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })
      }

      // 新建流程
      me.newProcessChart = function (copyId) {
        showLoading()
        let processTabMenu = JSON.parse(sessionStorage.getItem('processTabMenu')) || []
        let parentItem = !sessionStorage.getItem('processInfo') ? {} : JSON.parse(sessionStorage.getItem('processInfo'))
        // parentItem.state = '2' // 随意设置的
        let obj = {
          pid: parentItem.treeId,
          id: copyId, // 自建时为任务id
          treeId: parentItem.treeId,
          listPid: parentItem.item.id, // 父级bpmid
          listid: '100', // 随意设置的
          processName: '新建流程',
          item: parentItem.item || {},
          treeData: parentItem.treeData ? parentItem.treeData : (parentItem.item || {}),
          pidInfo: { // 存父级信息
            pid: parentItem.treeId,
            id: copyId, // 自建时为任务id
            treeId: parentItem.treeId,
            listPid: parentItem.item.id, // 父级bpmid
            bpmid: parentItem.item.bpmid, // 父级bpmid
          }
        }
        console.log(JSON.parse(sessionStorage.getItem('processInfo')), JSON.parse(sessionStorage.getItem('processTabMenu')))
        if (processTabMenu) {
          let tabMenus = processTabMenu.map(item => item.listid).join(',')
          if (tabMenus.indexOf(obj.listid) === -1) {
            processTabMenu.push(obj)
            sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
          } else { // 设置只能存在一个自建流程tab  更新父级的内容
            processTabMenu.forEach(item => {
              if (item.listid === obj.listid) {
                item = obj
              }
            })
            sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
          }
          sessionStorage.setItem('processInfo', JSON.stringify(obj))
          hideLoading();
          window.getProcessJson('Update')
        }
      }

      // 关联的岗位
      me.viewRelatedPost = function (copyId) {
        let relatedPost = []
        jQuery.support.cors = true;
        jq.ajax({
          type: 'GET',
          url: basFlow.baseUrl + '/org/manager/findRoleGroups/' + me.controls[copyId].role[0].id + '?username=' + me.username,
          data: {},
          async: true,
          success: function (res) {
            console.log(res)
            if (!!res && res.data.length > 0) {
              relatedPost = res.data || []
              let relatedPostControls = []
              let roleObj = {
                baseType: "current",
                bindSwimXId: "SWIMLANEA91C6B62",
                bindSwimXOffsetX: 0,
                bindSwimXOffsetY: 100,
                bindSwimYId: "SWIMLANE684EB5BE",
                bindSwimYOffsetX: 0,
                bindSwimYOffsetY: 0,
                drag: true,
                height: 50,
                id: "CONTROL2CD2DB7B",
                img: "role.png",
                inputname: "",
                isOperable: true,
                left: 438,
                name: "角色",
                outputname: "",
                outputnamename: "",
                padding: "0",
                rename: "角色",
                resize: true,
                state: "",
                time: "No",
                toolsPath: me.options.toolsPath,
                top: 114,
                type: "role",
                width: 140
              }
              relatedPost.forEach((item, index) => {
                let itemObj = JSON.parse(JSON.stringify(roleObj))
                itemObj.name = item.name
                itemObj.rename = item.name
                itemObj.id = GooFlow.getUID('CONTROL')
                itemObj.left = index*200 + 100
                itemObj.top = 200
                itemObj.type = 'post'
                itemObj.img = 'post.png'
                relatedPostControls.push(itemObj)
              })
              let roleData = JSON.parse(JSON.stringify(me.controls[copyId]))
              roleData.bindSwimYId = 'SWIMLANE684EB5BE'
              roleData.bindSwimXId = 'SWIMLANEA91C6B62'
              roleData.left = 100
              roleData.top = 60
              roleData.isRelate = false
              roleData.isReadAttr = 'true'
              relatedPostControls.push(roleData)
              var swimYWidth = 200*(relatedPost.length + 1);

              var swimnew = 100;
              var swimXHeight = document.body.offsetHeight - 190;
              var jsonData = { "controls": relatedPostControls, "lines": [], "swimlanes": [
                  { "height": swimXHeight , "width": 150, "inputDesc": "", "outputDesc": "", "name": "岗位/角色", "type": "swimlaneX", "time": "", "color": "#fff", "depts": [], "input": [], "output": [], "opertBooks": [], "id": "SWIMLANEA91C6B62" },
                  { "height": 150, "width": swimYWidth, "name": "阶段", "type": "swimlaneY", "time": "", "color": "#fff", "system": "", "opertBooks": [], "id": "SWIMLANE684EB5BE" }] }
              console.log(jsonData)

              let processTabMenu = JSON.parse(sessionStorage.getItem('processTabMenu')) || []
              let parentItem = !sessionStorage.getItem('processInfo') ? {} : JSON.parse(sessionStorage.getItem('processInfo'))
              // parentItem.state = '2' // 随意设置的
              let obj = {
                pid: parentItem.treeId,
                id: copyId, // 自建时为任务id
                treeId: parentItem.treeId,
                listPid: parentItem.item.id, // 父级bpmid
                listid: '200', // 随意设置的
                type: 'relatedPost',
                processName: me.controls[copyId].name,
                item: parentItem.item || {},
                treeData: parentItem.treeData ? parentItem.treeData : (parentItem.item || {}),
                pidInfo: { // 存父级信息
                  pid: parentItem.treeId,
                  id: copyId, // 自建时为任务id
                  treeId: parentItem.treeId,
                  listPid: parentItem.item.id, // 父级bpmid
                  bpmid: parentItem.item.bpmid, // 父级bpmid
                },
                json: jsonData
              }
              console.log(JSON.parse(sessionStorage.getItem('processInfo')), JSON.parse(sessionStorage.getItem('processTabMenu')))
              if (processTabMenu) {
                let tabMenus = processTabMenu.map(item => item.listid).join(',')
                if (tabMenus.indexOf(obj.listid) === -1) {
                  processTabMenu.push(obj)
                  sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
                } else { // 设置只能存在一个自建流程tab  更新父级的内容
                  processTabMenu.forEach(item => {
                    if (item.listid === obj.listid) {
                      item = obj
                    }
                  })
                  sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
                }
                sessionStorage.setItem('processInfo', JSON.stringify(obj))
                window.getProcessJson('Update')
              }
            } else {
              me.alertBox(me.controls[copyId].role[0].name + '未分配岗位！', 'danger');
            }
          }
        })
      }

      // 关联要素
      me.viewRelatedEle = function (copyId) {
        console.log(copyId,1,me.curId[0])
        if (!copyId) {
          copyId = me.curId[0]
        }
        console.log(copyId,2,me.curId[0])
        let relatedJson = JSON.parse(JSON.stringify(me.controls[copyId]))
        let relatedJsonControls = []
        let relatedJsonLines = []
        let jsonObj = {
          baseType: "current",
          bindSwimXId: "SWIMLANEA91C6B62",
          bindSwimXOffsetX: 0,
          bindSwimXOffsetY: 100,
          bindSwimYId: "SWIMLANE684EB5BE",
          bindSwimYOffsetX: 0,
          bindSwimYOffsetY: 0,
          drag: true,
          height: 50,
          id: "CONTROL2CD2DB7B",
          img: "role.png",
          inputname: "",
          isOperable: true,
          left: 438,
          name: "角色",
          outputname: "",
          outputnamename: "",
          padding: "0",
          rename: "角色",
          resize: true,
          state: "",
          time: "No",
          toolsPath: me.options.toolsPath,
          top: 114,
          type: "role",
          width: 140
        }
        relatedJson.bindSwimYId = 'SWIMLANE684EB5BE'
        relatedJson.bindSwimXId = 'SWIMLANEA91C6B62'
        relatedJson.left = 300
        relatedJson.top = 60
        let taskJson = JSON.parse(JSON.stringify(relatedJson)) // 删掉当前节点的输入 输出 等
        taskJson.input = []
        taskJson.output = []
        taskJson.inputDesc = ''
        taskJson.outputDesc = ''
        taskJson.keyControl = []
        taskJson.keyKSFControl = []
        taskJson.system = []
        taskJson.isRelatedEle = true
        relatedJsonControls.push(taskJson) // 先追加当前任务节点
        if (!!relatedJson.input && relatedJson.input.length > 0) { // 追加当前任务的输入
          let input = relatedJson.input.filter(item => !!item.type)
          input.forEach((item, index) => {
            let itemObj = JSON.parse(JSON.stringify(jsonObj))
            let controlId = GooFlow.getUID('CONTROL')
            if (!!item.type && item.docType === '2') { // docType === 2 电子文档  1 为 文档 默认的也为文档
              itemObj.name = item.docname
              itemObj.rename = item.docname
              itemObj.id = controlId
              itemObj.left = 100
              itemObj.top = 60 + index*100
              itemObj.type = 'relatedDoc'
              itemObj.img = 'relatedDoc.png'
              itemObj.isRelatedEle = true
              relatedJsonControls.push(itemObj)

              relatedJsonLines.push({
                "M": 270,
                "endPos":[
                  300,
                  60
                ],
                "from": controlId,
                "id": GooFlow.getUID('LINE'),
                "lineType":"solid",
                "startPos":[
                  240,
                  60 + index*100
                ],
                "to": basFlow.curId[0],
                "type":"lr"
              })
            } else if (!!item.type) {
              itemObj.name = item.docname
              itemObj.rename = item.docname
              itemObj.id = controlId
              itemObj.left = 100
              itemObj.top = 60 + index*100
              itemObj.type = 'doc'
              itemObj.img = 'doc.png'
              itemObj.isRelatedEle = true
              relatedJsonControls.push(itemObj)

              relatedJsonLines.push({
                "M": 270,
                "endPos":[
                  300,
                  60
                ],
                "from": controlId,
                "id": GooFlow.getUID('LINE'),
                "lineType":"solid",
                "startPos":[
                  240,
                  60 + index*100
                ],
                "to": basFlow.curId[0],
                "type":"lr"
              })
            }
          })
        }
        if (!!relatedJson.output && relatedJson.output.length > 0) {
          let output = relatedJson.output.filter(item => !!item.type)
          output.forEach((item, index) => {
              let itemObj = JSON.parse(JSON.stringify(jsonObj))
              let controlId = GooFlow.getUID('CONTROL')
              if (!!item.type && item.docType === '2') {
                itemObj.name = item.docname
                itemObj.rename = item.docname
                itemObj.id = controlId
                itemObj.left = 500
                itemObj.top = 60 + index*100
                itemObj.type = 'relatedDoc'
                itemObj.img = 'relatedDoc.png'
                itemObj.isRelatedEle = true
                relatedJsonControls.push(itemObj)

                relatedJsonLines.push({
                  "M": 470,
                  "endPos":[
                    500,
                    60
                  ],
                  "from": basFlow.curId[0],
                  "id": GooFlow.getUID('LINE'),
                  "lineType":"solid",
                  "startPos":[
                    440,
                    60 + index*100
                  ],
                  "to": controlId,
                  "type":"lr"
                })
              } else if (!!item.type) {
                itemObj.name = item.docname
                itemObj.rename = item.docname
                itemObj.id = controlId
                itemObj.left = 500
                itemObj.top = 60 + index*100
                itemObj.type = 'doc'
                itemObj.img = 'doc.png'
                itemObj.isRelatedEle = true
                relatedJsonControls.push(itemObj)

                relatedJsonLines.push({
                  "M": 470,
                  "endPos":[
                    500,
                    60
                  ],
                  "from": basFlow.curId[0],
                  "id": GooFlow.getUID('LINE'),
                  "lineType":"solid",
                  "startPos":[
                    440,
                    60 + index*100
                  ],
                  "to": controlId,
                  "type":"lr"
                })
              }
          })
        }
        let maxIndex = Math.max(!!relatedJson.input ? relatedJson.input.filter(item => !!item.type).length : 0,
            !!relatedJson.output ? relatedJson.output.filter(item => !!item.type).length : 0)
        maxIndex = !maxIndex ? 1 : maxIndex // 为0时  默认为1
        if (!!relatedJson.systemDocumentChapter && relatedJson.systemDocumentChapter.length > 0) {
          relatedJson.systemDocumentChapter.forEach((item, index) => {
            if (item && item.docId) {
              let itemObj = JSON.parse(JSON.stringify(jsonObj))
              itemObj.name = item.title
              itemObj.rename = item.title
              itemObj.id = GooFlow.getUID('CONTROL')
              itemObj.left = 100
              itemObj.top = (maxIndex + index)*100 + 60
              itemObj.type = 'roleSystem'
              itemObj.img = 'roleSystem.png'
              itemObj.isRelatedEle = true
              relatedJsonControls.push(itemObj)
              if (item.systemChapter[0].docId) {
                let itemChapterObj = JSON.parse(JSON.stringify(jsonObj))
                itemChapterObj.name = item.systemChapter.length > 0 && item.systemChapter[0].content ? item.systemChapter[0].content : ""
                itemChapterObj.rename = item.systemChapter.length > 0 && item.systemChapter[0].content ? item.systemChapter[0].content : ""
                itemChapterObj.id = GooFlow.getUID('CONTROL')
                itemChapterObj.left = 300
                itemChapterObj.top = (maxIndex + index)*100 + 60
                itemChapterObj.type = 'chapter'
                itemChapterObj.img = 'chapter.png'
                itemChapterObj.isRelatedEle = true
                relatedJsonControls.push(itemChapterObj)
              }
            }
          })
        }
        let maxSystemIndex = maxIndex + relatedJson.systemDocumentChapter.length
        if (!!relatedJson.system && relatedJson.system.length > 0) {
          relatedJson.system.forEach((item, index) => {
            let itemObj = JSON.parse(JSON.stringify(jsonObj))
            itemObj.name = item.name
            itemObj.rename = item.name
            itemObj.id = GooFlow.getUID('CONTROL')
            itemObj.left = index*200 + 100
            itemObj.top = 60 + maxSystemIndex*100
            itemObj.type = 'operatingSystem'
            itemObj.img = 'operatingSystem.png'
            itemObj.isRelatedEle = true
            relatedJsonControls.push(itemObj)
          })
        }
        var swimYWidth = Math.max(800, 100*relatedJson.system.length);
        var swimnew = 100;
        var swimXHeight = Math.max(document.body.offsetHeight - 190, 100*(maxSystemIndex + relatedJson.system.length));
        var jsonData = { "controls": relatedJsonControls, "lines": relatedJsonLines, "swimlanes": [
            { "height": swimXHeight , "width": 150, "inputDesc": "", "outputDesc": "", "name": "岗位/角色", "type": "swimlaneX", "time": "", "color": "#fff", "depts": [], "input": [], "output": [], "opertBooks": [], "id": "SWIMLANEA91C6B62" },
            { "height": 150, "width": swimYWidth, "name": "阶段", "type": "swimlaneY", "time": "", "color": "#fff", "system": "", "opertBooks": [], "id": "SWIMLANE684EB5BE" }], 'qiehuanbgimg': 'bg_img_white' }
        console.log('jsonDatajsonData',jsonData)

        let processTabMenu = JSON.parse(sessionStorage.getItem('processTabMenu')) || []
        let parentItem = !sessionStorage.getItem('processInfo') ? {} : JSON.parse(sessionStorage.getItem('processInfo'))
        // parentItem.state = '2' // 随意设置的
        let obj = {
          pid: parentItem.treeId,
          id: copyId, // 自建时为任务id
          treeId: parentItem.treeId,
          listPid: parentItem.item.id, // 父级bpmid
          listid: '300', // 随意设置的
          type: 'relatedEle',
          processName: me.controls[copyId].name,
          isReadAttr: 'true',
          item: parentItem.item || {},
          treeData: parentItem.treeData ? parentItem.treeData : (parentItem.item || {}),
          pidInfo: { // 存父级信息
            pid: parentItem.treeId,
            id: copyId, // 自建时为任务id
            treeId: parentItem.treeId,
            listPid: parentItem.item.id, // 父级bpmid
            bpmid: parentItem.item.bpmid, // 父级bpmid
          },
          json: jsonData
        }
        console.log(JSON.parse(sessionStorage.getItem('processInfo')), JSON.parse(sessionStorage.getItem('processTabMenu')))
        if (processTabMenu) {
          let tabMenus = processTabMenu.map(item => item.listid).join(',')
          if (tabMenus.indexOf(obj.listid) === -1) {
            processTabMenu.push(obj)
            sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
          } else { // 设置只能存在一个自建流程tab  更新父级的内容
            processTabMenu.forEach(item => {
              if (item.listid === obj.listid) {
                item = obj
              }
            })
            sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
          }
          sessionStorage.setItem('processInfo', JSON.stringify(obj))
          window.getProcessJson('Update')
        }
      }
      window.viewRelatedEle = me.viewRelatedEle
      // 流程版本 对比 模块代码 -------------------------------- start
      me.contrastClick = function () {
        me.historyVersion = []
        jq.ajax({
          type: 'POST',
          url: basFlow.baseUrl + '/listrelease/queryReleaseCopy?username=' + basFlow.username,
          data: JSON.stringify({
            "orderby": "createon",
            "pageNum": 1,
            "pageSize": 10000,
            "sort": "desc",
            "filters": [
              { "key": "listid", "opt": "LIKE", "type": "S", "value": me.listid }
            ]
          }),
          contentType: 'application/json;',
          success: function (res) {
            if (res.code === 200 && res.data) {
              me.historyVersion = res.data.list || []
              var span1 = "<span style='margin-right: 10px;'>当前版本：</span><select><option></option>";
              var span2 = "<span style='margin-right: 10px;'>比对版本：</span><select>";
              var str = "";
              for (var i = 0; i < me.historyVersion.length; i++) {
                str += " <option title=" + me.historyVersion[i].version + ">" + me.historyVersion[i].version + "</option>";
              }
              str += "</select>";
              jq("#versionSelectLeftWrap").html(span1 + str)
              jq("#versionSelectRightWrap").html(span2 + str)
              jq(".modalDialogHistoryVersion").show();
            }
          }
        });
      }
      jq(".modalDialogHistoryVersion .confirmModelHistoryVersion").on("click", function () {
        let value1 = jq("#versionSelectLeftWrap").find("option:selected").attr("title")
        if (value1) {
          me.selectedCurrentVersion = me.historyVersion.find(item => item.version === value1)
          jq.ajax({
            type: 'POST',
            url: basFlow.baseUrl + '/html2jpg/getWordJpgCopy?username=' + basFlow.username,
            data: JSON.stringify({
              "id": me.id,
              "json": "",
              "listid": me.listid,
              "name": "",
              "num": "",
              "version": value1
            }),
            contentType: 'application/json;',
            success: function (res) {
              if (res.code === 200 && res.data) {
                var str = `
               <ul>
                  <li>版本：${me.selectedCurrentVersion.version}</li>
                  <li>流程名称：${me.selectedCurrentVersion.name}</li>
                  <li>最后修改时间：${me.selectedCurrentVersion.updateon}</li>
                  <li>修改人：${me.selectedCurrentVersion.submitname}</li>
                </ul>
                <img src="${res.data.url}" alt="">
              `;
                jq("#leftVersionContrast").html(str)
              }
            }
          });
        }
        let value2 = jq("#versionSelectRightWrap").find("option:selected").attr("title")
        if (value2) {
          me.selectedCompareVersion = me.historyVersion.find(item => item.version === value2)
          jq.ajax({
            type: 'POST',
            url: basFlow.baseUrl + '/html2jpg/getWordJpgCopy?username=' + basFlow.username,
            data: JSON.stringify({
              "id": me.id,
              "json": "",
              "listid": me.listid,
              "name": "",
              "num": "",
              "version": value2
            }),
            contentType: 'application/json;',
            success: function (res) {
              if (res.code === 200 && res.data) {
                var str = `
               <ul>
                  <li>版本：${me.selectedCompareVersion.version}</li>
                  <li>流程名称：${me.selectedCompareVersion.name}</li>
                  <li>最后修改时间：${me.selectedCompareVersion.updateon}</li>
                  <li>修改人：${me.selectedCompareVersion.submitname}</li>
                </ul>
                <img src="${res.data.url}" alt="">
              `;
                jq("#rightVersionContrast").html(str)
              }
            }
          });
          getContrastInfo(false, 1)
          jq(".modalDialogHistoryVersion").hide();
          jq(".modalDialogVersionContrast").show();
        } else {
          me.alertBox("请选择比对版本", 'danger');
        }
      })

      // 自定义编码
      me.autoCodingClick = function () {
        me.confirmBox('一键编码会覆盖原有编码，是否一键编码?', function () {
            console.log(me.controls)
            var arrControl = []
            for (var i in me.controls) {
                if (me.controls[i].img.indexOf("processTask") > -1) {
                    arrControl.push(me.controls[i]);
                }
            }
            var arrControlTop = JSON.parse(JSON.stringify(arrControl))
            arrControlTop.sort((a, b) => {
                console.log('a',a,'b',b)
                if(a.top === b.top) {
                    return a.left - b.left
                }
                return a.top - b.top
            })
            var sortControls = JSON.parse(JSON.stringify(arrControl))
            for (var j = 0; j < arrControlTop.length; j++) {
                var repeatArr = []
                let conIndex = 0
                for (var k = 0; k < arrControlTop.length; k++) {
                    if (arrControlTop[j].top === arrControlTop[k].top) {
                        conIndex = k
                        repeatArr.push(arrControlTop[k])
                    }
                }
                if (j - 1 == (conIndex - repeatArr.length)) {
                    sortControls = sortTopLeft(arrControlTop, repeatArr.sort((a, b) => {
                        return a.left - b.left
                    }), j)
                }
            }
            // 对排序后的controls进行排序
            console.log(sortControls)
            for (var i = 0; i < sortControls.length; i++) {
                me.controls[sortControls[i].id].index = i < 9 ? '0' + (i + 1) : i + 1;
                jq("#" + sortControls[i].id).remove()
                me.addControl(me.controls[sortControls[i].id], true)
            }
        })
      }

      // 流程功能分配
      me.procFunAllocationClick = function () {
        let jsonData = {}
        jq.ajax({
          type: "GET",
          url: basFlow.baseUrl + "/listhistory/queryFunctionAllocation/" + me.listid + '?username=' + basFlow.username,
          async: false,
          contentType: 'application/json;',
          success: function (res) {
            if (!res) {
              return false
            }
            jsonData = JSON.parse(res.data)
            jsonData.qiehuanbgimg = 'bg_img_white'
          }
        })
        let processTabMenu = JSON.parse(sessionStorage.getItem('processTabMenu')) || []
        let parentItem = !sessionStorage.getItem('processInfo') ? {} : JSON.parse(sessionStorage.getItem('processInfo'))
        let obj = {
            pid: parentItem.treeId,
            id: null, // 自建时为任务id
            treeId: parentItem.treeId,
            listPid: parentItem.item.id, // 父级bpmid
            listid: '500', // 随意设置的
            type: 'procFunAllocation',
            processName: '流程功能分配图',
            isReadAttr: 'true',
            item: parentItem.item || {},
            treeData: parentItem.treeData ? parentItem.treeData : (parentItem.item || {}),
            pidInfo: { // 存父级信息
              pid: parentItem.treeId,
              id: null, // 自建时为任务id
              treeId: parentItem.treeId,
              listPid: parentItem.item.id, // 父级bpmid
              bpmid: parentItem.item.bpmid, // 父级bpmid
              // isReadAttr: 'true',
            },
            json: jsonData
          }
          console.log(JSON.parse(sessionStorage.getItem('processInfo')), JSON.parse(sessionStorage.getItem('processTabMenu')))
          if (processTabMenu) {
            let tabMenus = processTabMenu.map(item => item.listid).join(',')
            if (tabMenus.indexOf(obj.listid) === -1) {
              processTabMenu.push(obj)
              sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
            } else { // 设置只能存在一个自建流程tab  更新父级的内容
              processTabMenu.forEach(item => {
                if (item.listid === obj.listid) {
                  item = obj
                }
              })
              sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
            }
            sessionStorage.setItem('processInfo', JSON.stringify(obj))
            window.getProcessJson('Update')
          }
      }

      jq(".chooseModalDialogHistoryVersion").on("click", function () {
        jq(".modalDialogHistoryVersion").hide(); // 选择工具
      })

      jq(".modalDialogVersionContrast .versionContrastCancelChoose").off("click").on("click", function () {
        jq("#leftVersionContrast").html("")
        jq("#rightVersionContrast").html("")
        me.compareVersionList = []
        me.selectedCurrentVersion = {}
        jq(".modalDialogVersionContrast").hide()
      })

      // 高级搜索 目前前端筛选数据
      jq(".modalDialogVersionContrast .highSearchBtn").on("click", function () {
        if (jq("#contrastHighSearch").css("display") === 'none') {
          jq("#contrastHighSearch").show()
        } else {
          jq("#contrastHighSearch").hide()
        }
      })
      // 高级搜索
      jq(".modalDialogVersionContrast .highSearch").on("click", function () {
        let node = jq('#contrastHighSearch .node').val()
        let card = jq('#contrastHighSearch .card').val()
        let field = jq('#contrastHighSearch .field').val()
        let currentValue = jq('#contrastHighSearch .currentValue').val()
        let versionValue = jq('#contrastHighSearch .versionValue').val()
        let list = basFlow.isAllCompareVersionList.filter(item => {
          item.node = item.node || ""
          item.card = item.card || ""
          item.field = item.field || ""
          item.currentValue = item.currentValue || ""
          item.versionValue = item.versionValue || ""
          return item.node.indexOf(node) !== -1 && item.card.indexOf(card) !== -1 && item.field.indexOf(field) !== -1 && item.currentValue.indexOf(currentValue) !== -1 && item.versionValue.indexOf(versionValue) !== -1
        })
        addDataTableContrast(list)
      })
      // 重置
      jq(".modalDialogVersionContrast .reset").on("click", function () {
        jq('#contrastHighSearch .node').val('')
        jq('#contrastHighSearch .card').val('')
        jq('#contrastHighSearch .field').val('')
        jq('#contrastHighSearch .currentValue').val('')
        jq('#contrastHighSearch .versionValue').val('')
        addDataTableContrast(basFlow.isAllCompareVersionList)
      })
      // 刷新
      jq(".modalDialogVersionContrast .reload").on("click", function () {
        jq('#contrastHighSearch .node').val('')
        jq('#contrastHighSearch .card').val('')
        jq('#contrastHighSearch .field').val('')
        jq('#contrastHighSearch .currentValue').val('')
        jq('#contrastHighSearch .versionValue').val('')
        jq('.modalDialogVersionContrast .isShowAllCheck').prop('checked', true)
        addDataTableContrast(basFlow.compareVersionList)
      })

      // 导出
      jq(".modalDialogVersionContrast .export").on("click", function () {
        var url = basFlow.baseUrl + '/listrelease/exportCompare?username=' + basFlow.username
        var xhr = new XMLHttpRequest();
        xhr.open('POST', url, true);
        xhr.responseType = "blob";
        xhr.setRequestHeader('content-type', 'application/json');
        xhr.onload = function () {
          // 请求完成
          if (this.status === 200) {
            let blob = new Blob([this.response], {
              type: "application/vnd.ms-excel"
            });
            if (window.navigator && window.navigator.msSaveOrOpenBlob) {
              // 兼容TMD IE
              navigator.msSaveBlob(blob, "流程对比.xls");
            } else {
              // 其他浏览器
              const url = window.URL.createObjectURL(blob);
              const link = document.createElement("a");
              link.style.display = "none";
              link.href = url;
              link.setAttribute("download", "流程对比.xls");
              document.body.appendChild(link);
              link.click();
              window.URL.revokeObjectURL(link.href);
            }
          }
        };
        // 发送ajax请求
        xhr.send(JSON.stringify({
          "listid": basFlow.listid,
          "compareVersion": {
            "id": basFlow.selectedCompareVersion.id || "",
            "bpmId": basFlow.selectedCompareVersion.bpmid || "",
            "version": basFlow.selectedCompareVersion.version || ""
          },
          "currentVersion": {
            "id": basFlow.selectedCurrentVersion.id || "",
            "bpmId": basFlow.selectedCurrentVersion.bpmid || "",
            "version": basFlow.selectedCurrentVersion.version || ""
          }
        }))
      })

      // 流程版本 对比 模块代码 -------------------------------- end

      // 切换背景风格
      me.onChangeBgImgClick = function () {
        me.confirmBox('确定要切换吗?', function () {
          console.log("getCookie('qiehuanbgimg')", getCookie('qiehuanbgimg'));
          if (getCookie('qiehuanbgimg') === 'bg_img_grid') {
            setCookie('qiehuanbgimg', 'bg_img_white')
          } else {
            setCookie('qiehuanbgimg', 'bg_img_grid')
          }
          me.changeBgImg()
          // if (!!me.setIntervalSave) {
          //     clearInterval(me.setIntervalSave);
          // }
          // location.reload()
        })
      }

      //--------------------------------头部按钮区域----------------------------结束
    },
    // 背景风格切换
    changeBgImg: function () {
      var me = this;
      me.ToolsConfig['role'].baseType = '' // 角色图标是生成的  不显示
      if (getCookie('qiehuanbgimg') !== 'bg_img_grid') {
          //console.log(1);
          // setCookie('qiehuanbgimg', 'bg_img_white')
          // if (jq('.GooFlow_workArea').hasClass('GooFlow_workArea_grid')) {
          //   jq('.GooFlow_workArea').removeClass('GooFlow_workArea_grid')
          // }
          // if (!jq('.GooFlow_workArea').hasClass('GooFlow_workArea_white')) {
          //   jq('.GooFlow_workArea').addClass('GooFlow_workArea_white')
          //   jq('.swimlaneY .swimlane-title').css('display', 'none')
          //   jq('.swimlaneY .swimlane-content').css('border', 'none')
          // }
          jq('.swimlaneX,.swimlaneY').css('opacity',0)
          jq('.GooFlow_workArea_grid, .GooFlow_workArea').removeClass('GooFlow_workArea_grid')
          jq('.tools-title-current').html('EPC')
          jq('#btn_qiehuanbgimg span').html(jq.i18n.prop("swimLaneImg"))
          jq('.tools-base .tools_img').parent().hide()
          jq('.tools-title-advanced').hide()
          jq('.tools-group-process').hide()
          jq('.tools-title-node').hide()
          jq('.tools-group-node').hide()
          jq('.tools-title-bpmn').hide()
          jq('.tools-group-bpmn').hide()
          jq('.tools-title-architecture').hide()
          jq('.tools-group-architecture').hide()
          jq('.swimlaneX .swimlane-title, .swimlaneY .swimlane-title').hide()
          jq('#approvalTime').hide()
          me.ToolsConfig['process04'].baseType = 'current'
          me.ToolsConfig['AND'].baseType = 'current'
          me.ToolsConfig['OR'].baseType = 'current'
          me.ToolsConfig['XOR'].baseType = 'current'
          me.ToolsConfig['P'].baseType = ''
          me.ToolsConfig['notify'].baseType = ''
          me.ToolsConfig['processStart'].baseType = ''
          me.ToolsConfig['processEnd'].baseType = ''
          me.ToolsConfig['processNewsStart'].baseType = ''
          me.ToolsConfig['processTaskService'].baseType = ''
          me.ToolsConfig['processTimerStart'].baseType = ''
          me.ToolsConfig['exclusiveGateway'].baseType = ''
          me.ToolsConfig['processGateway'].baseType = ''
          me.ToolsConfig['mulNetworkManage'].baseType = ''
          me.ToolsConfig['incidentNetwork'].baseType = ''
          me.ToolsConfig['gatewayNetwork'].baseType = ''
          console.log(me.ToolsConfig)
          me.changeEPC()
      } else {
          //console.log(2);
          // setCookie('qiehuanbgimg', 'bg_img_grid')
          // if (jq('.GooFlow_workArea').hasClass('GooFlow_workArea_white')) {
          //   jq('.GooFlow_workArea').removeClass('GooFlow_workArea_white')
          // }
          // if (!jq('.GooFlow_workArea').hasClass('GooFlow_workArea_grid')) {
          //   jq('.GooFlow_workArea').addClass('GooFlow_workArea_grid')
          //   jq('.swimlaneY .swimlane-title').css('display', 'block')
          //   jq('.swimlaneY .swimlane-content').css('border', '1.5px solid #adabab')
          // }
          jq('.swimlaneX, .swimlaneY, .GooFlow_workArea_grid svg').css('opacity',1)
          jq('.GooFlow_workArea_grid, .GooFlow_workArea').addClass('GooFlow_workArea_grid')
          jq('.tools-title-current').html(jq.i18n.prop("swimLaneImg"))
          jq('#btn_qiehuanbgimg span').html(jq.i18n.prop("EPCImg"))
          jq('.tools-base .tools_img').parent().show()
          jq('.tools-title-advanced').show()
          jq('.tools-group-process').show()
          jq('.tools-title-node').show()
          jq('.tools-group-node').show()
          jq('.tools-title-bpmn').show()
          jq('.tools-group-bpmn').show()
          jq('.tools-title-architecture').show()
          jq('.tools-group-architecture').show()
          jq('.swimlaneX .swimlane-title, .swimlaneY .swimlane-title').show()
          jq('#approvalTime').show()
          me.ToolsConfig['process04'].baseType = ''
          me.ToolsConfig['AND'].baseType = ''
          me.ToolsConfig['OR'].baseType = ''
          me.ToolsConfig['XOR'].baseType = ''
          me.ToolsConfig['P'].baseType = 'current'
          me.ToolsConfig['notify'].baseType = 'current'
          me.ToolsConfig['processStart'].baseType = 'current'
          me.ToolsConfig['processEnd'].baseType = 'current'
          me.ToolsConfig['processNewsStart'].baseType = 'current'
          me.ToolsConfig['processTaskService'].baseType = 'current'
          me.ToolsConfig['processTimerStart'].baseType = 'current'
          me.ToolsConfig['exclusiveGateway'].baseType = 'current'
          me.ToolsConfig['processGateway'].baseType = 'current'
          me.ToolsConfig['mulNetworkManage'].baseType = 'current'
          me.ToolsConfig['incidentNetwork'].baseType = 'current'
          me.ToolsConfig['gatewayNetwork'].baseType = 'current'
          me.changeEPC()
      }
    },
    changeEPC: function () {
      var me = this;
      if (!me.toolsGroup) return;
      var tools = me.toolsGroup[0];
      me.$toolsBox.find('.tools-group-current').text('');
      for (var j = 0; j < tools.controls.length; j++) {
        var baseType = me.ToolsConfig[tools.controls[j]] ? me.ToolsConfig[tools.controls[j]].baseType : '';
          switch (true) {
              case baseType == 'current':
                  // 通用图例
                  var $li = jq('<li class="process_' + j + '"></li>');
                  var tool = new GooFlow.Tools(tools.controls[j], me.options);
                  $li.append(tool.$el);
                  $li.attr("title", tool.rename);
                  $li.find("img").attr("src", tool.iconPath);
                  // switch (true) {
                  //     case (tool.type == "processTask"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTask2.png");
                  //         break
                  //     case (tool.type == "exclusiveGateway"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/process05.png");
                  //         break
                  //     case (tool.type == "processGateway"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/processGateway.png");
                  //         break
                  //     case (tool.type == "processTask"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTask2.png");
                  //         break
                  //     case (tool.type == "exclusiveGateway"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/process05.png");
                  //         break
                  //     case (tool.type == "AND"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/AND.png");
                  //         break
                  //     case (tool.type == "P"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/P.png");
                  //         break
                  //     case (tool.type == "OR"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/OR.png");
                  //         break
                  //     case (tool.type == "XOR"):
                  //         $li.find("img").attr("src", "./" + me.options.toolsPath + "/XOR.png");
                  //         break
                  //      case (tool.type == "mulNetworkManage"):
                  //       $li.find("img").attr("src", "./" + me.options.toolsPath + "/networkManageTool.png");
                  //       break
                  //     case (tool.type == "incidentNetwork"):
                  //       $li.find("img").attr("src", "./" + me.options.toolsPath + "/incidentNetworkTool.png");
                  //       break
                  //     case (tool.type == "gatewayNetwork"):
                  //       $li.find("img").attr("src", "./" + me.options.toolsPath + "/gatewayNetworkTool.png");
                  //       break
                  //     case (tool.type == "processTimerStart"):
                  //       $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTimerStartTool.png");
                  //       break
                  //     case (tool.type == "processNewsStart"):
                  //       $li.find("img").attr("src", "./" + me.options.toolsPath + "/processNewsStartTool.png");
                  //       break
                  //     case (tool.type == "processTaskService"):
                  //       $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTaskServiceTool.png");
                  //       break
                  // }
                  me.$toolsBox.find('.tools-group-current').append($li);
                  break;
          }
      }
    },
    _initleticon: function () {

      jq(".GooFlow_lft .GooFlow_lft_item").click(function () {
        jq(this).css("background", "#D7D7D7");
        jq(this).addClass('active');
        jq(this).siblings().css("background", "#fff");
        jq(this).siblings().removeClass('active');
        const index = jq(this).index();
        console.log(index)
        // jq('.GooFlow_lft_item1').css("backgroundImage", "url('../img/basic_s.png')");
        // jq('.GooFlow_lft_item2').css("backgroundImage", "url('../img/tool_h.png')");
        jq('.tools-group, .tools-title ').hide();
        jq(`.titl-show${index}`).css("display", "block")

        let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
        if (!!processInfo.processType) { // 判断为业务对象时候隐藏图标
          jq('.tools-title-current').hide() // 通用
          jq('.tools-group-current').hide()
          jq('.tools-title-advanced').hide() // 高级
          jq('.tools-group-process').hide()
          jq('.tools-title-bpmn').hide() // bpmn
          jq('.tools-group-bpmn').hide()
          jq('.tools-title-architecture').hide() // 企业框架
          jq('.tools-group-architecture').hide()
          // jq("[data-type = 'processDocumentation']").parent().hide()
          // jq("[data-type = 'processInformation']").parent().hide()
          // jq("[data-type = 'approveRules']").parent().hide()
        } else {
          if (jq(".GooFlow_lft .GooFlow_lft_item:nth-of-type(1)").hasClass('active')) {
            jq('.tools-title-current').show() // 通用
            jq('.tools-group-current').show()
            jq('.tools-title-advanced').show() // 高级
            jq('.tools-group-process').show()
            jq('.tools-title-bpmn').show() // bpmn
            jq('.tools-group-bpmn').show()
            jq('.tools-title-architecture').show() // 企业框架
            jq('.tools-group-architecture').show()
          }
          // jq("[data-type = 'processDocumentation']").parent().show()
          // jq("[data-type = 'processInformation']").parent().show()
          // jq("[data-type = 'approveRules']").parent().show()
        }
        if (jq(".GooFlow_lft .GooFlow_lft_item:nth-of-type(2)").hasClass('active')) {
          jq('.tools-title-current').hide() // 通用
          jq('.tools-group-current').hide()
          jq('.tools-title-advanced').hide() // 高级
          jq('.tools-group-process').hide()
          jq('.tools-title-bpmn').hide() // bpmn
          jq('.tools-group-bpmn').hide()
          jq('.tools-title-architecture').hide() // 企业框架
          jq('.tools-group-architecture').hide()
        }
        // jq(`.titl-show${index}`).siblings().css("display", "none")
      });

      // jq("#GooFlow_lft1").click(function () {
      //   jq(this).css("background", "#D7D7D7");
      //   jq(this).siblings().css("background", "#fff");
      //   // jq('.GooFlow_lft_item2').css("backgroundImage", "url('../img/tool_s.png')");
      //   // jq('.GooFlow_lft_item1').css("backgroundImage", "url('../img/basic_h.png')");
      //   jq('.titl-show1').css("display", "none")
      //   jq('.titl-show').css("display", "block")
      // });
    },


    /**
     * 初始化左边工具栏 和右边属性栏
     */
    _initTools: function () {
      var me = this;
      if (!!me.isReadAttr || me.isEdit) {
        me.attrTempl = doT.template(jq('#attr_templ').text());
      }
      //console.log(111)
      if (!me.isEdit) return false;

      var templft = leftNav.menuTemp;
      me.$toolss = jq(templft);
      me.$toolsBox = me.$container.append(me.$toolss);

      var templ = '<div class="GooFlow_tool"><ul class="J_navTabs" style="display:none;">' +
        '<li data-plan="control" class="active"><a href="javascript:;">流程</a></li></ul><ul class="nav nav-cnts J_navCnts">' +
        '<li class="J_toolsBox"></li></ul></div>'; // <li class="J_attrBox" style="display:none;"></li>
      me.$tools = jq(templ);
      me.$toolsBox = me.$container.append(me.$tools).find('.J_toolsBox');
      me.$navTabs = me.$tools.find('.J_navTabs');
      me.$navCnts = me.$tools.find('.J_navCnts');





      // 子控件拖拽时切换到 状态
      me.$toolsBox.on('dragstart', function (event, ui) {
        me._switchEditType(me.EditEnum.SELECT);
      });


      // 初始化切换状态工具
      // me._initSwitchTools();
      // 初始化工具组
      me.toolsGroup = jq.isArray(me.options.toolsGroup) ? me.options.toolsGroup : [];
      me.toolsGroup = jq.map(me.toolsGroup, function (value) {
        value.id = GooFlow.getUID('GROUP');
        return value;
      });

      var tools = me.toolsGroup[0];
      templ = leftNav.leftNavContent(tools)
      me.$toolsBox.append(templ);
      leftNav.renderLeftNav('#vueTree');

      // 增加工作组控件
      me.$toolsBox.find('.tools-group').eq(0).prepend(me._initSwitchTools());
      me.$switchGroup = me.$toolsBox.find('.J_switch');




      // 增加流程图例，可拖拽的
      // 增加工作组控件
      for (var j = 0; j < tools.controls.length; j++) {
        var baseType = me.ToolsConfig[tools.controls[j]] ? me.ToolsConfig[tools.controls[j]].baseType : '';

        switch (true) {
          case baseType == 'current':
            // 通用图例
            var $li = jq('<li class="process_' + j + '"></li>');
            var tool = new GooFlow.Tools(tools.controls[j], me.options);
            $li.append(tool.$el);
            $li.attr("title", tool.rename);
            $li.find("img").attr("src", tool.iconPath);
            // switch (true) {
            //   case (tool.type == "processTask"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTask2.png");
            //     break
            //   case (tool.type == "exclusiveGateway"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/process05.png");
            //     break
            //   case (tool.type == "processGateway"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processGateway.png");
            //     break
            //   case (tool.type == "processTask"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTask2.png");
            //     break
            //   case (tool.type == "exclusiveGateway"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/process05.png");
            //     break
            //   case (tool.type == "AND"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/AND.png");
            //     break
            //   case (tool.type == "P"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/P.png");
            //     break
            //   case (tool.type == "OR"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/OR.png");
            //     break
            //   case (tool.type == "XOR"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/XOR.png");
            //     break
            //   case (tool.type == "mulNetworkManage"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/networkManageTool.png");
            //     break
            //   case (tool.type == "incidentNetwork"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/incidentNetworkTool.png");
            //     break
            //   case (tool.type == "gatewayNetwork"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/gatewayNetworkTool.png");
            //     break
            //   case (tool.type == "processTimerStart"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTimerStartTool.png");
            //     break
            //   case (tool.type == "processNewsStart"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processNewsStartTool.png");
            //     break
            //   case (tool.type == "processTaskService"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTaskServiceTool.png");
            //     break
            // }
            me.$toolsBox.find('.tools-group-current').append($li);
            break;
          case baseType == 'process':
            // 流程图例
            var $li = jq('<li class="process_' + j + '"></li>');
            var tool = new GooFlow.Tools(tools.controls[j], me.options);
            $li.append(tool.$el);
            $li.attr("title", tool.rename);
            $li.find("img").attr("src", tool.iconPath);
            // switch (true) {
            //   case (tool.type == "processRefer"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processReferTool.png");
            //     break
            //   case (tool.type == "processInterface"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processInterfaceTool.png");
            //     break
            //   case (tool.type == "processGateway"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processGateway.png");
            //     break
            //   case (tool.type == "processTool"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processTool.png");
            //     break
            //   case (tool.type == "processDocumentation"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processDocumentation.png");
            //     break
            //   case (tool.type == "processInformation"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processInformation.png");
            //     break
            //   case (tool.type == "notify"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/notifyTool.png");
            //     break
            //   case (tool.type == "processCallback"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/processCallbackTool.png");
            //     break
            //   case (tool.type == "triggerDown"):
            //     $li.find("img").attr("src", "./" + me.options.toolsPath + "/triggerDownTool.png");
            //     break
            // }
            me.$toolsBox.find('.tools-group-process').append($li);
            break;
          case baseType == 'node':
            // 流程图例
            var $li = jq('<li class="process_' + j + '"></li>');
            var tool = new GooFlow.Tools(tools.controls[j], me.options);
            $li.append(tool.$el);
            $li.attr("title", tool.rename);
            $li.find("img").attr("src", tool.iconPath);
            me.$toolsBox.find('.tools-group-node').append($li);
            break;
          case baseType == 'bpmn':
            // bpmn
            var $li = jq('<li class="process_' + j + '"></li>');
            var tool = new GooFlow.Tools(tools.controls[j], me.options);
            $li.append(tool.$el);
            $li.attr("title", tool.rename);
            me.$toolsBox.find('.tools-group-bpmn').append($li);
            break;
          case baseType == 'architecture':
            // 企业架构图例
            var $li = jq('<li></li>');
            var tool = new GooFlow.Tools(tools.controls[j], me.options);
            $li.append(tool.$el);
            $li.find("img").attr("src", tool.iconPath);
            me.$toolsBox.find('.tools-group-architecture').append($li);
            break;
        }
      }


      // l连线事件
      me.$toolsBox.on('click', '.J_line', function () {
        console.log(22)
        var switchType = jq(this).attr("class").indexOf("active") == -1 ? this.getAttribute('data-switchtype') : 1;
        me._switchDottedEditType(me.EditEnum.SELECT);
        me._switchEditType(switchType);
      })
      // 虚线连线事件
      me.$toolsBox.on('click', '.J_dotted_line', function () {
        //console.log(33)
        var switchDottedType = jq(this).attr("class").indexOf("active") == -1 ? this.getAttribute('data-switchtype') : 1;
        me._switchEditType(me.EditEnum.SELECT);
        me._switchDottedEditType(switchDottedType);
      })

    },
    _initLeftRightBtn: function () {
      var me = this;
      var templ = '<span class="leftRightBtn unactive"></span>';
      me.$container.append(templ);
      jq('.leftRightBtn').on('click', function () {
        if (jq(this).hasClass('active')) {
          jq(this).removeClass('active').addClass('unactive');
          jq('.GooFlow_work').css({
            'borderLeft': 'none'
          })
          me.$tools.show();

        } else if (jq(this).hasClass('unactive')) {
          jq(this).removeClass('unactive').addClass('active');
          jq('.GooFlow_work').css({
            'borderLeft': '1px solid #cfcfcf'
          })
          me.$tools.hide();
        }
      })
    },
    /**
     * 初始化右边属性栏  三个div
     *
     */
    //     if (getParam("isReadAttr") === 'true' && this.options.toolBtns[i].name == 'change') continue;
    //     tmp += "<a href='javascript:void(0)' title='" + this.options.toolBtns[i].title + "' type='" + this.options.toolBtns[i].name + "' id='btn_" + this.options.toolBtns[i].name.split(" ")[0] + "' class='GooFlow_head_btn'>
    // <i style='background-image: url(./img/" +'ico_' + this.options.toolBtns[i].name + ".png);background-repeat: no-repeat;background-size:100% 100%;' class='ico_" + this.options.toolBtns[i].name + "'/></a>"; //加入自定义按钮
    // } //  '"> <i class="icon iconfont ' + attrGroups[i].name + '" title="' + attrGroups[i].title + '"></i>  </li>'
    _initAttrGroups: function () {
      propsSetDialog.renderPropsSetDialog("#laydiv")

      var me = this;
      var templ = '<li></li>';
      var templContent = '';
      var attrGroups = me.options.attrGroup
      for (var i in attrGroups) {
        console.log(22,attrGroups[i],i)

        templ += '<li class="ico_' + attrGroups[i].name + '" style="' + ((attrGroups[i].name == 'icon-attribute' && !me.isEdit && !me.isReadAttr) ? 'display:none;' : '') +
          // '"> <i style="background-image: url(./img/'+ attrGroups[i].name + '.png);background-repeat: no-repeat;background-size:100% 100%;" title="' + attrGroups[i].title + '" ></i> </li>'
          '"> ' +
          // '<i style="background-image: url(./img/'+ attrGroups[i].name + '.png);background-repeat: no-repeat;background-size:100% 100%;" title="' + attrGroups[i].title + '"></i> ' +
          // '<i style="background-image: url(./img/'+ attrGroups[i].name + '.png);background-repeat: no-repeat;background-size:100% 100%;" title="' + attrGroups[i].title + '"></i> ' +
          '<span style="width: 25px;font-size: 13px;margin: 0 auto;display: block;">';
          if (i === '0') {
            templ += attrGroups[i].title
          } else {
            templ += attrGroups[i].title
          }
          templ += '</span></li>'

      }
      templContent += '<div class="content_item" style="display: none;width: 700px;"><div id="process_show"></div></div>';
      templContent += '<div class="content_item" style="display: none;width: 700px;"><h4>' + jq.i18n.prop("activityDes") + '<i class="closeRightMoal"></i></h4><div class="noJiedian">' + jq.i18n.prop("viewPropertiesNode") + '</div></div>';
      templContent += '<div class="content_item" style="display: none;width: 700px;"><h4>' + jq.i18n.prop("historyVersion") + ' <i class="closeRightMoal"></i></h4><div class="history_version"><div class="addVersionBtn"><span>+</span><span>' + jq.i18n.prop("createHistory") + '</span></div></div></div>';
      templContent += '<div class="content_item" id="childProcess" style="display: none;width: 700px;"><h4>' + jq.i18n.prop("processActivityDes") + ' <i class="closeRightMoal"></i></h4><div class=" ctable checkActivity" style="max-height: 450px;overflow:auto;"></div></div>';
      // 节点属性初始状态
      me.$attrBox = jq("<div class='attrWrapper'><ul class='btn_wrapper'></ul><div class='content_wrapper'></div></div>")
      me.$attrBtnBox = me.$attrBox.find('.btn_wrapper');
      me.$attrContentBox = me.$attrBox.find('.content_wrapper');
      me.$attrBtnBox.append(templ);
      me.$attrContentBox.append(templContent);
      me.$container.append(me.$attrBox);

      // 点击右边栏
      me.$attrBtnBox.on('click', 'li', function (e) {
        console.log(jq(this).index())
        console.log('me', me)
        // console.log('attrList', attrList)
        var thatIndex = jq(this).index();
        //console.log(thatIndex)
        //console.log(me.listid, me.id)
        if (!me.curId[0] || (me.controls[me.curId[0]] && me.controls[me.curId[0]].type == 'spliceGroup')) {
          me.$attrContentBox.children().eq(1).html('<h4>' + jq.i18n.prop("activityDes") + ' <i class="closeRightMoal">' +
            '</i></h4><div class="noJiedian">' + jq.i18n.prop("viewPropertiesNode") + ' </div>');
        }
        // if (thatIndex == 2) {
        //   jq('.dialogItem').css({
        //     'width': '100%',
        //     'height': '100%'
        //   })
        //   jq('.btn_wrapper').css({
        //     'display': 'none'
        //   })
        //   jq('.right-button').css({
        //     'display': 'none'
        //   })
        // }
        // if (thatIndex == 4) {
        //     // 流程活动说明
        //     var versionData = sessionStorage.getItem('versionData');
        //     if (versionData !== null) {
        //         versionData = JSON.parse(versionData);
        //     } else {
        //         jQuery.support.cors = true;
        //         jq.ajax({
        //             type: "POST",
        //             url: me.baseUrl + "/listhistory/getLast/" + me.id + '?username=' + me.username,
        //             data: {},
        //             async: false,
        //             success: function (res) {
        //                 //console.log(res)
        //                 if (!res.json) {
        //                     return false;
        //                 }
        //                 if (res) {
        //                     versionData = !JSON.parse(res.activityname) ? [] : JSON.parse(res.activityname).name;
        //                 } else {
        //                     versionData = [];
        //                 }
        //             }
        //         })
        //     }
        //     me.$attrContentBox.find('.checkActivity').children().remove();
        //     var list = versionData;
        //     // 需求说只需要显示任务模块的信息，so...
        //     var newlist = list;
        //     // 流程活动说明的标签内容
        //     //console.log(newlist);
        //     for (var k = 0; k < newlist.length; k++) {
        //         for (var m = 0; m < newlist[k].leaders.length; m++) {
        //             if (newlist[k].leaders[m].deptname == null) {
        //                 newlist[k].leaders[m].deptname = '';
        //             }
        //         }
        //     }
        //     newlist.sort(function (a, b) {
        //         return a.index - b.index;
        //     })
        //     var checkActivity = doT.template(jq("#checkActivity").text());
        //     //console.log(checkActivity);
        //     if (me.$attrContentBox.find('.checkActivity').children('table').length >= 1) {
        //         me.$attrContentBox.find('.checkActivity').children('table').replaceWith(checkActivity({
        //             list: newlist
        //         }));
        //     } else {
        //         me.$attrContentBox.find('.checkActivity').append(checkActivity({
        //             list: newlist
        //         }));
        //     }
        // } else
        if (thatIndex == 1) {
          console.dir(window.Vue)
        }
        if (thatIndex == 2 && me.curId[0] && me.curId[0].indexOf("CONTROL") > -1) {
          // 信息文档文件分类
          jQuery.support.cors = true;
          jq.ajax({
            type: 'POST',
            async: false,
            url: me.baseUrl + '/dictionary/query?username=' + me.username,
            data: JSON.stringify({
              "attr": {},
              "filters": [{ "key": "name", "opt": "LIKE", "type": "S", "value": "" },
              { "key": "state", "opt": "LIKE", "type": "S", "value": "" },
              { "key": "sheetname", "opt": "LIKE", "type": "S", "value": null },
              { "key": "sheetid", "opt": "EQ", "type": "S", "value": "691902961391259648" },
              { "key": "type", "opt": "LIKE", "type": "S", "value": "0" }],
              "logic": "and",
              "orderby": "createon",
              "pageNum": 1,
              "pageSize": 10,
              "sort": "desc"
            }),
            dataType: 'json',
            contentType: "application/json;",
            success: function (res) {
              if (me.curId[0]) {
                var list = res.data.list;
                console.log(list, me, me.controls, 1, me.curId[0])
                // me.controls[me.curId[0]]['messageFileType'] = res.data.list || []
                me.messageFileType = res.data.list || []
                var messageFileList = []
                if (!!me.controls[me.curId[0]].messageFile && me.controls[me.curId[0]].messageFile.length > 0) {
                  for (var i = 0; i < me.controls[me.curId[0]].messageFile.length; i++) {
                    for (var j = 0; j < list.length; j++) {
                      if (!!me.controls[me.curId[0]].messageFile[i].fileType && me.controls[me.curId[0]].messageFile[i].fileType == list[j].pname) {
                        messageFileList.push(me.controls[me.curId[0]].messageFile[i])
                      }
                    }
                  }
                }
                if (!!me.controls[me.curId[0]].messageFile) {
                  me.controls[me.curId[0]].messageFile = messageFileList
                }
              }
            }
          })
        }
        if (thatIndex == 4 && me.curId[0] && me.curId[0].indexOf("CONTROL") > -1) {
          sessionStorage.setItem('childProcessInfo',
          JSON.stringify({
            curId: me.curId[0],
            list: me.listid,
            type: me.controls[me.curId[0]].type
          }))
          childProcess.renderChildProcessDialog('#childProcess');
          console.log('childProcess')
          return
        }
        if(me.controls[me.curId[0]].type === 'role'){
          return false;
        }
        //console.log(me)
        if (!me.curId[0] || me.curId[0].indexOf("LINE") > -1) {
          me._switchPlan(me.curId[0], me.lines[me.curId[0]]);
        } else if (me.curId[0].indexOf("CONTROL") > -1) {
          const $control = me.controls[me.curId[0]];
          const PropsActivity = new propsActivity({ categoryId: me.category.id, control: $control })
          me._switchPlan(me.curId[0], me.controls[me.curId[0]]);
        } else if (me.curId[0].indexOf("SWIMLANE") > -1) {
          me._switchPlan(me.curId[0], me.swimlanes[me.curId[0]]);
        }

        if (jq(this).children().hasClass('active')) {
          jq(this).children().removeClass('active');
          me.$attrContentBox.children().siblings().hide().eq(thatIndex - 1).hide();
        } else {
          me.$attrBtnBox.children().children().removeClass('active').eq(thatIndex - 1).addClass('active');
          me.$attrBtnBox.children('a').removeClass('active').eq(thatIndex - 1).addClass('active');
          me.$attrContentBox.children().siblings().hide().eq(thatIndex - 1).show();
        }


      })
      var versionData = [];
      jQuery.support.cors = true;
      jq.ajax({
        type: 'POST',
        url: me.baseUrl + '/listhistory/getHistoryByListid/' + me.id + '?username=' + me.username,
        success: function (res) {
          versionData = res;
          for (var i in versionData) {
            if (versionData[i].singby != null || versionData[i].singby != undefined) {
              versionData[i].singby = versionData[i].singby.split(',');
            }
            if (versionData[i].approveby != null || versionData[i].approveby != undefined) {
              versionData[i].approveby = versionData[i].approveby.split(',');
            }
          }
          var $historyVertionTable = doT.template(jq("#historyVertionTable").text());
          me.$attrContentBox.find('.history_version').append($historyVertionTable({
            list: versionData
          }));

          //打开编辑历史版本按钮
          me.$attrContentBox.find('.addVersionBtn').on('click', function () {
            jq(this).hide().parent().find('.historyVesnContent').show();
          })
          // 编辑确定按钮
          me.$attrContentBox.find('.history_version').on('click', '#yesBtn', function () {
            var $this = jq(this);
            jQuery.support.cors = true;
            jq.ajax({
              type: 'POST',
              url: me.baseUrl + '/listhistory/saveHistory?username=' + me.username,
              data: JSON.stringify({
                description: jq("#descs").val(),
                name: jq('#name').val(),
                json: JSON.stringify(me.getToJSON()),
                listid: me.id
              }),
              contentType: 'application/json;',
              success: function (res) {
                jQuery.support.cors = true;
                jq.ajax({
                  type: 'POST',
                  url: me.baseUrl + '/listhistory/getHistoryByListid/' + me.id + '?username=' + me.username,
                  success: function (res) {

                    versionData = res;
                    for (var i in versionData) {
                      if (versionData[i].singby != null || versionData[i].singby != undefined) {
                        versionData[i].singby = versionData[i].singby.split(',');
                      }
                      if (versionData[i].approveby != null || versionData[i].approveby != undefined) {
                        versionData[i].approveby = versionData[i].approveby.split(',');
                      }
                    }
                    var $historyVertionTable = doT.template(jq("#historyVertionTable").text());
                    me.$attrContentBox.find('.addVersionBtn').show()
                    me.$attrContentBox.find('.replaceTable').replaceWith($historyVertionTable({
                      list: versionData
                    }));
                  }
                })
              }
            })

          })
          // 编辑取消按钮
          me.$attrContentBox.find('#noBtn').on('click', function () {
            jq(this).parents('.historyVesnContent').hide().siblings('.addVersionBtn').show();
          })
          // 查看版本按钮
          me.$attrContentBox.find('.history_version').on('click', '.check', function () {
            var jsonstr, lines;
            if (jq("#backToBefore").css("display") === 'none') {
              var localVersionData = JSON.stringify(me.getToJSON());
              sessionStorage.setItem('localVersionData', localVersionData);
            }
            jq("#backToBefore").show();
            if (jq(this).attr('data-viewjson') == '{}') {
              jsonstr = '{"controls":[],"lines":[],"swimlanes":[]}';
            } else {
              jsonstr = jq(this).parent().attr('data-viewjson');
            }
            me.clearAll();
            me.loadData(JSON.parse(jsonstr));

            sessionStorage.setItem('versionData', jsonstr);
          })
          jq("#backToBefore").on('click', function () {
            var localVersionData = JSON.parse(sessionStorage.getItem('localVersionData'));
            sessionStorage.removeItem('versionData');
            me.clearAll();
            me.loadData(localVersionData);
            jq(this).hide();
          })
          // 历史版本删除按钮事件
          me.$attrContentBox.find('.history_version').on('click', '.remove', function () {
            var $this = jq(this);
            var id = $this.parent().attr('data-id');
            jQuery.support.cors = true;
            jq.ajax({
              type: 'POST',
              url: me.baseUrl + '/listhistory/deleteHistory/' + id + '?username=' + me.username,
              success: function (res) {
                $this.parents('tr').remove();
              }
            })
          })
        }
      })

    },
    /**
     * 初始化上下游流程
     */
    _initUpDnProcess: function (data) {
      var me = this;
      var processObj = me.ToolsConfig['process'];

      var upArr = []
      var downArr = []
      if (data) {
        for (var i = 0; i < data.controls.length; i++) {
          if (data.controls[i].splitType === 'upProcess') {
            upArr.push(data.controls[i])
          }
          else if (data.controls[i].splitType === 'downProcess') {
            downArr.push(data.controls[i])
          }
        }
      }

      if (me.storeData) {
        var inputnamelist = me.storeData.bpmDto ? (me.storeData.bpmDto.inputnamelist || []) : [];
        var outputnamelist = me.storeData.bpmDto ? (me.storeData.bpmDto.outputnamelist || []) : [];
        var state = me.storeData.bpmDto ? me.storeData.bpmDto.state : ''
        var processLeft = 40;
        if (inputnamelist) {
          // 添加上游流程部分 ---------------------------- 开始
          for (var i = 0; i < inputnamelist.length; i++) {
            var processInfo = {};
            processInfo.id = GooFlow.getUID('CONTROL');
            me.upDownProcessList.push({
              id: processInfo.id,
              name: inputnamelist[i].name
            })

            processInfo.top = 20;

            processInfo.left = (i + 1) * processLeft + i * parseInt(processObj.width);
            processInfo.left = processInfo.left > jq('.swimlaneX').width() ? (2 * processInfo.left - jq('.swimlaneX').width()) : processInfo.left
            jq.extend(processInfo, JSON.parse(JSON.stringify(processObj)))
            processInfo.name = inputnamelist[i].code + inputnamelist[i].name;
            processInfo.processGroup = [{
              'id': inputnamelist[i].id,
              'name': inputnamelist[i].code + inputnamelist[i].name
            }];
            processInfo.splitType = 'upProcess'
            processInfo.inputname = inputnamelist[i].id

            if (upArr.length) {
              for (var k = 0; k < upArr.length; k++) {
                if (upArr[k].processGroup[0].id === processInfo.inputname) {
                  jq.extend(processInfo, JSON.parse(JSON.stringify(upArr[k])));
                  if (state === '3') {
                    processInfo.output = [];
                    processInfo.outputDesc = '';
                  }
                }
              }
            }
            var ctl = new GooFlow.Control(JSON.parse(JSON.stringify(processInfo)), me.options);
            ctl.syncUI();
            me.controls[ctl.id] = ctl;
            me.$workArea.append(ctl.$el);
          }
          // 添加上游流程部分 ---------------------------- 结束
        }

        var instanceTop = 30;
        for (var k = 0; k < jq('.swimlaneX').length; k++) {
          if (jq('.swimlaneX').length - 1 == k) break;
          instanceTop += jq(".swimlaneX").eq(k).height();
        }
        if (outputnamelist) {
          // 添加下游流程部分 ---------------------------- 开始
          me.instantTop += 100;
          for (var j = 0; j < outputnamelist.length; j++) {
            var processInfo = {};
            processInfo.id = GooFlow.getUID('CONTROL');
            me.upDownProcessList.push({
              id: processInfo.id,
              name: outputnamelist[j].name
            });
            processInfo.top = instanceTop;
            processInfo.left = (j + 1) * processLeft + j * parseInt(processObj.width);
            processInfo.left = processInfo.left > jq('.swimlaneX').width() ? (2 * processInfo.left - jq('.swimlaneX').width()) : processInfo.left
            jq.extend(processInfo, JSON.parse(JSON.stringify(processObj)))
            processInfo.name = outputnamelist[j].code + outputnamelist[j].name;
            processInfo.processGroup = [{
              'id': outputnamelist[j].id,
              'name': outputnamelist[j].code + outputnamelist[j].name
            }];
            processInfo.splitType = 'downProcess'
            processInfo.outputname = outputnamelist[j].id
            //console.log(processInfo)

            if (downArr.length) {
              for (var k = 0; k < downArr.length; k++) {
                if (downArr[k].processGroup[0].id === processInfo.outputname) {
                  jq.extend(processInfo, JSON.parse(JSON.stringify(downArr[k])));
                  break;
                }
              }
            }
            var ctl = new GooFlow.Control(JSON.parse(JSON.stringify(processInfo)), me.options);
            ctl.syncUI();
            me.controls[ctl.id] = ctl;
            me.$workArea.append(ctl.$el);
            basFlow.linkage(ctl.id)
          }
          // 添加下游流程部分 ---------------------------- 结束
        }
      }

    },
    // 自定义右键菜单事件   复制粘贴 删除的右键点击事件
    _initContextMenu: function () {
      var me = this;
      var $contextMenu = doT.template(jq('#contextMenu').text());
      me.$workArea.on('contextmenu', function (e) {
        e.preventDefault();
        var target = null;
        var isCopy = null;
        var isDelete = null;
        var isPaste = null;
        if (jq(e.target).parents('.text').length == 1) {
          target = jq(e.target).parents('.control');
          me.copyIdTemp = target.attr('id');
          isPaste = false;
        } else {
          isCopy = true;//禁止点击
          isDelete = true;
          isPaste = true;
        }
        //console.log(me, me.curId[0], $contextMenu, target, ToolsConfig, e.target.className)
        let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
        var obj = {
          left: e.clientX + 'px',
          top: e.clientY + 'px',
          menuList: [
            {
              name: jq.i18n.prop("copy"),
              class: 'copy',
              disable: window.isEditAttr === false || isCopy
            },
            {
              name: jq.i18n.prop("paste"),
              class: 'paste',
              disable: window.isEditAttr === false ? true : me.copyId[0] && isPaste ? false : true
            },
            {
              name: jq.i18n.prop("delete"),
              class: 'delete',
              disable: window.isEditAttr === false || isDelete
            },
            {
              name: jq.i18n.prop("openReferenceFlow"),
              class: 'view',
              disable: me.controls[me.copyIdTemp] && me.controls[me.copyIdTemp].processGroup && me.controls[me.copyIdTemp].processGroup.length > 0 ? false : true
            },
            {
              name: me.controls[me.copyIdTemp] && !!me.controls[me.copyIdTemp].isOperable ? jq.i18n.prop("rigidNode") : jq.i18n.prop("flexibleNode"),
              class: 'isOperable',
              disable: (me.controls[me.copyIdTemp] && me.controls[me.copyIdTemp].baseType !== 'process' && me.controls[me.copyIdTemp].baseType !== 'current') || isCopy
            },
            {
              name: jq.i18n.prop("attributes"),
              class: 'attrCheck',
              disable: me.controls[me.copyIdTemp] ? false : true
            },
            { // && !processInfo.pid && !processInfo.processType 除去新建流程 业务对象 未保存的情况
              name: '新建流程',
              class: 'newProcess',
              disable: (me.controls[me.copyIdTemp] && me.listid && !processInfo.pid && !processInfo.processType && me.controls[me.copyIdTemp].processGroup.length === 0) ? false : true
            },
            // {
            //   name: '业务对象',
            //   class: 'busObj',
            //   disable: (me.controls[me.copyIdTemp] && me.listid && !processInfo.pid && !processInfo.processType) ? false : true
            // }
            // {
            //     name: jq.i18n.prop("selectAttach"),
            //     class: (!!e.target.className && e.target.className.indexOf('outputTxt') > -1) ? 'outUploadFile' : 'inUploadFile',
            //     disable: (!!e.target.className && (e.target.className.indexOf('inputTxt') > -1 || e.target.className.indexOf('outputTxt') > -1)) ? false : true
            // }
          ]
        }

        //console.log(String(e.target.className))
        if (!!e.target.className && typeof e.target.className == 'string' && (e.target.className.indexOf('inputTxt') > -1 || e.target.className.indexOf('outputTxt') > -1)) {
          obj.menuList.push({
            name: jq.i18n.prop("selectAttach"),
            class: (!!e.target.className && e.target.className.indexOf('outputTxt') > -1) ? 'outUploadFile' : 'inUploadFile',
            disable: false
          })
        }
        if (!!e.target.className && typeof e.target.className == 'string' && me.controls[me.copyIdTemp].type === 'role') {
          obj.menuList.push({
            name: '关联岗位',
            class: 'relatedPost',
            disable: false
          })
        }
        if (!!e.target.className && typeof e.target.className == 'string' && (!!me.controls[me.copyIdTemp].role || !!me.controls[me.copyIdTemp].systemDocumentChapter || !!me.controls[me.copyIdTemp].input)) {
          obj.menuList.push({
            name: '查看关联要素',
            class: 'relatedEle',
            disable: me.controls[me.copyIdTemp].type === 'processTask' &&
              !me.controls[me.copyIdTemp].isRelatedEle &&
              (
                (me.controls[me.copyIdTemp].system && me.controls[me.copyIdTemp].system.length > 0) ||
                me.controls[me.copyIdTemp].inputDesc || (me.controls[me.copyIdTemp].input && me.controls[me.copyIdTemp].input.length > 0) ||
                me.controls[me.copyIdTemp].outputDesc || (me.controls[me.copyIdTemp].output && me.controls[me.copyIdTemp].output.length > 0) ||
                (me.controls[me.copyIdTemp].systemDocumentChapter && me.controls[me.copyIdTemp].systemDocumentChapter.filter(val => val.docId).length > 0) ||
                (me.controls[me.copyIdTemp].systemDocumentChapter && me.controls[me.copyIdTemp].systemDocumentChapter.filter(val => val.systemChapter && val.systemChapter[0] && val.systemChapter[0].dmid).length > 0)
              ) ? false : true
          })
        }

        me.$work.find('#menu').remove();
        me.$work.append($contextMenu(obj));
      });

      var isCopy = false;
      jq(window).off().on('click', function (e) {
        console.log('window.click')
        me.copyId = [];
        me.copyId[0] = me.copyIdTemp
        var isAllowed = jq(e.target).attr('data-isAllowed');
        if (isAllowed == 'true') {
          return false;
        }
        //console.log(e.target)
        console.log(' me.copyId', me.copyId)
        if (typeof e.target.className == 'string' && e.target.className && (e.target.className.indexOf('outUploadFile') > -1 || e.target.className.indexOf('inUploadFile') > -1)) {
        } else {
          me.$work.find('#menu').remove();
        }
        // 删除
        if (typeof e.target.className == 'string' && e.target.className) {
          if (e.target.className.indexOf('delete') > -1) {
            me.delControl(me.copyId[0]);
            // 复制
          } else if (e.target.className.indexOf('copy') > -1) {
            isCopy = true;
            // 粘贴
          } else if (e.target.className.indexOf('paste') > -1) {
            if (isCopy) {
              var ctrls = me.getToJSON().controls;
              me.copyItem = [];
              var distanceLeft = 0;
              //找出复制的模块信息
              if (!!me.controls[me.copyId[0]]) {
                me.copyItem[0] = JSON.parse(JSON.stringify(me.controls[me.copyId[0]]));
              }
              if (!me.copyItem.length) {
                return;
              }

              if (me.$tools.css('display') === 'block') {
                distanceLeft = 200;
              }
              me.copyItem[0].id = GooFlow.getUID('CONTROL');
              me.copyItem[0].left = (e.clientX + me.$work.scrollLeft() - distanceLeft - me.swimXwidth * me.scaleTo) / me.scaleTo;
              me.copyItem[0].top = (e.clientY + me.$work.scrollTop() - 30 - 35 * me.scaleTo) / me.scaleTo;


              me.addControl(JSON.parse(JSON.stringify(me.copyItem[0])), true);
              me.linkage();
              if (!!JSON.parse(JSON.stringify(me.copyItem[0])).keyKSFControl && !!JSON.parse(JSON.stringify(me.copyItem[0])).keyKSFControl.length > 0) {
                var keyKSFControlCopy = JSON.parse(JSON.stringify(me.copyItem[0])).keyKSFControl
                for (var f = 0; f < keyKSFControlCopy.length; f++) {
                  keyKSFControlCopy[f].listid = me.id
                  keyKSFControlCopy[f].keyid = me.copyItem[0].id
                }
                jQuery.support.cors = true;
                jq.ajax({
                  type: 'POST',
                  url: me.baseUrl + '/succelement/saveSuccelementList?username=' + me.username,
                  dataType: 'json',
                  contentType: "application/json;",
                  data: JSON.stringify(keyKSFControlCopy),

                  success: function (res) {
                    //console.log(res);
                  },
                  error: function () {
                    //console.log(err)
                  }
                })
              }

              if (!!JSON.parse(JSON.stringify(me.copyItem[0])).keyControl && JSON.parse(JSON.stringify(me.copyItem[0])).keyControl.length > 0) {
                jQuery.support.cors = true;
                var keyControlCopy = []
                var keyControlCopyItem = JSON.parse(JSON.stringify(me.copyItem[0])).keyControl
                for (var c = 0; c < keyControlCopyItem.length; c++) {
                  keyControlCopyItem[c].listid = me.id
                  keyControlCopyItem[c].keyid = me.copyItem[0].id
                  keyControlCopy.push(keyControlCopyItem[c])
                }
                jq.ajax({
                  type: 'POST',
                  url: me.baseUrl + '/modellist/saveCorekeyList?username=' + me.username,
                  dataType: 'json',
                  contentType: "application/json;",
                  data: JSON.stringify(keyControlCopy),

                  success: function (res) {
                    //console.log(res);
                  },
                  error: function () {
                  }
                })
              }

              if (JSON.parse(JSON.stringify(me.copyItem[0])).type == 'processTask' || JSON.parse(JSON.stringify(me.copyItem[0])).type == 'processIt') {
                var copyItem = JSON.parse(JSON.stringify(me.copyItem[0]));
                if (!!copyItem.input.length) {
                  for (var j = 0; j < copyItem.input.length; j++) {
                    (function (index) {
                      jQuery.support.cors = true;
                      jq.ajax({
                        type: 'POST',
                        url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.input[index].docid + '?username=' + me.username,
                        async: true,
                        success: function (res) {
                          for (var t = 0; t < me.controls[copyItem.id].input.length; t++) {
                            if (me.controls[copyItem.id].input[t].id == copyItem.input[index].id) {
                              me.controls[copyItem.id].input[t].docid = res.id;
                              break;
                            }
                          }
                        },
                        error: function (err) {
                          //console.log(err)
                        }
                      })
                    })(j)
                  }
                }
                if (!!copyItem.output.length) {
                  for (var j = 0; j < copyItem.output.length; j++) {
                    (function (index) {
                      jQuery.support.cors = true;
                      jq.ajax({
                        type: 'POST',
                        url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.output[index].docid + '?username=' + me.username,
                        async: true,
                        success: function (res) {
                          for (var t = 0; t < me.controls[copyItem.id].output.length; t++) {
                            if (me.controls[copyItem.id].output[t].id == copyItem.output[index].id) {
                              me.controls[copyItem.id].output[t].docid = res.id;
                              break;
                            }
                          }
                        },
                        error: function (err) {
                          //console.log(err)
                        }
                      })
                    })(j)
                  }
                }
                if (!!copyItem.messageFile.length) {
                  for (var j = 0; j < copyItem.messageFile.length; j++) {
                    (function (index) {
                      jQuery.support.cors = true;
                      jq.ajax({
                        type: 'POST',
                        url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.messageFile[index].docid + '?username=' + me.username,
                        async: true,
                        success: function (res) {
                          // //console.log(res);
                          // copyItem.input[index].docid = res.id;
                          // //console.log(copyItem.input[index])
                          for (var t = 0; t < me.controls[copyItem.id].messageFile.length; t++) {
                            if (me.controls[copyItem.id].messageFile[t].id == copyItem.messageFile[index].id) {
                              me.controls[copyItem.id].messageFile[t].docid = res.id;
                              break;
                            }
                          }
                        },
                        error: function (err) {
                          //console.log(err)
                        }
                      })
                    })(j)
                  }
                }
                if (!!copyItem.messageGroup.length) {
                  for (var j = 0; j < copyItem.messageGroup.length; j++) {
                    (function (index) {
                      jQuery.support.cors = true;
                      jq.ajax({
                        type: 'POST',
                        url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.messageGroup[index].docid + '?username=' + me.username,
                        async: true,
                        success: function (res) {
                          // //console.log(res);
                          // copyItem.input[index].docid = res.id;
                          // //console.log(copyItem.input[index])
                          for (var t = 0; t < me.controls[copyItem.id].messageGroup.length; t++) {
                            if (me.controls[copyItem.id].messageGroup[t].id == copyItem.messageGroup[index].id) {
                              me.controls[copyItem.id].messageGroup[t].docid = res.id;
                              break;
                            }
                          }
                        },
                        error: function (err) {
                          //console.log(err)
                        }
                      })
                    })(j)
                  }
                }
              }
              if (JSON.parse(JSON.stringify(me.copyItem[0])).type == 'approveRules') {
                var copyItem = JSON.parse(JSON.stringify(me.copyItem[0]));
                if (!!copyItem.approverules.length) {
                  for (var j = 0; j < copyItem.approverules.length; j++) {
                    (function (index) {
                      jQuery.support.cors = true;
                      jq.ajax({
                        type: 'POST',
                        url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.approverules[index].docid + '?username=' + me.username,
                        async: true,
                        success: function (res) {
                          // //console.log(res);
                          // copyItem.input[index].docid = res.id;
                          // //console.log(copyItem.input[index])
                          for (var t = 0; t < me.controls[copyItem.id].messageGroup.length; t++) {
                            if (me.controls[copyItem.id].approverules[t].id == copyItem.approverules[index].id) {
                              me.controls[copyItem.id].approverules[t].docid = res.id;
                              break;
                            }
                          }
                        },
                        error: function (err) {
                          //console.log(err)
                        }
                      })
                    })(j)
                  }
                }
              }
            }
          } else if (e.target.className.indexOf('view') > -1) { // 切换背景风格
            e.stopPropagation()
            e.preventDefault()
            // me.controls[me.copyIdTemp].processGroup
            me.openReferenceFlow()
          } else if (e.target.className.indexOf('isOperable') > -1) {
            //console.log(me.controls[me.copyId[0]], me.copyId[0])
            me.controls[me.copyId[0]].isOperable = !me.controls[me.copyId[0]].isOperable
            //console.log(me.copyId[0], me.curId[0])
            if (!me.controls[me.copyId[0]].isOperable) { // 刚性节点时 使之失去焦点
              if (me.copyId[0] == me.curId[0]) { // 选中的是当前节点时   使之变成未选中
                me.curId = []
              }
              me.controls[me.copyId[0]].blur()
              me.copyId = []
            }
          } else if (e.target.className.indexOf('inUploadFile') > -1) {
            //console.log(2222)
          } else if (e.target.className.indexOf('outUploadFile') > -1) {
            //console.log(2222)
          } else if (e.target.className.indexOf('attrCheck') > -1) {
            for (var s = 0; s < me.curId.length; s++) {
              me.controls[me.curId[s]].blur()
            }
            jq('#' + me.copyId[0]).addClass('cur')
            me.curId[0] = me.copyId[0]
            me.$attrBtnBox.find('.ico_icon-attribute').click()
            me.$attrBtnBox.children().children().removeClass('active').eq(1).addClass('active')
            me.$attrContentBox.children().siblings().hide().eq(1).show()
            for (var i = 0; i < jq("#pointAttr li").length; i++) {
              // if (obj.type == 'KCP) {
              if (jq("#pointAttr li").eq(i).text() === jq.i18n.prop("activityDes")) {
                jq("#pointAttr li").eq(i).siblings().removeClass("active");
                jq("#pointAttr li").eq(i).addClass("active");
                jq(".attr1Box").children().siblings().css("display", "none");
                jq(".attr1Box").children().eq(i).css("display", "block");
                break;
              }
            }
          } else if (e.target.className.indexOf('newProcess') > -1) {
            // element.error(2222222222222)
            element.$confirm('当前流程还未保存，是否确定打开?', '提示', {
              confirmButtonText: '确定',
              cancelButtonText: '取消',
              type: 'warning'
            }).then(() => {
              me.newProcessChart(me.copyId[0])
            })
          } else if (e.target.className.indexOf('busObj') > -1) {
            let chartJson = window.chartJson()
            // 先提示保存流程图
            if (!isSameData(chartJson, JSON.parse(sessionStorage.getItem('chartJson')))) {
              me.alertBox('请先保存流程图！', 'danger');
              return
            }
            // jq.ajax({
            //   type: "POST",
            //   url: basFlow.baseUrl + "/listhistory/saveHistory?username=" + basFlow.username,
            //   contentType: 'application/json;',

            //   data: JSON.stringify({
            //     "listid": getParam("id"),
            //     "json": JSONval,
            //     "inputname": inputids.length == 0 ? '' : inputids.join(","),
            //     "outputname": outputids.length == 0 ? '' : outputids.join(","),
            //     "activityname": JSON.stringify({ "name": tempArr }),
            //     "swimid": me.listid,
            //     "swimlane": swimlane,
            //   }),
            //   success: function (data) {}
            // })
            let processTabMenu = JSON.parse(sessionStorage.getItem('processTabMenu')) || []
            let parentItem = !sessionStorage.getItem('processInfo') ? {} : JSON.parse(sessionStorage.getItem('processInfo'))
            console.log(JSON.parse(sessionStorage.getItem('processInfo')), JSON.parse(sessionStorage.getItem('processTabMenu')))
            if (processTabMenu) {
              console.log(me.copyId[0], 'me.controls[me.copyId[0]]')
              console.log(me.controls)
              console.log(me.controls[me.copyId[0]])
              var thisbusObjJson = me.controls[me.copyId[0]]
              let busObjData = {} // 存取改节点的业务对象
              if (thisbusObjJson) {
                if (!thisbusObjJson.busObjData || jq.isEmptyObject(thisbusObjJson.busObjData)) {
                  let zuobiao = {
                    KCP: {
                      left: 260,
                      top: 50
                    },
                    KSF: {
                      left: 400,
                      top: 50
                    },
                    input: {
                      left: 100,
                      top: 190
                    },
                    processTask: {
                      left: 295,
                      top: 170
                    },
                    output: {
                      left: 545,
                      top: 190
                    },
                    processForm: {
                      left: 232,
                      top: 305
                    },
                    processTool: {
                      left: 400,
                      top: 305
                    }
                  }
                  let thisbusObjControls = []
                  thisbusObjControls.push(Object.assign({},
                    me.ToolsConfig['processTask'],
                    {
                      "name": thisbusObjJson.name,
                      id: 'CONTROLD673A2EB',
                      "bindSwimXId":"SWIMLANEA91C6B62",
                      "bindSwimXOffsetX":0,
                      "bindSwimXOffsetY":0,
                      "bindSwimYId":"SWIMLANE684EB5BE",
                      "bindSwimYOffsetX":0,
                      "bindSwimYOffsetY":0
                    },
                    zuobiao.processTask
                    )
                  )
                  for (var key in thisbusObjJson) {
                    if (key === 'inputDesc' && !!thisbusObjJson[key]) {
                      thisbusObjControls.push(Object.assign({},
                        me.ToolsConfig['processInput'],
                        {
                          "inputDesc": thisbusObjJson[key],
                          "name": thisbusObjJson[key],
                          "input": thisbusObjJson.input,
                          id: 'CONTROLFAEDAEE7',
                          "bindSwimXId":"SWIMLANEA91C6B62",
                          "bindSwimXOffsetX":0,
                          "bindSwimXOffsetY":0,
                          "bindSwimYId":"SWIMLANE684EB5BE",
                          "bindSwimYOffsetX":0,
                          "bindSwimYOffsetY":0
                        },
                        zuobiao.input
                        )
                      )
                    }
                    if (key === 'outputDesc' && !!thisbusObjJson[key]) {
                      thisbusObjControls.push(Object.assign({},
                        me.ToolsConfig['processOutput'],
                        {
                          "outputDesc": thisbusObjJson[key],
                          "name": thisbusObjJson[key],
                          "output": thisbusObjJson.output,
                          id: 'CONTROLA83C3B4E',
                          "bindSwimXId":"SWIMLANEA91C6B62",
                          "bindSwimXOffsetX":0,
                          "bindSwimXOffsetY":0,
                          "bindSwimYId":"SWIMLANE684EB5BE",
                          "bindSwimYOffsetX":0,
                          "bindSwimYOffsetY":0
                        },
                        zuobiao.output
                        )
                      )
                    }
                    // KCP
                    if (key === 'keyControl' && !!thisbusObjJson[key] && thisbusObjJson[key].length > 0) {
                      thisbusObjControls.push(Object.assign({},
                        me.ToolsConfig['KCP'],
                        {
                          "keyControl": thisbusObjJson[key],
                          id: 'CONTROLF324AF1D',
                          "bindSwimXId":"SWIMLANEA91C6B62",
                          "bindSwimXOffsetX":0,
                          "bindSwimXOffsetY":0,
                          "bindSwimYId":"SWIMLANE684EB5BE",
                          "bindSwimYOffsetX":0,
                          "bindSwimYOffsetY":0
                        },
                        zuobiao.KCP
                        )
                      )
                    }
                    // KSF
                    if (key === 'keyKSFControl' && !!thisbusObjJson[key] && thisbusObjJson[key].length > 0) {
                      thisbusObjControls.push(Object.assign({},
                        me.ToolsConfig['KSF'],
                        {
                          "keyKSFControl": thisbusObjJson[key],
                          id: 'CONTROL21D03DE6',
                          "bindSwimXId":"SWIMLANEA91C6B62",
                          "bindSwimXOffsetX":0,
                          "bindSwimXOffsetY":0,
                          "bindSwimYId":"SWIMLANE684EB5BE",
                          "bindSwimYOffsetX":0,
                          "bindSwimYOffsetY":0
                        },
                        zuobiao.KSF
                        )
                      )
                    }
                    // processForm
                    if (key === 'messagefileForm' && !!thisbusObjJson[key]) {
                      thisbusObjControls.push(Object.assign({},
                        me.ToolsConfig['processForm'],
                        {
                          "messagefileForm": thisbusObjJson[key],
                          "messageFile": thisbusObjJson.messageFile,
                          "name": thisbusObjJson[key],
                          id: 'CONTROL2018F752',
                          "bindSwimXId":"SWIMLANEA91C6B62",
                          "bindSwimXOffsetX":0,
                          "bindSwimXOffsetY":0,
                          "bindSwimYId":"SWIMLANE684EB5BE",
                          "bindSwimYOffsetX":0,
                          "bindSwimYOffsetY":0
                        },
                        zuobiao.processForm
                        )
                      )
                    }
                    // processTool
                    if (key === 'modelListToolsDtos' && !!thisbusObjJson[key] && thisbusObjJson.modelListToolsDtos.length > 0) {
                      thisbusObjControls.push(Object.assign({},
                        me.ToolsConfig['processTool'],
                        {
                          "modelListToolsDtos": thisbusObjJson[key],
                          "name": thisbusObjJson[key].map(item => item.toolname).join(','),
                          id: 'CONTROLE96F332D',
                          "bindSwimXId":"SWIMLANEA91C6B62",
                          "bindSwimXOffsetX":0,
                          "bindSwimXOffsetY":0,
                          "bindSwimYId":"SWIMLANE684EB5BE",
                          "bindSwimYOffsetX":0,
                          "bindSwimYOffsetY":0
                        },
                        zuobiao.processTool
                        )
                      )
                    }
                  }
                  console.log(thisbusObjControls, 'thisbusObjControls')
                  busObjData = {
                    // "controls":[{"id":"CONTROLA83C3B4E","name":"输出","type":"processOutput","left":544,"top":189,"width":70,"height":40,"inputname":"","outputnamename":"","rename":"输出","baseType":"node","desc":"","time":"","drag":true,"resize":true,"isOperable":true,"padding":"0","img":"processOutput.png","system":[],"isKeyCtrl":false,"leaders":[],"input":[],"output":[],"inputDesc":"","outputDesc":"","opertBooks":[],"messageForm":"","state":"","iconPath":"http://jiucaiyunbpm.jiucaiyun.cn/bpabpmapi/bpm/attachment/download/730708060510900224?attachmentType=bpm","toolsPath":"shadow","outputname":"","bindSwimXId":"SWIMLANEA91C6B62","bindSwimXOffsetX":0,"bindSwimXOffsetY":0,"bindSwimYId":"SWIMLANE684EB5BE","bindSwimYOffsetX":0,"bindSwimYOffsetY":0},{"id":"CONTROLFAEDAEE7","name":"输入","type":"processInput","left":100,"top":188,"width":70,"height":40,"inputname":"","outputnamename":"","rename":"输入","baseType":"node","desc":"","time":"","drag":true,"resize":true,"isOperable":true,"padding":"0","img":"processInput.png","system":[],"isKeyCtrl":false,"leaders":[],"input":[],"output":[],"inputDesc":"","outputDesc":"","opertBooks":[],"messageForm":"","state":"","iconPath":"http://jiucaiyunbpm.jiucaiyun.cn/bpabpmapi/bpm/attachment/download/730707815244779520?attachmentType=bpm","toolsPath":"shadow","outputname":"","bindSwimXId":"SWIMLANEA91C6B62","bindSwimXOffsetX":0,"bindSwimXOffsetY":0,"bindSwimYId":"SWIMLANE684EB5BE","bindSwimYOffsetX":0,"bindSwimYOffsetY":0},{"id":"CONTROL21D03DE6","name":"KSF","type":"KSF","left":402,"top":53,"width":60,"height":60,"inputname":"","outputnamename":"","rename":"KSF","baseType":"node","desc":"","drag":true,"resize":true,"isOperable":true,"padding":"0 0 10px 0","img":"KSF.png","system":[],"keyKSFControl":[],"color":"#fff","isKeyKSFCtrl":false,"leaders":[],"input":[],"output":[],"inputDesc":"","outputDesc":"","opertBooks":[],"messageForm":"","state":"","iconPath":"http://jiucaiyunbpm.jiucaiyun.cn/bpabpmapi/bpm/attachment/download/730708421430759424?attachmentType=bpm","toolsPath":"shadow","outputname":"","bindSwimXId":"SWIMLANEA91C6B62","bindSwimXOffsetX":0,"bindSwimXOffsetY":0,"bindSwimYId":"SWIMLANE684EB5BE","bindSwimYOffsetX":0,"bindSwimYOffsetY":0},{"id":"CONTROLF324AF1D","name":"KCP","type":"KCP","left":259,"top":53,"width":60,"height":60,"inputname":"","outputnamename":"","rename":"KCP","baseType":"node","desc":"","drag":true,"resize":true,"isOperable":true,"padding":"0 0 10px 0","img":"KCP1.png","system":[],"keyControl":[],"color":"#fff","isKeyCtrl":false,"leaders":[],"input":[],"output":[],"inputDesc":"","outputDesc":"","opertBooks":[],"messageForm":"","state":"","iconPath":"http://jiucaiyunbpm.jiucaiyun.cn/bpabpmapi/bpm/attachment/download/730708254136750080?attachmentType=bpm","toolsPath":"shadow","outputname":"","bindSwimXId":"SWIMLANEA91C6B62","bindSwimXOffsetX":0,"bindSwimXOffsetY":0,"bindSwimYId":"SWIMLANE684EB5BE","bindSwimYOffsetX":0,"bindSwimYOffsetY":0},{"id":"CONTROL2018F752","name":"","type":"processInformation","left":232,"top":305,"width":80,"height":80,"inputname":"","outputnamename":"","rename":"资料单","baseType":"node","time":"","desc":"","drag":true,"resize":true,"isOperable":true,"padding":"0","img":"processInformation.png","state":"","keyControl":[],"isKeyCtrl":false,"messagefileForm":"","messageFile":[],"iconPath":"http://jiucaiyunbpm.jiucaiyun.cn/bpabpmapi/bpm/attachment/download/730709356034936832?attachmentType=bpm","toolsPath":"shadow","outputname":"","bindSwimXId":"SWIMLANEA91C6B62","bindSwimXOffsetX":0,"bindSwimXOffsetY":0,"bindSwimYId":"SWIMLANE684EB5BE","bindSwimYOffsetX":0,"bindSwimYOffsetY":0,"system":[]},{"id":"CONTROLE96F332D","name":"","type":"processTool","left":402,"top":306,"width":60,"height":60,"inputname":"","outputnamename":"","rename":"工具","baseType":"node","time":"","desc":"","drag":true,"resize":true,"isOperable":true,"padding":"0","img":"processTool.png","state":"","keyControl":[],"isKeyCtrl":false,"messagefileForm":"","messageFile":[],"iconPath":"http://jiucaiyunbpm.jiucaiyun.cn/bpabpmapi/bpm/attachment/download/730708993017925632?attachmentType=bpm","toolsPath":"shadow","outputname":"","bindSwimXId":"SWIMLANEA91C6B62","bindSwimXOffsetX":0,"bindSwimXOffsetY":0,"bindSwimYId":"SWIMLANE684EB5BE","bindSwimYOffsetX":0,"bindSwimYOffsetY":0,"system":[]},{"id":"CONTROLD673A2EB","name":"任务","type":"processTask","left":293,"top":171,"width":132,"height":80,"inputname":"","outputnamename":"","index":"","rename":"任务","baseType":"current","desc":"","time":"","drag":true,"resize":true,"isOperable":true,"padding":"5px 0 0 0","img":"processTask.png","system":[],"processGroup":[],"keyControl":[],"keyKSFControl":[],"isKeyCtrl":false,"isKeyKSFCtrl":false,"leaders":[],"input":[],"output":[],"inputDesc":"","outputDesc":"","opertBooks":[],"role":[],"messageForm":"","messageGroup":[],"messagefileForm":"","messageFile":[],"appovalType":"Single","percentOfPass":100,"workTimeRequire":"","workResults":"","file":[],"enterpriseStandard":"","enterpriseStandardFile":[],"enterpriseStandardData":[],"isModelListBoDtos":true,"inModelListBoDtos":[],"outModelListBoDtos":[],"modelListToolsDtos":[],"approers":[],"consultants":[],"noticers":[],"state":"current","iconPath":"http://jiucaiyunbpm.jiucaiyun.cn/bpabpmapi/bpm/attachment/download/730698154751840256?attachmentType=bpm","toolsPath":"shadow","outputname":"","bindSwimXId":"SWIMLANEA91C6B62","bindSwimXOffsetX":0,"bindSwimXOffsetY":0,"bindSwimYId":"SWIMLANE684EB5BE","bindSwimYOffsetX":0,"bindSwimYOffsetY":0,"SwimlaneName":"岗位/角色","DeptName":"","StationName":""}],
                    "controls": thisbusObjControls,
                    "lines":[
                      {"id":"LINE314C7606","type":"tb","M":209.5,"from":"CONTROLFAEDAEE7","to":"CONTROLD673A2EB","name":"","priority":"","desc":"","startPos":[136,211],"endPos":[315,208],"lineType":"solid","formType":"processInput"},
                      {"id":"LINE2F693D90","type":"tb","M":210,"from":"CONTROLD673A2EB","to":"CONTROLA83C3B4E","name":"","priority":"","desc":"","startPos":[397,209],"endPos":[551,209],"lineType":"solid","formType":"processTask"},
                      {"id":"LINE0B7D2916","type":"tb","M":147,"from":"CONTROLF324AF1D","to":"CONTROLD673A2EB","name":"","priority":"","desc":"","startPos":[302,88],"endPos":[339,180],"lineType":"solid"},
                      {"id":"LINE55850CD2","type":"tb","M":147,"from":"CONTROL21D03DE6","to":"CONTROLD673A2EB","name":"","priority":"","desc":"","startPos":[446,93],"endPos":[385,174],"lineType":"solid"},
                      {"id":"LINE41955435","type":"tb","M":278,"from":"CONTROL2018F752","to":"CONTROLD673A2EB","name":"","priority":"","desc":"","startPos":[283,339],"endPos":[333,249],"lineType":"solid","formType":"processInformation"},
                      {"id":"LINE5A873EF3","type":"tb","M":277.5,"from":"CONTROLE96F332D","to":"CONTROLD673A2EB","name":"","priority":"","desc":"","startPos":[427,333],"endPos":[399,253],"lineType":"solid","formType":"processTool"}],
                    "swimlanes":[{"name":"岗位/角色","type":"swimlaneX","time":"","color":"#fff","system":"","depts":[],"input":[],"output":[],"opertBooks":[],"height":467,"width":950,"inputDesc":"","outputDesc":"","id":"SWIMLANEA91C6B62","showMember":"swimlaneX"},{"name":"阶段","type":"swimlaneY","time":"","color":"#fff","system":"","input":[],"output":[],"opertBooks":[],"height":537,"width":835,"id":"SWIMLANE684EB5BE","showMember":"swimlaneX"}],
                    "qiehuanbgimg":"bg_img_grid"
                  }
                } else {
                  busObjData = thisbusObjJson.busObjData
                }
                // sessionStorage.setItem('busObjData', JSON.stringify(busObjData)) // 这个要存接口的 现在先存session 后面再删除
                // console.log(busObjData, 'busObjData')
                let obj = {
                  id: me.copyId[0],
                  listid: me.copyId[0],
                  treeId: me.copyId[0],
                  processName: me.controls[me.copyId[0]].name.replace(/<br>/g, ''),
                  processType: 'busObj',
                  username: '',
                  processNum: '111',
                  state: '2',
                  isRead: 'no',
                  version: '1',
                  item: {
                    id: parentItem.id,
                    listid: parentItem.listid,
                    treeId: me.copyId[0],
                    processName: me.controls[me.copyId[0]].name,
                    username: '',
                    processNum: '111',
                    state: '2',
                  },
                  treeData: {}
                }
                console.log(busObjData, 'busObjDatabusObjDatabusObjData')
                obj.busObjData = busObjData
                sessionStorage.setItem('processInfo', JSON.stringify(obj))
                let tabMenus = processTabMenu.map(item => item.listid).join(',') // tabMenu
                if (tabMenus.indexOf(obj.listid) === -1) {
                  processTabMenu.push(obj)
                  sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
                } else { // 设置只能存在一个自建流程tab  更新父级的内容
                  processTabMenu.forEach(item => {
                    if (item.listid === obj.listid) {
                      item = obj
                    }
                  })
                  sessionStorage.setItem('processTabMenu', JSON.stringify(processTabMenu))
                }
                window.getProcessJson('Update')
              }
            }
          } else if (e.target.className.indexOf('relatedPost') > -1) {
            me.viewRelatedPost(me.copyId[0])
          } else if (e.target.className.indexOf('relatedEle') > -1) {
            me.viewRelatedEle(me.copyId[0])
          }
          //  else if (e.target.className.indexOf('marked') > -1) {
          // 	var keyControl = me.controls[me.copyId].keyControl;
          // 	if (keyControl === 0) {
          // 		jq(".addKeyControl").show();
          // 	} else if (keyControl === 1) {
          // 		jq.ajax({
          // 			type: 'POST',
          // 			url: me.baseUrl + '/modellist/deleteCorekey',
          // 			dataType: 'json',
          // 			contentType: "application/json;",
          // 			data: JSON.stringify({
          // 				keyid: me.copyId,
          // 				listid: listid
          // 			}),
          // 			success: function (res) {
          // 				me.controls[me.copyId].keyControl = 0;
          // 				me.alertBox('取消成功！','success');
          // 				jq("#key"+me.copyId).hide();
          // 			},
          // 			error: function () {
          // 				me.alertBox('取消失败！', 'danger');
          // 			}
          // 		})
          // 	}
          // }
        }
      });

      jq(".addKeyControl #cancelKeyCtrl").on('click', function () {
        jq(this).parents(".addKeyControl").hide();
      });

      jq(".ico_close").on("click", function () {
        jq(this).parents(".addKeyControl").hide();
      })
    },

    // 弹框
    alertBox: function (msg, type, callback) {
      var msg = msg || '';
      var type = type || 'danger';
      var me = this;
      jq(".applert").text(msg);
      jq(".applert").addClass('alert-' + type + ' in');
      clearTimeout(me.timeout);
      me.timeout = setTimeout(function () {
        jq(".applert").removeClass('alert-' + type + ' in')
        if (callback) {
          callback();
        }
      }, 2000);
    },
    // 确认框
    confirmBox: function (msg, success, cancel) {
      jq(".modalDialogConfirm").show()
      jq(".modalDialogConfirm .dialog_wrapper").text(msg)
      jq(".modalDialogConfirm .confirmProcess").off("click").on("click", function () {
        if (!!success) {
          success()
        }
        jq(".modalDialogConfirm").hide()
      })
      jq(".modalDialogConfirm .cancelChoose").off("click").on("click", function () {
        if (!!cancel) {
          cancel()
        }
        jq(".modalDialogConfirm").hide()
      })
    },
    /**
     * 切换面板   展示节点属性
     */
    _switchPlan: function (id, attrList) {
      var me = this;
      // //console.log(attrList)
      // //console.log(attrList.index)
      if (!attrList) return;
      var $attrContentBox1 = me.$attrContentBox.children().eq(1);
      // if (attrList.type === 'role') {
      //   alert(1)
      //   return false;
      // }
      if(me.controls[id].type === 'role') {
        return false;
      }
      if (attrList.type === 'spliceGroup' || attrList.type === 'AND' || attrList.type === 'OR' || attrList.type === 'P' || attrList.type === 'XOR' || attrList.name === '上游流程' || attrList.name === '下游流程') {
        me.$attrContentBox.children().eq(1).html('<h4>' + jq.i18n.prop("activityDes") + ' <i class="closeRightMoal"></i></h4><div class="noJiedian">' + jq.i18n.prop("viewPropertiesNode") + ' </div>');
        return false;
      }

      if (attrList.processGroup && attrList.processGroup[0]) {
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: basFlow.baseUrl + '/modellist/getByModelid/' + attrList.processGroup[0].id + '?username=' + basFlow.username,
          data: {},
          async: false,
          success: function (res) {
            //console.log(res)
            basFlow.storeUpgressData = res
          },
          error: function (err) {
            //console.log(err)
          }
        })
      }

      // 选择已发布流程选中
      var processlist = [];
      if (attrList && (attrList.splitType == "upProcess")) {
        if (!me.storeUpgressData.bpmDto) {
          processlist = []
        } else {
          processlist = me.storeUpgressData.bpmDto.outputlist ? me.storeUpgressData.bpmDto.outputlist : [];
          if (me.storeUpgressData.bpmDto.outputlist) {
            for (var i = 0; i < me.storeUpgressData.bpmDto.outputlist.length; i++) {
              for (var j = 0; j < attrList.output.length; j++) {
                if (me.storeUpgressData.bpmDto.outputlist[i].attatchid == attrList.output[j].attatchid) {
                  me.storeUpgressData.bpmDto.outputlist[i].isChecked = true;
                }
              }
            }
          }
        }
      }
      // 改变序号和名称的顺序
      if (!!attrList.index || attrList.index === "") {
        attrList = JSON.parse(JSON.stringify(attrList))
        var tempIndex = attrList.index;
        delete attrList.index;
        var arr = [];
        for (var i in attrList) {
          arr.push([attrList[i], i]);
        };
        arr.unshift([tempIndex, "index"]);
        //console.log(arr)
        var obj = {};
        for (var i = 0; i < arr.length; i++) {
          obj[arr[i][1]] = arr[i][0];
        }
        attrList = obj;
        //console.log(attrList)
        // jq(".pproval-time-td").html(attrList.time==''?"0":attrList.time+'天')
        // jq(".approval-time-tr").html('审核时间')

      }
      me.isReadAttr = 'true'
      $attrContentBox1.html(me.attrTempl({
        attrList: attrList,
        listProcess: attrList.processGroup ? (attrList.processGroup.length > 0 ? processlist : []) : [],
        messageFileType: me.messageFileType || []
      }));

      $attrContentBox1.off('keyup', 'input[type="number"],input[type="text"],textarea').on('keyup', 'input[type="number"],input[type="text"],textarea', function () {
        var $this = jq(this);
        $this.attr("title", $this[0].value)
      })
      $attrContentBox1.off('blur', 'input[type="number"],input[type="text"],textarea').on('blur', 'input[type="number"],input[type="text"],textarea', function () {
        var $this = jq(this),
          dataType = $this.attr('data-type');
        dataIndex = $this.attr('data-index') || '';
        dataName = $this.attr('data-name') || '';
        // console.log($this, dataType, dataIndex, dataName, jq.trim($this.val()), attrList, me.controls[me.curId[0]], 7777)
        if (dataType === 'index') {
          me.$workArea.find('#' + me.curId[0]).find('.index').text(jq.trim($this.val()));
        } else if (dataType == 'name') {
          me.$workArea.find('#' + me.curId[0]).find('.J_editAttr').text(jq.trim($this.val()));
        } else if (dataType == 'KSFList') {
          attrList.keyKSFControl = me.controls[me.curId[0]].keyKSFControl
          attrList.keyKSFControl[dataIndex][dataName] = jq.trim($this.val())
        }
        for (var i in attrList) {
          if (dataType == 'input' || dataType == 'output' || dataType == 'leaders') {
            continue;
          }
          if (dataType === i) {
            //console.log(i)
            // if (i !== 'inModelListBoDtos' && i !== 'outModelListBoDtos') { // 业务对象 输入 输出
            attrList[i] = jq.trim($this.val());
            // }
            if (i == "inputDesc") {
              attrList.inputDesc = attrList.inputDesc ? attrList.inputDesc : (attrList.input[0] ? attrList.input[0].newName : '')
            }
            if (i == "outputDesc") {
              attrList.outputDesc = attrList.outputDesc ? attrList.outputDesc : (attrList.output[0] ? attrList.output[0].newName : '')
            }
            if (i == "workResults") {
              attrList.workResults = attrList.workResults ? attrList.workResults : (attrList.file[0] ? attrList.file[0].newName : '')
            }
          } else {
            if (/SWIMLANE/.test(id)) {
              attrList[i] = me.swimlanes[id][i];
            } else if (/CONTROL/.test(id)) {
              if (i === 'inModelListBoDtos' || i === 'outModelListBoDtos') {// 业务对象 输入 输出
                let modelType = dataType === 'in' ? 'inModelListBoDtos' : 'outModelListBoDtos'
                //console.log(me.controls[id][modelType][Number(dataIndex)])
                if (me.controls[id][modelType][Number(dataIndex)]) {
                  me.controls[id][modelType][Number(dataIndex)].docname = jq.trim($this.val())
                }
                if (dataIndex === '0' && dataType === 'in') {
                  //console.log(dataIndex)
                  attrList.inputDesc = jq.trim($this.val())
                }
                if (dataIndex === '0' && dataType === 'out') {
                  //console.log(dataIndex)
                  attrList.outputDesc = jq.trim($this.val())
                }
              }
              attrList[i] = me.controls[id][i];
            } else if (/LINE/.test(id)) {
              attrList[i] = me.lines[id][i];
            }
          }
        }
        //console.log(me.lines[id])
        // //console.log(attrList)
        // return false
        if (/SWIMLANE/.test(id)) {
          if (!parseInt(attrList.time)) attrList.time = '0';
          jq.extend(me.swimlanes[id], attrList)
          jq('#' + id).find('.swimlane-title span').text(attrList.name);

          jq('#' + id).find('.timeLine').text(parseInt(attrList.time) + jq.i18n.prop("day"));
          me.changeScaleLine(true);
        }
        else if (/CONTROL/.test(id)) {
          if (attrList.outputDesc === '') {
            attrList.outputDesc = attrList.output.length > 0 ? attrList.output[0].newName : '';
          }
          if (attrList.inputDesc === '') {
            attrList.inputDesc = attrList.input.length > 0 ? attrList.input[0].newName : '';
          }
          jq.extend(me.controls[id], attrList)
          var doTData = doT.template(jq('#img_templ').text())

          if (me.controls[id].type === 'processForm') {
            me.controls[id].name = $this.val()
            jq("#" + basFlow.curId[0] + " .text span").text($this.val())
          }
          if (me.controls[id].img.indexOf('process.png') > -1 || me.controls[id].img.indexOf('process02.png') > -1 || me.controls[id].img.indexOf('process03.png') > -1) {
            if (me.controls[id].processGroup[0]) {
              me.controls[id].name = me.controls[id].processGroup[0].name
              jq("#" + basFlow.curId[0] + " .text span").text(me.controls[id].processGroup[0].name)
            }
            // if(me.controls[id].splitType == 'upProcess'){

            var inputList = me.controls[id];
            if (!inputList.outputDesc) {
              inputList.outputDesc = inputList.output.length > 0 ? inputList.output[0].newName : (inputList.outputDes ? inputList.outputDes : '');
            }
            if (!inputList.inputDesc) {
              inputList.inputDesc = inputList.input.length > 0 ? inputList.input[0].newName : (inputList.inputDesc ? inputList.inputDesc : '');
            }
            if (jq("#" + basFlow.curId[0] + " .text .outputCss").length > 0) {
              jq("#" + basFlow.curId[0] + " .text .outputCss").remove()
            }
            if (!jq("#" + basFlow.curId[0] + " .text .outputCss").length) {
              var desc = ((inputList.output.length > 1 ? basFlow.controls[basFlow.curId[0]].outputDesc.substring(0, 10) + '...' : (basFlow.controls[basFlow.curId[0]].outputDesc.length > 10 ? basFlow.controls[basFlow.curId[0]].outputDesc.substring(0, 10) + '...' : basFlow.controls[basFlow.curId[0]].outputDesc.substring(0, 10))));
              jq("#" + basFlow.curId[0] + " .text").append('<div class="inputImgCss outputCss">' + desc + '<img src="' + basFlow.options.toolsPath + '/processOutput.png" /></div>');
            }
            // }
          }
          jq("#" + id).remove()
          me.addControl(me.controls[id], true)
          var currentClass = "";
          var currentIndex = 0;
          for (var i = 0; i < jq("#pointAttr li").length; i++) {
            if (jq("#pointAttr li").eq(i).attr("class").indexOf("active") > -1) {
              currentClass = jq("#pointAttr li").eq(i).attr("data-class");
              currentIndex = i;
              break;
            }
          }
          if (currentClass != 'addKeyControl' && currentClass != 'addKeyKSFControl') {
            //console.log(me)
            me.focusItem2(me.curId[0], "single");
            jq("#pointAttr li").eq(currentIndex).addClass("active").siblings().removeClass("active")
            jq("." + currentClass).show().siblings().hide()
            if (currentClass == "table") {
              jq("." + currentClass).find(".table").show();
            }
            if (dataType === 'in') { // 业务对象 输入 输出
              for (var j = 0; j < jq("#pointAttr li").length; j++) {
                jq("#modelListAttr li").eq(j).siblings().removeClass("active");
                jq(".modelListAttr_wrap").children().siblings().css("display", "none");
              }
              jq("#modelListAttr li").eq(0).addClass("active");
              jq(".modelListAttr_wrap").children().eq(0).css("display", "block");
            } else {
              for (var j = 0; j < jq("#pointAttr li").length; j++) {
                jq("#modelListAttr li").eq(j).siblings().removeClass("active");
                jq(".modelListAttr_wrap").children().siblings().css("display", "none");
              }
              jq("#modelListAttr li").eq(1).addClass("active");
              jq(".modelListAttr_wrap").children().eq(1).css("display", "block");
            }
          }
          // 计算审批时间
          if (dataType == "time") {
            me.computedApproveTime(me)
          }
        }
        else if (/LINE/.test(id)) {
          var name = attrList.name
          me.lines[id].name = ''
          //console.log(name)
          me.setName(id, name, "line");
          jq.extend(me.lines[id], attrList)
        }
      })
      // function end
      // $attrContentBox1.off('change', 'select').on('change', 'select', function () {
      //   var $this = jq(this),
      //     dataType = $this.attr('data-type');

      //   for (var i in attrList) {
      //     if (dataType === i) {
      //       attrList[i] = jq.trim($this.val())
      //     }
      //   }
      //   if (/CONTROL/.test(id)) {
      //     jq.extend(me.controls[id], attrList)
      //     var doTData = doT.template(jq('#img_templ').text())

      //     jq("#" + id).remove()
      //     me.addControl(me.controls[id], true)
      //     var currentClass = "";
      //     var currentIndex = 0;
      //     for (var i = 0; i < jq("#pointAttr li").length; i++) {
      //       if (jq("#pointAttr li").eq(i).attr("class").indexOf("active") > -1) {
      //         currentClass = jq("#pointAttr li").eq(i).attr("data-class");
      //         currentIndex = i;
      //         break;
      //       }
      //     }
      //     if (currentClass != 'addKeyControl' && currentClass != 'addKeyKSFControl') {
      //       me.focusItem(me.curId[0], "single");
      //       jq("#pointAttr li").eq(currentIndex).addClass("active").siblings().removeClass("active")
      //       jq("." + currentClass).show().siblings().hide()
      //       if (currentClass == "table") {
      //         jq("." + currentClass).find(".table").show();
      //       }
      //     }
      //   }
      // })



      $attrContentBox1.on('click', '#pointAttr li', function () {
        var dataClass = jq(this).attr("data-class");
        jq(this).addClass("active").siblings().removeClass('active');
        jq('.' + dataClass).siblings().hide();
        for (var i = 0; i < jq('.' + dataClass).length; i++) {
          jq('.' + dataClass).eq(i).show()
        }
      })
      // 业务对象
      $attrContentBox1.on('click', '#modelListAttr li', function () {
        var dataClass = jq(this).attr("data-class");
        jq(this).addClass("active").siblings().removeClass('active');
        jq('.' + dataClass).siblings().hide();
        for (var i = 0; i < jq('.' + dataClass).length; i++) {
          jq('.' + dataClass).eq(i).show()
        }
      })

      // 提交关键风险控制点
      $attrContentBox1.off('click', '.addKeyControl #submitKeyCtrl').on('click', '.addKeyControl #submitKeyCtrl', function () {
        // var keyCtrlList = jq("#keyControlForm").serializeArray();
        var keyCtrlList = JSON.parse(JSON.stringify(me.controls[me.curId[0]].keyControl));
        // var data = {
        //     listid: me.id,
        //     keyid: id
        // };
        for (var i = 0; i < keyCtrlList.length; i++) {
          keyCtrlList[i].listid = me.id
          keyCtrlList[i].keyid = id
        }
        //console.log(keyCtrlList)
        // data.documentlist = me.controls[me.curId[0]].keyControl.documentlist;
        // if (keyCtrlList.length > 0) {
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/modellist/saveCorekeyList?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(keyCtrlList),
          success: function (res) {
            if (res) {
              me.alertBox(jq.i18n.prop("addSuccess") + "! ", 'success');
              jq("#key" + id).show();
              me.controls[id].keyControl = keyCtrlList;
              if (keyCtrlList.length > 0) {
                me.controls[id].isKeyCtrl = true;
              } else {
                me.controls[id].isKeyCtrl = false;
              }
              jq("#" + id).remove()
              me.addControl(me.controls[id], true)
              jq('#' + id).addClass('cur')
              jq(".content_wrapper").find('.content_item').eq(1).hide();
              me.$attrBox.find('span.active').removeClass('active');
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })
        // } else {
        // me.alertBox(jq.i18n.prop("needKcpname") + "! ", 'danger');
        // }

      });

      // 关键风险控制点显示hide
      $attrContentBox1.on('change', '.addKeyControl input[name=\'remark\']', function () {
        var keyCtrlList = jq("#keyControlForm").serializeArray();
        var data = {
          listid: me.id,
          keyid: id
        };
        for (var i = 0; i < keyCtrlList.length; i++) {
          data[keyCtrlList[i].name] = keyCtrlList[i].value;
        }
        data.documentlist = me.controls[me.curId[0]].keyControl.documentlist;

        var id = me.curId[0]
        //console.log(me.controls[id])

        //console.log(me.controls[me.curId[0]].keyControl.documentlist, keyCtrlList, jq("input[name='remark']").val())
        if (jq("input[name='remark']").val() != '') {
          // jq("input[name='remark']").attr("disabled","disabled")
          jq("#selectRegulations").attr("disabled", "disabled")
          if (me.controls[me.curId[0]].keyControl.documentlist && me.controls[me.curId[0]].keyControl.documentlist.length > 0) {
            me.controls[me.curId[0]].keyControl.documentlist = []
            jq(".uploadregutions .commonFileName").css('display', 'none')
          }
        } else {
          jq(".uploadregutions").show()
        }
      })
      // 提交关键成功要素
      $attrContentBox1.off('click', '.addKeyKSFControl #submitKeyKSFCtrl').on('click', '.addKeyKSFControl #submitKeyKSFCtrl', function (e) {
        // var keyCtrlList = jq("#keyKSFControlForm").serializeArray();
        var keyCtrlList = JSON.parse(JSON.stringify(me.controls[me.curId[0]].keyKSFControl));
        // var data = {
        //     listid: me.id,
        //     keyid: id
        // };
        console.log(me.id)
        for (var i = 0; i < keyCtrlList.length; i++) {
          keyCtrlList[i].listid = me.id
          keyCtrlList[i].keyid = id
        }
        // if (keyCtrlList.length > 0) {
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/succelement/saveSuccelementList?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(keyCtrlList),
          success: function (res) {
            if (res) {
              me.alertBox(jq.i18n.prop("addSuccess") + "! ", 'success');
              jq("#key" + id).show();
              me.controls[id].keyKSFControl = keyCtrlList;
              if (keyCtrlList.length > 0) {
                me.controls[id].isKeyKSFCtrl = true;
              } else {
                me.controls[id].isKeyKSFCtrl = false;
              }
              jq("#" + id).remove()
              me.addControl(me.controls[id], true)
              jq('#' + id).addClass('cur')
              jq(".content_wrapper").find('.content_item').eq(1).hide();
              me.$attrBox.find('span.active').removeClass('active');
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })
        // } else {
        // me.alertBox(jq.i18n.prop("needKsfname") + "! ", 'danger');
        // }
      });

      // 提交业务对象 输入
      $attrContentBox1.off('click', '.isModelListBoDtos #submitInModel').on('click', '.isModelListBoDtos #submitInModel', function (e) {
        // var inModelList = jq("#inModelListBoDtos").serializeArray();
        var data = {}
        var inModelList = JSON.parse(JSON.stringify(basFlow.controls[basFlow.curId[0]].inModelListBoDtos))
        //console.log(me.id, id, inModelList, basFlow.curId[0], basFlow.controls[basFlow.curId[0]].inModelListBoDtos)
        // if (inModelList && inModelList.length > 0) {
        //     var boids = inModelList.map(function (item, index) {
        //         return item.bonameId
        //     }).join(',');
        //     var bonames = inModelList.map(function (item, index) {
        //         return item.boname
        //     }).join(',');
        //     data = {
        //         inout: 'in',
        //         listid: me.id,
        //         keyid: id,
        //         modelListBoDtos: {
        //             boDtoList: inModelList,
        //             boids: boids,
        //             bonames: bonames,
        //             docid: inModelList[0].id,
        //             docname: inModelList[0].docname,
        //             inout: 'in',
        //             keyid: id,
        //             listid: me.id
        //         }
        //     };
        // }
        if (inModelList && inModelList.length > 0) {
          // var boids = inModelList.map(function (item, index) {
          //     return item.bonameId
          // }).join(',');
          // var bonames = inModelList.map(function (item, index) {
          //     return item.boname
          // }).join(',');
          for (var i = 0; i < inModelList.length; i++) {
            if (!inModelList[i].docname) {
              me.alertBox("请选择第" + Number(i + 1) + "行的文档名称! ", 'danger');
              return
            }
            if (!inModelList[i].boDtoList || inModelList[i].boDtoList.length === 0) {
              me.alertBox("请选择第" + Number(i + 1) + "行的业务对象名称! ", 'danger');
              return
            }
            inModelList[i]['boids'] = inModelList[i].bonameId;
            inModelList[i]['bonames'] = inModelList[i].boname;
            // inModelList[i]['docid'] = inModelList[i].docid || '';
            // inModelList[i]['docname'] = inModelList[i].docname;
            inModelList[i]['inout'] = 'in';
            inModelList[i]['keyid'] = id;
            inModelList[i]['listid'] = me.id;
            if (!!inModelList[i].bolist) {
              delete inModelList[i].bolist
            }
          }
        }
        // data = {
        //     inout: 'in',
        //     listid: me.id,
        //     keyid: id,
        //     modelListBoDtos: inModelList
        // };
        data = inModelList;
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/modellistbo/saveBo/' + me.id + '/' + id + '/in?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(data),
          success: function (res) {
            if (res) {
              me.alertBox(jq.i18n.prop("addSuccess") + "! ", 'success');
              // jq("#key" + id).show();
              me.controls[id].inModelListBoDtos = res.data;
              jq("#" + id).remove()
              me.addControl(me.controls[id], true)
              // me.onBtnSaveClick(null, null, 'ico_temporalit');
              // jq(".content_wrapper").find('.content_item').eq(1).hide();
              // me.$attrBox.find('i.active').removeClass('active');
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })
      });

      // 提交业务对象 输出
      $attrContentBox1.off('click', '.isModelListBoDtos #submitOutModel').on('click', '.isModelListBoDtos #submitOutModel', function (e) {
        // var inModelList = jq("#outModelListBoDtos").serializeArray();
        var data = {}
        var outModelList = JSON.parse(JSON.stringify(basFlow.controls[basFlow.curId[0]].outModelListBoDtos))
        //console.log(me.id, id, outModelList, basFlow.controls[basFlow.curId[0]].outModelListBoDtos)
        if (outModelList && outModelList.length > 0) {
          // var boids = outModelList.map(function (item, index) {
          //     return item.bonameId
          // }).join(',');
          // var bonames = outModelList.map(function (item, index) {
          //     return item.boname
          // }).join(',');
          for (var i = 0; i < outModelList.length; i++) {
            if (!outModelList[i].docname) {
              me.alertBox("请选择第" + Number(i + 1) + "行的文档名称! ", 'danger');
              return
            }
            if (!outModelList[i].boDtoList || outModelList[i].boDtoList.length === 0) {
              me.alertBox("请选择第" + Number(i + 1) + "行的业务对象名称! ", 'danger');
              return
            }
            outModelList[i]['boids'] = outModelList[i].bonameId;
            outModelList[i]['bonames'] = outModelList[i].boname;
            // outModelList[i]['docid'] = !outModelList[i].id ? (outModelList[i].id) : outModelList[i].docid;
            // outModelList[i]['docname'] = outModelList[i].docname;
            outModelList[i]['inout'] = 'out';
            outModelList[i]['keyid'] = id;
            outModelList[i]['listid'] = me.id;
            if (!!outModelList[i].bolist) {
              delete outModelList[i].bolist
            }
          }
        }
        // data = {
        //     inout: 'in',
        //     listid: me.id,
        //     keyid: id,
        //     modelListBoDtos: outModelList
        // };
        data = outModelList;
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/modellistbo/saveBo/' + me.id + '/' + id + '/out?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(data),
          success: function (res) {
            if (res) {
              me.alertBox(jq.i18n.prop("addSuccess") + "! ", 'success');
              me.controls[id].outModelListBoDtos = res.data;
              jq("#" + id).remove()
              me.addControl(me.controls[id], true)
              // me.onBtnSaveClick(null, null, 'ico_temporalit');
              // jq(".content_wrapper").find('.content_item').eq(1).hide();
              // me.$attrBox.find('i.active').removeClass('active');
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })
      });

      // 提交业工具
      $attrContentBox1.off('click', '.modelListToolsDtos #submitTool').on('click', '.modelListToolsDtos #submitTool', function (e) {
        // var inModelList = jq("#outModelListBoDtos").serializeArray();
        var data = []
        var toolList = JSON.parse(JSON.stringify(basFlow.controls[basFlow.curId[0]].modelListToolsDtos))
        //console.log(me.id, id, toolList, basFlow.controls[basFlow.curId[0]].modelListToolsDtos)
        if (toolList && toolList.length > 0) {
          for (var i = 0; i < toolList.length; i++) {
            toolList[i].toolid = toolList[i].id;
            toolList[i].keyid = id;
            toolList[i].listid = me.id;
          }
          // data = {
          //     listid: me.id,
          //     keyid: id,
          //     modelListToolsDtos: toolList
          // };
          data = toolList;
        }
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/modellisttools/saveTools/' + me.id + '/' + id + '?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(data),
          success: function (res) {
            if (res) {
              me.alertBox(jq.i18n.prop("addSuccess") + "! ", 'success');
              console.log(data, `#toolsList${basFlow.curId[0]}`);
              var evalText = doT.template(jq("#toolsListTmpl").text());
              console.log('evalText(data)', evalText(data))
              jq(`#toolsList${basFlow.curId[0]}`).html(evalText(data));

              // jq("#key" + id).show();
              // me.controls[id].inModelListBoDtos = inModelList;
              // jq("#" + id).remove()
              // me.addControl(me.controls[id], true)
              // jq(".content_wrapper").find('.content_item').eq(1).hide();
              // me.$attrBox.find('i.active').removeClass('active');
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })
      });


      // 引用流程点击跳转
      $attrContentBox1.off('click', '.aboutProcess span.commonFileName.processDel span').on('click', '.aboutProcess span.commonFileName.processDel span', function () {
        // jq("span.commonFileName.processDel").on("click", function () {
        var keyCtrlList = jq(".aboutProcess").serializeArray();
        var data = {
          listid: me.id,
          keyid: id
        };
        for (var i = 0; i < keyCtrlList.length; i++) {
          data[keyCtrlList[i].name] = keyCtrlList[i].value;
        }
        //console.log(me.controls[me.curId[0]], me.controls[me.curId[0]].processGroup[0].id)
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/modellist/QueryListIdAndBpmId/' + me.controls[me.curId[0]].processGroup[0].id + '?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(data),
          success: function (res) {
            if (res.data.length > 0) {
              window.open(basFlow.htmlUrl + '/leftMenu/BaseNewPage.html?id=' + res.data[0].BPMID + '&listid=' + res.data[0].LISTID + '&userid=' + me.username + '&treeId=' + res.data[0].MODELID + '&isReadAttr=true')
            } else {
              me.alertBox("流程未发布! ", 'danger');
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })
      })

      // 重置关键风险控制点
      $attrContentBox1.off('click', '.addKeyControl #restBtn').on('click', '.addKeyControl #restBtn', function () {
        var keyCtrlList = jq("#keyControlForm").serializeArray();
        var keyArr = []
        var id = me.curId[0]
        if (!me.curId[0]) {
          me.alertBox(jq.i18n.prop("firstChooseNode") + "! ", 'danger');
          return false;
        }

        for (var i = 0; i < keyCtrlList.length; i++) {
          if (keyCtrlList[i].name == 'testfrequency') {
            keyArr.push({
              "name": keyCtrlList[i].name,
              "value": "月度"
            })
          } else {
            keyArr.push({
              "name": keyCtrlList[i].name,
              "value": ""
            })
          }
        }
        var keyCtrlList = jq("#keyControlForm").serializeArray();
        var data = {
          listid: me.id,
          keyid: id
        };
        for (var i = 0; i < keyCtrlList.length; i++) {
          data[keyArr[i].name] = keyArr[i].value;
        }

        me.controls[id].keyControl = data
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/modellist/deleteByListidAndKeyid?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(data),
          success: function (res) {
            if (res) {
              me.alertBox(jq.i18n.prop("resetSuccess") + "! ", 'success');
              jq("#key" + id).show();
              me.controls[id].keyControl = data;
              if (data.kcpname) {
                me.controls[id].isKeyCtrl = true;
              } else {
                me.controls[id].isKeyCtrl = false;
              }
              jq(".form-control").val("")
              var doTData = doT.template(jq('#attr_templ').text())
              jq(".content_wrapper .content_item").eq(2).html(doTData({
                attrList: me.controls[id]
              }))
              jq("#" + id).remove()
              me.addControl(me.controls[id], true)
              me.focusItem(me.curId[0], "single");
              jq("#pointAttr li").eq(2).addClass("active").siblings().removeClass("active")
              jq(".addKeyKSFControl").show().siblings().hide()
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })

      });

      // 重置关键成功要素
      $attrContentBox1.off('click', '.addKeyKSFControl #restKSFBtn').on('click', '.addKeyKSFControl #restKSFBtn', function () {
        var keyCtrlList = jq("#keyKSFControlForm").serializeArray();
        var keyArr = []
        var id = me.curId[0]
        if (!me.curId[0]) {
          me.alertBox(jq.i18n.prop("firstChooseNode") + "! ", 'danger');
          return false;
        }

        for (var i = 0; i < keyCtrlList.length; i++) {
          if (keyCtrlList[i].name == 'testfrequency') {
            keyArr.push({
              "name": keyCtrlList[i].name,
              "value": "月度"
            })
          } else {
            keyArr.push({
              "name": keyCtrlList[i].name,
              "value": ""
            })
          }
        }
        var keyCtrlList = jq("#keyKSFControlForm").serializeArray();
        var data = {
          listid: me.id,
          keyid: id
        };
        for (var i = 0; i < keyCtrlList.length; i++) {
          data[keyArr[i].name] = keyArr[i].value;
        }
        me.controls[id].keyKSFControl = data
        jQuery.support.cors = true;
        jq.ajax({
          type: 'POST',
          url: me.baseUrl + '/succelement/deleteByListidAndKeyid?username=' + me.username,
          dataType: 'json',
          contentType: "application/json;",
          data: JSON.stringify(data),
          success: function (res) {
            if (res) {
              me.alertBox(jq.i18n.prop("resetSuccess") + "! ", 'success');
              jq("#key" + id).show();
              me.controls[id].keyKSFControl = data;
              if (data.kcpname) {
                me.controls[id].isKeyKSFCtrl = true;
              } else {
                me.controls[id].isKeyKSFCtrl = false;
              }
              jq(".form-control").val("")
              var doTData = doT.template(jq('#attr_templ').text())

              jq("#" + id).remove()
              me.addControl(me.controls[id], true)
              me.focusItem(me.curId[0], "single");
              jq("#pointAttr li").eq(2).addClass("active").siblings().removeClass("active")
              jq(".addKeyKSFControl").show().siblings().hide()
            }
          },
          error: function () {
            me.alertBox(jq.i18n.prop("addFail") + "! ", 'danger');
          }
        })

      });


      $attrContentBox1.on('click', '.addKeyControl #cancelKeyCtrl', function () {
        jq(this).parents(".content_item").hide();
      });

      jq(".ico_close").on("click", function () {
        jq(this).parents(".addKeyControl").hide();
      })
    },

    /**
     * 切换工作状态
     */
    _initSwitchTools: function () {
      var me = this,
        id = GooFlow.getUID('GROUP');
      var templ = '';
      if (me.toolsGroup[0].controls.indexOf('dash') > -1) {
        templ += '<li><div data-switchtype="2" class="tools pointer J_dotted_line"><p>' + jq.i18n.prop("dashed") + '</p></div></li>';
      }
      if (me.toolsGroup[0].controls.indexOf('solid') > -1) {
        templ += '<li><div data-switchtype="2" class="tools pointer J_switch J_line" title="' + jq.i18n.prop("connectLine") + '"><p>' + jq.i18n.prop("connectLine") + '</p></div></li>';
      }
      // me.$toolsBox.append(templ);
      return jq(templ);
    },

    /**
     * 初始化右侧工作区间
     */
    _initWorkArea: function (type) {
      var me = this;
      var id = window.location.search.split('=')[1];
      var templ = '';
      templ = '<div class="GooFlow_work" id="GooFlow_work"><div class="GooFlow_workArea J_workArea" onmousedown="down(event)" onmouseup="moveUp(event)" onmousemove="move(event)" style="left: 260px;"></div></div>';
      me.$work = jq(templ);

      // tab
      if (window.isEditAttr === false || (!me.isReadAttr && getCookie('storeChangeState') !== 'publish')) {
        let tabMenu = processTabMenu.tab;
        me.$container.append(jq(tabMenu));
        processTabMenu.renderProcessTabMenu('#processTabMenu');
      }

      me.$workArea = me.$container.append(me.$work).find('.J_workArea');
      // 初始化泳道
      me._initSwimlane(type);
      me._initDraw();
      me.$textArea = jq("<textarea style='display:none;'></textarea>");
      me.$textArea.on('mousedown', function (e) {
        e.stopPropagation();
      });
      me.$work.append(me.$textArea);
      me.$textArea.off("blur").on('blur', function (e) {
        var dom = me.$textArea.data('dom'),
          attrName = me.$textArea.data('attrName'),
          attrTime = me.$textArea.data('attrTime'),
          type = me.$textArea.data('type');
        if (!dom) return;
        // console.log(dom.innerHTML,type,this.value, 2222222)
        if (attrName == 'outputTxt') {
          me.$textArea.removeData(['dom', 'attrName', 'type']).hide();
          me.controls[jq(dom).parents(".control").attr("id")].outputDesc = this.value
          dom.innerHTML = this.value ? (this.value.length > 10 ? (this.value.substring(0, 10) + '...') : this.value) : "输出";
          return;
        } else if (attrName == 'inputTxt') {
          me.$textArea.removeData(['dom', 'attrName', 'type']).hide();
          me.controls[jq(dom).parents(".control").attr("id")].inputDesc = this.value
          dom.innerHTML = this.value ? (this.value.length > 10 ? (this.value.substring(0, 10) + '...') : this.value) : "输入";
          return;
        } else if (attrName == 'name') {
          console.log('this.value', this.value)
          if (me.controls[jq(dom).parents(".control").attr("id")].type === 'interface') {
            if (this.value.length > 10) {
              me.$workArea.find('#' + me.curId[0]).find('.J_editAttr').addClass('attrLineClamp')
              me.$workArea.find('#' + me.curId[0]).find('.J_editAttr').removeClass('alignCenter')
            } else {
              me.$workArea.find('#' + me.curId[0]).find('.J_editAttr').addClass('alignCenter')
              me.$workArea.find('#' + me.curId[0]).find('.J_editAttr').removeClass('attrLineClamp')
            }
          }
        }

        me.curId[0] = jq(dom).parents(".control").attr("id") || jq(dom).parents(".swimlaneX").attr("id") || jq(dom).parents(".swimlaneY").attr("id");

        me.setAttr(me.curId[0], attrName, this.value, type);

        me.setAttr(me.curId[0], attrTime, this.value, type);

        if (me.curId[0]) {
          if (me.curId[0].indexOf("SWIMLANE") > -1) {
            var temStore = me.swimlanes[me.curId[0]]
            var swimlaneTempl = temStore.showMember === temStore.type ? doT.template(jq('#swimlaneChoose-headcontent').text()) : doT.template(jq('#swimlane-headcontent').text());
            console.log(swimlaneTempl, swimlaneTempl(temStore))
            // jq("#" + me.curId[0]).find(".swimlane-title").children().remove();
            // jq("#" + me.curId[0] + " .swimlane-title").html(swimlaneTempl(temStore))
            jq("#" + me.curId[0]).find(".swimlane-title .showMemberTitle").remove();
            jq("#" + me.curId[0]).find(".swimlane-title  span:nth-of-type(1)").remove();
            // jq("#" + me.curId[0]).find(".swimlane-title .showMember").remove();
            // jq("#" + me.curId[0]).find(".swimlane-title p").remove();
            jq("#" + me.curId[0] + " .swimlane-title").append(swimlaneTempl(temStore))
            me.swimlanes[me.curId[0]].name = me.swimlanes[me.curId[0]].name.replace(/[^a-za-z0-9\u4E00-\u9FA5.@]/g,'')
            jq("#" + me.curId[0]).find(".swimlane-title  span:nth-of-type(1)").text(this.value.replace(/[^a-za-z0-9\u4E00-\u9FA5.@]/g,''))
            if (jq(dom).parents("." + temStore.showMember).length > 0 && temStore.showMember === "swimlaneX") {
              jq("#" + me.curId[0] + ".showMemberTitle").css({
                "height": (me.swimlanes[me.curId[0]].height - 20),
                "transform": 'scale(' + me.scaleTo + ') translate(-50%, -50%)',
                "-ms-transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)"
              })
            }
            else if (jq(dom).parents("." + temStore.showMember).length > 0 && temStore.showMember === "swimlaneY") {
              jq("#" + me.curId[0] + ".showMemberTitle").css({
                "width": (me.swimlanes[me.curId[0]].width - 20),
                "transform": 'scale(' + me.scaleTo + ') translate(-50%, -50%)',
                "-ms-transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)"
              })
            }
            else {
              jq("#" + me.curId[0] + ".swimlane-title span").css({
                "transform": 'scale(' + me.scaleTo + ') translate(-50%, -50%)',
                "-ms-transform": "scale(" + me.scaleTo + ") translate(-50%, -50%)"
              })
            }
          } else {
            //   dom.innerHTML = this.value;
            // 添加换行符
            var domValue = this.value.replace(/<br>/g, '').replace(/\n/g, "\n<br>")
            dom.innerHTML = domValue;

          }

        }

        me.$textArea.removeData(['dom', 'attrName', 'type']).hide();
      });

      // 双击编辑序列事件
      me.$workArea.on("dblclick", ".index", function (e) {
        if (!me.isEdit || window.isEditAttr === false) return false;
        var attrId = jq(this).parents('.control').attr("id")
        //console.log(attrId)
        if (attrId && !me.controls[attrId].isOperable) {
          me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
          return
        }
        if (
          me.controls[attrId].type === "processForm" ||
          me.controls[attrId].type === "process" ||
          me.controls[attrId].type === "process02" ||
          me.controls[attrId].type === "process03" ||
          me.controls[attrId].type === "spliceGroup" ||
          me.controls[attrId].type === "processGateway"
        ) {
          return false
        }
        index = jq(this).parents('.control').index() - 4;
        jq(this).parents('.control').removeClass('cur');
        var $this = jq(this), $height = $this.parent().height(),
          $parentControl = $this.parents('.control'),
          id = $parentControl[0].id,
          attrName = this.getAttribute('data-attrName') || 'index',
          oldTxt = this.innerHTML,
          t = me._getToWorkOffset($this.offset(), me.$work);
        if (me.controls[attrId].type == 'processRefer' && $this.hasClass('control')) {
          $height = $height * 2 / 5;
        } else if ($this.hasClass('control')) {
          $height = $height * 4 / 5;
        }
        me.$textArea.blur().val(oldTxt).css({
          display: "block",
          position: "absolute",
          height: $height * me.scaleTo,
          width: $this.parent().width() * me.scaleTo,
          left: t.left * me.scaleTo,
          top: t.top * me.scaleTo,
          zIndex: 999
        }).data({
          dom: this,
          attrName: attrName,
          type: 'control'
        }).focus();
        //console.log(123123)
      });
      // 绑定双击编辑事件
      var index;
      me.$workArea.on("dblclick", ".J_editAttr", function (e) {
        console.log('me.controls[attrId]', me.controls[attrId])
        if (!me.isEdit || window.isEditAttr === false) return false;
        // if(me.controls[attrId].type ==='role') return false;
        var attrId = jq(this).parents('.control').attr("id")
        console.log(me.controls[attrId].type)
        if (attrId && !me.controls[attrId].isOperable) {
          me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
          return
        }
        if (
          me.controls[attrId].type === "processForm" ||
          me.controls[attrId].type === "process" ||
          me.controls[attrId].type === "process02" ||
          me.controls[attrId].type === "process03" ||
          me.controls[attrId].type === "spliceGroup" ||
          me.controls[attrId].type === "processGateway" ||
          me.controls[attrId].type === "AND" ||
          me.controls[attrId].type === "OR" ||
          me.controls[attrId].type === "P" ||
          me.controls[attrId].type === "XOR" ||
          me.controls[attrId].type ==='role'
        ) {
          return false
        }
        index = jq(this).parents('.control').index() - 4;
        jq(this).parents('.control').removeClass('cur');
        console.log(this.innerHTML)
        // this.innerHTML = this.innerHTML.replace(/(^\s*)|(\s*$)|<br>/g, "") // 去掉空格和换行符
        var $this = jq(this), $height = $this.parent().height(),
          $parentControl = $this.parents('.control'),
          id = $parentControl[0].id,
          attrName = this.getAttribute('data-attrName') || 'name',
          oldTxt = this.innerHTML,
          t = me._getToWorkOffset($this.offset(), me.$work);
        if (me.controls[attrId].type == 'processRefer' && $this.hasClass('second-line')) {
          $height = $height * 2 / 5;
        } else if ($this.hasClass('second-line')) {
          $height = $height * 4 / 5;
        }
        me.$textArea.blur().val(oldTxt).css({
          display: "block",
          position: "absolute",
          height: $height * me.scaleTo,
          width: $this.parent().width() * me.scaleTo,
          left: t.left * me.scaleTo,
          top: t.top * me.scaleTo,
          zIndex: 999
        }).data({
          dom: this,
          attrName: attrName,
          type: 'control'
        }).focus();
        //console.log()
      });
      // 输入
      // me.$workArea.on("dblclick", ".inputTxt", function (e) {
      //   if (!me.isEdit) return false;
      //   var attrId = jq(this).parents('.control').attr("id")
      //   //console.log(attrId)
      //   if (attrId && !me.controls[attrId].isOperable) {
      //     me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
      //     return
      //   }
      //   if (
      //     me.controls[attrId].type === "processForm" ||
      //     me.controls[attrId].type === "process" ||
      //     me.controls[attrId].type === "process02" ||
      //     me.controls[attrId].type === "process03" ||
      //     me.controls[attrId].type === "spliceGroup" ||
      //     me.controls[attrId].type === "processGateway"
      //   ) {
      //     return false
      //   }
      //   index = jq(this).parents('.control').index() - 4;
      //   jq(this).parents('.control').removeClass('cur');
      //   var $this = jq(this), $height = $this.parent().height(),
      //     $parentControl = $this.parents('.control'),
      //     id = $parentControl[0].id,
      //     // attrName = this.getAttribute('data-attrName') || 'name',
      //     oldTxt = me.controls[attrId].inputDesc,
      //     t = me._getToWorkOffset($this.offset(), me.$work);
      //   //console.log(t)
      //   $height = $height * 4 / 5;
      //   me.$textArea.blur().val(oldTxt).css({
      //     display: "block",
      //     position: "absolute",
      //     height: $height * me.scaleTo,
      //     width: $this.parent().width() * me.scaleTo,
      //     left: t.left * me.scaleTo,
      //     top: t.top * me.scaleTo,
      //     zIndex: 999
      //   }).data({
      //     dom: this,
      //     attrName: 'inputTxt',
      //     type: 'control'
      //   }).focus();
      // });
      // 输出
      // me.$workArea.on("dblclick", ".outputTxt", function (e) {
      //   if (!me.isEdit) return false;
      //   var attrId = jq(this).parents('.control').attr("id")
      //   //console.log(attrId)
      //   if (attrId && !me.controls[attrId].isOperable) {
      //     me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
      //     return
      //   }
      //   if (
      //     me.controls[attrId].type === "processForm" ||
      //     me.controls[attrId].type === "process" ||
      //     me.controls[attrId].type === "process02" ||
      //     me.controls[attrId].type === "process03" ||
      //     me.controls[attrId].type === "spliceGroup" ||
      //     me.controls[attrId].type === "processGateway"
      //   ) {
      //     return false
      //   }
      //   index = jq(this).parents('.control').index() - 4;
      //   jq(this).parents('.control').removeClass('cur');
      //   var $this = jq(this), $height = $this.parent().height(),
      //     $parentControl = $this.parents('.control'),
      //     id = $parentControl[0].id,
      //     // attrName = this.getAttribute('data-attrName') || 'name',
      //     oldTxt = me.controls[attrId].outputDesc,
      //     t = me._getToWorkOffset($this.offset(), me.$work);
      //   //console.log(t)
      //   $height = $height * 4 / 5;
      //   me.$textArea.blur().val(oldTxt).css({
      //     display: "block",
      //     position: "absolute",
      //     height: $height * me.scaleTo,
      //     width: $this.parent().width() * me.scaleTo,
      //     left: t.left * me.scaleTo,
      //     top: t.top * me.scaleTo,
      //     zIndex: 999
      //   }).data({
      //     dom: this,
      //     attrName: 'outputTxt',
      //     type: 'control'
      //   }).focus();
      // });

      // KSF双击打开
      me.$workArea.on("dblclick", ".keyKSFControl", function (e) {
        if (!me.isEdit) return false;
        var attrId = jq(this).parents('.control').attr("id")
        //console.log(attrId)
        if (attrId && !me.controls[attrId].isOperable) {
          me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
          return
        }
        if (
          me.controls[attrId].type === "processForm" ||
          me.controls[attrId].type === "process" ||
          me.controls[attrId].type === "process02" ||
          me.controls[attrId].type === "process03" ||
          me.controls[attrId].type === "spliceGroup" ||
          me.controls[attrId].type === "processGateway"
        ) {
          return false
        }
          jq('#' + attrId).addClass('cur')
          me.curId[0] = attrId
          me.$attrBtnBox.find('.ico_icon-attribute').click()
          me.$attrBtnBox.children().children().removeClass('active').eq(1).addClass('active')
          me.$attrContentBox.children().siblings().hide().eq(1).show()
          for (var i = 0; i < jq("#pointAttr li").length; i++) {
              if (jq("#pointAttr li").eq(i).text() === jq.i18n.prop('KSF')) {
                  jq("#pointAttr li").eq(i).siblings().removeClass("active");
                  jq("#pointAttr li").eq(i).addClass("active");
                  jq(".attr1Box").children().siblings().css("display", "none");
                  jq(".attr1Box").children().eq(i).css("display", "block");
                  break;
              }
          }
      });

      // KCP双击打开
      me.$workArea.on("dblclick", ".keyControl", function (e) {
          if (!me.isEdit) return false;
          var attrId = jq(this).parents('.control').attr("id")
          //console.log(attrId)
          if (attrId && !me.controls[attrId].isOperable) {
              me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
              return
          }
          if (
              me.controls[attrId].type === "processForm" ||
              me.controls[attrId].type === "process" ||
              me.controls[attrId].type === "process02" ||
              me.controls[attrId].type === "process03" ||
              me.controls[attrId].type === "spliceGroup" ||
              me.controls[attrId].type === "processGateway"
          ) {
              return false
          }
          jq('#' + attrId).addClass('cur')
          me.curId[0] = attrId
          me.$attrBtnBox.find('.ico_icon-attribute').click()
          me.$attrBtnBox.children().children().removeClass('active').eq(1).addClass('active')
          me.$attrContentBox.children().siblings().hide().eq(1).show()
          for (var i = 0; i < jq("#pointAttr li").length; i++) {
              if (jq("#pointAttr li").eq(i).text() === jq.i18n.prop('KCP')) {
                  jq("#pointAttr li").eq(i).siblings().removeClass("active");
                  jq("#pointAttr li").eq(i).addClass("active");
                  jq(".attr1Box").children().siblings().css("display", "none");
                  jq(".attr1Box").children().eq(i).css("display", "block");
                  break;
              }
          }
      });

      // 信息文档双击打开
      me.$workArea.on("dblclick", ".messageFile, .messageFormCss", function (e) {
          if (!me.isEdit) return false;
          var attrId = jq(this).parents('.control').attr("id")
          //console.log(attrId)
          if (attrId && !me.controls[attrId].isOperable) {
              me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
              return
          }
          if (
              me.controls[attrId].type === "processForm" ||
              me.controls[attrId].type === "process" ||
              me.controls[attrId].type === "process02" ||
              me.controls[attrId].type === "process03" ||
              me.controls[attrId].type === "spliceGroup" ||
              me.controls[attrId].type === "processGateway"
          ) {
              return false
          }
          jq('#' + attrId).addClass('cur')
          me.curId[0] = attrId
          me.$attrBtnBox.find('.ico_icon-attribute').click()
          me.$attrBtnBox.children().children().removeClass('active').eq(1).addClass('active')
          me.$attrContentBox.children().siblings().hide().eq(1).show()
          for (var i = 0; i < jq("#pointAttr li").length; i++) {
              if (jq("#pointAttr li").eq(i).text() === jq.i18n.prop('processForm')) {
                  jq("#pointAttr li").eq(i).siblings().removeClass("active");
                  jq("#pointAttr li").eq(i).addClass("active");
                  jq(".attr1Box").children().siblings().css("display", "none");
                  jq(".attr1Box").children().eq(i).css("display", "block");
                  break;
              }
          }
      });

      // ------------------------------------------------------- 添加热键部分 --------------开始
      // 只init时 加载一次
      if (!type) {
        // 判断用户是否按下ctrl+c c---67 v---86
        var copyItem, step = 10;
        jq(document).keydown(function (e) {
          if (me.isEdit && window.isEditAttr !== false) {
            console.log(e.keyCode)
            switch (true) {
            case (e.ctrlKey && e.keyCode === 67): // 左键
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              //console.log(111)
              e.preventDefault();
              me.copyItem = [];
              me.copyId = me.curId;
              var ctrls = me.controls;
              for (var k = 0; k < me.copyId.length; k++) {
                for (var i in ctrls) {
                  if (ctrls[i].id == me.copyId[k]) {
                    var obj = {}
                    for (var j in ctrls[i]) {
                      if (j !== '$el' && j !== 'id') {
                        obj[j] = ctrls[i][j]
                      }
                    }
                    me.copyItem.push(JSON.parse(JSON.stringify(obj)))
                    break;
                  }
                }
              }
              break;
            case (e.ctrlKey && e.keyCode === 86 && !me.$textArea.is(":focus")):
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              e.preventDefault();
              if (!me.copyItem.length) {
                return;
              }
              if (me.copyItem.length) {
                for (var i = 0; i < me.copyItem.length; i++) {
                  me.copyItem[i].id = GooFlow.getUID('CONTROL');
                  me.copyItem[i].left = me.copyItem[i].left + step;
                  me.copyItem[i].top = me.copyItem[i].top + step;
                  me.copyItem[i].rename = '';
                  var arr = JSON.parse(JSON.stringify(me.copyItem[i]));
                  me.addControl(arr, true);
                  if (!!JSON.parse(JSON.stringify(me.copyItem[i])).keyKSFControl && !!JSON.parse(JSON.stringify(me.copyItem[i])).keyKSFControl.length > 0) {
                    var keyKSFControlCopy = JSON.parse(JSON.stringify(me.copyItem[i])).keyKSFControl
                    for (var f = 0; f < keyKSFControlCopy.length; f++) {
                      keyKSFControlCopy[f].listid = me.id
                      keyKSFControlCopy[f].keyid = me.copyItem[i].id
                    }
                    jQuery.support.cors = true;
                    jq.ajax({
                      type: 'POST',
                      url: me.baseUrl + '/succelement/saveSuccelementList?username=' + me.username,
                      dataType: 'json',
                      contentType: "application/json;",
                      data: JSON.stringify(keyKSFControlCopy),
                      success: function (res) {
                        //console.log(res);
                      },
                      error: function () {
                        //console.log(err)
                      }
                    })
                  }

                  if (!!JSON.parse(JSON.stringify(me.copyItem[i])).keyControl && !!JSON.parse(JSON.stringify(me.copyItem[i])).keyControl.length > 0) {
                    jQuery.support.cors = true;
                    jq.ajax({
                      type: 'POST',
                      url: me.baseUrl + '/modellist/saveCorekeyList?username=' + me.username,
                      dataType: 'json',
                      contentType: "application/json;",
                      // data: JSON.stringify({
                      //     listid: me.id,
                      //     keyid: me.copyItem[i].id,
                      //     code: JSON.parse(JSON.stringify(me.copyItem[i])).keyControl.code,
                      //     controlelement: JSON.parse(JSON.stringify(me.copyItem[i])).keyControl.controlelement,
                      //     kcpname: JSON.parse(JSON.stringify(me.copyItem[i])).keyControl.kcpname
                      // }),
                      data: JSON.stringify(me.copyItem[i].keyControl),
                      success: function (res) {
                        //console.log(res);
                      },
                      error: function () {
                      }
                    })
                  }

                  if (JSON.parse(JSON.stringify(me.copyItem[i])).type == 'processTask' || JSON.parse(JSON.stringify(me.copyItem[i])).type == 'processIt') {
                    var copyItem = JSON.parse(JSON.stringify(me.copyItem[i]));
                    if (!!copyItem.input.length) {
                      for (var j = 0; j < copyItem.input.length; j++) {
                        (function (index) {
                          jQuery.support.cors = true;
                          jq.ajax({
                            type: 'POST',
                            url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.input[index].docid + '?username=' + me.username,
                            async: true,
                            success: function (res) {
                              for (var t = 0; t < me.controls[copyItem.id].input.length; t++) {
                                if (me.controls[copyItem.id].input[t].id == copyItem.input[index].id) {
                                  me.controls[copyItem.id].input[t].docid = res.id;
                                  break;
                                }
                              }
                            },
                            error: function (err) {
                              //console.log(err)
                            }
                          })
                        })(j)
                      }
                    }
                    if (!!copyItem.output.length) {
                      for (var j = 0; j < copyItem.output.length; j++) {
                        (function (index) {
                          jQuery.support.cors = true;
                          jq.ajax({
                            type: 'POST',
                            url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.output[index].docid + '?username=' + me.username,
                            async: true,
                            success: function (res) {
                              // //console.log(res);
                              // copyItem.input[index].docid = res.id;
                              // //console.log(copyItem.input[index])
                              for (var t = 0; t < me.controls[copyItem.id].output.length; t++) {
                                if (me.controls[copyItem.id].output[t].id == copyItem.output[index].id) {
                                  me.controls[copyItem.id].output[t].docid = res.id;
                                  break;
                                }
                              }
                            },
                            error: function (err) {
                              //console.log(err)
                            }
                          })
                        })(j)
                      }
                    }
                    if (!!copyItem.messageFile.length) {
                      for (var j = 0; j < copyItem.messageFile.length; j++) {
                        (function (index) {
                          jQuery.support.cors = true;
                          jq.ajax({
                            type: 'POST',
                            url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.messageFile[index].docid + '?username=' + me.username,
                            async: true,
                            success: function (res) {
                              // //console.log(res);
                              // copyItem.input[index].docid = res.id;
                              // //console.log(copyItem.input[index])
                              for (var t = 0; t < me.controls[copyItem.id].messageFile.length; t++) {
                                if (me.controls[copyItem.id].messageFile[t].id == copyItem.messageFile[index].id) {
                                  me.controls[copyItem.id].messageFile[t].docid = res.id;
                                  break;
                                }
                              }
                            },
                            error: function (err) {
                              //console.log(err)
                            }
                          })
                        })(j)
                      }
                    }
                    if (!!copyItem.messageGroup.length) {
                      for (var j = 0; j < copyItem.messageGroup.length; j++) {
                        (function (index) {
                          jQuery.support.cors = true;
                          jq.ajax({
                            type: 'POST',
                            url: basFlow.baseUrl + '/modellistdoc/copy/' + copyItem.messageGroup[index].docid + '?username=' + me.username,
                            async: true,
                            success: function (res) {
                              // //console.log(res);
                              // copyItem.input[index].docid = res.id;
                              // //console.log(copyItem.input[index])
                              for (var t = 0; t < me.controls[copyItem.id].messageGroup.length; t++) {
                                if (me.controls[copyItem.id].messageGroup[t].id == copyItem.messageGroup[index].id) {
                                  me.controls[copyItem.id].messageGroup[t].docid = res.id;
                                  break;
                                }
                              }
                            },
                            error: function (err) {
                              //console.log(err)
                            }
                          })
                        })(j)
                      }
                    }
                  }
                }
                me.linkage();
              }
              break;
            //  保存
            case (e.ctrlKey && e.keyCode === 83):
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              e.preventDefault();
              jq('#btn_save').trigger('click');
              break;
            // 反撤销
            case (e.ctrlKey && e.keyCode === 89):
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                  return;
              }
              e.preventDefault();
              me.onCtrlyClick()
              break;
            // 撤回
            case (e.ctrlKey && e.keyCode === 90):
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              e.preventDefault();
              me.onCtrlzClick()
              //console.log(me.ctrlZlist)
              break;

            case (e.keyCode === 37): // 左键
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              e.preventDefault();
              if (!me.curId[0]) {
                return;
              }
              if (me.curId[0].indexOf("CONTROL") > -1) {
                for (var i = 0; i < me.curId.length; i++) {
                  var leftOffset = me.controls[me.curId[i]].left - 2;
                  var topOffset = me.controls[me.curId[i]].top;
                  jq("#" + me.curId[i]).css({
                    "left": leftOffset * me.scaleTo,
                    "top": topOffset * me.scaleTo
                  })
                  me.controls[me.curId[i]].left = leftOffset;
                  me.controls[me.curId[i]].top = topOffset;
                  // me.resetLines(me.curId[i], me.controls[me.curId[i]],null , {
                  //     left: -1,
                  //     top: 0
                  // });
                }
                for (var key in me.lines) {
                  if (me.curId.indexOf(me.lines[key].from) > -1 || me.curId.indexOf(me.lines[key].to) > -1) {
                    if (me.lines[key].type == "lr") {
                      me.lines[key].M += -2
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "tb") {
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "fr") {
                      for (var i = 0; i < me.curId.length; i++) {
                        me.resetLines(me.curId[i], me.controls[me.curId[i]], null, {
                          left: -2,
                          top: 0
                        });
                      }
                      return
                    }
                  }
                }
                // 链接泳道
                me.linkage();
              }
              if (me.curId[0].indexOf("LINE") > -1) {
                var p = me.$lineMove.position();
                if (me.$lineMove.data("type") == "lr") {
                  me.setLineM(me.$lineMove.data("tid"), p.left / me.scaleTo - 2);
                }

                if (me.curId[0] == me.$lineMove.data("tid")) {
                  me.focusItem(me.$lineMove.data("tid"), "single");
                }
              }

              break;

            case (e.keyCode === 38): // 上键
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              e.preventDefault();
              if (!me.curId[0]) {
                return;
              }
              if (me.curId[0].indexOf("CONTROL") > -1) {
                var referFlag = false
                for (var i = 0; i < me.curId.length; i++) {
                  if (!basFlow.referInnerLine({
                    left: Number(jq('#' + me.curId[i]).css("left").replace("px", "")),
                    top: Number(jq('#' + me.curId[i]).css("top").replace("px", ""))
                  }, me.controls[me.curId[i]].type, me.controls[me.curId[i]].height) && getCookie('qiehuanbgimg') === 'bg_img_grid') {
                    referFlag = true
                  }
                }
                if (referFlag) {
                  basFlow.alertBox(jq.i18n.prop("addProcessRule") + "! ", 'danger');
                  return
                }
                for (var i = 0; i < me.curId.length; i++) {
                  var leftOffset = me.controls[me.curId[i]].left;
                  var topOffset = me.controls[me.curId[i]].top - 2;
                  jq("#" + me.curId[i]).css({
                    "left": leftOffset * me.scaleTo,
                    "top": topOffset * me.scaleTo
                  })
                  me.controls[me.curId[i]].left = leftOffset;
                  me.controls[me.curId[i]].top = topOffset;
                  // me.resetLines(me.curId[i], me.controls[me.curId[i]]);
                }
                // 链接泳道
                me.linkage();
                for (var key in me.lines) {
                  if (me.curId.indexOf(me.lines[key].from) > -1 || me.curId.indexOf(me.lines[key].to) > -1) {
                    if (me.lines[key].type == "lr") {
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "tb") {
                      me.lines[key].M += -2
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "fr") {
                      for (var i = 0; i < me.curId.length; i++) {
                        me.resetLines(me.curId[i], me.controls[me.curId[i]], null, {
                          left: 0,
                          top: -2
                        });
                      }
                      return
                    }
                  }
                }
              }
              if (me.curId[0].indexOf("LINE") > -1) {
                var p = me.$lineMove.position();
                if (me.$lineMove.data("type") == "tb") {
                  me.setLineM(me.$lineMove.data("tid"), p.top / me.scaleTo - 2);
                }

                if (me.curId[0] == me.$lineMove.data("tid")) {
                  me.focusItem(me.$lineMove.data("tid"), "single");
                }
              }

              break;

            case (e.keyCode === 39): // 右键
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              e.preventDefault();
              if (!me.curId[0]) {
                return;
              }
              if (me.curId[0].indexOf("CONTROL") > -1) {
                for (var i = 0; i < me.curId.length; i++) {
                  var leftOffset = me.controls[me.curId[i]].left + 2;
                  var topOffset = me.controls[me.curId[i]].top;
                  jq("#" + me.curId[i]).css({
                    "left": leftOffset * me.scaleTo,
                    "top": topOffset * me.scaleTo
                  })
                  me.controls[me.curId[i]].left = leftOffset;
                  me.controls[me.curId[i]].top = topOffset;
                  // me.resetLines(me.curId[i], me.controls[me.curId[i]]);
                }
                for (var key in me.lines) {
                  if (me.curId.indexOf(me.lines[key].from) > -1 || me.curId.indexOf(me.lines[key].to) > -1) {
                    if (me.lines[key].type == "lr") {
                      me.lines[key].M += 2
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "tb") {
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "fr") {
                      for (var i = 0; i < me.curId.length; i++) {
                        me.resetLines(me.curId[i], me.controls[me.curId[i]], null, {
                          left: 2,
                          top: 0
                        });
                      }
                      return
                    }
                  }
                }
                // 链接泳道
                me.linkage();
              }
              if (me.curId[0].indexOf("LINE") > -1) {
                var p = me.$lineMove.position();
                if (me.$lineMove.data("type") == "lr") {
                  me.setLineM(me.$lineMove.data("tid"), p.left / me.scaleTo + 5);
                }

                if (me.curId[0] == me.$lineMove.data("tid")) {
                  me.focusItem(me.$lineMove.data("tid"), "single");
                }
              }
              break;

            case (e.keyCode === 40): // 下键
            console.log('下键')
              var ev = e || window.event;//获取event对象
              var obj = ev.target || ev.srcElement;//获取事件源
              var t = obj.type || obj.getAttribute('type');//获取事件源类型
              if (t == "password" || t == "text" || t == "textarea") {
                return;
              }
              e.preventDefault();
              if (!me.curId[0]) {
                return;
              }
              var referFlag = false
              for (var i = 0; i < me.curId.length; i++) {
                if (!basFlow.referInnerLine({
                  left: Number(jq('#' + me.curId[i]).css("left").replace("px", "")),
                  top: Number(jq('#' + me.curId[i]).css("top").replace("px", ""))
                }, me.controls[me.curId[i]].type, me.controls[me.curId[i]].height) && getCookie('qiehuanbgimg') === 'bg_img_grid') {
                  referFlag = true
                }
              }
              if (referFlag) {
                basFlow.alertBox(jq.i18n.prop("addProcessRule") + "! ", 'danger');
                return
              }
              if (me.curId[0].indexOf("CONTROL") > -1) {
                for (var i = 0; i < me.curId.length; i++) {
                  var leftOffset = me.controls[me.curId[i]].left;
                  var topOffset = me.controls[me.curId[i]].top + 2;
                  jq("#" + me.curId[i]).css({
                    "left": leftOffset * me.scaleTo,
                    "top": topOffset * me.scaleTo
                  })
                  me.controls[me.curId[i]].left = leftOffset;
                  me.controls[me.curId[i]].top = topOffset;
                  // me.resetLines(me.curId[i], me.controls[me.curId[i]]);
                }
                for (var key in me.lines) {
                  if (me.curId.indexOf(me.lines[key].from) > -1 || me.curId.indexOf(me.lines[key].to) > -1) {
                    if (me.lines[key].type == "lr") {
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "tb") {
                      me.lines[key].M += 2
                      me.setLineM(key, me.lines[key].M);
                    } else if (me.lines[key].type == "fr") {
                      for (var i = 0; i < me.curId.length; i++) {
                        me.resetLines(me.curId[i], me.controls[me.curId[i]], null, {
                          left: 0,
                          top: 2
                        });
                      }
                      return
                    }
                  }
                }
                // 链接泳道
                me.linkage();
              }
              if (me.curId[0].indexOf("LINE") > -1) {
                var p = me.$lineMove.position();
                if (me.$lineMove.data("type") == "tb") {
                  me.setLineM(me.$lineMove.data("tid"), p.top / me.scaleTo + 5);
                }

                if (me.curId[0] == me.$lineMove.data("tid")) {
                  me.focusItem(me.$lineMove.data("tid"), "single");
                }
              }
              break;
            // case (e.keyCode === 46): // 删除泳道
            //     var ev = e || window.event;//获取event对象
            //     var obj = ev.target || ev.srcElement;//获取事件源
            //     var t = obj.type || obj.getAttribute('type');//获取事件源类型
            //     if (t == "password" || t == "text" || t == "textarea") {
            //         return;
            //     }
            //     if (!me.curId[0]) return;
            //     if (me.curId[0].indexOf('SWIMLANE') === -1) return;
            //     if (me.curId[0] && jq(".swimlaneX-list .swimlaneX:last").attr("id") === me.curId[0]) {
            //         me.alertBox(jq.i18n.prop("noDelDown") + "! ", "danger");
            //         return;
            //     }
            //     if (me.curId[0] && jq(".swimlaneX-list .swimlaneX:first").attr("id") === me.curId[0]) {
            //         me.alertBox(jq.i18n.prop("noDelUp") + "! ", "danger");
            //         return;
            //     }
            //     var ev = e || window.event;//获取event对象
            //     var obj = ev.target || ev.srcElement;//获取事件源
            //     var t = obj.type || obj.getAttribute('type');//获取事件源类型
            //     if (t != "password" && t != "text" && t != "textarea") {
            //         me.delSwimlane(me.curId[0]);
            //     }
            //     break;
            case ((e.keyCode === 8 || e.keyCode === 46) && e.target.nodeName == 'BODY'):
              console.log(me.curId)
              // for (var m = 0; m < me.curId.length; m++) {
              //     me.delControl(me.curId[m])
              // }
              if (jq('#rect').css("display") === 'block') { // 框选 全部删除
                for (var i = 0; i < window.basFlow.rectItems.length; i++) {
                  me.delControl(window.basFlow.rectItems[i].id)
                }
                jq('#rect').css("display", 'none')
                return
              }
              if (me.curId[0].indexOf("CONTROL") > -1) {
                if (!me.$attrBtnBox.find('span').hasClass('active')) {
                  me.delControl(me.curId[0])
                }
              } else if (me.curId[0].indexOf("LINE") > -1) {
                me.delLine(me.curId[0])
              }
              break;
          }
          var ev = e || window.event;//获取event对象
          var obj = ev.target || ev.srcElement;//获取事件源
          var t = obj.type || obj.getAttribute('type');//获取事件源类型
          if (ev.keyCode == 8 && t != "password" && t != "text" && t != "textarea" && t != "number") {
            return false;
          }

          }
        })

        jq(document).keypress(function (e) {
          var ev = e || window.event;//获取event对象
          var obj = ev.target || ev.srcElement;//获取事件源
          var t = obj.type || obj.getAttribute('type');//获取事件源类型
          if (ev.keyCode == 8 && t != "password" && t != "text" && t != "textarea" && t != "number") {
            return false;
          }
        })
      }


      // ------------------------------------------------------- 添加热键部分 --------------结束

      // 绑定单击编辑事件ico_icon-attribute
      // me.$workArea.on("click", ".J_editAttr", function (e) {
      //     var $this = jq(this),
      //         $parentControl = $this.parents('.control'),
      //         id = $parentControl[0].id;
      //     if (!me.isEdit) return false;
      //     if ($this.parents('.control').hasClass('cur')) {
      //         me.newid = id;
      //     } else {
      //         me.newid = undefined;
      //     }

      //     if (me.controls[id].type == 'spliceGroup') {
      //         me.focusItem(id, "single");
      //         return false;
      //     }

      //     me.$attrBtnBox.find('.icon-attribute').addClass('active');
      //     me.$attrContentBox.children().hide();
      //     me.$attrContentBox.children().eq(1).show();
      // });

      // 泳道竖和泳道横固定位置
      jq("#GooFlow_work").get(0).onscroll = function (e) {
        if (jq(this).scrollLeft() != me.storeScroll.left) {
          me.storeScroll.left = jq(this).scrollLeft();
          for (var key in me.swimlanes) {
            if (me.swimlanes[key].type == 'swimlaneX') {
              jq("#" + me.swimlanes[key].id).find(".J_swimlaneTitle").css({
                "left": me.storeScroll.left
              })
              jq("#" + me.swimlanes[key].id).find(".ui-resizable-handle.ui-resizable-s").css({
                "left": me.storeScroll.left
              })
              jq("#" + me.swimlanes[key].id).find(".surChooseLeaders").css({
                "left": 85 * me.scaleTo + me.storeScroll.left
              })
              jq("#" + me.swimlanes[key].id).find(".surChooseLeadersAdd").css({
                "left": (85 * me.scaleTo + me.storeScroll.left) - 75 > 0 ? (85 * me.scaleTo + me.storeScroll.left) - 75 : 2
              })
              jq("#" + me.swimlanes[key].id).find(".delImg").css({
                "left": me.storeScroll.left + 2
              })
            }
          }
        } else if (jq(this).scrollTop() != me.storeScroll.top) {
          me.storeScroll.top = jq(this).scrollTop();
          for (var key in me.swimlanes) {
            if (me.swimlanes[key].type == 'swimlaneY') {
              jq("#" + me.swimlanes[key].id).find(".J_swimlaneTitle").css({
                "top": me.storeScroll.top
              })
              jq("#" + me.swimlanes[key].id).find(".rightImgPart,.leftImgPart").css({
                "top": me.storeScroll.top
              })
              jq("#" + me.swimlanes[key].id).find(".ui-resizable-handle.ui-resizable-e").css({
                "top": me.storeScroll.top
              })
              jq("#" + me.swimlanes[key].id).find(".delImg").css({
                "top": me.storeScroll.top + 2
              })
              jq("#" + me.swimlanes[key].id).find(".surChooseLeaders").css({
                "top": 58 * me.scaleTo + me.storeScroll.top
              })
              jq("#" + me.swimlanes[key].id).find(".surChooseLeadersAdd").css({
                "top": 58 * me.scaleTo + me.storeScroll.top
              })
              jq("#" + me.swimlanes[key].id).find(".surChooseLeadersAdd").css({
                "left": (85 * me.scaleTo + me.storeScroll.left) - 75 > 0 ? (85 * me.scaleTo + me.storeScroll.left) - 75 : 2
              })
            }
          }
        }
      };

      // 接收拖拽生成的对象
      me.$workArea.droppable({
        accept: '.tools',
        tolerance: 'pointer',
        drop: function (event, ui) {
          console.log(ui, ui.draggable.attr('id'))

          var type = ui.draggable.attr('data-type');
          var offset = me._getToWorkOffset(ui.offset);
          let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
          if (!me.referInnerLine(basFlow._getToWorkOffset(ui.offset), type, Number(ToolsConfig[type].height))) {
            me.alertBox(jq.i18n.prop("addProcessRule") + "! ", 'danger');
            return
          }
          if (type.indexOf("processStart") > -1) {
            for (var s in me.controls) {
              if (me.controls[s].type == 'processStart') {
                me.alertBox(jq.i18n.prop("startTaskNoExistsCannotBeAdded") + "! ", 'danger');
                return
              }
            }
          }
          if (type.indexOf("processEnd") > -1) {
            for (var k in me.controls) {
              if (me.controls[k].type == 'processEnd') {
                me.alertBox(jq.i18n.prop("endTaskNoExistsCannotBeAdded") + "! ", 'danger');
                return
              }
            }
          }
          if ((type.indexOf("KCP") > -1 || type.indexOf("KSF") > -1 ||
          type.indexOf("processInput") > -1 || type.indexOf("processOutput") > -1 ||
          type.indexOf("processForm") > -1 || type.indexOf("processTool") > -1) &&
          !!processInfo.processType) {
            for (var k in me.controls) {
              if (me.controls[k].type == type) {
                me.alertBox(jq.i18n.prop("thisNoExistsCannotBeAdded") + "! ", 'danger');
                return
              }
            }
          }
          // if (!me.referInnerLine(offset, type, ui.helper[0].offsetHeight - 2)) {
          //     me.alertBox(jq.i18n.prop("addProcessRule") + "! ", 'danger');
          //     return false
          // }
          var count = jq("[data-type = 'processGateway']").length / 2
          var addControlId = GooFlow.getUID('CONTROL')
          if (type === 'processGateway') {
            var addControlId2 = GooFlow.getUID('CONTROL')
            me.addControl({
              id: addControlId2,
              name: '拆分',
              type: 'exclusiveGateway',
              left: offset.left,
              top: offset.top,
              gateway: '' + count,
              gatewaytype: '2'
            });
            me.addControl({
              id: addControlId,
              name: '合并',
              type: 'exclusiveGateway',
              left: offset.left + parseFloat(me.ToolsConfig[type].width),
              top: offset.top,
              gateway: '' + count,
              gatewaytype: '1'
            });
            chooseControl([addControlId, addControlId2])
            return false
          } else {
            me.addControl({
              id: addControlId,
              type: type,
              left: offset.left,
              top: offset.top
            });
            chooseControl([addControlId])
          }
        }
      });
      me.$work.on('click', function (e) {
        // if (!me.isEdit && !me.isReadAttr) return false;
        var attrId = jq(e.target).parents(".ui-resizable.cur").attr("id");
        // if (e.target.className !== 'J_editAttr' && e.target.className !== 'swimlane-title J_swimlaneTitle' &&
        //     e.target.className !== 'index' && e.target.className !== 'role' && e.target.className !== 'second-line J_editAttr') {
        //     me.$attrContentBox.children().siblings().hide();
        //     me.$attrBtnBox.children().siblings().children().removeClass('active');
        // }
        if (!!me.swimlanes[attrId] && me.swimlanes[attrId].name == "上游流程") {
          return;
        }
        if (!!me.swimlanes[attrId] && me.swimlanes[attrId].name == "下游流程") {
          return;
        }
        if ((e.target.className == 'swimlane-title J_swimlaneTitle') || (jq(e.target).parent().attr("class") == 'swimlane-title J_swimlaneTitle')) {

          // me.$attrContentBox.children().siblings().hide().eq(1).show();
        }
        if (me.editType == me.EditEnum.SELECT) {
          var t = e.target;
          var n = t.tagName;
          if (n == "svg" || (n == "DIV" && t.className.indexOf("control") > -1) || (n == "DIV" && t.className.indexOf("ui-sortable") > -1)) {
            if (me.$lineOper.data("tid")) {
              me.focusItem(me.$lineOper.data("tid"), false);
            } else {
              me.nodeState = '';
              console.log(2)
              me.blurItem();
            }
          }
        } else if (jq(".J_line").attr("class").indexOf("active") > -1) {
          var t = e.target;
          var n = t.tagName;
          if (n == "svg" || (n == "DIV" && t.className.indexOf("control") > -1) || (n == "DIV" && t.className.indexOf("ui-sortable") > -1)) {
            if (me.$lineOper.data("tid")) {
              me.focusItem(me.$lineOper.data("tid"), false);
            } else {
              me.nodeState = '';
              console.log(3)
              me.blurItem();
            }
          }
        }
        if (me.editDottedType == me.EditEnum.SELECT) {
          var t = e.target;
          var n = t.tagName;
          if (n == "svg" || (n == "DIV" && t.className.indexOf("control") > -1) || (n == "DIV" && t.className.indexOf("ui-sortable") > -1)) {
            if (me.$lineOper.data("tid")) {
              me.focusItem(me.$lineOper.data("tid"), false);
            } else {
              me.nodeState = '';
              me.blurItemDotted();
            }
          }
        } else if (jq(".J_dotted_line").attr("class").indexOf("active") > -1) {
          var t = e.target;
          var n = t.tagName;
          if (n == "svg" || (n == "DIV" && t.className.indexOf("control") > -1) || (n == "DIV" && t.className.indexOf("ui-sortable") > -1)) {
            if (me.$lineOper.data("tid")) {
              me.focusItem(me.$lineOper.data("tid"), false);
            } else {
              me.nodeState = '';
              me.blurItemDotted();
            }
          }
        }
      });

      // 拖拽开始时。重新划线
      me.$workArea.on('dragstart', '.control', function (event, ui) {
        me.$textArea.blur()
        // me.focusItem(this.id); // change at 2018-11-1
        guides = jq.map(jq(".control").not(this), computeGuidesForElement);

        //offsetX、offsetY：源元素（srcElement）的X,Y坐标

        innerOffsetX = event.offsetX;

        innerOffsetY = event.offsetY;
      });

      // 拖拽过程中
      me.$workArea.on('drag', '.control', function (event, ui) {
        //迭代所有的guids，记住最近的h和v guids

        var guideV, guideH, distV = MIN_DISTANCE + 1, distH = MIN_DISTANCE + 1, offsetV, offsetH;

        var chosenGuides = { top: { dist: MIN_DISTANCE + 1 }, left: { dist: MIN_DISTANCE + 1 } };

        var $t = jq(this);

        //pageX、pageY：文档坐标x、y ;

        var pos = { top: event.pageY - innerOffsetY, left: event.pageX - innerOffsetX };

        //outerHeight、outerWidth：整个浏览器的高度、宽度

        var w = $t.outerWidth() - 1;

        var h = $t.outerHeight() - 1;

        var elemGuides = computeGuidesForElement(null, pos, w, h);

        jq.each(guides, function (i, guide) {

          jq.each(elemGuides, function (i, elemGuide) {

            if (guide.type == elemGuide.type) {

              var prop = guide.type == "h" ? "top" : "left";

              var d = Math.abs(elemGuide[prop] - guide[prop]);

              if (d < chosenGuides[prop].dist) {

                chosenGuides[prop].dist = d;

                chosenGuides[prop].offset = elemGuide[prop] - pos[prop];

                chosenGuides[prop].guide = guide;

              }

            }

          });

        });

        if (chosenGuides.top.dist <= MIN_DISTANCE) {

          jq("#guide-h").css("top", chosenGuides.top.guide.top).show();

          // ui.position.top = chosenGuides.top.guide.top - chosenGuides.top.offset;

        }

        else {

          jq("#guide-h").hide();

          // ui.position.top = pos.top;

        }

        if (chosenGuides.left.dist <= MIN_DISTANCE) {

          jq("#guide-v").css("left", chosenGuides.left.guide.left).show();

          // ui.position.left = chosenGuides.left.guide.left - chosenGuides.left.offset;

        }

        else {

          jq("#guide-v").hide();

          // ui.position.left = pos.left;

        }
      })


      // 拖拽停止时。重新划线
      me.$workArea.on('dragstop', '.control', function (event, ui) {
        //console.log(me.controls[this.id], me.controls[this.id].isOperable, !me.controls[this.id].isOperable, this.id)
        if (!me.controls[this.id].isOperable) {
          return
        }
        //console.log(222)
        me.$lineOper.hide();
        me.$mpFrom.hide();
        me.$mpTo.hide();
        // 辅助线对齐
        jq("#guide-v, #guide-h").hide();

        // 拖拽后和 _initDrag 方法  的 stop 方法 都调用了    避免重新画线
        // console.log(ui, me.controls[this.id].type, me.controls[this.id].height, 'uiuiuiuiuiuiuiui', basFlow.referInnerLine(basFlow._getToWorkOffset(ui.offset), me.type, me.height))
        if (!basFlow.referInnerLine(basFlow._getToWorkOffset(ui.offset), me.controls[this.id].type, me.controls[this.id].height) && getCookie('qiehuanbgimg') === 'bg_img_grid') {
          console.log('------------------------------')
          return
        }
        var thisControl = me.controls[this.id];

        var posAbout = function (num, step) {
          if ((num % step) > Math.floor(step / 2)) {
            num = num + step - (num % step);
          } else {
            num = num - (num % step);
          }
          return num;
        };
        console.log(ui, 'uiuiuiuiuiuiuiui')
        var offset = ui.offset;
        offset.top = offset.top;// posAbout(offset.top, 10);
        offset.left = offset.left; // posAbout(offset.left, 10);
        console.log(offset, 'offsetoffsetoffsetoffsetoffsetoffsetoffsetoffset')
        var offsetMinus = {
          left: offset.left - thisControl.left * me.scaleTo,
          top: offset.top - thisControl.top * me.scaleTo
        }
        // 改变的值
        var changeDistance = {
          left: offset.left - ui.originalPosition.left,
          top: offset.top - ui.originalPosition.top
        }
        thisControl.syncUI(offset);
        // thisControl.top = thisControl.top + offset.top - ui.originalPosition.top
        // thisControl.left = thisControl.left + offset.left - ui.originalPosition.left
        if (me.curId.length < 2) {
          me.resetLines(this.id, thisControl, null, {
            left: offset.left - ui.originalPosition.left,
            top: offset.top - ui.originalPosition.top
          });
        } else {
          thisControl.left = thisControl.left / me.scaleTo;
          thisControl.top = thisControl.top / me.scaleTo;
        }



        if (me.curId.indexOf(this.id) > -1 && me.curId.length > 1) {
          if (me.curId[0].indexOf("CONTROL") > -1) {
            for (var i = 0; i < me.curId.length; i++) {
              if (me.curId[i] == this.id) {
                continue;
              }
              var left = me.controls[me.curId[i]].left * me.scaleTo + offsetMinus.left;
              var top = me.controls[me.curId[i]].top * me.scaleTo + offsetMinus.top;
              me.controls[me.curId[i]].syncUI({
                left: left,
                top: top
              });
              me.controls[me.curId[i]].left = me.controls[me.curId[i]].left / me.scaleTo;
              me.controls[me.curId[i]].top = me.controls[me.curId[i]].top / me.scaleTo;
            }
          }

          for (var key in me.lines) {
            if (me.curId.indexOf(me.lines[key].from) > -1 || me.curId.indexOf(me.lines[key].to) > -1) {
              if (me.lines[key].type == "lr") {
                me.lines[key].M += changeDistance.left / me.scaleTo
                me.setLineM(key, me.lines[key].M);
              } else if (me.lines[key].type == "tb") {
                me.lines[key].M += changeDistance.top / me.scaleTo
                me.setLineM(key, me.lines[key].M);
              }
            }
          }
          if (me.curId[0].indexOf("LINE") > -1) {
            var p = me.$lineMove.position();
            if (me.$lineMove.data("type") == "tb") {
              me.setLineM(me.$lineMove.data("tid"), p.top + 5);
            }
            if (me.curId[0] == me.$lineMove.data("tid")) {
              me.focusItem(me.$lineMove.data("tid"), "single");
            }
          }
        }

        // 判断上下游流程
        me.referUpAndDownProcess()

      });

      // 划线部分 四周出现圆圈
      me.$workArea.on('mouseover', '.commonCircle', function (event) {
        if (!me.isEdit && !me.isReadAttr) return;
          me.$textArea.blur()
          // if (jq(this).parent().attr("class").indexOf("cur") > -1) {
          //     jq(this).css("cursor","move");
          //     return false;
          // }
          jq.each(me.controls, function () {
              this.$el.draggable();
              this.$el.resizable();
          });
          jq(this).css("cursor", "crosshair");
          me._switchEditType(2);
          // event.stopPropagation();
      })
      me.$workArea.on('mouseout', '.commonCircle', function (event) {
        if (!me.isEdit && !me.isReadAttr) return;
          // me.$textArea.blur()
          // if (jq(this).parent().attr("class").indexOf("cur") > -1) {
          //     jq(this).css("cursor","move");
          //     return false;
          // }
          // jq.each(me.controls, function () {
          //     this.$el.draggable();
          //     this.$el.resizable();
          // });
          // jq(this).css("cursor", "crosshair");
          console.log('commonCircle')
          me._switchEditType(1);
          // event.stopPropagation();
      })
      // me.$workArea.on('mousedown', '.commonCircle', function (e) {
      //   me.$textArea.blur()
      //   if (jq(this).parent().attr("class").indexOf("cur") > -1) {
      //       jq(this).css("cursor","move");
      //       return false;
      //   }
      //   jq.each(me.controls, function () {
      //       this.$el.draggable();
      //       this.$el.resizable();
      //   });
      //   jq(this).css("cursor", "crosshair");
      //   console.log('mousedownmousedown')
      //   me._switchEditType(2);
      // })


      // 改变大小时。重新划线
      me.$workArea.on('resizestop', '.control', function (event, ui) {
        var thisControl = me.controls[this.id];

        var offset = {
          width: jq("#" + this.id).width() - thisControl.width,
          height: jq("#" + this.id).height() - thisControl.height
        }
        thisControl.syncUI();
        me.resetLines(this.id, thisControl);
        for (var k = 0; k < me.curId.length; k++) {
          if (this.id == me.curId[k]) {
            continue;
          }
          jq("#" + me.curId[k]).css("width", parseFloat(me.controls[me.curId[k]].width) + offset.width + "px")
          jq("#" + me.curId[k]).css("height", parseFloat(me.controls[me.curId[k]].height) + offset.height + "px")
          me.controls[me.curId[k]].width = parseFloat(me.controls[me.curId[k]].width) + offset.width;
          me.controls[me.curId[k]].height = parseFloat(me.controls[me.curId[k]].height) + offset.height;
          me.controls[me.curId[k]].syncUI();
          me.resetLines(me.curId[k], me.controls[me.curId[k]]);
        }
      });

      // 点击切换当前控件
      me.$workArea.on('click', '.control', function (e) {

        window.categoryTab = null
        me.$textArea.blur()
        var thisCtl = me.controls[this.id];
        if (!me.isEdit && !me.isReadAttr) {
          me.focusItem(thisCtl.id, "single");
        } else if (!e.ctrlKey && !e.metaKey) {
          // 单选模式
          if (thisCtl.type === 'mulNetworkManage' || thisCtl.type === 'gatewayNetwork') {
            jq('.right-button').hide()
            jq('.ico_icon-dingdan').hide()
            jq('.ico_icon-attribute').hide()
            jq('.ico_icon-childProcess').show()
            if (thisCtl.type === 'mulNetworkManage') {
              jq('.ico_icon-childProcess span').text('子流程触发设置')
            } else {
              jq('.ico_icon-childProcess span').text('子流程完成设置')
            }
          } else {
            jq('.right-button').show()
            jq('.ico_icon-dingdan').show()
            jq('.ico_icon-attribute').show()
            jq('.ico_icon-childProcess').hide()
          }
          if (me.curId.indexOf(this.id) === -1) {
            me.focusItem(thisCtl.id, "single");
          }
        }
        else if (e.ctrlKey || e.metaKey) {
          // 多选模式
          if (!me.isEdit) return;
          var thisCtl = me.controls[this.id];
          me.focusItem(thisCtl.id, "multiSelect");
        }
        const $control = me.controls[me.curId[0]];
        const PropsActivity = new propsActivity({ categoryId: me.category.id, control: $control })
      });



      // 划线或改线时用的绑定
      me.$workArea.on('mousemove', function (e) {

        // if (me.editType != me.EditEnum.LINE && !me.$mpTo.data("p")) return;
        var lineStart = me.$workArea.data("lineStart");
        var lineEnd = me.$workArea.data("lineEnd");
        if (!lineStart && !lineEnd) return;
        me._switchEditType(2)
        var line = document.getElementById("GooFlow_tmp_line"),
          toWorkOffset = me._getToWorkOffset(e),
          X = toWorkOffset.left,
          Y = toWorkOffset.top;

        if (lineStart) {
          // 连线时自动滚动滚动条(用了个自己都奇怪的方法实现了 )
          var contentHeight = $('#GooFlow_work').height();
          var contentWidth = $('#GooFlow_work').width();
          var contentST = Y - $('#GooFlow_work').scrollTop() / me.scaleTo;
          var contentSL = X - $('#GooFlow_work').scrollLeft() / me.scaleTo;
          var timer = null
          var timer2 = null
          if (contentST < 20) {
            $('#GooFlow_work').animate({ scrollTop: "-=10" }, 0);
            timer = setInterval(function (){
              $('#GooFlow_work').animate({ scrollTop: "-=10" }, 0);
            }, 100)
            setTimeout(function (){
              clearInterval(timer);
            }, 1000)
          } else if (contentHeight - (contentST + 53) * me.scaleTo < 20 * me.scaleTo) {
            $('#GooFlow_work').animate({ scrollTop: "+=10" }, 0);
            timer = setInterval(function (){
              $('#GooFlow_work').animate({ scrollTop: "+=10" }, 0);
            }, 100)
            setTimeout(function (){
              clearInterval(timer);
            }, 1000)
          } else {
            clearInterval(timer);
          }
          if (contentSL < 20) {
            $('#GooFlow_work').animate({ scrollLeft: "-=10" }, 0);
            timer2 = setInterval(function (){
              $('#GooFlow_work').animate({ scrollLeft: "-=10" }, 0);
            }, 100)
            setTimeout(function (){
              clearInterval(timer2)
            }, 1000)
          } else if(contentWidth - (contentSL + 164) * me.scaleTo < 20 * me.scaleTo) {
            $('#GooFlow_work').animate({ scrollLeft: "+=10" }, 0);
            timer2 = setInterval(function (){
              $('#GooFlow_work').animate({ scrollLeft: "+=10" }, 0);
            }, 100)
            setTimeout(function (){
              clearInterval(timer2)
            }, 1000)
          } else {
            clearInterval(timer2)
          }

          if (useSVG) {
            line.childNodes[0].setAttribute("d", "M " + lineStart.x + " " + lineStart.y + " L " + X + " " + Y);
            line.childNodes[1].setAttribute("d", "M " + lineStart.x + " " + lineStart.y + " L " + X + " " + Y);
          }
        } else if (lineEnd) {
          if (useSVG) {
            line.childNodes[0].setAttribute("d", "M " + X + " " + Y + " L " + lineEnd.x + " " + lineEnd.y);
            line.childNodes[1].setAttribute("d", "M " + X + " " + Y + " L " + lineEnd.x + " " + lineEnd.y);
          }
        }
      });




      me._initLineMove()
      me._initLineOper();
      me._initLinePoints();

      // me.$workArea.on('mouseover', '.control', function (e) {
      //   if (!jq(this).hasClass("cur")) {
      //     jq(this).addClass("control-mark").addClass("crosshair").css("border-color", me.options.color.mark);
      //     me._switchEditType(2)
      //   }
      // })
      // 绑定连线时确定初始点 editDottedType虚线
      me.$workArea.on('mousedown', '.control', function (e) {

        console.log('me.$workArea.on(mousedown')
        if (e.button == 2) return false;
        console.log(5555, me)
        if (!(me.editType == me.EditEnum.LINE || me.editDottedType == me.EditEnum.LINE)) return;
        // 获取戍边相对工作区间距离
        var toWorkOffset = me._getToWorkOffset(e),
          X = toWorkOffset.left,
          Y = toWorkOffset.top;
        me.$workArea.data("lineStart", {
          "x": X,
          "y": Y,
          "id": this.id
        })
          // .css("cursor", "crosshair");
        me.startPos = [X, Y]

        var line = me.drawLine("GooFlow_tmp_line", [X, Y], [X, Y], true, true);
        me.$draw.appendChild(line);
      });

      me.$workArea.on('mouseenter', '.control', function (e) {
        if (!(me.editType == me.EditEnum.LINE || me.editDottedType == me.EditEnum.LINE) && !document.getElementById("GooFlow_tmp_line")) return;
        jq(this).addClass("control-mark").addClass("crosshair").css("border-color", me.options.color.mark);
      });

      me.$workArea.on('mouseleave', '.control', function (e) {
        jq(this).removeClass("control-mark").removeClass("crosshair").css("border-color", '');
      });

      // 绑定连线时确定结束点
      me.$workArea.on('mouseup', '.control', function (e) {
        console.log('划线或改线时用的绑定2')
        if (!me.isEdit) return false;
        if (!(me.editType == me.EditEnum.LINE || me.editDottedType == me.EditEnum.LINE) && !me.$mpTo.data("p")) return;

        var toWorkOffset = me._getToWorkOffset(e),
          X = toWorkOffset.left,
          Y = toWorkOffset.top;

        var lineStart = me.$workArea.data("lineStart"),
          lineEnd = me.$workArea.data("lineEnd");
        console.log('lineStart', lineStart)
        console.log('lineEnd', lineEnd)
        console.log('idididid', this.id)
        if (lineStart && !me.$mpTo.data("p")) {
          console.log('YYYYYYYYYYYYY')
          me.addLine({
            from: lineStart.id,
            to: this.id,
            name: '',
            startPos: me.startPos,
            endPos: [X, Y]
          });
          me.startPos = []
        } else {
          console.log('NNNNNNNNNNNNNNN')

          if (lineStart) {
            me.moveLinePoints(me.curId[0], lineStart.id, this.id, 'start', [X, Y]);
          } else if (lineEnd) {
            me.moveLinePoints(me.curId[0], this.id, lineEnd.id, 'end', [X, Y]);
          }

          if (!me.controls[this.id].marked) {
            jq(this).removeClass("item_mark");
            if (this.id != me.curId[0]) {
              jq(this).css("border-color", me.options.color.node);
            } else {
              jq(this).css("border-color", me.options.color.line);
            }
          }

        }

      });

      // 划线或改线时用的绑定
      me.$workArea.on('mouseup', function (e) {
        console.log('划线或改线时用的绑定1', e)
        console.warn('meme:', me)
        console.warn('me.$mpTo.data("p"):', me.$mpTo.data("p"))
        // if (!(me.editType == me.EditEnum.LINE || me.editDottedType == me.EditEnum.LINE) && !me.$mpTo.data("p")) return;

        var tmp = document.getElementById("GooFlow_tmp_line");

        if (tmp) {
          me.$workArea.css("cursor", "auto").removeData("lineStart").removeData("lineEnd");
          me.$mpTo.hide().removeData("p");
          me.$mpFrom.hide().removeData("p");
          me.$draw.removeChild(tmp);

          me.focusItem(me.curId[0], false, "single");

          console.log('newLineId:', newLineId)
          console.log('me.lines[newLineId]:', me.lines[newLineId])
          // if ((!!me.lines[newLineId] && me.lines[newLineId].type === 'sl') {
          //   if (
          //     (me.controls[me.lines[newLineId].to].top > (me.controls[me.lines[newLineId].from].height + me.controls[me.lines[newLineId].from].top))
          //   ) {
          //     console.log('pppppppppppppppp')
          //     // me.setLineType(newLineId, "tb");
          //     // fr 自由连线
          //     me.setLineType(newLineId, "fr");
          //   } else {
          //     console.log('ooooooooooooooo')
          //     // me.setLineType(newLineId, "lr");
          //     me.setLineType(newLineId, "fr");
          //   }
          // }
          console.log(me.lines[newLineId], 'me.lines[newLineId]me.lines[newLineId]me.lines[newLineId]')
          // if (!!me.lines[newLineId] && me.lines[newLineId].type === 'sl') {
          //   me.setLineType(newLineId, "sl", me.lines[newLineId].M);
          // } else {
          me.setLineType(newLineId, "fr");
          // }
        } else {
          me.$lineOper.removeData("tid");
        }
        me.startPos = []
        me._switchEditType(1)
      });

      // 绑定结点的删除功能
      me.$workArea.on("click", ".J_remove", function (e) {
        var e = e || window.event;
        let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
        // me.delControl(me.curId[0]); // 多选的时候删除会只能删除掉 已选中的第一个
        console.log(me.controls[jq(this).parent().attr('id')])
        if (!!processInfo.processType && me.controls[jq(this).parent().attr('id')].type === 'processTask') {
          me.alertBox("不允许删除! ", 'danger')
          return false;
        }
        me.delControl(jq(this).parent().attr('id')) // 保证多选的时候删除时 也能删除当前的
        return false;
      });

    },
    // 判断拖进去的节点是否在上下游泳道内
    referInnerLine: function (offset, type, height) {
      var me = this
      offset.top = offset.top * basFlow.scaleTo
      offset.left = offset.left * basFlow.scaleTo
      height = height * basFlow.scaleTo
      console.log(offset, type, height)
      var simlaneXTotalHeight = 0
      for (var i = 0; i < jq('.swimlaneX').length - 1; i++) {
        simlaneXTotalHeight += jq('.swimlaneX').eq(i).height()
      }
      console.log(me.isUpDownProcess)
      if (!me.isUpDownProcess) {
        return true
      }
      if (type === 'process') {
        if ((offset.top + height) > jq('.swimlaneX:nth-of-type(1)').height() && offset.top < simlaneXTotalHeight) {
          return false
        } else {
          return true
        }
      } else {
        //console.log(jq('.swimlaneX:nth-of-type(1)').height(), simlaneXTotalHeight, basFlow.scaleTo, basFlow.scaleTo * 35)
        // if (offset.top > jq('.swimlaneX:nth-of-type(1)').height() && (offset.top + height - basFlow.scaleTo * 35) < simlaneXTotalHeight) {
          if (offset.top > jq('.swimlaneX:nth-of-type(1)').height() && (offset.top + height) < simlaneXTotalHeight) {
          return true
        } else {
          return false
        }
      }
    },
    // 初始化泳道
    _initSwimlane: function (type) {
      var me = this,
        i;
      if (!me.options.swimlane) return;

      me.swimlaneTempl = doT.template(jq('#swimlane_templ').text());
      var $swimlaneBox = me.$swimlaneBox = jq('<div class="swimlane-box" id="swimlane-box"></div>');

      $swimlaneBox.on('dblclick', '.J_swimlaneTitle', function () {
        if (!me.isEdit) return false;
        //console.log(me.id)
        var $this = jq(this),
          $parent = $this.parent(),
          id = $parent[0].id,
        // if (id && !!me.swimlanes[id].isOperable) {
        //   me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
        //   return
        // }
        attrName = this.getAttribute('data-attrName') || 'name',
          oldTxt = this.innerHTML,
          t = me._getToWorkOffset($this.offset(), me.$work);
        if (jq(".swimlaneX-list .swimlaneX:last").attr("id") === id && me.isUpDownProcess) {
          me.alertBox(jq.i18n.prop("noEditDown") + "! ", "danger");
          return;
        }
        if (jq(".swimlaneX-list .swimlaneX:first").attr("id") === id && me.isUpDownProcess) {
          me.alertBox(jq.i18n.prop("noEditUp") + "! ", "danger");
          return;
        }

        // if ($this.parent().attr("class").indexOf("swimlaneX") > -1){
        $this = $this.find("span");
        attrName = $this.attr('data-attrName') || 'name';
        oldTxt = $this.text();
        // }

        me.$textArea.blur().val(oldTxt).css({
          display: "block",
          position: "absolute",
          height: this.offsetHeight - 2,
          width: this.offsetWidth - 2,
          left: t.left * me.scaleTo,
          top: t.top * me.scaleTo,
          zIndex: 999
        }).data({
          dom: this,
          attrName: attrName,
          type: 'swimlane'
        }).focus();
        console.log(jq('#' + id + '.swimlane-title .showMemberTitle'))
      });
      var me = this;
      var $contextMenu = doT.template(jq('#contextMenu').text());
      $swimlaneBox.on('contextmenu', '.J_swimlaneTitle', function (e) {
        if (!me.isEdit) return false;
        e.preventDefault();
        var parentClass = jq(this).parent().attr('class')
        if (
          jq(this).parent().attr('id') == jq(".swimlaneX:first").attr('id') ||
          jq(this).parent().attr('id') == jq(".swimlaneX:last").attr('id')
        ) {
          me.$work.find('#menu').remove();
          return false;
        }
        me.storeSwimlaneId = jq(this).parent().attr('id');
        //console.log('me.storeSwimlaneId11111111111111111', me.storeSwimlaneId, me.swimlanes[me.storeSwimlaneId])
        var obj = {
          left: e.clientX + 'px',
          top: e.clientY + 'px',
          menuList: [
            {
              name: '添加竖泳道',
              class: 'addSwimlaneY',
              disable: parentClass.indexOf('swimlaneY') > -1 ? false : true
            },
            {
              name: '添加横泳道',
              class: 'addSwimlaneX',
              disable: parentClass.indexOf('swimlaneX') > -1 ? false : true
            },
            // {
            //     name: !me.swimlanes[me.storeSwimlaneId].isOperable ? jq.i18n.prop("rigidNode") : jq.i18n.prop("flexibleNode"),
            //     class: 'swimLaneIsOperable',
            //     disable: false
            // }
          ]
        }
        me.$work.find('#menu').remove();
        me.$work.append($contextMenu(obj));
      });

      $swimlaneBox.on('click', '.surChooseLeadersAdd', function () {
        me.storeSwimlaneId = jq(this).parent().attr('id');
        //console.log('  me.storeSwimlaneId', me.storeSwimlaneId);
        if (jq(this).attr("data-isallowed") === 'true' || (!me.isEdit && !me.isReadAttr)) return false;
        // me.addSwimlane('x', '泳道横', {}, true, true);
        me.addSwimlane(me.options.swimMember == 'swimlaneX' ? 'x' : 'y', '泳道横', {}, true, true);
      })
      $swimlaneBox.on('click', '.addSwimlaneY', function () {
        me.storeSwimlaneId = jq(this).parent().parent().attr('id');
        if (jq(this).attr("data-isallowed") === 'true' || (!me.isEdit && !me.isReadAttr)) return false;
        // me.addSwimlane('y', '泳道竖', {}, true, true);
        me.addSwimlane(me.options.swimMember == 'swimlaneX' ? 'y' : 'x', '泳道竖', {}, true, true);
      })

      jq('body').on('click', '#menu .addSwimlaneY', function () {
        if (jq(this).attr("data-isallowed") === 'true' || (!me.isEdit && !me.isReadAttr)) return false;
        me.addSwimlane('y', '泳道竖', {}, true, true);
      })

      jq('body').on('click', '#menu .addSwimlaneX', function () {
        if (jq(this).attr("data-isallowed") === 'true' || (!me.isEdit && !me.isReadAttr)) return false;
        me.addSwimlane('x', '泳道横');
      })
      jq('body').on('click', '#menu .swimLaneIsOperable', function () {
        if (!me.isEdit && !me.isReadAttr) return;
        me.swimlanes[me.storeSwimlaneId].isOperable = !me.swimlanes[me.storeSwimlaneId].isOperable
      })

      // $swimlaneBox.on('dblclick', '.timeLine', function () {
      //   if (!me.isEdit) return false;
      //   var $this = jq(this),
      //     $parent = $this.parent(),
      //     id = $parent[0].id,
      //     attrName = this.getAttribute('data-attrtime') || 'time',
      //     oldTxt = this.innerHTML,
      //     t = me._getToWorkOffset($this.offset(), me.$work);
      //   if (oldTxt.indexOf(jq.i18n.prop("day")) > -1) {
      //     oldTxt = jq.i18n.prop("day") == '天' ? oldTxt.replace(/天/g, '') : oldTxt.replace(/day/g, '');
      //   }
      //   me.$textArea.blur().val(oldTxt).css({
      //     display: "block",
      //     position: "absolute",
      //     height: parseFloat($this.css("height")) * me.scaleTo,
      //     width: parseFloat($this.css("width")) * me.scaleTo,
      //     left: t.left * me.scaleTo,
      //     top: t.top * me.scaleTo,
      //     zIndex: 999
      //   }).data({
      //     dom: this,
      //     attrTime: attrName,
      //     type: 'swimlane'
      //   }).focus();
      // });

      $swimlaneBox.on('click', '.delImg', function () {
        if (!me.isEdit) return false;
        console.log(me.curId[0])
        if (!me.curId[0]) return;
        if (me.curId[0].indexOf('SWIMLANE') === -1) return;
        if (me.curId[0] && jq(".swimlaneX-list .swimlaneX:last").attr("id") === me.curId[0] && me.isUpDownProcess) {
          me.alertBox(jq.i18n.prop("noDelDown") + "! ", "danger");
          return;
        }
        if (me.curId[0] && jq(".swimlaneX-list .swimlaneX:first").attr("id") === me.curId[0] && me.isUpDownProcess) {
          // if (!me.isUpDownProcess) {
          //   me.alertBox("当前只存在一条泳道，不能删除! ", "danger");
          // } else {
            me.alertBox(jq.i18n.prop("noDelUp") + "! ", "danger");
          // }
          return;
        }
        for (var i in me.controls) {
          if (me.controls[i].bindSwimXId === me.curId[0] || me.controls[i].bindSwimYId === me.curId[0]) {
            me.alertBox(jq.i18n.prop("SwimCannotDeleted") + "! ", "danger");
            return;
          }
        }
        me.delSwimlane(me.curId[0]);
        me.computedHeight();
        me.computedWidth();
      });


      var swimlane = jq.isArray(me.options.swimlane) ? me.options.swimlane : me.options.swimlane.split(',');
      // 生成泳道area
      for (i = 0; i < swimlane.length; i++) {
        var laneType = swimlane[i].toLowerCase();

        // 横向泳道
        if (laneType == 'x') {
          me.$swimlaneX = jq('<div class="swimlaneX-list"></div>');
          me.$swimlaneX.appendTo($swimlaneBox);
        }

        // 纵向泳道
        if (laneType == 'y') {
          me.$swimlaneY = jq('<div class="swimlaneY-list"></div>');
          me.$swimlaneY.appendTo($swimlaneBox);
        }
      }

      $swimlaneBox.appendTo(me.$work);
      var isSwimlaneY = !!me.$swimlaneY,
        isSwimlaneX = !!me.$swimlaneX;

      // 获取焦点
      me.$swimlaneBox.on('click', '.swimlaneX,.swimlaneY', function (e) {
        me.focusItem(this.id, "single");
      });


      if (isSwimlaneX) {
        me.$swimlaneX.sortable({
          axis: 'y',
          handle: '.J_swimlaneTitle',
          tolerance: 'pointer',
          revert: true,
          start: function (event, ui) {
            me.referIfMove = true;
            // ui.draggable("disable");
            ui.placeholder.height(ui.item.height());
            // me.$swimlaneX.sortable( "refreshPositions" );
          },
          update: function (event, ui) {
            // a.a = 1;
            console.log(event, ui, ui.item[0].id, me.swimlanes[ui.item[0].id]);
            if (!!me.swimlanes[ui.item[0].id]) {
              console.log(event, ui, ui.item[0].id, me.swimlanes[ui.item[0].id], jq(".swimlaneX-list .swimlaneX"), jq(".swimlaneX-list .swimlaneX:first").text(), jq(".swimlaneX-list .swimlaneX:last").text());
              if (!!me.swimlanes[ui.item[0].id] &&
                  (me.swimlanes[ui.item[0].id].name == "上游流程" || me.swimlanes[ui.item[0].id].name == "下游流程" ||
                  jq(".swimlaneX-list .swimlaneX:first").text() != '上游流程' ||
                  jq(".swimlaneX-list .swimlaneX:last").text() != '下游流程')) {
                  basFlow.alertBox(jq.i18n.prop("upperAndLowerSwimCannotBeDragged") + "! ", 'danger');
                  return false;
              }
            }
          },
          stop: function (event, ui) {
            var id = ui.item[0].id;
            me.linkMove(id, 'moveAndResizeX', "sort", id)
          }
        });
      }

      if (isSwimlaneY) {
        me.$swimlaneY.sortable({
          axis: 'x',
          handle: '.J_swimlaneTitle',
          tolerance: 'pointer',
          revert: true,
          start: function (event, ui) {
            me.referIfMove = true;
            ui.placeholder.width(ui.item.width());
            // me.$swimlaneX.sortable( "refreshPositions" );
          },
          stop: function (event, ui) {
            var id = ui.item[0].id
            me.linkMove(id, 'moveAndResize', "sort")
          }
        });
      }

      if ( !me.isEdit || !me.options.haveTools) return;

      // 初始化左边栏泳道工具
      // var templ = '<li></li>';
      var templ = '';
      if (isSwimlaneX && me.toolsGroup[0].controls.indexOf('swimlaneX') > -1) {
        templ += '<li><div data-lane="x" class="tools tools_img tools-click J_laneX" title="' + jq.i18n.prop("acrosSwimLane") + '"><img class="process07" src="./' + me.options.toolsPath + '/process07.png"><p>' + jq.i18n.prop("acrosSwimLane") + '</p></div></li>';
      }

      if (isSwimlaneY && me.toolsGroup[0].controls.indexOf('swimlaneY') > -1) {
        templ += '<li><div data-lane="y" class="tools tools_img tools-click  J_laneY" title="' + jq.i18n.prop("verticalSwimLane") + '"><img class="process08" src="./' + me.options.toolsPath + '/process09.png"><p>' + jq.i18n.prop("verticalSwimLane") + '</p></div></li>';
      }
      if (type !== 'Update') { // 避免重新加载流程时  重复添加
        me.$toolsBox.find('.tools-base').append(templ);
      }

      if (isSwimlaneX) {

        me.$toolsBox.find('.J_laneX').on('click', function () {
          me.addSwimlane('x', '泳道横', {}, true);
        });
      }

      if (isSwimlaneY) {
        me.$toolsBox.find('.J_laneY').on('click', function () {
          me.addSwimlane('y', '泳道竖');
        });
      }




    },

    // 初始化布局
    _initLayout: function () {
      var me = this;
      jq(window).on('resize', function () {
        var height = me.options.height || jq(window).height(),
          workHeight = me.options.haveHead ? height - me.$head.height() : height,
          workWidth = me.$work.width() * 2;

        if (!!me.isEdit) {
          me.$tools.css('height', workHeight - 1);
        }
        me.$work.css('height', workHeight);

        var workAreaTop = 0,
          workAreaLeft = 0;

        if (me.$swimlaneBox) {
          me.$swimlaneBox.css({
            height: me.initSvgHeight + me.swimYheight + (me.swimYheight == 90 ? 0 : 35) * me.scaleTo,
            width: (me.initSvgWidth + me.swimXwidth + (me.swimYheight == 90 ? 35 : 0)) * me.scaleTo,
            background: '#fff'
          });
        }

        if (me.$swimlaneX) {
          workAreaLeft = me.swimXwidth;
          var laneXtop = me.$swimlaneY ? (me.swimYheight + 1) : 0;
          me.$swimlaneX.css({
            width: (me.initSvgWidth + me.swimXwidth + (me.swimYheight == 90 ? 35 : 0)) * me.scaleTo,
            height: me.initSvgHeight * me.scaleTo,
            marginTop: laneXtop * me.scaleTo
          });
        }


        if (me.$swimlaneY) {
          workAreaTop = me.swimYheight;
          var laneYleft = me.$swimlaneX ? me.swimXwidth : 0;
          me.$swimlaneY.css({
            width: me.initSvgWidth * me.scaleTo,
            height: (me.initSvgHeight + me.swimYheight + (me.swimYheight == 90 ? 0 : 35)) * me.scaleTo,
            marginLeft: laneYleft * me.scaleTo
          });
        }

        // 工作控件高度。默认为容器高度的三倍
        me.$workArea.css({
          width: me.initSvgWidth * me.scaleTo,
          top: workAreaTop * me.scaleTo,
          left: workAreaLeft * me.scaleTo
        });
        jq(me.$draw).css({
          width: me.initSvgWidth * me.scaleTo,
          height: me.initSvgHeight * me.scaleTo
        });
        me.computedHeight()
        me.computedWidth()
      }).trigger('resize');
    },



    /**
     * 增加工具组
     *
     * @param {String}
     * @param {Object}
     */
    _addToolsGroup: function (title, group) {
      if (!jq.isArray(group) || group.length == 0) {
        return '';
      }
      var templ = '',
        i;
      templ += '<h4 class="tools-title">' + '111' + '</h4>';
      templ += '<ul class="tools-group">';
      for (i = 0; i < group.length; i++) {
        templ += '<li><div data-drag="' + group[i].drag + '" class="tools"></div></li>'; // <span class="' + group[i].icon + '"></span><span></span>
      }
      templ += '</ul>';

      this.$toolsBox.append(templ);
    },


    _createPlanArea: function () {

    },


    /**
     * 获取鼠标相对工作区间距离
     *
     * @param {Object}
     *            如果为空则取鼠标距离
     * @return {Object}
     */
    _getToWorkOffset: function (offset, wk) {
      if (offset.pageX) {
        offset = {
          left: offset.pageX,
          top: offset.pageY
        }
      }
      var $wk = wk || this.$workArea,
        workOffset = $wk.offset(),
        sT = $wk.scrollTop(),
        sL = $wk.scrollLeft();
      return {
        left: (offset.left - workOffset.left + sL) / this.scaleTo,
        top: (offset.top - workOffset.top + sT) / this.scaleTo
        // left: (offset.left - workOffset.left + sL),
        // top: (offset.top - workOffset.top + sT)
      }
    },

    /**
     * 切换工作状态
     */
    _switchEditType: function (type) {
      var me = this;
      if (!me.isEdit || me.editType == type) return;
      console.log(4)
      me.blurItem();
      if (type == me.EditEnum.SELECT) {
        jq.each(me.controls, function () {
          this.$el.draggable("enable");
          this.$el.resizable("enable");
        });
      } else {
        jq.each(me.controls, function () {
          this.$el.draggable("disable");
          this.$el.resizable("disable");
        });
      }

      me.editType = type;
      //console.log(me.$switchGroup)
      me.$switchGroup.removeClass('active').filter(function () {
        return this.getAttribute('data-switchtype') == type;
      }).addClass('active');
      // jq('.J_dotted_line').removeClass('active')
    },
    // _switchDottedEditType虚线切换工作状态
    _switchDottedEditType: function (type) {
      var me = this;
      //console.log(me.$switchGroup, me.isEdit, me.editDottedType, type)
      if (!me.isEdit || me.editDottedType == type) return;

      me.blurItemDotted();
      if (type == me.EditEnum.SELECT) {
        jq.each(me.controls, function () {
          this.$el.draggable("enable");
          this.$el.resizable("enable");
        });
      } else {
        jq.each(me.controls, function () {
          this.$el.draggable("disable");
          this.$el.resizable("disable");
        });
      }

      me.editDottedType = type;
      // jq('.J_dotted_line').addClass('active');
      // me.$switchGroup.removeClass('active')
      jq('.J_dotted_line').removeClass('active').filter(function () {
        return this.getAttribute('data-switchtype') == type;
      }).addClass('active');
    },

    /**
     * 向工作空间中添加泳道
     */
    addSwimlane: function (laneType, name, obj, lastAdd, indexBool) {
      if (obj === undefined) {
        obj = {}
      }
      var me = this,
        laneType = laneType.toLowerCase()
      var swimType = "swimlane" + laneType.toUpperCase();
      var swimObj = {};
      swimObj = JSON.parse(JSON.stringify(me.ToolsConfig[swimType]))
      //console.log(swimObj)
      //console.log(obj)
      var obj = jq.extend(swimObj, JSON.parse(JSON.stringify(obj)));
      obj = jq.extend({
        height: this.swimLineWidth,
        width: laneType == "y" ? this.swimLineYWidth : this.swimLineWidth
      }, obj);
      obj.id = obj.id || GooFlow.getUID('SWIMLANE');

      if (laneType == 'x') {
        obj.width = me.initSvgWidth + me.swimXwidth;
      }
      if (laneType == 'y') {
        obj.height = me.initSvgHeight + me.swimYheight;
      }

      // 判断竖向还是横向
      obj.showMember = me.swimYheight === 90 ? 'swimlaneY' : 'swimlaneX'


      me.swimlanes[obj.id] = obj;
      if (laneType == 'x') {
        if (!me.$swimlaneX) return;
        window.$swimlaneX = me.$swimlaneX;
        var $item = jq(me.swimlaneTempl(obj));
        if (!indexBool) {
          if (me.$swimlaneX.find(".swimlaneX:last").length) {
            //console.log('这是第一个判断');
            var swimlaneX = me.$swimlaneX.find(".swimlaneX:last");
            swimlaneX.before($item)
          } else {
            me.$swimlane.$append($item);
          }
        } else {
          var index = 0;
          jq(".swimlaneX").each(function () {
            if (me.storeSwimlaneId == jq(this).attr('id')) {
              index = jq(".swimlaneX").index(jq(this));
              return false
            }
          })
          var swimlaneX = me.$swimlaneX.find(".swimlaneX").eq(index);
          swimlaneX.after($item)
        }

        $item.css({
          height: obj.height
        });
        if (indexBool) {
          me.changeScaleLine(true, function () {
            me.linkMove($item.id, 'moveAndResizeX', '', '')
          })
        }

        var tempStr = "";
        for (var m = 0; m < obj.depts.length; m++) {
          tempStr += (m == 0 ? "" : ",") + obj.depts[m].name;
        }
        jq("#" + obj.id + " .J_swimlaneTitle").attr("title", (tempStr ? tempStr : ''));

        $item.resizable({
          handles: 's',
          minHeight: me.swimMinLineWidth * me.scaleTo,
          resize: function (e,ui) {
            // var id = ui.element.attr('id');
            // $("#" + id + " .timeLine").css("height", '100%');
          },
          start: function (e, ui) {
            // me.changeScaleLine()
            var id = ui.element.attr('id');
            $("#" + id + " .timeLine").css("height", '100%');
          },
          stop: function (e, ui) {
            var id = ui.element.attr('id');
            me.swimlanes[id].height = ui.size.height / me.scaleTo;
            me.linkMove(id, 'moveAndResizeX')
            me.computedHeight()
            me.computedWidth()
          }
        });
        $item = null;
        if (me.swimlanes[obj.id].depts.length > 0) {
          var tempDepts = "";
          var tempStation = "";
          var tempRole = "";
          for (var m = 0; m < me.swimlanes[obj.id].depts.length; m++) {
            var temStore = me.swimlanes[obj.id];
            // tempDepts += (m == 0 ? "" : ",") + temStore.depts[m].upLeveldeptname + (!temStore.depts[m].deptTopname ? '' : '(' + temStore.depts[m].deptTopname + ')');
            // tempStation += (m == 0 ? "" : ",") + temStore.depts[m].name;
          }
          // if (!!temStore && !!temStore.depts && temStore.depts.length > 0) {
          //   jq("#" + obj.id + " .J_swimlaneTitle p").html(jq.i18n.prop("depts") + ':' + temStore.depts[0].upLeveldeptname + (!temStore.depts[0].deptTopname ? '' : '(' + temStore.depts[0].deptTopname + ')') + (temStore.depts.length > 1 ? '...' : '') + '<br />' + jq.i18n.prop("station") + ':' + temStore.depts[0].name + (temStore.depts.length > 1 ? '...' : ''));
          //   jq("#" + obj.id + " .J_swimlaneTitle p").attr({
          //     'title': jq.i18n.prop("depts") + ':' + tempDepts + '\n' + jq.i18n.prop("station") + ':' + tempStation
          //   });
          // }
          tempDepts = me.swimlanes[obj.id].depts.map((item, index) => { return (item.type == '3' || item.type == '5') ? (!item.deptTopname ? item.upLeveldeptname:(item.deptTopname + '(' + item.upLeveldeptname + ')') ) : ''}).filter(d=>d).join(',')
          tempStation = me.swimlanes[obj.id].depts.map((item, index) => { return (item.type == '3' || item.type == '5') ?  item.name : ''}).filter(d=>d).join(',')
          tempRole = me.swimlanes[obj.id].depts.map((item, index) => { return (item.type != '3' && item.type != '5') ? item.name : ''}).filter(d=>d).join(',')
          if (!!temStore && !!temStore.depts && temStore.depts.length > 0) {
            if (!tempDepts) {
              jq("#" + obj.id + " .J_swimlaneTitle p").html(jq.i18n.prop("role") + ':' + tempRole);
              jq("#" + obj.id + " .J_swimlaneTitle p").attr({
                'title': jq.i18n.prop("role") + ':' + tempRole
              });
            } else {
              jq("#" + obj.id + " .J_swimlaneTitle p").html(jq.i18n.prop("depts") + ':' + tempDepts + '<br />' + jq.i18n.prop("station") + ':' + tempStation + '<br />' + jq.i18n.prop("role") + ':' + tempRole);
              jq("#" + obj.id + " .J_swimlaneTitle p").attr({
                'title': jq.i18n.prop("depts") + ':' + tempDepts + '\n' + jq.i18n.prop("station") + ':' + tempStation + '\n' + jq.i18n.prop("role") + ':' + tempRole
              });
            }
          }
        }


        me.computedHeight()
        me.computedWidth()
        me.linkMove(null, 'moveProcess')
      }


      if (laneType == 'y') {
        if (!me.$swimlaneY) return;
        window.$swimlaneY = me.$swimlaneY;
        var $item = jq(me.swimlaneTempl(obj));

        if (!indexBool) {
          me.$swimlaneY.append($item);
        } else {
          var index = 0;
          jq(".swimlaneY").each(function () {
            if (me.storeSwimlaneId == jq(this).attr('id')) {
              index = jq(".swimlaneY").index(jq(this));
              return false
            }
          })
          var swimlaneY = me.$swimlaneY.find(".swimlaneY").eq(index);
          swimlaneY.after($item)
        }

        $item.css({
          width: obj.width
        });
        if (indexBool) {
          me.changeScaleLine(true, function () {
            me.linkMove($item.id, 'moveAndResize')
          })
        }
        $item.resizable({
          handles: 'e',
          minWidth: me.swimMinLineWidth * me.scaleTo,
          resize: function (e, ui) {
            var id = ui.element.attr('id');
            me.swimlanes[id].width = ui.size.width / me.scaleTo;
            jq("#" + id + " .timeLine").css("width", me.swimlanes[id].width);
            jq("#" + id + ".swimlaneY .swimlane-title span").css({
              "width": (me.swimlanes[id].width - 20)
            })
            // // 解决在 泳道类型为“swimlaneY”时，调整竖泳道宽度时，文字宽度未变化的问题
            // $('.swimlaneY>.swimlane-title.J_swimlaneTitle').css({
            //   'width': '100%'
            // })
            me.computedWidth()
          },
          start: function (e, ui) {
            // 解决在 泳道类型为“swimlaneY”时，调整竖泳道宽度时，文字宽度未变化的问题
            $('.swimlaneY>.swimlane-title.J_swimlaneTitle').css({
              'width': '100%'
            })
          },
          stop: function (e, ui) {
            var id = ui.element.attr('id');
            me.swimlanes[id].width = ui.size.width / me.scaleTo;
            me.linkMove(id, 'moveAndResize')
            jq("#" + id + ".swimlaneY .swimlane-title span").css({
              "width": (me.swimlanes[id].width - 20)
            })
            me.computedWidth()
          }
        });
        $item = null;
        me.computedWidth()
      }

      for (var key in me.swimlanes) {
        if (me.swimlanes[key].type == 'swimlaneY') {
          jq("#" + me.swimlanes[key].id).find(".J_swimlaneTitle").css({
            "top": me.storeScroll.top
          })
          jq("#" + me.swimlanes[key].id).find(".rightImgPart,.leftImgPart").css({
            "top": me.storeScroll.top
          })
          jq("#" + me.swimlanes[key].id).find(".ui-resizable-handle.ui-resizable-e").css({
            "top": me.storeScroll.top
          })
          jq("#" + me.swimlanes[key].id).find(".delImg").css({
            "top": me.storeScroll.top + 2
          })
        } else if (me.swimlanes[key].type == 'swimlaneX') {
          jq("#" + me.swimlanes[key].id).find(".J_swimlaneTitle").css({
            "left": me.storeScroll.left
          })
          jq("#" + me.swimlanes[key].id).find(".ui-resizable-handle.ui-resizable-s").css({
            "left": me.storeScroll.left
          })
          jq("#" + me.swimlanes[key].id).find(".surChooseLeaders").css({
            "left": 85 * me.scaleTo + me.storeScroll.left
          })
          jq("#" + me.swimlanes[key].id).find(".surChooseLeadersAdd").css({
            "left": (85 * me.scaleTo + me.storeScroll.left) - 75 > 0 ? (85 * me.scaleTo + me.storeScroll.left) - 75 : 2
          })
          jq("#" + me.swimlanes[key].id).find(".delImg").css({
            "left": me.storeScroll.left + 2
          })
        }
      }

      if (!indexBool) {
        me.changeScaleLine(true)
        // 链接泳道
        me.linkage()
      }

      me.ctrlZlist.push({
        method: 'add',
        type: 'swimlane',
        data: JSON.parse(JSON.stringify(me.swimlanes[obj.id])),
        id: obj.id
      })


    },

    /**
     * 删除工作空间中泳道
     */
    delSwimlane: function (id) {
      var me = this;
      if (!me.swimlanes[id]) return;
      if (me.swimlanes[id].type === 'swimlaneX') {
        let swimlaneXTop = 0 // 记录上游泳道距离改泳道的高度
        for (var i = 0; i < jq(".swimlaneX-list .swimlaneX").length; i++) {
          if (jq(".swimlaneX-list .swimlaneX").eq(i).attr('id') === id) {
            break
          }
          swimlaneXTop += jq(".swimlaneX-list .swimlaneX").eq(i).height()
          console.log(jq(".swimlaneX-list .swimlaneX").eq(i).attr('id'), jq(".swimlaneX-list .swimlaneX").eq(i).height())
        }
        for (var i in me.controls) {
          if (me.controls[i].top > swimlaneXTop && me.controls[i].rename !== '上下游流程') {
            me.controls[i].top -= me.swimlanes[id].height
            jq("#" + me.controls[i].id).remove();
            me.addControl(me.controls[i], true);
            // 重画转换线
            me.resetLines(me.controls[i].id, me.controls[i]);
          }
        }
      } else {
        let swimlaneXLeft = 0 // 记录泳道竖距离改泳道的高度
        for (var i = 0; i < jq(".swimlaneY-list .swimlaneY").length; i++) {
          if (jq(".swimlaneY-list .swimlaneY").eq(i).attr('id') === id) {
            break
          }
          swimlaneXLeft += jq(".swimlaneY-list .swimlaneY").eq(i).width()
          console.log(jq(".swimlaneY-list .swimlaneY").eq(i).attr('id'), jq(".swimlaneY-list .swimlaneY").eq(i).width())
        }
        for (var i in me.controls) {
          if (me.controls[i].left > swimlaneXLeft) {
            me.controls[i].left -= me.swimlanes[id].width
            jq("#" + me.controls[i].id).remove();
            me.addControl(me.controls[i], true);
            // 重画转换线
            me.resetLines(me.controls[i].id, me.controls[i]);
          }
        }
      }
      // 撤销代码
      me.ctrlZlist.push({
        method: 'del',
        type: 'swimlane',
        data: JSON.parse(JSON.stringify(me.swimlanes[id])),
        id: id
      })

      jq('#' + id).remove();
      delete me.swimlanes[id];
      me.linkMove(null, 'moveProcess')

      me.linkage()
    },

    /**
     * 向工作空间中添加控件
     *
     * @param {String}
     *            控件类型
     * @param {Object}
     *            控件offset
     */
    addControl: function (obj, bool) {
      var me = this;
      if (!obj.type) {
        return;
      }
      let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
      if ((obj.type == 'processInput' || obj.type == 'processOutput' || obj.type == 'KSF' || obj.type == 'KCP' || obj.type == 'processForm') && !processInfo.processType) { // 判断类型为输入 输出时  不添加节点  只往节点上添加输入输出
        for (var key in me.controls) {
          let con_left = Number(me.controls[key].left)
          let con_top = Number(me.controls[key].top)
          let con_width = Number(me.controls[key].width)
          let con_height = Number(me.controls[key].height)

          let card_left = Number(obj.left)
          let card_top = Number(obj.top)
          let card_height = Number(me.ToolsConfig[obj.type].height)
          let card_width = Number(me.ToolsConfig[obj.type].width)
          if (me.controls[key].img == 'processTask.png' || me.controls[key].img == 'processIt.png' || me.controls[key].img == 'process15.png') { // 判断是否为任务节点
            let isInclude = false
            if (con_left <= card_left && (con_left + con_width) >= card_left && con_top <= card_top && (con_top + con_height) >= card_top) { // 判断添加的输出、输入是否在任务节点内
              isInclude = true
              //console.log(1, me.controls[key])
            }
            if (con_left <= (card_left + card_width) && (con_left + con_width) >= (card_left + card_width) && con_top <= card_top && (con_top + con_height) >= card_top) { // 判断添加的输出、输入是否在任务节点内
              isInclude = true
              //console.log(2, me.controls[key])
            }
            if (con_left <= card_left && (con_left + con_width) >= card_left && con_top <= (card_top + card_height) && (con_top + con_height) >= (card_top + card_height)) { // 判断添加的输出、输入是否在任务节点内
              isInclude = true
              //console.log(3, me.controls[key])
            }
            if (con_left <= (card_left + card_width) && (con_left + con_width) >= (card_left + card_width) && con_top <= (card_top + card_height) && (con_top + con_height) >= (card_top + card_height)) { // 判断添加的输出、输入是否在任务节点内
              isInclude = true
              //console.log(4, me.controls[key])
            }
            if (isInclude && obj.type == 'processInput' && !me.controls[key].inputDesc) {
              me.controls[key].inputDesc = '输入'
              jq("#" + me.controls[key].id).remove()
              me.addControl(me.controls[key], true);
              return
            }
            if (isInclude && obj.type == 'processOutput' && !me.controls[key].outputDesc) {
              me.controls[key].outputDesc = '输出'
              jq("#" + me.controls[key].id).remove()
              me.addControl(me.controls[key], true);
              return
            }
            if (isInclude && (obj.type == 'KSF' || obj.type == 'KCP' || obj.type == 'processForm')) {
              console.log(me.controls[key].id)
              jq("#" + me.controls[key].id).remove();
              me.addControl(me.controls[key], true);
              jq('#' + me.controls[key].id).addClass('cur')
              me.curId[0] = key
              me.$attrBtnBox.find('.ico_icon-attribute').click()
              me.$attrBtnBox.children().children().removeClass('active').eq(1).addClass('active')
              me.$attrContentBox.children().siblings().hide().eq(1).show()
              for (var i = 0; i < jq("#pointAttr li").length; i++) {
                if (jq("#pointAttr li").eq(i).text() === jq.i18n.prop(obj.type)) {
                    jq("#pointAttr li").eq(i).siblings().removeClass("active");
                    jq("#pointAttr li").eq(i).addClass("active");
                    jq(".attr1Box").children().siblings().css("display", "none");
                    jq(".attr1Box").children().eq(i).css("display", "block");
                    break;
                }
              }
            }
          }
        }
        return
      }
      var ctl = new GooFlow.Control(obj, me.options);

      me.ctrlZlist.push({
        method: 'add',
        type: 'control',
        id: ctl.id,
        data: obj
      })
      ctl.syncUI();
      me.controls[ctl.id] = ctl;
      jq(ctl.$el).css("transform", "scale(" + me.scaleTo + ")")
      jq(ctl.$el).css("left", ctl.left * me.scaleTo)
      jq(ctl.$el).css("top", ctl.top * me.scaleTo)
      me.$workArea.append(ctl.$el);

      if (!bool) {
        // 判断上下游流程
        me.referUpAndDownProcess()

        // 链接泳道
        me.linkage()
      }
    },

    // 控制任务 移动返回
    moveControl: function (obj, bool) {
      var me = this;
      var data = obj.data.controls[obj.id]
      if (!data.type) {
          return;
      }
      var ctl = new GooFlow.Control(data, me.options);
      console.log(ctl)

      me.ctrlZlist.push({
          method: 'move',
          type: 'control',
          id: ctl.id,
          data: {
              ids: ctl.id,
              controls: JSON.parse(JSON.stringify(me.controls)),
              lines: JSON.parse(JSON.stringify(me.lines))
          }
      })

      jq('#' + obj.id).remove();
      delete me.swimlanes[obj.id];

      ctl.syncUI();
      me.controls[ctl.id] = ctl;
      jq(ctl.$el).css("transform", "scale(" + me.scaleTo + ")")
      jq(ctl.$el).css("left", ctl.left * me.scaleTo)
      jq(ctl.$el).css("top", ctl.top * me.scaleTo)
      me.$workArea.append(ctl.$el);
      console.log(me.controls)
      if (!bool) {
          // // 判断上下游流程
          // me.referUpAndDownProcess()
          //
          // // 链接泳道
          // me.linkage()
          console.log(11, ctl.id, ctl)
          // 重画转换线
          me.resetLines(ctl.id, ctl);

      }
    },

    // 判断是否是上下游流程
    referUpAndDownProcess: function () {
      var me = this;
      for (var key in me.controls) {
        if (me.controls[key].img.indexOf('process.png') > -1) {
          if (me.controls[key].top < parseFloat(jq(".swimlaneX").eq(0).css("height"))) {
            me.controls[key].splitType = 'upProcess'
          }
          else if (jq(".swimlaneX").eq(jq(".swimlaneX").length - 1).position()) {
            if (me.controls[key].top > jq(".swimlaneX").eq(jq(".swimlaneX").length - 1).position().top) {
              me.controls[key].splitType = 'downProcess'
            }
            else {
              me.controls[key].splitType = ''
              if (me.controls[key].inputname) {
                me.controls[key].inputname = ''
              }
              if (me.controls[key].outputname) {
                me.controls[key].outputname = ''
              }
            }
          }
          else {
            me.controls[key].splitType = ''
            if (me.controls[key].inputname) {
              me.controls[key].inputname = ''
            }
            if (me.controls[key].outputname) {
              me.controls[key].outputname = ''
            }
          }
        }
      }
    },

    // 增加控件和阶段联调
    linkage: function (id) {
      var me = this
      if (id) {
        if (me.controls[id].bindSwimYId) {
          me.controls[id].bindSwimYId = ''
        }
        if (me.controls[id].bindSwimXId) {
          me.controls[id].bindSwimXId = ''
        }
        for (var keyC in me.swimlanes) {

          if (jq("#" + me.swimlanes[keyC].id).position()) {
            if (me.swimlanes[keyC].type === 'swimlaneY') {
              if (me.controls[id].bindSwimYId) {
                continue
              }
              if ((me.controls[id].left * me.scaleTo) > jq("#" + me.swimlanes[keyC].id).position().left) {
                if ((me.controls[id].left * me.scaleTo + me.controls[id].width * me.scaleTo) < (jq("#" + me.swimlanes[keyC].id).position().left + parseFloat((jq("#" + me.swimlanes[keyC].id).css("width"))))) {
                  me.controls[id].bindSwimYId = me.swimlanes[keyC].id
                  me.controls[id].bindSwimYOffsetX = jq("#" + me.swimlanes[keyC].id).position().left
                  me.controls[id].bindSwimYOffsetY = jq("#" + me.swimlanes[keyC].id).position().top
                  jq('#' + me.controls[id].id).removeClass('lineWarn')
                }
                else {
                  me.controls[id].bindSwimYId = ''
                  me.controls[id].bindSwimYOffsetX = ''
                  me.controls[id].bindSwimYOffsetY = ''
                  jq('#' + me.controls[id].id).addClass('lineWarn')
                }
              }
              else {
                me.controls[id].bindSwimYId = ''
                me.controls[id].bindSwimYOffsetX = ''
                me.controls[id].bindSwimYOffsetY = ''
                jq('#' + me.controls[id].id).addClass('lineWarn')
              }
              if (!me.controls[id].bindSwimXId) {
                jq('#' + me.controls[id].id).addClass('lineWarn')
              }
            }
            if (me.swimlanes[keyC].type === 'swimlaneX') {
              if (me.controls[id].bindSwimXId) {
                continue
              }
              if ((me.controls[id].top * me.scaleTo) > jq("#" + me.swimlanes[keyC].id).position().top) {
                if ((me.controls[id].top * me.scaleTo + me.controls[id].height * me.scaleTo) < (jq("#" + me.swimlanes[keyC].id).position().top + parseFloat(jq("#" + me.swimlanes[keyC].id).css("height")))) {
                  me.controls[id].bindSwimXId = me.swimlanes[keyC].id
                  me.controls[id].bindSwimXOffsetX = jq("#" + me.swimlanes[keyC].id).position().left
                  me.controls[id].bindSwimXOffsetY = jq("#" + me.swimlanes[keyC].id).position().top
                  jq('#' + me.controls[id].id).removeClass('lineWarn')
                }
                else {
                  me.controls[id].bindSwimXId = ''
                  jq('#' + me.controls[id].id).addClass('lineWarn')
                }
              }
              else {
                me.controls[id].bindSwimXId = ''
                me.controls[id].bindSwimXOffsetX = ''
                me.controls[id].bindSwimXOffsetY = ''
                jq('#' + me.controls[id].id).addClass('lineWarn')
              }
              if (!me.controls[id].bindSwimYId) {
                jq('#' + me.controls[id].id).addClass('lineWarn')
              }
            }
          }
        }
      }
      else {
        for (var key in me.controls) {
          if (me.controls[key].bindSwimYId) {
            me.controls[key].bindSwimYId = ''
          }
          if (me.controls[key].bindSwimXId) {
            me.controls[key].bindSwimXId = ''
          }
          for (var keyC in me.swimlanes) {
            if (jq("#" + me.swimlanes[keyC].id).position()) {
              if (me.swimlanes[keyC].type === 'swimlaneY') {
                if (me.controls[key].bindSwimYId) {
                  continue
                }
                if ((me.controls[key].left * me.scaleTo) > jq("#" + me.swimlanes[keyC].id).position().left) {
                  if (((me.controls[key].left + me.controls[key].width) * me.scaleTo) < (jq("#" + me.swimlanes[keyC].id).position().left + parseFloat(jq("#" + me.swimlanes[keyC].id).css("width")))) {
                    me.controls[key].bindSwimYId = me.swimlanes[keyC].id
                    me.controls[key].bindSwimYOffsetX = jq("#" + me.swimlanes[keyC].id).position().left
                    me.controls[key].bindSwimYOffsetY = jq("#" + me.swimlanes[keyC].id).position().top
                    jq('#' + me.controls[key].id).removeClass('lineWarn')
                  }
                  else {
                    me.controls[key].bindSwimYId = ''
                    me.controls[key].bindSwimYOffsetX = ''
                    me.controls[key].bindSwimYOffsetY = ''
                    jq('#' + me.controls[key].id).addClass('lineWarn')
                  }
                }
                else {
                  me.controls[key].bindSwimYId = ''
                  me.controls[key].bindSwimYOffsetX = ''
                  me.controls[key].bindSwimYOffsetY = ''
                  jq('#' + me.controls[key].id).addClass('lineWarn')
                }
                if (!me.controls[key].bindSwimXId) {
                  jq('#' + me.controls[key].id).addClass('lineWarn')
                }
              }
              if (me.swimlanes[keyC].type === 'swimlaneX') {
                if (me.controls[key].bindSwimXId) {
                  continue
                }
                if ((me.controls[key].top * me.scaleTo) > jq("#" + me.swimlanes[keyC].id).position().top) {
                  if (((me.controls[key].top + me.controls[key].height) * me.scaleTo) < (jq("#" + me.swimlanes[keyC].id).position().top + parseFloat(jq("#" + me.swimlanes[keyC].id).css("height")))) {
                    me.controls[key].bindSwimXId = me.swimlanes[keyC].id
                    me.controls[key].bindSwimXOffsetX = jq("#" + me.swimlanes[keyC].id).position().left
                    me.controls[key].bindSwimXOffsetY = jq("#" + me.swimlanes[keyC].id).position().top
                    jq('#' + me.controls[key].id).removeClass('lineWarn')
                  }
                  else {
                    me.controls[key].bindSwimXId = ''
                    me.controls[key].bindSwimXOffsetX = ''
                    me.controls[key].bindSwimXOffsetY = ''
                    jq('#' + me.controls[key].id).addClass('lineWarn')
                  }
                }
                else {
                  me.controls[key].bindSwimXId = ''
                  me.controls[key].bindSwimXOffsetX = ''
                  me.controls[key].bindSwimXOffsetY = ''
                  jq('#' + me.controls[key].id).addClass('lineWarn')
                }
                if (!me.controls[key].bindSwimYId) {
                  jq('#' + me.controls[key].id).addClass('lineWarn')
                }
              }
            }
          }
        }
      }
      me.computedApproveTime(me)

    },

    // 随阶段移动节点
    linkMove: function (id, type, moveType, isMove) {
      //console.log(id);
      //console.log(type);
      //console.log(moveType);
      var me = this;
      //console.log(id, me.swimlanes[id]);
      // if (id && !!me.swimlanes[id].isOperable) {
      //   me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
      //   return
      // }
      //console.log(666)
      var sortLinesAcross = {};
      for (var i in me.lines) {
        // 获取结束/开始结点的数据
        var line = me.lines[i];
        if (moveType == "sort" && ((me.controls[line.from].bindSwimXId != me.controls[line.to].bindSwimXId && type === 'moveAndResizeX') || (me.controls[line.from].bindSwimYId != me.controls[line.to].bindSwimYId && type === 'moveAndResize'))) {
          sortLinesAcross[i] = JSON.parse(JSON.stringify(line));
          var referLineMiddle = 0;
          if (line.type == "lr") {
            referLineMiddle = me.controls[line.from].left < me.controls[line.to].left ? ((line.M > (me.controls[line.from].left + me.controls[line.from].width) && line.M < me.controls[line.to].left) ? -1 : 1) : ((line.M > (me.controls[line.to].left + me.controls[line.to].width) && line.M < me.controls[line.from].left) ? -1 : 1);
          } else {
            referLineMiddle = me.controls[line.from].top < me.controls[line.to].top ? ((line.M > (me.controls[line.from].top + me.controls[line.from].height) && line.M < me.controls[line.to].top) ? -1 : 1) : ((line.M > (me.controls[line.to].top + me.controls[line.to].height) && line.M < me.controls[line.from].top) ? -1 : 1);
          }
          if (line.type == "lr" && referLineMiddle > 0) {
            var fromLeft = (me.controls[line.from].left + me.controls[line.from].width) - line.M;
            var toLeft = (me.controls[line.to].left + me.controls[line.to].width) - line.M;
            sortLinesAcross[i].middle = false;
            sortLinesAcross[i].diffence = Math.abs(fromLeft) < Math.abs(toLeft) ? fromLeft : toLeft;
            sortLinesAcross[i].minControlId = Math.abs(fromLeft) < Math.abs(toLeft) ? me.controls[line.from].id : me.controls[line.to].id;
          } else if (line.type == "tb" && referLineMiddle > 0) {
            var fromTop = (me.controls[line.from].top + me.controls[line.from].height) - line.M;
            var toTop = (me.controls[line.to].top + me.controls[line.to].height) - line.M;
            sortLinesAcross[i].middle = false;
            sortLinesAcross[i].diffence = Math.abs(fromTop) < Math.abs(toTop) ? fromTop : toTop;
            sortLinesAcross[i].minControlId = Math.abs(fromTop) < Math.abs(toTop) ? me.controls[line.from].id : me.controls[line.to].id;
          } else if (line.type == "lr" && referLineMiddle < 0) {
            var fromLeft = me.controls[line.from].left < me.controls[line.to].left ? ((me.controls[line.from].left + me.controls[line.from].width) - line.M) : (me.controls[line.from].left - line.M);
            var toLeft = me.controls[line.from].left < me.controls[line.to].left ? ((me.controls[line.to].left + me.controls[line.to].width) - line.M) : (me.controls[line.to].left - line.M);
            sortLinesAcross[i].middle = true;
            sortLinesAcross[i].diffence = Math.abs(fromLeft) < Math.abs(toLeft) ? Math.abs(fromLeft) : Math.abs(toLeft);
            sortLinesAcross[i].minControlId = Math.abs(fromLeft) < Math.abs(toLeft) ? me.controls[line.from].id : me.controls[line.to].id;
          } else if (line.type == "tb" && referLineMiddle < 0) {
            var fromTop = me.controls[line.from].top < me.controls[line.to].top ? ((me.controls[line.from].top + me.controls[line.from].height) - line.M) : (me.controls[line.from].top - line.M);
            var toTop = me.controls[line.from].top < me.controls[line.to].top ? ((me.controls[line.to].top + me.controls[line.to].height) - line.M) : (me.controls[line.to].top - line.M);
            sortLinesAcross[i].middle = true;
            sortLinesAcross[i].diffence = Math.abs(fromTop) < Math.abs(toTop) ? Math.abs(fromTop) : Math.abs(toTop);
            sortLinesAcross[i].minControlId = Math.abs(fromTop) < Math.abs(toTop) ? me.controls[line.from].id : me.controls[line.to].id;
          }
        }
      }
      //console.log(sortLinesAcross)
      for (var index = 0; index < me.curId.length; index++) {
        if (me.curId[index]) {
          if (/CONTROL/.test(me.curId[index])) {
            // 控件
            me.controls[me.curId[index]].blur();
          } else if (/LINE/.test(me.curId[index])) {
            // 连接线
            var line = me.lines[me.curId[index]];
            if (useSVG) {
              if (!line.marked) {
                line.$el.childNodes[1].setAttribute("stroke", me.options.color.line || "#3892D3");
                //line.$el.childNodes[1].setAttribute("marker-end", 'url("#arrow1")');
              }
            }

            me.$lineMove.hide().removeData("type").removeData("tid");

            if (me.isEdit) {
              me.$lineOper.hide().removeData("tid");
              me.$mpFrom.hide().removeData("p");
              me.$mpTo.hide().removeData("p");
            }

          } else {
            // 泳道
            jq('#' + me.curId).removeClass('cur');
          }
        }
        if (!isCurClass()) {
          me.curId[index] = "";
        }

      }
      if (!isCurClass()) {
        me.curId = [];
      }
      if (type === 'moveAndResize') {
        // 改变阶段的位置，移动里面的节点随之移动
        var tempArr = {};
        for (var key in me.controls) {
          if (!me.controls[key].bindSwimYId) {
            continue;
          }
          var swimId = me.controls[key].bindSwimYId;
          var idx = jq("#" + swimId).index();

          var original = {
            left: 0,
            top: 0,
          }
          if (jq("#" + swimId).attr("class").indexOf("swimlaneY") > -1) {
            for (var i = 0; i < idx; i++) {
              original.left += jq(".swimlaneY").eq(i).width();
            }
          } else {
            for (var i = 0; i < idx; i++) {
              original.top += jq(".swimlaneX").eq(i).height();
            }
          }

          var miusOffset = {
            "left": original.left - parseFloat(me.controls[key].bindSwimYOffsetX),
            "top": original.top - parseFloat(me.controls[key].bindSwimYOffsetY)
          }
          var AbsmiusOffset = {
            "left": miusOffset.left < 0 ? -miusOffset.left : miusOffset.left,
            "top": miusOffset.top < 0 ? -miusOffset.top : miusOffset.top
          }
          if (AbsmiusOffset.left < 5 && AbsmiusOffset.top < 5) {
            continue;
          }
          me.controls[key].bindSwimYOffsetX = original.left
          me.controls[key].bindSwimYOffsetY = original.top
          var offset = {
            "top": me.controls[me.controls[key].id].top + miusOffset.top / me.scaleTo,
            "left": me.controls[me.controls[key].id].left + miusOffset.left / me.scaleTo
          }
          jq("#" + me.controls[key].id).css({
            "left": offset.left * me.scaleTo,
            "top": offset.top * me.scaleTo
          })
          me.controls[me.controls[key].id].left = offset.left;
          me.controls[me.controls[key].id].top = offset.top;
          // me.resetLines(me.controls[key].id, me.controls[key]);
          if (miusOffset.left != 0 || miusOffset.top != 0) {
            tempArr[me.controls[key].id] = {
              left: miusOffset.left / me.scaleTo,
              top: miusOffset.top / me.scaleTo,
              bindSwimYId: me.controls[key].bindSwimYId
            };
          }
        }

        for (var i in me.lines) {
          // 获取结束/开始结点的数据
          var line = me.lines[i];
          var offset = tempArr[line.from];
          if (offset && me.controls[line.from].bindSwimYId == me.controls[line.to].bindSwimYId) {
            if (line.type == "lr") {
              if (!!offset && !!offset.left) {
                line.M += offset.left;
              }
            } else if (line.type == "tb") {
              if (!!offset && !!offset.top) {
                line.M += offset.top;
              }
            }
          }
          if (moveType != "sort" && me.controls[line.from].bindSwimYId != me.controls[line.to].bindSwimYId) {
            if (line.type == "lr") {
              if (!!offset && !!offset.left) {
                line.M += offset.left;
              }
            } else if (line.type == "tb") {
              if (!!offset && !!offset.top) {
                line.M += offset.top;
              }
            }
          }

          if (moveType == "sort" && me.controls[line.from].bindSwimYId != me.controls[line.to].bindSwimYId) {
            if (line.type == "lr") {
              if (!sortLinesAcross[i].middle) {
                line.M = me.controls[sortLinesAcross[i].minControlId].left + me.controls[sortLinesAcross[i].minControlId].width - sortLinesAcross[i].diffence;
              } else {
                line.M = sortLinesAcross[i].minControlId == line.from ? (me.controls[line.from].left < me.controls[line.to].left ? (me.controls[line.from].left + me.controls[line.from].width + sortLinesAcross[i].diffence) : (me.controls[line.from].left - sortLinesAcross[i].diffence)) : (me.controls[line.from].left > me.controls[line.to].left ? (me.controls[line.to].left + me.controls[line.to].width + sortLinesAcross[i].diffence) : (me.controls[line.to].left - sortLinesAcross[i].diffence));
                referLineMiddle = me.controls[line.from].left < me.controls[line.to].left ? (me.controls[line.from].left + me.controls[line.from].width - line.M) * (me.controls[line.to].left - line.M) : (me.controls[line.to].left + me.controls[line.to].width - line.M) * (me.controls[line.from].left - line.M);
                line.M = referLineMiddle > 0 ? me.getMValue(me.controls[line.from], me.controls[line.to], "tb") : line.M;
              }
            } else if (line.type == "tb") {
              if (!sortLinesAcross[i].middle) {
                line.M = me.controls[sortLinesAcross[i].minControlId].top + me.controls[sortLinesAcross[i].minControlId].height - sortLinesAcross[i].diffence;
              } else {
                line.M = sortLinesAcross[i].minControlId == line.from ? (me.controls[line.from].top < me.controls[line.to].top ? (me.controls[line.from].top + me.controls[line.from].height + sortLinesAcross[i].diffence) : (me.controls[line.from].top - sortLinesAcross[i].diffence)) : (me.controls[line.from].top > me.controls[line.to].top ? (me.controls[line.to].top + me.controls[line.to].height + sortLinesAcross[i].diffence) : (me.controls[line.to].top - sortLinesAcross[i].diffence));
                var referLineMiddle = me.controls[line.from].top < me.controls[line.to].top ? (me.controls[line.from].top + me.controls[line.from].height - line.M) * (me.controls[line.to].top - line.M) : (me.controls[line.to].top + me.controls[line.to].height - line.M) * (me.controls[line.from].top - line.M);
                line.M = referLineMiddle > 0 ? me.getMValue(me.controls[line.from], me.controls[line.to], "tb") : line.M;
              }
            }
          }
        }
        json = basFlow.getToJSON();
        jq("#GooFlow_work svg g").remove();
        me.lines = {};
        _.each(json.lines, function (v) {
          me.addLine(v);
        });
      }
      else if (type === 'moveProcess') {
        //console.log(jq(".swimlaneX"))
        for (var key in me.controls) {
          if (!me.controls[key].bindSwimXId) {
            continue;
          }
          if (me.controls[key].splitType != 'downProcess') {
            continue;
          }

          var swimId = me.controls[key].bindSwimXId;
          var idx = jq("#" + swimId).index();
          //console.log(idx)

          var original = {
            left: 0,
            top: 0,
          }
          if (jq("#" + swimId).attr("class").indexOf("swimlaneX") > -1) {
            for (var i = 0; i < idx; i++) {
              original.top += jq(".swimlaneX").eq(i).height();
            }
          } else {
            for (var i = 0; i < idx; i++) {
              original.left += jq(".swimlaneX").eq(i).width();
            }
          }
          if (!original) {
            return;
          }

          //console.log(original)

          var miusOffset = {
            "left": original.left - parseFloat(me.controls[key].bindSwimXOffsetX),
            "top": original.top - parseFloat(me.controls[key].bindSwimXOffsetY)
          }
          me.controls[key].bindSwimXOffsetX = original.left
          me.controls[key].bindSwimXOffsetY = original.top

          var offset = {
            "top": me.controls[me.controls[key].id].top + miusOffset.top / me.scaleTo,
            "left": me.controls[me.controls[key].id].left + miusOffset.left / me.scaleTo
          }

          jq("#" + me.controls[key].id).css({
            "left": offset.left * me.scaleTo,
            "top": offset.top * me.scaleTo
          })
          me.controls[me.controls[key].id].left = offset.left * me.scaleTo;
          me.controls[me.controls[key].id].top = offset.top * me.scaleTo;
          me.resetLines(me.controls[key].id, me.controls[key]);
        }

      }
      else if (type === 'moveAndResizeX') {
        // 改变横泳道的位置，移动里面的节点随之移动
        var tempArr = {};
        for (var key in me.controls) {
          if (!me.controls[key].bindSwimXId) {
            continue;
          }
          var swimId = me.controls[key].bindSwimXId;
          var idx = jq("#" + swimId).index();

          var original = {
            left: 0,
            top: 0,
          }
          if (jq("#" + swimId).attr("class").indexOf("swimlaneX") > -1) {
            for (var i = 0; i < idx; i++) {
              original.top += jq(".swimlaneX").eq(i).height();
            }
          } else {
            for (var i = 0; i < idx; i++) {
              original.left += jq(".swimlaneX").eq(i).width();
            }
          }

          var miusOffset = {
            "left": original.left - parseFloat(me.controls[key].bindSwimXOffsetX),
            "top": original.top - parseFloat(me.controls[key].bindSwimXOffsetY)
          }
          var AbsmiusOffset = {
            "left": miusOffset.left < 0 ? -miusOffset.left : miusOffset.left,
            "top": miusOffset.top < 0 ? -miusOffset.top : miusOffset.top
          }
          if (AbsmiusOffset.left < 1 && AbsmiusOffset.top < 1) {
            continue;
          }
          me.controls[key].bindSwimXOffsetX = original.left
          me.controls[key].bindSwimXOffsetY = original.top
          var offset = {
            "top": me.controls[me.controls[key].id].top + miusOffset.top / me.scaleTo,
            "left": me.controls[me.controls[key].id].left + miusOffset.left / me.scaleTo
          }
          jq("#" + me.controls[key].id).css({
            "left": offset.left * me.scaleTo,
            "top": offset.top * me.scaleTo
          })
          me.controls[me.controls[key].id].left = offset.left;
          me.controls[me.controls[key].id].top = offset.top;
          if (miusOffset.top != 0) {
            tempArr[me.controls[key].id] = {
              left: miusOffset.left / me.scaleTo,
              top: miusOffset.top / me.scaleTo,
              bindSwimXId: me.controls[key].bindSwimXId
            };
          }
        }

        for (var i in me.lines) {
          // 获取结束/开始结点的数据
          var line = me.lines[i];
          var offset = tempArr[line.from];
          if (offset && me.controls[line.from].bindSwimXId == me.controls[line.to].bindSwimXId) {
            if (line.type == "lr") {
              if (!!offset && !!offset.left) {
                line.M += offset.left;
              }
            } else if (line.type == "tb") {
              if (!!offset && !!offset.top) {
                line.M += offset.top;
              }
            }
          }

          if (moveType != "sort" && me.controls[line.from].bindSwimXId != me.controls[line.to].bindSwimXId) {
            if (line.type == "lr") {
              if (!!offset && !!offset.left) {
                line.M += offset.left;
              }
            } else if (line.type == "tb") {
              if (!!offset && !!offset.top) {
                line.M += offset.top;
              }
            }
          }

          if (moveType == "sort" && me.controls[line.from].bindSwimXId != me.controls[line.to].bindSwimXId) {
            if (line.type == "lr") {
              if (!sortLinesAcross[i].middle) {
                line.M = me.controls[sortLinesAcross[i].minControlId].left + me.controls[sortLinesAcross[i].minControlId].width - sortLinesAcross[i].diffence;
              } else {
                line.M = sortLinesAcross[i].minControlId == line.from ? (me.controls[line.from].left < me.controls[line.to].left ? (me.controls[line.from].left + me.controls[line.from].width + sortLinesAcross[i].diffence) : (me.controls[line.from].left - sortLinesAcross[i].diffence)) : (me.controls[line.from].left > me.controls[line.to].left ? (me.controls[line.to].left + me.controls[line.to].width + sortLinesAcross[i].diffence) : (me.controls[line.to].left - sortLinesAcross[i].diffence));
                referLineMiddle = me.controls[line.from].left < me.controls[line.to].left ? (me.controls[line.from].left + me.controls[line.from].width - line.M) * (me.controls[line.to].left - line.M) : (me.controls[line.to].left + me.controls[line.to].width - line.M) * (me.controls[line.from].left - line.M);
                line.M = referLineMiddle > 0 ? me.getMValue(me.controls[line.from], me.controls[line.to], "tb") : line.M;
              }
            } else if (line.type == "tb") {
              if (!sortLinesAcross[i].middle) {
                line.M = me.controls[sortLinesAcross[i].minControlId].top + me.controls[sortLinesAcross[i].minControlId].height - sortLinesAcross[i].diffence;
              } else {
                line.M = sortLinesAcross[i].minControlId == line.from ? (me.controls[line.from].top < me.controls[line.to].top ? (me.controls[line.from].top + me.controls[line.from].height + sortLinesAcross[i].diffence) : (me.controls[line.from].top - sortLinesAcross[i].diffence)) : (me.controls[line.from].top > me.controls[line.to].top ? (me.controls[line.to].top + me.controls[line.to].height + sortLinesAcross[i].diffence) : (me.controls[line.to].top - sortLinesAcross[i].diffence));
                var referLineMiddle = me.controls[line.from].top < me.controls[line.to].top ? (me.controls[line.from].top + me.controls[line.from].height - line.M) * (me.controls[line.to].top - line.M) : (me.controls[line.to].top + me.controls[line.to].height - line.M) * (me.controls[line.from].top - line.M);
                line.M = referLineMiddle > 0 ? me.getMValue(me.controls[line.from], me.controls[line.to], "tb") : line.M;
              }
            }
          }
        }

        json = basFlow.getToJSON();
        jq("#GooFlow_work svg g").remove();
        me.lines = {};
        _.each(json.lines, function (v) {
          me.addLine(v);
        });
      }
      // 移动的阶段的索引值index
      // var swimIndex = jq("#"+id).index();
      me.referIfMove = false;
      me.linkage();
    },

    // 清空当前页面所有制图节点
    clearAll: function () {
      var me = this;
      for (var i in me.controls) {
        me.delControl(i);
      }
      for (var j in me.lines) {
        me.delLine(j);
      }
      for (var k in me.swimlanes) {
        me.delSwimlane(k);
      }
    },
    /**
     * 删除工作空间中控件
     */
    delControl: function (id) {
      var me = this;
      var type = '';
      if (!me.controls[id]) return;
      // if (me.onItemDel != null && !me.onItemDel(id, "node")) return;

      // 先删除可能的连线
      for (var k in me.lines) {
        if (me.lines[k].from == id || me.lines[k].to == id) {
          me.delLine(k);
        }
      }

      me.ctrlZlist.push({
        method: 'del',
        type: 'control',
        data: me.controls[id],
        id: id
      })

      if (!!me.controls[id].input && !!me.controls[id].input.length) {
        for (var i = 0; i < me.controls[id].input.length; i++) {
          jQuery.support.cors = true;
          jq.ajax({
            type: 'GET',
            url: basFlow.baseUrl + '/document/docdelete/' + me.controls[id].input[i].id + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })

          jQuery.support.cors = true;
          jq.ajax({
            type: 'POST',
            url: basFlow.baseUrl + '/modellistdoc/delete/' + me.controls[id].input[i].docid + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })
        }
      }

      if (!!me.controls[id].output && !!me.controls[id].output.length) {
        for (var i = 0; i < me.controls[id].output.length; i++) {
          jQuery.support.cors = true;
          jq.ajax({
            type: 'GET',
            url: basFlow.baseUrl + '/document/docdelete/' + me.controls[id].output[i].id + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })

          jQuery.support.cors = true;
          jq.ajax({
            type: 'POST',
            url: basFlow.baseUrl + '/modellistdoc/delete/' + me.controls[id].output[i].docid + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })
        }
      }

      if (!!me.controls[id].messageFile && !!me.controls[id].messageFile.length) {
        for (var i = 0; i < me.controls[id].messageFile.length; i++) {
          jQuery.support.cors = true;
          jq.ajax({
            type: 'GET',
            url: basFlow.baseUrl + '/document/docdelete/' + me.controls[id].messageFile[i].id + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })

          jQuery.support.cors = true;
          jq.ajax({
            type: 'POST',
            url: basFlow.baseUrl + '/modellistdoc/delete/' + me.controls[id].messageFile[i].docid + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })
        }
      }

      if (!!me.controls[id].messageGroup && !!me.controls[id].messageGroup.length) {
        for (var i = 0; i < me.controls[id].messageGroup.length; i++) {
          jQuery.support.cors = true;
          jq.ajax({
            type: 'GET',
            url: basFlow.baseUrl + '/document/docdelete/' + me.controls[id].messageGroup[i].id + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })

          jQuery.support.cors = true;
          jq.ajax({
            type: 'POST',
            url: basFlow.baseUrl + '/modellistdoc/delete/' + me.controls[id].messageGroup[i].docid + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })
        }
      }

      if (!!me.controls[id].approverules && !!me.controls[id].approverules.length) {
        for (var i = 0; i < me.controls[id].approverules.length; i++) {
          jQuery.support.cors = true;
          jq.ajax({
            type: 'GET',
            url: basFlow.baseUrl + '/document/docdelete/' + me.controls[id].approverules[i].id + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })

          jQuery.support.cors = true;
          jq.ajax({
            type: 'POST',
            url: basFlow.baseUrl + '/modellistdoc/delete/' + me.controls[id].approverules[i].docid + '?username=' + basFlow.username,
            data: {},
            async: true,
            success: function (res) {
              //console.log(res);
            },
            error: function (err) {
              //console.log(err)
            }
          })
        }
      }

      type = me.controls[id].type;
      me.controls[id].remove();
      delete me.controls[id];
      // if (me.curId[0] == id) {
      //   me.curId[0] = "";
      // }
      // 针对多选情况删除对应的id
      for (var index = 0; index < me.curId.length; index++) {
        if (me.curId[index] == id) {
          me.curId.splice(index, 1);
        }
      }
      console.log(me.curId)
      // 删除模块之后 也删除关键控制点信息
      if (type != 'processTask') {
        return;
      }
      jQuery.support.cors = true;
      jq.ajax({
        type: 'POST',
        url: me.baseUrl + '/modellist/deleteByListidAndKeyid?username=' + me.username,
        dataType: 'json',
        contentType: "application/json;",
        data: JSON.stringify({
          keyid: id,
          listid: me.id
        }),
        success: function (res) {
          //console.log("删除任务模块，同时清除了关键控制点信息！");
        },
        error: function () {
        }
      })

      jQuery.support.cors = true;
      jq.ajax({
        type: 'POST',
        url: me.baseUrl + '/succelement/deleteByListidAndKeyid?username=' + me.username,
        dataType: 'json',
        contentType: "application/json;",
        data: JSON.stringify({
          keyid: id,
          listid: me.id
        }),
        success: function (res) {
          //console.log("删除关键控制点")
        },
        error: function () {
        }
      })





      // if (me.$editable) {
      // //在回退新增操作时,如果节点ID以this.$id+"_node_"开头,则表示为本次编辑时新加入的节点,这些节点的删除不用加入到$deletedItem中
      // if (id.indexOf(this.$id + "_node_") < 0)
      // this.$deletedItem[id] = "node";
      // }

    },

    /**
     * 聚焦id
     *
     * @param {String}
     *            id
     */
    focusItem: function (id, type) {
      console.log('idididid', id, type)
      console.log('this type', type)
      var me = this;
      if (type == "single" && !me.referIfMove) {
        console.log(5)
        if (!me.blurItem() || !id) return;
      }
      // 属性列表
      var attrList = null;

      if (/CONTROL/.test(id)) {
        console.log( 'me.controls[id]',me.controls[id].type)

        if( me.controls[id].type ==='role') {
          $('.content_item').hide();
        }
        if (!me.controls[id].isOperable) { // 刚性节点时 不可选中
          me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
          return
        }
        attrList = me.controls[id];
        // 控件
        // 清除到未选中状态 2020年11月4日17:32:41
        me._switchEditType(me.EditEnum.SELECT);
        me._switchDottedEditType(me.EditEnum.SELECT);
        me.controls[id].$el.removeClass("control-mark").removeClass("crosshair").css("border-color", '');
        me.controls[id].focus();
      } else if (/LINE/.test(id)) {
        attrList = me.lines[id];
        // 设置form的type
        attrList.formType = me.controls[attrList.from].type
        // 连接线
        var lineDom = me.lines[id].$el;
        if (useSVG) {
          lineDom.childNodes[1].setAttribute("stroke", me.options.color.mark);
        }
        if (!me.isEdit) return;

        var x, y, from, to, n;
        if (useSVG) {
          from = lineDom.getAttribute("from").split(",");
          to = lineDom.getAttribute("to").split(",");
          n = [from[0], from[1], to[0], to[1]];
        }
        from[0] = parseInt(from[0], 10);
        from[1] = parseInt(from[1], 10);
        to[0] = parseInt(to[0], 10);
        to[1] = parseInt(to[1], 10);

        if (me.lines[id].type == "lr" || (me.lines[id].type == 'fr' && (me.lines[id].point.type === 'lr'))) {
          from[0] = me.lines[id].M;
          to[0] = from[0];

          me.$lineMove.css({
            width: "5px",
            height: ((to[1] - from[1]) * (to[1] > from[1] ? 1 : -1)) * me.scaleTo + "px",
            left: (from[0] - 3) * me.scaleTo + "px",
            top: ((to[1] > from[1] ? from[1] : to[1]) + 1) * me.scaleTo + "px",
            cursor: "e-resize",
            display: "block"
          }).data({
            "type": "lr",
            "tid": id
          });
        } else if (me.lines[id].type == "tb" || (me.lines[id].type == 'fr' && (me.lines[id].point.type === 'tb'))) {
          from[1] = me.lines[id].M;
          to[1] = from[1];
          me.$lineMove.css({
            width: ((to[0] - from[0]) * (to[0] > from[0] ? 1 : -1)) * me.scaleTo + "px",
            height: "5px",
            left: ((to[0] > from[0] ? from[0] : to[0]) + 1) * me.scaleTo + "px",
            top: (from[1] - 3) * me.scaleTo + "px",
            cursor: "s-resize",
            display: "block"
          }).data({
            "type": "tb",
            "tid": id
          });
        }


        x = (from[0] + to[0]) / 2 + 10;
        y = (from[1] + to[1]) / 2 + 6;

        me.$lineOper.css({
          display: "block",
          left: x * me.scaleTo + "px",
          top: y * me.scaleTo + "px"
        }).data("tid", id);

        if (me.isEdit) {
          me.$mpFrom.css({
            display: "block",
            left: (n[0] - 4) * me.scaleTo + "px",
            top: (n[1] - 4) * me.scaleTo + "px"
          }).data("p", n[0] + "," + n[1]);
          me.$mpTo.css({
            display: "block",
            left: (n[2] - 4) * me.scaleTo + "px",
            top: (n[3] - 4) * me.scaleTo + "px"
          }).data("p", n[2] + "," + n[3]);
        }

        me.$draw.appendChild(lineDom);
      } else {
        // if (!!me.swimlanes[id].isOperable) { // 刚性节点时 不可选中
        //     me.alertBox(jq.i18n.prop("whenRigidNodesAreInoperable") + "! ", 'danger')
        //     return
        // }
        attrList = me.swimlanes[id];
        // 泳道
        jq('#' + id).addClass('cur');
      }
      var pick = _.pick(attrList, _.keys(attrList));
      attrList = _.omit(pick, ['$el', 'marked', 'templ', 'drag', 'resize']);
      me._switchPlan(id, attrList);
      if (type == "single") {
        me.curId[0] = id;
      }
      else if (type == "multiSelect") {
        me.curId.push(id);
      }
    },
    focusItem2: function (id, type) {
      var me = this;
      if (type == "single" && !me.referIfMove) {
        console.log(6)
        if (!me.blurItem() || !id) return;
      }
      // 属性列表
      var attrList = null;

      if (/CONTROL/.test(id)) {
        attrList = me.controls[id];
        // 控件
        // 清除到未选中状态 2020年11月4日17:32:41
        me._switchEditType(me.EditEnum.SELECT);
        me._switchDottedEditType(me.EditEnum.SELECT);
        me.controls[id].$el.removeClass("control-mark").removeClass("crosshair").css("border-color", '');
        me.controls[id].focus();
      } else if (/LINE/.test(id)) {
        attrList = me.lines[id];
        // 连接线
        var lineDom = me.lines[id].$el;
        if (useSVG) {
          lineDom.childNodes[1].setAttribute("stroke", me.options.color.mark);
        }
        if (!me.isEdit) return;

        var x, y, from, to, n;
        if (useSVG) {
          from = lineDom.getAttribute("from").split(",");
          to = lineDom.getAttribute("to").split(",");
          n = [from[0], from[1], to[0], to[1]];
        }
        from[0] = parseInt(from[0], 10);
        from[1] = parseInt(from[1], 10);
        to[0] = parseInt(to[0], 10);
        to[1] = parseInt(to[1], 10);

        if (me.lines[id].type == "lr") {
          from[0] = me.lines[id].M;
          to[0] = from[0];

          me.$lineMove.css({
            width: "5px",
            height: ((to[1] - from[1]) * (to[1] > from[1] ? 1 : -1)) * me.scaleTo + "px",
            left: (from[0] - 3) * me.scaleTo + "px",
            top: ((to[1] > from[1] ? from[1] : to[1]) + 1) * me.scaleTo + "px",
            cursor: "e-resize",
            display: "block"
          }).data({
            "type": "lr",
            "tid": id
          });
        } else if (me.lines[id].type == "tb") {
          from[1] = me.lines[id].M;
          to[1] = from[1];
          me.$lineMove.css({
            width: ((to[0] - from[0]) * (to[0] > from[0] ? 1 : -1)) * me.scaleTo + "px",
            height: "5px",
            left: ((to[0] > from[0] ? from[0] : to[0]) + 1) * me.scaleTo + "px",
            top: (from[1] - 3) * me.scaleTo + "px",
            cursor: "s-resize",
            display: "block"
          }).data({
            "type": "tb",
            "tid": id
          });
        }


        x = (from[0] + to[0]) / 2 + 10;
        y = (from[1] + to[1]) / 2 + 6;

        me.$lineOper.css({
          display: "block",
          left: x * me.scaleTo + "px",
          top: y * me.scaleTo + "px"
        }).data("tid", id);

        if (me.isEdit) {
          me.$mpFrom.css({
            display: "block",
            left: (n[0] - 4) * me.scaleTo + "px",
            top: (n[1] - 4) * me.scaleTo + "px"
          }).data("p", n[0] + "," + n[1]);
          me.$mpTo.css({
            display: "block",
            left: (n[2] - 4) * me.scaleTo + "px",
            top: (n[3] - 4) * me.scaleTo + "px"
          }).data("p", n[2] + "," + n[3]);
        }

        me.$draw.appendChild(lineDom);

      } else {
        attrList = me.swimlanes[id];
        // 泳道
        jq('#' + id).addClass('cur');
      }
      var pick = _.pick(attrList, _.keys(attrList));
      attrList = _.omit(pick, ['$el', 'marked', 'templ', 'drag', 'resize']);
      if (type == "single") {
        me.curId[0] = id;
      }
      else if (type == "multiSelect") {
        me.curId.push(id);
      }
    },


    /**
     * 取消所有结点/连线被选定的状态
     */
    blurItem: function () {
      console.log('blurItem')
      var me = this;
      console.log(me.referIfMove)
      console.log(me.curId, me.controls[me.curId[0]])
      if (me.referIfMove) {
        return false;
      }
      if (me.curId.length > 0) {
        for (var index = 0; index < me.curId.length; index++) {
          console.log(me.curId.length, index)
          console.log('取消所有结点')
          if (me.curId[index]) {
            if (/CONTROL/.test(me.curId[index])) {
              // 控件
              me.controls[me.curId[index]].blur && me.controls[me.curId[index]].blur();
              console.log('控件', me.curId[index])
            }
            else if (/LINE/.test(me.curId[index])) {
              // 连接线
              var line = me.lines[me.curId[index]];
              if (useSVG) {
                if (!line.marked) {
                  line.$el.childNodes[1].setAttribute("stroke", me.options.color.line || "#3892D3");
                }
              }

              me.$lineMove.hide().removeData("type").removeData("tid");

              if (me.isEdit) {
                me.$lineOper.hide().removeData("tid");
                me.$mpFrom.hide().removeData("p");
                me.$mpTo.hide().removeData("p");
              }

            }
            else {
              // 泳道
              jq('#' + me.curId).removeClass('cur');
            }
          }
          //console.log(111)
          if (!isCurClass()) {
            me.curId[index] = "";
          }
          //console.log(222)
        }
      }
      //console.log(333)
      if (!isCurClass()) {
        me.curId = [];
      }
      //console.log(444)
      me.changeScaleLine(true)
      return true;
    },

    /**
     * 取消所有结点/连线被选定的状态  虚线
     */
    blurItemDotted: function () {
      console.log('blurItemDotted')
      var me = this;
      if (me.referIfMove) {
        return false;
      }
      for (var index = 0; index < me.curId.length; index++) {
        if (me.curId[index]) {
          if (/CONTROL/.test(me.curId[index])) {
            // 控件
            me.controls[me.curId[index]].blur();
          } else if (/LINE/.test(me.curId[index])) {
            // 连接线
            var line = me.lines[me.curId[index]];
            //console.log(line)
            if (useSVG) {
              if (!line.marked) {
                if (!line.lineType || line.lineType == 'solid') {
                  line.lineType = 'solid'
                  // line.$el.childNodes[1].setAttribute("stroke-dasharray", "0 0");
                  line.$el.childNodes[1].setAttribute("stroke", me.options.color.line || "#3892D3");
                } else {
                  line.lineType = 'dash'
                  line.$el.childNodes[1].setAttribute("stroke-dasharray", "3 3");

                }
              }
            }

            me.$lineMove.hide().removeData("type").removeData("tid");

            if (me.isEdit) {
              me.$lineOper.hide().removeData("tid");
              me.$mpFrom.hide().removeData("p");
              me.$mpTo.hide().removeData("p");
            }

          } else {
            // 泳道
            jq('#' + me.curId).removeClass('cur');
          }
        }
        if (!isCurClass()) {
          me.curId[index] = "";
        }
      }
      if (!isCurClass()) {
        me.curId = [];
      }
      me.changeScaleLine(true)
      return true;
    },
    // 切换实线 虚线
    changeLineType: function () {
      var me = this;
      if (me.referIfMove) {
        return false;
      }
      for (var index = 0; index < me.curId.length; index++) {
        if (me.curId[index]) {
          if (/CONTROL/.test(me.curId[index])) {
            // 控件
            me.controls[me.curId[index]].blur();
          } else if (/LINE/.test(me.curId[index])) {
            // 连接线
            var line = me.lines[me.curId[index]];
            //console.log(line)
            if (useSVG) {
              if (!line.marked) {
                if (!line.lineType || line.lineType == 'dash') {
                  line.lineType = 'solid'
                  // line.$el.childNodes[1].setAttribute("stroke-dasharray", "0 0");
                  line.$el.childNodes[1].setAttribute("stroke", me.options.color.line || "#3892D3");
                } else {
                  line.lineType = 'dash'
                  line.$el.childNodes[1].setAttribute("stroke-dasharray", "3 3");

                }
              }
            }

            me.$lineMove.hide().removeData("type").removeData("tid");

            if (me.isEdit) {
              me.$lineOper.hide().removeData("tid");
              me.$mpFrom.hide().removeData("p");
              me.$mpTo.hide().removeData("p");
            }

          } else {
            // 泳道
            jq('#' + me.curId).removeClass('cur');
          }
        }
        if (!isCurClass()) {
          me.curId[index] = "";
        }

      }
      if (!isCurClass()) {
        me.curId = [];
      }
      me.changeScaleLine(true)
      return true;
    },


    /**
     * 设置结点/连线/永道 属性值
     *
     * @param {String}
     *            id 控件id
     * @param {String}
     *            attr 属性
     * @param {String}
     *            val 值
     * @param {String}
     *            type 控件类型
     */
    setAttr: function (id, attr, val, type) {
      var me = this;
      if (type == "control") {
        var control = me.controls[id];
        // 如果是控件
        if (!control || control[attr] == val) return;

        // if (me.onItemRename != null && !me.onItemRename(id, name,
        // "node")) return;
        var oldVal = control[attr];
        control[attr] = val;
        control.syncUI();

        // 重画转换线
        me.resetLines(id, control);
      }

      if (type == "swimlane") {
        var swimlane = me.swimlanes[id];
        // 如果是泳道
        if (!swimlane || swimlane[attr] == val) return;
        var oldVal = swimlane[attr];
        swimlane[attr] = val;
      }
    },
    /**
     * 设置svg text换行
     *
     * @param {String} str 需要处理的字符串
     * @param {Object} lineElement 连线Dom
     * @param {String} id 操作对象的id
     * @param {Number} len 分割的长度
     */
    wrap: function(str, lineElement, id, len) {
      var me = this;
      var lineBox = lineElement.childNodes[1].getBBox()
      // var line = lineElement.childNodes[3].getBoundingClientRect()
      var lineX = lineElement.childNodes[3].getAttribute('x')
      var centerX = 0;
      // 判断连线类型设置x值
      if (me.lines[id].type == "lr") {
        centerX = lineX
      } else {
        centerX = lineBox.width / 2 + lineBox.x
      }
      var strs = [];
      var tspans = '';
      // 按字符长度切割
      // while(str.length > len){
      //   var pos = str.substring(0, len).lastIndexOf(' ');
      //   pos = pos <= 0 ? len : pos;
      //   strs.push(str.substring(0, pos));
      //   var i = str.indexOf(' ', pos)+1;
      //   if(i < pos || i > pos+len)
      //     i = pos;
      //   str = str.substring(i);
      // }
      // strs.push(str);
      strs = str.split("\n");
      $.each(strs, function (index, obj) {
        if (index === 0) {
          var dy = strs.length / 2 - 0.5;
          tspans = '<tspan x = "' + centerX + '" dy="-'+ dy +'em">' + obj +'</tspan>'
        } else {
          tspans += '\n<tspan x="'+ centerX +'" dy ="1.2em">' + obj +'</tspan>'
        }

      })
      // console.log('tspans', tspans)
      return tspans;
    },
    /**
     * 设置结点/连线/分组区域的文字信息
     */
    setName: function (id, name, type) {
      var oldName, me = this;
      if (type == "control") {
        var control = me.controls[id];
        // 如果是控件
        if (!control || control.name == name) return;

        oldName = control.name;
        control.name = name;
        control.$el.find(".J_text").text(name);
        control.syncUI();

        // 重画转换线
        me.resetLines(id, control);
      } else if (type == "line") {
        // 如果是线
        if (!me.lines[id] || me.lines[id].name == name) return;

        oldName = me.lines[id].name;
        me.lines[id].name = name;
        if (useSVG) {
          // me.lines[id].$el.childNodes[3].textContent = name;
          var lineElement = document.getElementById(id);
          if (lineElement) {
            me.lines[id].$el.childNodes[3].innerHTML = me.wrap(name, lineElement, id);
            lineElement.childNodes[2].setAttribute("width", !lineElement.childNodes[3].getBBox().width ? 0 : (lineElement.childNodes[3].getBBox().width + 10))
            lineElement.childNodes[2].setAttribute("height", !lineElement.childNodes[3].getBBox().height ? 0 : (lineElement.childNodes[3].getBBox().height + 10))
            lineElement.childNodes[2].setAttribute("x", lineElement.childNodes[3].getBBox().x - 5)
            lineElement.childNodes[2].setAttribute("y", lineElement.childNodes[3].getBBox().y - 5)
          }
        }
      }
    },


    getUrl: function (id, type) {
      var oldName, me = this;
      if (type == "control") {
        var control = me.controls[id];
        // 如果是控件

        url = control.url;
        name = control.name;
        type = control.type;
        pageid = document.getElementById('id').value;
        jQuery.support.cors = true;
        jq.ajax({
          type: "POST",
          url: ctx + "/configPage/configFormBussion/configFormId.do?username=" + me.username,
          dataType: "text",
          data: {
            url: url,
            type: type,
            name: name
          },
          success: function (data) {

            if (data == "url" || data == "") {

              alert('没有下一级');

            } else {
              window.location.href = ctx + "/configPage/configForm/configForm.do?id=" + data;
              //window.location.href=ctx +"/configPage/configFormBussion/childForm.do?id="+newid+"&pageid="+pageid;
            }
          }

        });
      }

    },
    getattr: function (id, type) {
      var oldName, me = this;
      if (type == "control") {
        var control = me.controls[id];
        // 如果是控件
        url = control.url;
        name = control.name;
        type = control.type;
        //var listid=jq("#id").val();
        //  pageid=document.getElementById('id').value;
        // jq.ajax({
        // 	type : "POST",
        // 	url : ctx + "/configPage/configFormBussion/childattr.do",
        // 	dataType : "text",
        // 	data : {
        // 	//	newid :newid,
        // 		url : url
        // 	},
        // 	success : function(data) {
        // 		if(data!=""){
        // 			var json=JSON.parse(data);
        // 			//alert(json);
        // 			//	alert(json.flowname);
        // 			/*document.getElementById("flowname").value = json.flowname;
        // 			document.getElementById("flowtype").value = json.flowtype;
        // 			document.getElementById("flowtycreateorpe").value = json.createby;
        // 			document.getElementById("createtime").value = json.createon;
        // 			document.getElementById("changeor").value = json.updateby;
        // 			document.getElementById("changetime").value = json.updateon;*/
        // 		}else{
        // 			document.getElementById('yin').style.display='block';
        // 		}
        // 	}
        // });
      }

    },

    // 载入一组数据
    loadData: function (data, bool) {
      var me = this;
      var t = me.isEdit;
      var swimlanes = _.groupBy(data.swimlanes, 'type');
      // me.addSwimlane('x', '泳道横', {}, true, JSON.stringify(swimlanes), bool, data);
      console.log(7)
      me.blurItem();
      me.isEdit = t;
      me.ctrlZlist = [];
      me.ctrlYlist = [];
    },

    // 载入画图数据
    initData: function (data, type) {
      var me = this;
      if (type === 'Update') {

        let processInfo = sessionStorage.getItem('processInfo') ? JSON.parse(sessionStorage.getItem('processInfo')) : {}

        // 属性只读
        // me.isReadAttr = processInfo.isReadAttr === 'true' ? true : me.isReadAttr;

        window.isEditAttr = processInfo.isReadAttr === 'true' ? false : me.isEdit;

        me.$swimlaneX = null
        me.$swimlaneY = null
        // 存储所有生成的控件
        me.controls = {};
        // 存储所有生成的连接线
        me.lines = {};
        // 存储所有生成的泳道
        me.swimlanes = {}
        // 当前聚焦的控件/线/泳道 ID
        me.curId = []
        // copy内容
        me.copyItem = []
        // copy内容的id
        me.copyId = [];
         // ctrl + z list，撤销
        me.ctrlZlist = [];
        // ctrl + y list 反撤销
        me.ctrlYlist = [];
        jq('.GooFlow_head').remove()
        jq('.GooFlow_head_2').remove()
        me._initHeadBtns()
        jq('.GooFlow_lft').remove()
        jq('.GooFlow_tool').remove()
        this._initTools()
        this._initleticon()
        jq('.GooFlow_work').remove()
        me._initWorkArea(type)
        me._initContextMenu();
        me.changeScaleLine()
        // 用于每次切换流程时  关闭活动属性弹框
        jq('.btn_wrapper li').children().removeClass('active');
        jq(".content_wrapper .content_item").hide()

        // headerBtn.renderHeaderBtn('#headerBtn')
        // if (!getParam("isReadAttr") && getCookie('storeChangeState') !== 'publish') {
          headerBtn.renderHeaderBtn('#headerBtn');
        // }
        jq("#selectVal").val("1") //  切换时候恢复正常
        me.onScaleMaxClick()
      } else if (type === 'initParamUrl') { // 第一次打开时  并且URL带参数情况  本来想要update 这样可以减少页面重复渲染
        // if (!getParam("isReadAttr") && getCookie('storeChangeState') !== 'publish') {
          jq("#selectVal").val("1")
          me.onScaleMaxClick()
          headerBtn.renderHeaderBtn('#headerBtn');
          let tabMenu = processTabMenu.tab;
          me.$container.append(jq(tabMenu));
          processTabMenu.renderProcessTabMenu('#processTabMenu');
        // }
      }
      // 添加控件
      for (var c = 0; c < data.controls.length; c++) {
        data.controls[c].toolsPath = me.options.toolsPath
        console.log(ToolsConfigJson, 'ToolsConfigJson')
        for (var key in ToolsConfigJson) {
          if (data.controls[c].type === ToolsConfigJson[key].type) {
            data.controls[c].iconPath = ToolsConfigJson[key].iconPath
          }
        }
      }
      var tempArr = []
      //console.log(data)
      for (var i = 0; i < data.controls.length; i++) {
        // keyControl 老数据为object 处理成数组 默认之前的数据为[]
        if (!!data.controls[i].keyControl && !Array.isArray(data.controls[i].keyControl)) {
          data.controls[i].keyControl = []
        }
        // keyKSFControl 老数据为object 处理成数组 默认之前的数据为[]
        if (!!data.controls[i].keyKSFControl && !Array.isArray(data.controls[i].keyKSFControl)) {
          data.controls[i].keyKSFControl = []
        }
        data.controls[i].name = data.controls[i].name.replace(/<br>/g, '').replace(/\n/g, "\n<br>")
        console.log(me.ToolsConfig, 'me.ToolsConfig')
        console.log(Object.keys(me.ToolsConfig), 'me.ToolsConfig')
        // for (var key in me.ToolsConfig) {
        //   if (me.ToolsConfig[key].type) {
        //     console.log()
        //   }
        // }
        // Object.keys(me.ToolsConfig).indexOf(data.controls.type) > -1 2021-7-1 11:33:36 过滤ai识别 识别类型不存在情况
        if (Object.keys(me.ToolsConfig).indexOf(data.controls[i].type) > -1 && data.controls[i].splitType != 'upProcess' && data.controls[i].splitType != 'downProcess') {
          tempArr.push(data.controls[i])
        }
        // 角色图标 的角色 是否存在关联岗位 isReadAttr查看时不显示
        if (data.controls[i].type === 'role' && data.controls[i].role.length > 0 && !data.controls[i].isReadAttr) {
          jq.ajax({
            type: 'GET',
            url: basFlow.baseUrl + '/org/manager/findRoleGroups/' + data.controls[i].role[0].id + '?username=' + me.username,
            data: {},
            async: false,
            success: function (res) {
              console.log(res)
              if (!!res && res.data.length > 0) {
                data.controls[i]['isRelate'] = true
              } else {
                data.controls[i]['isRelate'] = false
              }
            }
          })
        }
      }
      console.log(tempArr, 'tempArr')
      // let isEdit = sessionStorage.getItem('processInfo') && JSON.parse(sessionStorage.getItem('processInfo')).type !== 'relatedEle'
      // console.log()
      // if (sessionStorage.getItem('processInfo') && JSON.parse(sessionStorage.getItem('processInfo')).type === 'relatedEle') {
        // me.options = false
      // }
      for (var i = 0; i < tempArr.length; i++) {
        if (!tempArr[i].type) {
          return;
        }
        // //console.log(tempArr[i])
        var ctl = new GooFlow.Control(JSON.parse(JSON.stringify(tempArr[i])), me.options);
        ctl.syncUI();
        me.controls[ctl.id] = ctl;
        me.$workArea.append(ctl.$el);
      }
      // 添加泳道
      for (var i = 0; i < data.swimlanes.length; i++) {
        console.log('data', data.swimlanes[i])
        var swimObj = JSON.parse(JSON.stringify(me.ToolsConfig[data.swimlanes[i].type]))
        var obj = jq.extend(swimObj, data.swimlanes[i]);
        // 判断竖向还是横向
        obj.showMember = me.swimYheight === 90 ? 'swimlaneY' : 'swimlaneX'
        me.swimlanes[data.swimlanes[i].id] = JSON.parse(JSON.stringify(obj));

        if (data.swimlanes[i].type == 'swimlaneY') {
          if (!me.$swimlaneY) return;
          var item = me.swimlanes[data.swimlanes[i].id];
          window.$swimlaneY = me.$swimlaneY;
          var $item = jq(me.swimlaneTempl(item));
          me.$swimlaneY.append($item);

          $item.css({
            width: item.width
          });
          if (!!me.isEdit) {
            $item.resizable({
              handles: 'e',
              minWidth: me.swimMinLineWidth * me.scaleTo,
              resize: function (e, ui) {
                var id = ui.element.attr('id');
                me.swimlanes[id].width = ui.size.width / me.scaleTo;
                jq("#" + id + " .timeLine").css("width", me.swimlanes[id].width);
                jq("#" + id + ".swimlaneY .swimlane-title span").css({
                  "width": (me.swimlanes[id].width - 20)
                })
                // 解决在 泳道类型为“swimlaneY”时，调整竖泳道宽度时，文字宽度未变化的问题
                // $('.swimlaneY>.swimlane-title.J_swimlaneTitle').css({
                //   'width': '100%'
                // })
                me.computedWidth();
              },
              start: function (e, ui) {
                // 解决在 泳道类型为“swimlaneY”时，调整竖泳道宽度时，文字宽度未变化的问题
                $('.swimlaneY>.swimlane-title.J_swimlaneTitle').css({
                  'width': '100%'
                })
              },
              stop: function (e, ui) {
                var id = ui.element.attr('id');
                me.swimlanes[id].width = ui.size.width / me.scaleTo;
                me.linkMove(id, 'moveAndResize')
                jq("#" + id + ".swimlaneY .swimlane-title span").css({
                  "width": (me.swimlanes[id].width - 20)
                })
                // me.$swimlanesY.sortable( "refreshPositions" );
                me.computedWidth();
              }
            });
          }

          $item = null;
        }

        if (data.swimlanes[i].type == 'swimlaneX') {
          if (!me.$swimlaneX) return;
          window.$swimlaneX = me.$swimlaneX;
          var item = me.swimlanes[data.swimlanes[i].id];
          var $item = jq(me.swimlaneTempl(item));
          me.$swimlaneX.append($item);

          $item.css({
            height: item.height
          });

          var tempStr = "";
          for (var m = 0; m < item.depts.length; m++) {
            tempStr += (m == 0 ? "" : ",") + item.depts[m].name;
          }
          jq("#" + item.id + " .J_swimlaneTitle").attr("title", (tempStr ? tempStr : ''));
          if (!!me.isEdit) {
            $item.resizable({
              handles: 's',
              minHeight: me.swimMinLineWidth * me.scaleTo,
              maxHeight: me.swimMaxLineWidth * me.scaleTo,
              resize: function (e, ui) {
                // // me.changeScaleLine()
                // var id = ui.element.attr('id');
                // $("#" + id + " .timeLine").css("height", '100%');
              },
              start: function (e, ui) {
                // me.changeScaleLine()
                var id = ui.element.attr('id');
                $("#" + id + " .timeLine").css("height", '100%');
              },
              stop: function (e, ui) {
                var id = ui.element.attr('id');
                me.swimlanes[id].height = ui.size.height / me.scaleTo;
                me.linkMove(id, 'moveAndResizeX');
                me.computedHeight();
              }
            });
          }
          $item = null;
          if (me.swimlanes[item.id].depts.length > 0) {
            var tempDepts = "";
            var tempStation = "";
            var tempRole = "";
            for (var m = 0; m < me.swimlanes[item.id].depts.length; m++) {
              var temStore = me.swimlanes[item.id];
              // tempDepts += (m == 0 ? "" : ",") + temStore.depts[m].upLeveldeptname + (!temStore.depts[m].deptTopname ? '' : '(' + temStore.depts[m].deptTopname + ')');
              // tempStation += (m == 0 ? "" : ",") + temStore.depts[m].name;
            }
            // jq("#" + temStore.id + " .J_swimlaneTitle").attr("title", tempStr);
            // if (!!temStore && !!temStore.depts && temStore.depts.length > 0) {
            //   jq("#" + item.id + " .J_swimlaneTitle p").html(jq.i18n.prop("depts") + ':' + temStore.depts[0].upLeveldeptname + (!temStore.depts[0].deptTopname ? '' : '(' + temStore.depts[0].deptTopname + ')') + (temStore.depts.length > 1 ? '...' : '') + '<br />' + jq.i18n.prop("station") + ':' + temStore.depts[0].name + (temStore.depts.length > 1 ? '...' : ''));
            //   jq("#" + item.id + " .J_swimlaneTitle p").attr({
            //     'title': jq.i18n.prop("depts") + ':' + tempDepts + '\n' + jq.i18n.prop("station") + ':' + tempStation
            //   });
            // }
            tempDepts = me.swimlanes[obj.id].depts.map((item, index) => { return (item.type == '3' || item.type == '5') ? (!item.deptTopname ? item.upLeveldeptname:(item.deptTopname + '(' + item.upLeveldeptname + ')') ) : ''}).filter(d=>d).join(',')
            tempStation = me.swimlanes[obj.id].depts.map((item, index) => { return (item.type == '3' || item.type == '5') ?  item.name : ''}).filter(d=>d).join(',')
            tempRole = me.swimlanes[obj.id].depts.map((item, index) => { return (item.type != '3' && item.type != '5') ? item.name : ''}).filter(d=>d).join(',')
            if (!!temStore && !!temStore.depts && temStore.depts.length > 0) {
              if (!tempDepts) {
                jq("#" + obj.id + " .J_swimlaneTitle p").html(jq.i18n.prop("role") + ':' + tempRole);
                jq("#" + obj.id + " .J_swimlaneTitle p").attr({
                  'title': jq.i18n.prop("role") + ':' + tempRole
                });
              } else {
                jq("#" + obj.id + " .J_swimlaneTitle p").html(jq.i18n.prop("depts") + ':' + tempDepts + '<br />' + jq.i18n.prop("station") + ':' + tempStation + '<br />' + jq.i18n.prop("role") + ':' + tempRole);
                jq("#" + obj.id + " .J_swimlaneTitle p").attr({
                  'title': jq.i18n.prop("depts") + ':' + tempDepts + '\n' + jq.i18n.prop("station") + ':' + tempStation + '\n' + jq.i18n.prop("role") + ':' + tempRole
                });
              }
            }
          }
        }
      }
      // 添加连接线
      _.each(data.lines, function (v) {
        me.addLine(v, 'init');
      });
      me._initUpDnProcess(data);
      me.computedHeight();
      me.computedWidth();
      // 切换背景风格
      // if (!!data.qiehuanbgimg && data.qiehuanbgimg !== 'bg_img_grid') {
      //   setCookie('qiehuanbgimg', 'bg_img_white')
      // } else {
      //   setCookie('qiehuanbgimg', 'bg_img_grid')
      // }
      if (!!data.qiehuanbgimg && data.qiehuanbgimg === 'bg_img_grid') {
        setCookie('qiehuanbgimg', 'bg_img_grid')
      } else {
        setCookie('qiehuanbgimg', 'bg_img_white')
      }
      me.changeBgImg()
      if (type === 'Update') { // 加在下面 因为changeBgImg时也控制了图标显示隐藏
        let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
        console.log(!!processInfo.processType, '!!processInfo.processType')
        if (!!processInfo.processType) { // 判断为业务对象时候隐藏图标
          jq('.tools-title-current').hide() // 通用
          jq('.tools-group-current').hide()
          jq('.tools-title-advanced').hide() // 高级
          jq('.tools-group-process').hide()
          jq('.tools-title-bpmn').hide() // bpmn
          jq('.tools-group-bpmn').hide()
          jq('.tools-title-architecture').hide() // 企业框架
          jq('.tools-group-architecture').hide()
          // jq("[data-type = 'processDocumentation']").parent().hide()
          // jq("[data-type = 'processInformation']").parent().hide()
          // jq("[data-type = 'approveRules']").parent().hide()
        } else {
          if (jq(".GooFlow_lft .GooFlow_lft_item:nth-of-type(1)").hasClass('active')) {
            jq('.tools-title-current').show() // 通用
            jq('.tools-group-current').show()
            jq('.tools-title-advanced').show() // 高级
            jq('.tools-group-process').show()
            jq('.tools-title-bpmn').show() // bpmn
            jq('.tools-group-bpmn').show()
            jq('.tools-title-architecture').show() // 企业框架
            jq('.tools-group-architecture').show()
          }
          // jq("[data-type = 'processDocumentation']").parent().show()
          // jq("[data-type = 'processInformation']").parent().show()
          // jq("[data-type = 'approveRules']").parent().show()
        }
        if (jq(".GooFlow_lft .GooFlow_lft_item:nth-of-type(2)").hasClass('active')) {
          jq('.tools-title-current').hide() // 通用
          jq('.tools-group-current').hide()
          jq('.tools-title-advanced').hide() // 高级
          jq('.tools-group-process').hide()
          jq('.tools-title-bpmn').hide() // bpmn
          jq('.tools-group-bpmn').hide()
          jq('.tools-title-architecture').hide() // 企业框架
          jq('.tools-group-architecture').hide()
        }
        if (!!processInfo.type) { // 判断为流程功能分配时候隐藏图标
          jq('#btn_procFunAllocation').hide() // 流程功能分配
        } else {
          jq('#btn_procFunAllocation').show() // 流程功能分配
        }
      }
      // let processInfo = JSON.parse(sessionStorage.getItem('processInfo')) || {}
      // console.log(processInfo, 'processInfoprocessInfoprocessInfo111')
      // if (!!processInfo.processType) { // 判断为业务对象 取session数据
      //   sessionStorage.setItem('chartJson', JSON.stringify(processInfo.busObjData))
      // } else {
        sessionStorage.setItem('chartJson', JSON.stringify(me.chartJson()))
      // }
    },

    /**
     * 获取流程图 json 数据
     */

    getToJSON: function () {
      var me = this;
      console.log(122212, me.controls);
      var newCtrl = [];
      var controls = []
      for (var key in me.controls) {
        controls.push(me.controls[key].getToJSON());
      }

      for (var i = 0; i < controls.length; i++) {
        if (!Array.isArray(controls[i].system)) { // 处理之前字符串的问题
          controls[i].system = []
        }
        if (controls[i] != null) {
          newCtrl.push(controls[i]);
        }
      }
      var lines = _.map(me.lines, function (v) {
        return _.omit(v, ['$el', 'marked']);
      });


      var swimlanes = [],
        i;
      if (me.$swimlaneX) {
        var swimlaneX = me.$swimlaneX.sortable("toArray");
        //console.log(swimlaneX)
        for (i = 0; i < swimlaneX.length; i++) {
          console.log(7, swimlaneX[i]);
          if (!!swimlaneX[i] && swimlaneX[i] !== 'approvalTime') {
            swimlanes.push(me.swimlanes[swimlaneX[i]]);
          }
        }
      }

      if (me.$swimlaneY) {
        var swimlaneY = me.$swimlaneY.sortable("toArray");
        //console.log(swimlaneY)
        console.log(7, swimlaneY);


        for (i = 0; i < swimlaneY.length; i++) {
          if (!!swimlaneY[i]) {
            swimlanes.push(me.swimlanes[swimlaneY[i]]);
          }
        }
      }

      var json = {
        controls: newCtrl,
        lines: lines,
        swimlanes: swimlanes,
        qiehuanbgimg: me.qiehuanbgimg || getCookie('qiehuanbgimg')
      };

      return json;

    },





    /**
     * 初始化SVG画布
     */
    _initDraw: function () {
      var me = this;
      // 创建SVG
      me.$draw = document.createElementNS(SVG_NS, 'svg');
      me.$workArea.prepend(me.$draw);


      // 创建箭头
      var defs = document.createElementNS(SVG_NS, "defs");
      me.$draw.appendChild(defs);
      defs.appendChild(me._getSvgMarker("arrow1", me.options.color.line));
      defs.appendChild(me._getSvgMarker("arrow2", me.options.color.line));
      defs.appendChild(me._getSvgMarker("arrow3", me.options.color.mark));

      me.$draw.id = GooFlow.getUID('DRAW');

      // 绑定连线的点击选中以及双击编辑事件
      if (!me.isEdit || window.isEditAttr === false) return;

      var tmpClk = null;
      if (useSVG) {
        tmpClk = "g";
      } else {
        tmpClk = "PolyLine";
      }

      jq(me.$draw).on('click', tmpClk, function (e) {
        console.log(999999999999)
        console.log('this id', this.id)
        me.focusItem(this.id, "single");
        // me.$attrBtnBox.find('.icon-attribute').addClass('active');
        // me.$attrContentBox.children().hide();
        // me.$attrContentBox.children().eq(1).show();
        return false
      });

      jq(me.$draw).on('dblclick', tmpClk, function (e) {
        var oldTxt, x, y, from, to;
        if (useSVG) {
          oldTxt = this.childNodes[3].textContent;
          from = this.getAttribute("from").split(",");
          to = this.getAttribute("to").split(",");
        }

        if (me.lines[this.id].type == "lr") {
          from[0] = me.lines[this.id].M;
          to[0] = from[0];
        } else if (me.lines[this.id].type == "tb") {
          from[1] = me.lines[this.id].M;
          to[1] = from[1];
        }

        x = ((parseInt(from[0], 10) + parseInt(to[0], 10)) / 2 - 60);
        y = ((parseInt(from[1], 10) + parseInt(to[1], 10)) / 2 - 10);

        var t = me.$workArea.offset();
        me.$textArea.blur().val(oldTxt).css({
          display: 'block',
          position: 'absolute',
          width: 120,
          height: 48,
          "z-index": 999,
          left: (x + (me.$swimlaneY ? 40 : 0) + 80) * me.scaleTo,
          top: (y + (me.$swimlaneX ? 40 : 0) + 20) * me.scaleTo
        }).data({
          "id": me.curId[0],
          dom: this,
          type: 'line'
        }).focus();

        me.$workArea.parent().one("mousedown", function (e) {
          if (e.button == 2) return false;
          me.setName(me.$textArea.data("id"), me.$textArea.val(), "line");
          me.$textArea.val("").removeData("id").hide();
        });
      });

    },

    /**
     * 获取svg marker （箭头）
     */
    _getSvgMarker: function (id, color) {
      var m = document.createElementNS(SVG_NS, 'marker');
      m.setAttribute("id", id);
      m.setAttribute("viewBox", "2 0 6 6");
      m.setAttribute("refX", 5);
      m.setAttribute("refY", 3);
      m.setAttribute("markerUnits", "strokeWidth");
      m.setAttribute("markerWidth", 6);
      m.setAttribute("markerHeight", 6);
      m.setAttribute("orient", "auto");

      // 两直线连接而成的箭头
      var path1 = document.createElementNS(SVG_NS, 'line');
      path1.setAttribute("x1", "5");//5,3 0,0
      path1.setAttribute("y1", "3");
      path1.setAttribute("x2", "0");
      path1.setAttribute("y2", "0");
      path1.setAttribute("style", 'stroke:' + color + ';stroke-width:1.7');
      var path2 = document.createElementNS(SVG_NS, 'line');
      path2.setAttribute("x1", "5");
      path2.setAttribute("y1", "3");
      path2.setAttribute("x2", "0");
      path2.setAttribute("y2", "6");
      path2.setAttribute("style", 'stroke:' + color + ';stroke-width:1.7');
      m.appendChild(path1);
      m.appendChild(path2);
      return m;
    },



    /**
     * 初始化操作折线时的移动框
     */
    _initLineMove: function () {
      var me = this;

      // me.$lineMove = jq("<div class='GooFlow_line_move' style='display:none'></div>");
      me.$lineMove = jq("<div class='GooFlow_line_move' style='display:block'></div>");
      me.$workArea.append(me.$lineMove);

      me.$lineMove.draggable({
        opacity: 0.5,
        containment: "#J_workArea",
        start: function (e, ui) {
          console.warn('ggggggggggggg')
          me.$lineMove.css('background-color', '#333');
          if (me.$lineMove.data("type") == "lr") {
            me.$lineMove.draggable("option", "axis", "x");
          }
          else if (me.$lineMove.data("type") == "tb") {
            me.$lineMove.draggable("option", "axis", "y");
          }

        },
        stop: function (e, ui) {
          me.$lineMove.css({
            "background-color": "transparent"
          });
          var p = me.$lineMove.position();

          if (me.$lineMove.data("type") == "lr") {
            me.lines[me.$lineMove.data("tid")].difference = (p.left / me.scaleTo + 3) - me.getMValue(me.controls[me.lines[me.$lineMove.data("tid")].from], me.controls[me.lines[me.$lineMove.data("tid")].to], "lr")
           console.warn('lllllllllll', me.$lineMove)
            me.setLineM(me.$lineMove.data("tid"), p.left / me.scaleTo + 3);
          } else if (me.$lineMove.data("type") == "tb") {
            console.warn('kkkkkkkk')
            me.lines[me.$lineMove.data("tid")].difference = (p.top / me.scaleTo + 3) - me.getMValue(me.controls[me.lines[me.$lineMove.data("tid")].from], me.controls[me.lines[me.$lineMove.data("tid")].to], "tb")
            me.setLineM(me.$lineMove.data("tid"), p.top / me.scaleTo + 3);
          }

          if (me.curId[0] == me.$lineMove.data("tid")) {
            me.focusItem(me.$lineMove.data("tid"), "single");
          }
        }
      });

      jq("body").on('dblclick', '.GooFlow_line_move', function (e) {
        var oldTxt, x, y, from, to;
        var id = jq(this).data("tid");
        var _this = jq("#" + jq(this).data("tid")).get(0);
        if (useSVG) {
          oldTxt = _this.childNodes[3].textContent;
          from = _this.getAttribute("from").split(",");
          to = _this.getAttribute("to").split(",");
        }

        if (me.lines[id].type == "lr") {
          from[0] = me.lines[id].M;
          to[0] = from[0];
        } else if (me.lines[id].type == "tb") {
          from[1] = me.lines[id].M;
          to[1] = from[1];
        }

        x = ((parseInt(from[0], 10) + parseInt(to[0], 10)) / 2 - 60);
        y = ((parseInt(from[1], 10) + parseInt(to[1], 10)) / 2 - 10);

        var t = me.$workArea.offset();
        me.$textArea.blur().val(oldTxt).css({
          display: 'block',
          position: 'absolute',
          width: 120,
          height: 48,
          "z-index": 999,
          left: (x + (me.$swimlaneY ? 40 : 0) + 80) * me.scaleTo,
          top: (y + (me.$swimlaneX ? 40 : 0) + 20) * me.scaleTo
        }).data("id", me.curId[0]).focus();

        me.$workArea.parent().one("mousedown", function (e) {
          if (e.button == 2) return false;
          me.setName(me.$textArea.data("id"), me.$textArea.val(), "line");
          me.$textArea.val("").removeData("id").hide();
        });
      });
      me.$workArea.on("click", ".inModelListBoDtos-list-item", function (e) {
        const obj = jq(this).data('obj');
        console.log('obj', obj)
        const res = obj;
        var interText = doT.template(jq(`#modalDialogBusObjDetailTmpl`).text());
        jq('#modalDialogBusObjDetail').html(interText(res));
        jq('#modalDialogBusObjDetail').show()
        return false;
      })
    },

    /**
     * 初始化选定一条转换线后出现的浮动操作栏，有改变线的样式和删除线等按钮。
     */
    _initLineOper: function () {
      var me = this;
      // 选定线时显示的操作框
      // me.$lineOper = jq("<div class='GooFlow_line_oper' style='display:none'><i class='b_l1'></i><i class='b_l2'></i><i class='b_x'></i><i class='b_d'>切换</i></div>");
      me.$lineOper = jq("<div class='GooFlow_line_oper' style='display:none'><i class='b_l1'></i><i class='b_l2'></i><i class='b_x'></i></div>");
      // let xian = jq("<div class='approval-time'><div class='approval-time-tr'></div><div class='pproval-time-td'></div></div>");

      // <i class='b_l3'></i>
      me.$workArea.parent().append(me.$lineOper);
      // me.$workArea.parent().append(xian);

      me.$lineOper.on("click", function (e) {
        var e = e || window.event;
        if (e.target.tagName != "I") return;
        var id = jq(this).data("tid");
        switch (jq(e.target).attr("class")) {
          case "b_x":
            me.delLine(id);
            this.style.display = "none";
            break;
          case "b_l1":
            console.log('iiiiiiiiiiiii')
            me.setLineType(id, "lr");
            break;
          case "b_l2":
            console.log('uuuuuuuuuu')
            me.setLineType(id, "tb");
            break;
          case "b_l3":
            me.setLineType(id, "sl");
            break;
        }
      });
      jq("body").on('dblclick', '.GooFlow_line_oper', function (e) {
        var oldTxt, x, y, from, to;
        var id = jq(this).data("tid");
        var _this = jq("#" + jq(this).data("tid")).get(0);
        if (useSVG) {
          oldTxt = _this.childNodes[3].textContent;
          from = _this.getAttribute("from").split(",");
          to = _this.getAttribute("to").split(",");
        }

        if (me.lines[id].type == "lr") {
          from[0] = me.lines[id].M;
          to[0] = from[0];
        } else if (me.lines[id].type == "tb") {
          from[1] = me.lines[id].M;
          to[1] = from[1];
        }

        x = ((parseInt(from[0], 10) + parseInt(to[0], 10)) / 2 - 60);
        y = ((parseInt(from[1], 10) + parseInt(to[1], 10)) / 2 - 10);

        var t = me.$workArea.offset();
        me.$textArea.blur().val(oldTxt).css({
          display: 'block',
          position: 'absolute',
          width: 120,
          height: 48,
          "z-index": 999,
          left: (x + (me.$swimlaneY ? 40 : 0) + 80) * me.scaleTo,
          top: (y + (me.$swimlaneX ? 40 : 0) + 20) * me.scaleTo
        }).data("id", me.curId[0]).focus();

        me.$workArea.parent().one("mousedown", function (e) {
          if (e.button == 2) return false;
          me.setName(me.$textArea.data("id"), me.$textArea.val(), "line");
          me.$textArea.val("").removeData("id").hide();
        });
      });

    },

    /**
     * 初始化用来改变连线的连接端点的两个小方块
     */
    _initLinePoints: function () {
      var me = this;
      me.$mpFrom = jq("<div class='GooFlow_line_mp' style='display:none'></div>");
      me.$mpTo = jq("<div class='GooFlow_line_mp' style='display:none'></div>");
      me.$workArea.append(me.$mpFrom).append(me.$mpTo);
      console.warn('$mpFrom$mpFrom');
      me.$mpFrom.on("mousedown", function (e) {
        console.warn('hhhhhhhhhhhhhhhhhhh')
        jq(this).hide();
        // This.switchToolBtn("cursor");
        var ps = me.$mpFrom.data("p").split(",");
        var pe = me.$mpTo.data("p").split(",");

        me.$workArea.data("lineEnd", {
          "x": pe[0],
          "y": pe[1],
          "id": me.lines[me.$lineOper.data("tid")].to
        }).css("cursor", "crosshair");

        var line = me.drawLine("GooFlow_tmp_line", [ps[0], ps[1]], [pe[0], pe[1]], true, true);
        me.$draw.appendChild(line);
        return false;
      });


      me.$mpTo.on("mousedown", function (e) {
        jq(this).hide();
        // me.switchToolBtn("cursor");
        var ps = me.$mpFrom.data("p").split(",");
        var pe = me.$mpTo.data("p").split(",");

        me.$workArea.data("lineStart", {
          "x": ps[0],
          "y": ps[1],
          "id": me.lines[me.$lineOper.data("tid")].from
        }).css("cursor", "crosshair");

        var line = me.drawLine("GooFlow_tmp_line", [ps[0], ps[1]], [pe[0], pe[1]], true, true);
        me.$draw.appendChild(line);
        return false;
      });
    },


    // 原lineData已经设定好的情况下，只在绘图工作区画一条线的页面元素
    addLineDom: function (id, lineData, isNesLine) {
      console.log('addLineDom:', lineData)
      newLineId = id
      var me = this;
      // 获取开始/结束结点的数据
      var n1 = me.controls[lineData.from],
        n2 = me.controls[lineData.to];

      if (!n1 || !n2)
        return;
      // 开始计算线端点坐标
      var res;
      if (lineData.type && lineData.type != "sl" && !isNesLine) {
      // if (lineData.type && (lineData.type === "tb" || lineData.type === "lr")) {
        console.log('0000000000000000')
        res = me.calcPolyPoints(n1, n2, lineData.type, lineData.M, lineData);

      console.log(1111, res)
      }
      else {
        console.log('111111111111111')
        res = me.calcStartEnd(n1, n2, lineData);
      console.log(2222, res)
      }
      if (!res) return;

      if (lineData.type == "sl" || isNesLine) {
        console.log('44444')
        me.lines[id].$el = me.drawLine(id, res.start, res.end, lineData.marked);
      } else {
        console.log('55555')
        me.lines[id].$el = me.drawPoly(id, res.start, res.m1, res.m2, res.end, lineData.marked, lineData);
      }
      me.$draw.appendChild(me.lines[id].$el);

      if (useSVG) {
        console.log('666666')
        me.lines[id].$el.childNodes[1].innerHTML = lineData.name;
        if (me.lines[id].$el.childNodes[3]) {
          me.lines[id].$el.childNodes[3].textContent = lineData.name;
        }


        if (lineData.type != "sl" && !isNesLine) {
          console.log('777777')
          var Min = (res.start[0] > res.end[0] ? res.end[0] : res.start[0]);
          if (Min > res.m2[0]) Min = res.m2[0];
          if (Min > res.m1[0]) Min = res.m1[0];

          me.lines[id].$el.childNodes[1].style.left = (res.m2[0] + res.m1[0]) / 2 - Min - me.lines[id].$el.childNodes[1].offsetWidth / 2 + 4;

          Min = (res.start[1] > res.end[1] ? res.end[1] : res.start[1]);
          if (Min > res.m2[1]) Min = res.m2[1];
          if (Min > res.m1[1]) Min = res.m1[1];

          me.lines[id].$el.childNodes[1].style.top = (res.m2[1] + res.m1[1]) / 2 - Min - me.lines[id].$el.childNodes[1].offsetHeight / 2;
        } else {

          me.lines[id].$el.childNodes[1].style.left =
            ((res.end[0] - res.start[0]) * (res.end[0] > res.start[0] ? 1 : -1) - me.lines[id].$el.childNodes[1].offsetWidth) / 2 + 4;

        }


        var lineElement = document.getElementById(id);
        if (lineElement && !!lineElement.childNodes[3]) {
          me.lines[id].$el.childNodes[3].innerHTML = me.wrap(me.lines[id].name, lineElement, id);
          lineElement.childNodes[2].setAttribute("width", !lineElement.childNodes[3].getBBox().width ? 0 : (lineElement.childNodes[3].getBBox().width + 10))
          lineElement.childNodes[2].setAttribute("height", !lineElement.childNodes[3].getBBox().height ? 0 : (lineElement.childNodes[3].getBBox().height + 10))
          lineElement.childNodes[2].setAttribute("x", lineElement.childNodes[3].getBBox().x - 5)
          lineElement.childNodes[2].setAttribute("y", lineElement.childNodes[3].getBBox().y - 5)
        }


      }
    },

    // 增加一条线
    addLine: function (json, type) {

      var id = GooFlow.getUID('LINE');
      console.log('getUID', id)
      var me = this;
      console.log('memememe', me)
      console.log('jsonjson', json)
      if (json.from == json.to) return;

      // 获取开始/结束结点的数据
      var n1 = me.controls[json.from],
        n2 = me.controls[json.to];

      if (!n1 || !n2) {
        return
      };


      // 避免两个节点间不能有一条以上同向接连线
      // for (var k in me.lines) {
      //     if ((json.from == me.lines[k].from && json.to == me.lines[k].to)) {
      //         return;
      //     }
      // }


      // 设置lines

      me.lines[id] = {
        $el: '',
        id: id,
        type: 'sl', // 默认为直线
        M: '',
        from: '',
        to: '',
        name: '',
        priority: '', // 优先级
        desc: '',
        marked: false,
        startPos: [],
        endPos: []
      };
      jq.extend(me.lines[id], json);

      me.addLineDom(id, me.lines[id]);

      if (type !== 'init') {
        me.ctrlZlist.push({
            method: 'add',
            type: 'line',
            id: id,
            data: JSON.parse(JSON.stringify(json))
        })
      }
    },


    // 重构所有连向某个结点的线的显示，传参结构为controls数组的一个单元结构
    resetLines: function (id, node, chooseIds, offset, bool, fn) {
      console.warn('resetLines111', id, node, chooseIds, offset, bool, fn)
      var me = this;
      node.left = node.left / me.scaleTo;
      node.top = node.top / me.scaleTo;
      for (var i in me.lines) {
        // 获取结束/开始结点的数据
        var other = null,
          res,
          line = me.lines[i];
        console.log(line, 'linelinelinelinelineline')
        // var rectItemsId = window.basFlow.rectItems.map(item => item.id)
        // if (offset && !bool && (line.from == id || line.to == id) && me.curId.length > 0) {
        // rectItemsId 判断是否是框选的  线在框选里面则M点不
        // console.log(rectItemsId, rectItemsId.indexOf(line.to) === -1)
        if (offset && !bool &&
          (line.from == id || line.to == id)) {
          // ((line.from == id && rectItemsId.indexOf(line.to) === -1) || (line.to == id && rectItemsId.indexOf(line.from) === -1))) {
          console.log(line, 333333)
          let rectLinesFromId = me.rectLines.map(item => item.from)
          let rectLinesToId = me.rectLines.map(item => item.to)
          // 过滤已经移动的线 避免重复移动M点
          if (rectLinesFromId.indexOf(line.from) > -1 && rectLinesFromId.indexOf(line.from) === rectLinesToId.indexOf(line.to)) {
            console.log('撤出')
          } else {
            if (line.type == "lr") {
              if (offset.left) {
                line.M += offset.left;
              }
            }
            else if (line.type == "tb") {
              if (offset.top) {
                line.M += offset.top;
              }
              // if (line.startPos[0] <= node.left) {
              //   line.type = 'lr'
              //   line.M = node.left - 20
              // }
            }
            else if (line.type == "fr") {
              if (line.point.type == 'tb') {
                if (offset.top) {
                  line.M += offset.top;
                }
                // if (line.startPos[0] <= node.left) {
                //   line.type = 'lr'
                //   line.M = node.left - 20
                // }
              } else {
                if (offset.left) {
                  line.M += offset.left;
                }
              }
            }
            me.rectLines.push(line)
          }
          console.warn('resetLines2222', line)
        }
        if (line.from == id) { // 找结束点
          if (offset && bool && (me.controls[line.from].bindSwimYId != me.controls[id].bindSwimYId) && me.curId.length > 0) {
            if (line.type == "lr") {
              if (offset.left) {
                line.M += offset.left;
              }

            }
            else if (line.type == "tb") {
              if (offset.top) {
                line.M += offset.top;
              }
            }
            else if (line.type == "fr") {
              if (offset.left) {
                line.M += offset.left;
              }

            }
          }
          other = me.controls[line.to] || null;
          if (other == null) continue;
          if (line.type == "sl") {
            res = me.calcStartEnd(node, other);
          } else if (!offset) {
            console.log('222222222222', line)
            // if (!bool) {
            //   line.startPos[0] += offset.left
            //   line.startPos[1] += offset.top
            // }
            res = me.calcPolyPoints(node, other, line.type, line.M, line);
          }
          else if (line.type == "tb") {
            res = {
              start: [line.startPos[0] + offset.left, line.startPos[1] + offset.top],
              m1: [line.startPos[0] + offset.left, line.M],
              m2: [line.endPos[0], line.M],
              end: line.endPos
            }
            if (!bool) {
              line.startPos[0] += offset.left
              line.startPos[1] += offset.top
            }
          } else if (line.type == "lr"){ // lr
            res = {
              start: [line.startPos[0] + offset.left, line.startPos[1] + offset.top],
              m1: [line.M, line.startPos[1]+ offset.top],
              m2: [line.M, line.endPos[1]],
              end: line.endPos
            }
            if (!bool) {
              line.startPos[0] += offset.left
              line.startPos[1] += offset.top
            }
          } else if (line.type == "fr") {
            if (line.point.type == 'tb') {
              res = {
                start: [line.point.start[0] + offset.left, line.point.start[1] + offset.top],
                m1: [line.point.start[0] + offset.left, line.M],
                m2: [line.point.end[0], line.M],
                end: line.point.end
              }
            } else {
              res = {
                start: [line.point.start[0] + offset.left, line.point.start[1] + offset.top],
                m1: [line.M, line.point.start[1] + offset.top],
                m2: [line.M, line.point.end[1]],
                end: line.point.end
              }
            }
            if (!bool) {
              line.point.start[0] += offset.left
              line.point.start[1] += offset.top
              line.startPos[0] = line.point.start[0]
              line.startPos[1] = line.point.start[1]
            }
          }
          if (!res) break;
        } else if (line.to == id) { // 找开始点
          if (offset && bool && (me.controls[line.from].bindSwimYId != me.controls[id].bindSwimYId) && me.curId.length > 0) {
            if (line.type == "lr") {
              if (offset.left) {
                line.M += offset.left;
              }
            }
            else if (line.type == "tb") {
              if (offset.top) {
                line.M += offset.top;
              }
            }
            else if (line.type == "fr") {
              if (offset.left) {
                line.M += offset.left;
              }

            }
          }
          other = me.controls[line.from] || null;
          if (other == null) continue;
          if (line.type == "sl") {
            res = me.calcStartEnd(other, node);
          }
          else if (!offset) {
            console.log('3333333333333')
            // if (!bool) {
            //   line.endPos[0] += offset.left
            //   line.endPos[1] += offset.top
            // }
            res = me.calcPolyPoints(other, node, line.type, line.M, line);
          }
          else if (line.type == "tb") {
            res = {
              start: line.startPos,
              m1: [line.startPos[0], line.M],
              m2: [line.endPos[0] + offset.left, line.M],
              end: [line.endPos[0] + offset.left, line.endPos[1] + offset.top]
            }
            if (!bool) {
              line.endPos[0] += offset.left
              line.endPos[1] += offset.top
            }
          } else if (line.type == "lr"){ // lr
            res = {
              start: line.startPos,
              m1: [line.M, line.startPos[1]],
              m2: [line.M, line.endPos[1] + offset.top],
              end: [line.endPos[0] + offset.left, line.endPos[1] + offset.top]
            }
            if (!bool) {
              line.endPos[0] += offset.left
              line.endPos[1] += offset.top
            }
          } else if (line.type == "fr") {
            if (line.point.type == 'tb') {
              res = {
                start: line.point.start,
                m1: [line.point.start[0], line.M],
                m2: [line.point.end[0] + offset.left, line.M],
                end: [line.point.end[0] + offset.left, line.point.end[1] + offset.top]
              }
            } else {
              res = {
                start: line.point.start,
                m1: [line.M, line.point.start[1]],
                m2: [line.M, line.point.end[1] + offset.top],
                end: [line.point.end[0] + offset.left, line.point.end[1] + offset.top]
              }
            }
            if (!bool) {
              line.point.end[0] += offset.left
              line.point.end[1] += offset.top
              line.endPos[0] = line.point.end[0]
              line.endPos[1] = line.point.end[1]
            }
          }
          if (!res) break;
        }
        if (other == null) continue;
        me.$draw.removeChild(line.$el);
        if (line.type == "sl") {
          line.$el = me.drawLine(i, res.start, res.end, line.marked);
        } else {
          line.$el = me.drawPoly(i, res.start, res.m1, res.m2, res.end, line.marked, line);
        }
        me.$draw.appendChild(line.$el);
        if (useSVG) {
          // line.$el.childNodes[3].textContent = line.name;
          var lineElement = document.getElementById(i);
          if (lineElement) {
            line.$el.childNodes[3].innerHTML = me.wrap(line.name, lineElement, i);
            lineElement.childNodes[2].setAttribute("width", !lineElement.childNodes[3].getBBox().width ? 0 : (lineElement.childNodes[3].getBBox().width + 10))
            lineElement.childNodes[2].setAttribute("height", !lineElement.childNodes[3].getBBox().height ? 0 : (lineElement.childNodes[3].getBBox().height + 10))
            lineElement.childNodes[2].setAttribute("x", lineElement.childNodes[3].getBBox().x - 5)
            lineElement.childNodes[2].setAttribute("y", lineElement.childNodes[3].getBBox().y - 5)
          }
        }
      }

      if (fn) {
        fn();
      }
    },

    /**
     * 重新设置连线的样式 newType= "sl":直线, "lr":中段可左右移动型折线, "tb":中段可上下移动型折线
     */
    setLineType: function (id, newType, M) {
      var me = this;
      console.warn('newType', newType)
      console.warn('lines', me.lines[id])
      if (!newType || newType == null || newType == "" || !me.lines[id] || (newType == me.lines[id].type && newType != 'fr')) return false;

      var from = me.lines[id].from;
      var to = me.lines[id].to;
      me.lines[id].type = newType;
      var res;

      if (newType == "sd") { // 切换实线 虚线
        me.changeLineType()
        return
      }
      // 如果是变成折线
      if (newType != "sl") {
        console.log('444444444444')
        // var res = me.calcPolyPoints(me.controls[from], me.controls[to], me.lines[id].type, me.lines[id].M, id);
        if (M) {
          console.log('mmmmmmmmmmm')
          me.setLineM(id, M, true);
        } else {
          console.log('nnnnnnnnnnn')
          me.setLineM(id, me.getMValue(me.controls[from], me.controls[to], newType, id), true);

        }
      }
      // 如果是变回直线
      else {
        delete me.lines[id].M;
        me.$lineMove.hide().removeData("type").removeData("tid");
        res = me.calcStartEnd(me.controls[from], me.controls[to]);
        if (!res) return;
        me.$draw.removeChild(me.lines[id].$el);
        me.lines[id].$el = me.drawLine(id, res.start, res.end, me.lines[id].marked || me.curId[0] == id);
        me.$draw.appendChild(me.lines[id].$el);
        if (useSVG) {
          // me.lines[id].$el.childNodes[3].textContent = me.lines[id].name;
          var lineElement = document.getElementById(id);
          if (lineElement) {
            me.lines[id].$el.childNodes[3].innerHTML = me.wrap(me.lines[id].name, lineElement, id);
            lineElement.childNodes[2].setAttribute("width", !lineElement.childNodes[3].getBBox().width ? 0 : (lineElement.childNodes[3].getBBox().width + 10))
            lineElement.childNodes[2].setAttribute("height", !lineElement.childNodes[3].getBBox().height ? 0 : (lineElement.childNodes[3].getBBox().height + 10))
            lineElement.childNodes[2].setAttribute("x", lineElement.childNodes[3].getBBox().x - 5)
            lineElement.childNodes[2].setAttribute("y", lineElement.childNodes[3].getBBox().y - 5)
          }
        }
      }
      if (me.curId[0] == id) {
        me.focusItem(id, "single");
      }
    },

    /**
     * 设置折线中段的X坐标值（可左右移动时）或Y坐标值（可上下移动时）
     */
    setLineM: function (id, M, noStack) {
      var me = this;
      if (!me.lines[id] || M < 0 || !me.lines[id].type || me.lines[id].type == "sl") return false;
      var from = me.lines[id].from;
      var to = me.lines[id].to;

      me.lines[id].M = M;
      console.log('5555555555')
      console.log('me.line', me.lines[id])
      var ps = me.calcPolyPoints(me.controls[from], me.controls[to], me.lines[id].type, me.lines[id].M, me.lines[id], true);

      me.$draw.removeChild(me.lines[id].$el);
      console.log('pspspsps:', ps)
      me.lines[id].$el = me.drawPoly(id, ps.start, ps.m1, ps.m2, ps.end, me.lines[id].marked || me.curId[0] == id, me.lines[id]);

      me.$draw.appendChild(me.lines[id].$el);

      if (useSVG) {
        // me.lines[id].$el.childNodes[3].textContent = me.lines[id].name;
        var lineElement = document.getElementById(id);
        if (lineElement) {
          me.lines[id].$el.childNodes[3].innerHTML = me.wrap(me.lines[id].name, lineElement, id);
          lineElement.childNodes[2].setAttribute("width", !lineElement.childNodes[3].getBBox().width ? 0 : (lineElement.childNodes[3].getBBox().width + 10))
          lineElement.childNodes[2].setAttribute("height", !lineElement.childNodes[3].getBBox().height ? 0 : (lineElement.childNodes[3].getBBox().height + 10))
          lineElement.childNodes[2].setAttribute("x", lineElement.childNodes[3].getBBox().x - 5)
          lineElement.childNodes[2].setAttribute("y", lineElement.childNodes[3].getBBox().y - 5)
        }
      }
    },

    /**
     * 删除转换线
     */
    delLine: function (id) {
      var me = this;
      if (!me.lines[id]) return;

      me.ctrlZlist.push({
        method: 'del',
        type: 'line',
        data: JSON.parse(JSON.stringify(me.lines[id])),
        id: id
      })

      me.$draw.removeChild(me.lines[id].$el);
      delete me.lines[id];

      if (me.curId[0] == id) {
        me.curId[0] = "";
      }

      if (me.isEdit) {
        // 在回退新增操作时,如果节点ID以me.$id+"_line_"开头,则表示为本次编辑时新加入的节点,这些节点的删除不用加入到$deletedItem中
        // if (id.indexOf(me.$id + "_line_") < 0){
        // me.$deletedItem[id] = "line";
        // }
        me.$mpFrom.hide().removeData("p");
        me.$mpTo.hide().removeData("p");
      }
      me.$lineOper.hide().removeData("tid");
    },



    // 变更连线两个端点所连的结点
    // 参数：要变更端点的连线ID，新的开始结点ID、新的结束结点ID；如果开始/结束结点ID是传入null或者""，则表示原端点不变
    moveLinePoints: function (lineId, newStart, newEnd, type, xy) {
      console.log('moveLinePoints')
      console.log('lineId', lineId)
      console.log('newStart', newStart)
      console.log('newEnd', newEnd)
      if (newStart == newEnd) return;
      if (!lineId || !this.lines[lineId]) return;
      if (newStart == null || newStart == "")
        newStart = this.lines[lineId].from;
      if (newEnd == null || newEnd == "")
        newEnd = this.lines[lineId].to;
      console.warn(4)
      if (type === 'start') {
        this.lines[lineId].endPos = xy
      } else {
        this.lines[lineId].startPos = xy
      }
      // 避免两个节点间不能有一条以上同向接连线
      for (var k in this.lines) {
        if ((newStart == this.lines[k].from && newEnd == this.lines[k].to))
          return;
      }

      if (newStart != null && newStart != "") {
        this.lines[lineId].from = newStart;
      }

      if (newEnd != null && newEnd != "") {
        this.lines[lineId].to = newEnd;
      }
      console.warn('改线')
      // 重建转换线
      this.$draw.removeChild(this.lines[lineId].$el);
      this.addLineDom(lineId, this.lines[lineId], true);
    },



    /**
     * 绘制一条箭头线，并返回线的DOM
     */
    drawLine: function (id, sp, ep, mark, dash) {
      console.log('epep:', ep)
      var me = this
      var line;
      if (useSVG) {
        line = document.createElementNS(SVG_NS, "g");
        var hi = document.createElementNS(SVG_NS, "path");
        var path = document.createElementNS(SVG_NS, "path");
        var path2 = document.createElementNS(SVG_NS, "path");

        if (id != "") line.setAttribute("id", id);

        line.setAttribute("from", sp[0] + "," + sp[1]);
        line.setAttribute("to", ep[0] + "," + ep[1]);
        hi.setAttribute("visibility", "hidden");
        hi.setAttribute("stroke-width", 9);
        hi.setAttribute("fill", "none");
        hi.setAttribute("stroke", "white");
        hi.setAttribute("d", "M " + sp[0] + " " + sp[1] + " L " + ep[0] + " " + ep[1]);
        hi.setAttribute("pointer-events", "stroke");
        path.setAttribute("d", "M " + sp[0] + " " + sp[1] + " L " + ep[0] + " " + ep[1]);
        path.setAttribute("stroke-width", 1.4);
        path.setAttribute("stroke-linecap", "round");
        path.setAttribute("fill", "none");

        // path2.setAttribute("d", "M " + sp[0] + " " + sp[1] + " L " + ep[0] + " " + ep[1]);
        path2.setAttribute("stroke-width", 1.4);
        // path2.setAttribute("stroke-linecap", "round");
        // path2.setAttribute("fill", "none");


        if (dash) path.setAttribute("style", "stroke-dasharray:6,5");
        if (mark) {
          path.setAttribute("stroke", this.options.color.mark);
          path.setAttribute("marker-end", 'url("#arrow2")');
          // path2.setAttribute("stroke", this.options.color.mark);
          path2.setAttribute("marker-end", 'url("#arrow2")');
          // path.setAttribute("marker-start", 'url("#arrow2")');
        } else {
          path.setAttribute("stroke", this.options.color.line);
          path.setAttribute("marker-end", 'url("#arrow1")');
          // path2.setAttribute("stroke", '#2d42af');
          path2.setAttribute("marker-end", 'url("#arrow1")');
          // path.setAttribute("marker-start", 'url("#arrow1")');
        }
        path.setAttribute("class", "line1");
        path2.setAttribute("class", "line2");
        var moveLocus = "path('"  + "M " + sp[0] + " " + sp[1] + " L " + ep[0] + " " + ep[1] + "')"
        path2.setAttribute("style", "offset-path:" + moveLocus);

        line.appendChild(hi);
        line.appendChild(path);
        line.appendChild(path2);
        var moveBall = '<div class="ball" style="offset-path:' + moveLocus + '"></div>';
        // path2.append(jq(moveBall));
        line.style.cursor = "crosshair";
        console.log('lineline1111:', line)
        if (id != "" && id != "GooFlow_tmp_line") {
          var text = document.createElementNS(SVG_NS, "text");
          text.setAttribute("fill", this.options.color.font);
          line.appendChild(text);
          var x = (ep[0] + sp[0]) / 2;
          var y = (ep[1] + sp[1]) / 2;
          text.setAttribute("text-anchor", "middle");
          text.setAttribute("x", x);
          text.setAttribute("y", y);
          line.style.cursor = "pointer";
          text.style.cursor = "text";
          console.log('lineline2222:', line)
        }
      }
      return line;
    },

    drawPoly: function (id, sp, m1, m2, ep, mark, line) {
      var poly, strPath;
      if (useSVG) {
        poly = document.createElementNS(SVG_NS, "g");
        var hi = document.createElementNS(SVG_NS, "path");
        var path = document.createElementNS(SVG_NS, "path");
        var path2 = document.createElementNS(SVG_NS, "path");
        if (id != "") poly.setAttribute("id", id);
        poly.setAttribute("from", sp[0] + "," + sp[1]);
        poly.setAttribute("start", line.from);
        poly.setAttribute("end", line.to);
        poly.setAttribute("to", ep[0] + "," + ep[1]);
        hi.setAttribute("visibility", "hidden");
        hi.setAttribute("stroke-width", 9);
        hi.setAttribute("fill", "none");
        hi.setAttribute("stroke", "white");

        console.log('sp:', sp)
        console.log('m1:', m1)
        console.log('m2:', m2)
        console.log('ep:', ep)
        console.log('mark:', mark)
        console.log('line:', line)
        strPath = "M " + sp[0] + " " + sp[1];
        if (m1[0] != sp[0] || m1[1] != sp[1])
          strPath += " L " + m1[0] + " " + m1[1];
        if (m2[0] != ep[0] || m2[1] != ep[1])
          strPath += " L " + m2[0] + " " + m2[1];
        strPath += " L " + ep[0] + " " + ep[1];
        console.log('strPath:', strPath)
        hi.setAttribute("d", strPath);
        hi.setAttribute("pointer-events", "stroke");
        path.setAttribute("d", strPath);
        path.setAttribute("stroke-width", 1.7);
        path.setAttribute("stroke-linecap", "round");
        path.setAttribute("fill", "none");

        // path2.setAttribute("d", strPath);
        path2.setAttribute("stroke-width", 1.7);
        // path2.setAttribute("stroke-linecap", "round");
        // path2.setAttribute("fill", "none");
        //console.log(mark, this.options, line)
        if (mark) {
          // jq(this).attr("class").indexOf("active") == -1
          path.setAttribute("stroke", this.options.color.mark);
          path.setAttribute("marker-end", 'url("#arrow2")');
          // path2.setAttribute("stroke", this.options.color.mark);
          path2.setAttribute("marker-end", 'url("#arrow2")');
          // path.setAttribute("marker-start", 'url("#arrow2")');
          if (!line.lineType || line.lineType == 'solid') {
            line.lineType = 'solid'
            // path.setAttribute("stroke-dasharray", "0 0");
          } else {
            line.lineType = 'dash'
            path.setAttribute("stroke-dasharray", "3 3");
            // path2.setAttribute("stroke-dasharray", "3 3");
          }
        } else {
          path.setAttribute("stroke", this.options.color.line);
          path.setAttribute("marker-end", 'url("#arrow1")');
          // path2.setAttribute("stroke", '#2d42af');
          path2.setAttribute("marker-end", 'url("#arrow1")');
          // path.setAttribute("marker-start", 'url("#arrow1")');
          if (!line.lineType || line.lineType == 'solid') {
            line.lineType = 'solid'
            // path.setAttribute("stroke-dasharray", "0 0");
          } else {
            line.lineType = 'dash'
            path.setAttribute("stroke-dasharray", "3 3");
            // path2.setAttribute("stroke-dasharray", "3 3");
          }
        }
        if (jq('.J_line ') && jq('.J_line ').attr("class") && jq('.J_line ').attr("class").indexOf("active") > -1) {
          line.lineType = 'solid'
          // path.setAttribute("stroke-dasharray", "0 0");
          path.setAttribute("stroke", this.options.color.line);
          // path2.setAttribute("stroke", this.options.color.line);
        }
        if (jq('.J_dotted_line ') && jq('.J_dotted_line ').attr("class") && jq('.J_dotted_line ').attr("class").indexOf("active") > -1) {
          line.lineType = 'dash'
          path.setAttribute("stroke-dasharray", "3 3");
          // path2.setAttribute("stroke-dasharray", "3 3");
        }

        path.setAttribute("class", "line1");
        path2.setAttribute("class", "line2");
        var moveLocus = "path('"  + strPath + "')"
        path2.setAttribute("style", "offset-path:" + moveLocus);

        poly.appendChild(hi);
        poly.appendChild(path);
        poly.appendChild(path2);

        var moveBall = '<div class="ball" style="offset-path:' + moveLocus + '"></div>';
        // poly.append(jq(moveBall));
        console.log('polypoly:', poly)
        var rect = document.createElementNS(SVG_NS, "rect");
        rect.setAttribute("fill", "#fff");
        rect.setAttribute("x", sp[0]);
        rect.setAttribute("y", sp[1]);
        rect.setAttribute("width", 10);
        rect.setAttribute("width", 2);
        poly.appendChild(rect);

        var x = (ep[0] + sp[0]) / 2;
        var y = (ep[1] + sp[1]) / 2;
        // rect.setAttribute("x", x);
        // rect.setAttribute("y", y);
        var text = document.createElementNS(SVG_NS, "text");
        text.setAttribute("fill", this.options.color.font);
        poly.appendChild(text);

        console.log(line, 'line')
        // var circle = document.createElementNS(SVG_NS, "circle");
        // circle.setAttribute("cx", sp[0]);
        // circle.setAttribute("cy", sp[1]);
        // circle.setAttribute("fill", "#00a1f7");
        // circle.setAttribute("r", "5");
        // circle.setAttribute("width", "10");
        // poly.appendChild(circle);

        var x = (m2[0] + m1[0]) / 2;
        var y = (m2[1] + m1[1]) / 2;
        text.setAttribute("text-anchor", "middle");
        text.setAttribute("x", x);
        text.setAttribute("y", y);
        // text.setAttribute("filter", "url(#bg-rect)");
        text.style.cursor = "text";
        poly.style.cursor = "pointer";
      }
      //console.log(poly)
      return poly;
    },

    /**
     * 计算两个结点间要连直线的话，连线的开始坐标和结束坐标
     */
    calcStartEnd: function (n1, n2, lineData) {
      console.log('直线n1', n1)
      console.log('直线n2', n2)
      var X_1, Y_1, X_2, Y_2;
      console.warn(lineData)
      // X判断：
      var x11 = n1.left,
        x12 = n1.left + n1.width,
        x21 = n2.left,
        x22 = n2.left + n2.width;
      // 结点2在结点1左边
      if (x11 >= x22) {
        X_1 = x11;
        X_2 = x22;
      }
      // 结点2在结点1右边
      else if (x12 <= x21) {
        X_1 = x12;
        X_2 = x21;
      }
      // 结点2在结点1水平部分重合
      else if (x11 <= x21 && x12 >= x21 && x12 <= x22) {
        X_1 = (x12 + x21) / 2;
        X_2 = X_1;
      } else if (x11 >= x21 && x12 <= x22) {
        X_1 = (x11 + x12) / 2;
        X_2 = X_1;
      } else if (x21 >= x11 && x22 <= x12) {
        X_1 = (x21 + x22) / 2;
        X_2 = X_1;
      } else if (x11 <= x22 && x12 >= x22) {
        X_1 = (x11 + x22) / 2;
        X_2 = X_1;
      }

      // Y判断：
      var y11 = n1.top,
        y12 = n1.top + n1.height,
        y21 = n2.top,
        y22 = n2.top + n2.height;
      // 结点2在结点1上边
      if (y11 >= y22) {
        Y_1 = y11;
        Y_2 = y22;
      }
      // 结点2在结点1下边
      else if (y12 <= y21) {
        Y_1 = y12;
        Y_2 = y21;
      }
      // 结点2在结点1垂直部分重合
      else if (y11 <= y21 && y12 >= y21 && y12 <= y22) {
        Y_1 = (y12 + y21) / 2;
        Y_2 = Y_1;
      } else if (y11 >= y21 && y12 <= y22) {
        Y_1 = (y11 + y12) / 2;
        Y_2 = Y_1;
      } else if (y21 >= y11 && y22 <= y12) {
        Y_1 = (y21 + y22) / 2;
        Y_2 = Y_1;
      } else if (y11 <= y22 && y12 >= y22) {
        Y_1 = (y11 + y22) / 2;
        Y_2 = Y_1;
      }
      return {
        "start": [X_1, Y_1],
        "end": [X_2, Y_2]
      };
    },

    /**
     * 计算两个结点间要连折线的话，连线的所有坐标
     */
    calcPolyPoints: function (n1, n2, type, M, line, isNew) {
      console.log('折线n1', n1)
      console.log('折线n2', n2)
      console.log('折线type', type)
      console.log('折线M', M)
      console.log('折线line', line)
      console.log('折线isNew', isNew)
      var me = this;
      // 开始/结束两个结点的中心
      // type = 'lr'
      // M = 540
      // var me = this;
      // type = me.lines[id].type
      var SP = {
        x: n1.left + n1.width / 2,
        y: n1.top + n1.height / 2
      };
      var EP = {
        x: n2.left + n2.width / 2,
        y: n2.top + n2.height / 2
      };
      var sp = [],
        m1 = [],
        m2 = [],
        ep = [];
      // 如果是允许中段可左右移动的折线,则参数M为可移动中段线的X坐标
      // 粗略计算起始点
      sp = [SP.x, SP.y];
      ep = [EP.x, EP.y];
      if (type == "lr" ) {
        // 粗略计算2个中点
        m1 = [M, SP.y];
        m2 = [M, EP.y];
        // 再具体分析修改开始点和中点1
        if (m1[0] > n1.left && m1[0] < n1.left + n1.width) {
          m1[1] = (SP.y > EP.y ? n1.top : n1.top + n1.height);
          sp[0] = m1[0];
          sp[1] = m1[1];
        } else {
          sp[0] = (m1[0] < n1.left ? n1.left : n1.left + n1.width)
        }
        // 再具体分析中点2和结束点
        if (m2[0] > n2.left && m2[0] < n2.left + n2.width) {
          m2[1] = (SP.y > EP.y ? n2.top + n2.height : n2.top);
          ep[0] = m2[0];
          ep[1] = m2[1];
        } else {
          ep[0] = (m2[0] < n2.left ? n2.left : n2.left + n2.width)
        }
      }
      // 如果是允许中段可上下移动的折线,则参数M为可移动中段线的Y坐标
      else if (type == "tb") {
        // 粗略计算2个中点
        m1 = [SP.x, M];
        m2 = [EP.x, M];
        // 再具体分析修改开始点和中点1
        if (m1[1] > n1.top && m1[1] < n1.top + n1.height) {
          m1[0] = (SP.x > EP.x ? n1.left : n1.left + n1.width);
          sp[0] = m1[0];
          sp[1] = m1[1];
        } else {
          sp[1] = (m1[1] < n1.top ? n1.top : n1.top + n1.height)
        }
        // 再具体分析中点2和结束点
        if (m2[1] > n2.top && m2[1] < n2.top + n2.height) {
          m2[0] = (SP.x > EP.x ? n2.left + n2.width : n2.left);
          ep[0] = m2[0];
          ep[1] = m2[1];
        } else {
          ep[1] = (m2[1] < n2.top ? n2.top : n2.top + n2.height);
        }
      }
      else if (type == "fr") {
        console.warn('line', line)
        if (isNew) {
          sp = line.point.start
          ep = line.point.end
          if (line.point.type === 'lr') {
            m1 = [M, line.point.start[1]];
            m2 = [M, line.point.end[1]];
          }
          else if (line.point.type === 'tb') {
            m1 = [line.point.start[0], M];
            m2 = [line.point.end[0], M];
          }
        } else {
          if (line.point.type === 'lr') {
            // 粗略计算2个中点
            m1 = [M, SP.y];
            m2 = [M, EP.y];
            // 再具体分析修改开始点和中点1
            if (m1[0] > n1.left && m1[0] < n1.left + n1.width) {
              m1[1] = (SP.y > EP.y ? n1.top : n1.top + n1.height);
              sp[0] = m1[0];
              sp[1] = m1[1];
            } else {
              sp[0] = (m1[0] < n1.left ? n1.left : n1.left + n1.width)
            }
            // 再具体分析中点2和结束点
            if (m2[0] > n2.left && m2[0] < n2.left + n2.width) {
              m2[1] = (SP.y > EP.y ? n2.top + n2.height : n2.top);
              ep[0] = m2[0];
              ep[1] = m2[1];
            } else {
              ep[0] = (m2[0] < n2.left ? n2.left : n2.left + n2.width)
            }
          } else {
            // 粗略计算2个中点
            m1 = [SP.x, M];
            m2 = [EP.x, M];
            // 再具体分析修改开始点和中点1
            if (m1[1] > n1.top && m1[1] < n1.top + n1.height) {
              m1[0] = (SP.x > EP.x ? n1.left : n1.left + n1.width);
              sp[0] = m1[0];
              sp[1] = m1[1];
            } else {
              sp[1] = (m1[1] < n1.top ? n1.top : n1.top + n1.height)
            }
            // 再具体分析中点2和结束点
            if (m2[1] > n2.top && m2[1] < n2.top + n2.height) {
              m2[0] = (SP.x > EP.x ? n2.left + n2.width : n2.left);
              ep[0] = m2[0];
              ep[1] = m2[1];
            } else {
              ep[1] = (m2[1] < n2.top ? n2.top : n2.top + n2.height);
            }
          }
        }
      }
      return {
        start: sp,
        m1: m1,
        m2: m2,
        end: ep
      };
    },

    /**
     * 初始化折线中段的X/Y坐标,mType='lr'时为X坐标,mType='tb'时为Y坐标, fr 自由连线
     */
    getMValue: function (n1, n2, mType, id) {
      var me = this;
      if (mType == "lr") {
        return (n1.left + n1.width / 2 + n2.left + n2.width / 2) / 2;
        console.log((n1.left + n1.width / 2 + n2.left + n2.width / 2) / 2)
      } else if (mType == "tb") {
        return (n1.top + n1.height / 2 + n2.top + n2.height / 2) / 2;
        console.log((n1.top + n1.height / 2 + n2.top + n2.height / 2) / 2)
      } else if (mType === 'fr') {
        var line = me.lines[id];
        console.log('line:', me.lines[id])
        console.log('n1n1n1n1:', n1)
        console.log('n2n2n2n2:', n2)
      //  矩形的四条边的中点
        var O_1,O_2,O_3,O_4;
        O_1 = [n1.left + n1.width / 2, n1.top]; // 上
        O_2 = [n1.left + n1.width, n1.top + n1.height / 2]; //右
        O_3 = [n1.left + n1.width / 2, n1.top + n1.height]; // 下
        O_4 = [n1.left, n1.top + n1.height / 2] // 左
        // console.log(O_1, O_2, O_3, O_4)
        var O = [O_1, O_2, O_3, O_4]
        // 找出鼠标开始点离哪个中点最近
        var s1 = Math.sqrt(Math.pow(O_1[0] -line.startPos[0], 2) + Math.pow(O_1[1] - line.startPos[1], 2));
        var s2 = Math.sqrt(Math.pow(O_2[0] -line.startPos[0], 2) + Math.pow(O_2[1] - line.startPos[1], 2));
        var s3 = Math.sqrt(Math.pow(O_3[0] -line.startPos[0], 2) + Math.pow(O_3[1] - line.startPos[1], 2));
        var s4 = Math.sqrt(Math.pow(O_4[0] -line.startPos[0], 2) + Math.pow(O_4[1] - line.startPos[1], 2));
        // console.log('distance', s1,s2,s3,s4)
        // console.log(Math.min(s1, s2, s3, s4))
        // var O = Math.min(s1, s2, s3, s4);
        var s = [s1,s2,s3,s4]
        var minIndex1 = s.indexOf(Math.min(s1, s2, s3, s4))
        var start = O[minIndex1]
        // console.log('line', me.lines[id])
        if (!me.lines[id].point) me.lines[id].point = {}
        me.lines[id].point.start = start
        var P_1,P_2,P_3,P_4;
        P_1 = [n2.left + n2.width / 2, n2.top]; // 上
        P_2 = [n2.left + n2.width, n2.top + n2.height / 2]; //右
        P_3 = [n2.left + n2.width / 2, n2.top + n2.height]; // 下
        P_4 = [n2.left, n2.top + n2.height / 2] // 左
        console.log(P_1, P_2, P_3, P_4)
        var P = [P_1, P_2, P_3, P_4]
        // 找出鼠标开始点离哪个中点最近
        var k1 = Math.sqrt(Math.pow(P_1[0] -line.endPos[0], 2) + Math.pow(P_1[1] - line.endPos[1], 2));
        var k2 = Math.sqrt(Math.pow(P_2[0] -line.endPos[0], 2) + Math.pow(P_2[1] - line.endPos[1], 2));
        var k3 = Math.sqrt(Math.pow(P_3[0] -line.endPos[0], 2) + Math.pow(P_3[1] - line.endPos[1], 2));
        var k4 = Math.sqrt(Math.pow(P_4[0] -line.endPos[0], 2) + Math.pow(P_4[1] - line.endPos[1], 2));
        var k = [k1,k2,k3,k4]
        var minIndex2 = k.indexOf(Math.min(k1, k2, k3, k4))
        var end = P[minIndex2]
        me.lines[id].point.end = end
        console.log(me.lines[id])
        // 左上
        if (start[0] > end[0] && start[1] > end[1]) {
          console.warn('左上')
          // 上
          if (minIndex1 === 0 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height / 3
          }
          if (minIndex1 === 0 && minIndex2 === 1) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height / 2
          }
          if (minIndex1 === 0 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return (n1.top + n2.top + n2.height) / 2
          }
          if (minIndex1 === 0 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }

          // 右
          if (minIndex1 === 1 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height / 3
          }
          if (minIndex1 === 1 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n1.left + n1.width + n1.width / 3
          }
          if (minIndex1 === 1 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return (n1.top + n2.top + n2.height) / 2
          }
          if (minIndex1 === 1 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }

          // 下
          if (minIndex1 === 2 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height / 3
          }
          if (minIndex1 === 2 && minIndex2 === 1) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height / 2
          }
          if (minIndex1 === 2 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n1.top + n1.height + n1.height / 3
          }
          if (minIndex1 === 2 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }

          // 左
          if (minIndex1 === 3 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height /3
          }
          if (minIndex1 === 3 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return (n2.left + n2.width + n1.left ) / 2
          }
          if (minIndex1 === 3 && minIndex2 === 2) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width / 2
          }
          if (minIndex1 === 3 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }
        }
        // 右上
        if (start[0] < end[0] && start[1] > end[1]) {
          console.warn('右上')
          // 上
          if (minIndex1 === 0 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height / 3
          }
          if (minIndex1 === 0 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 0 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return (n1.top + n2.top + n2.height) / 2
          }
          if (minIndex1 === 0 && minIndex2 === 3) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height / 2
          }

          // 右
          if (minIndex1 === 1 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height / 3
          }
          if (minIndex1 === 1 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 1 && minIndex2 === 2) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width / 2
          }
          if (minIndex1 === 1 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return (n1.top + n2.top + n2.height) / 2
          }

          // 下
          if (minIndex1 === 2 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height / 2
          }
          if (minIndex1 === 2 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 2 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n1.top + n1.height + n1.height / 3
          }
          if (minIndex1 === 2 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return (n1.top + n2.top + n2.height) / 2
          }

          // 左
          if (minIndex1 === 3 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height /3
          }
          if (minIndex1 === 3 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 3 && minIndex2 === 2) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width / 2
          }
          if (minIndex1 === 3 && minIndex2 === 3) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height / 2
          }
        }
        // 右下
        if (start[0] <end[0] && start[1] < end[1]) {
          console.warn('右下')
          // 上
          if (minIndex1 === 0 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n1.top - n1.height / 3
          }
          if (minIndex1 === 0 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 0 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height / 3
          }
          if (minIndex1 === 0 && minIndex2 === 3) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height / 2
          }

          // 右
          if (minIndex1 === 1 && minIndex2 === 0) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width / 2
          }
          if (minIndex1 === 1 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 1 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height / 3
          }
          if (minIndex1 === 1 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return (n1.left + n1.width + n2.left) / 2
          }

          // 下
          if (minIndex1 === 2 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height / 2
          }
          if (minIndex1 === 2 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 2 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height / 3
          }
          if (minIndex1 === 2 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n1.left + n1.width / 2
          }

          // 左
          if (minIndex1 === 3 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n2.top - n2.height /3
          }
          if (minIndex1 === 3 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width + n2.width / 3
          }
          if (minIndex1 === 3 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height / 3
          }
          if (minIndex1 === 3 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n1.left - n1.width / 3
          }
        }
        // 左下
        if (start[0] > end[0] && start[1] < end[1]) {
          console.warn('左下')
          // 上
          if (minIndex1 === 0 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return n1.top - n1.height / 3
          }
          if (minIndex1 === 0 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return (n1.left + n1.width / 2 + n2.left + n2.width) / 2
          }
          if (minIndex1 === 0 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height / 3
          }
          if (minIndex1 === 0 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }

          // 右
          if (minIndex1 === 1 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return (n1.top + n1.height / 2 + n2.top) / 2
          }
          if (minIndex1 === 1 && minIndex2 === 1) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height / 2
          }
          if (minIndex1 === 1 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height / 3
          }
          if (minIndex1 === 1 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }

          // 下
          if (minIndex1 === 2 && minIndex2 === 0) {
            me.lines[id].point.type = 'tb'
            return (n1.top + n1.height + n2.top) / 2
          }
          if (minIndex1 === 2 && minIndex2 === 1) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height / 2
          }
          if (minIndex1 === 2 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height / 3
          }
          if (minIndex1 === 2 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }

          // 左
          if (minIndex1 === 3 && minIndex2 === 0) {
            me.lines[id].point.type = 'lr'
            return n2.left + n2.width / 2
          }
          if (minIndex1 === 3 && minIndex2 === 1) {
            me.lines[id].point.type = 'lr'
            return (n1.left + n2.left + n2.width) / 2
          }
          if (minIndex1 === 3 && minIndex2 === 2) {
            me.lines[id].point.type = 'tb'
            return n2.top + n2.height + n2.height/ 3
          }
          if (minIndex1 === 3 && minIndex2 === 3) {
            me.lines[id].point.type = 'lr'
            return n2.left - n2.width / 3
          }
        }

      }

    },



  }


  /**
   * 生成ID
   */
  GooFlow.getUID = function (ns) {
    return ns + uuid(8, 16);
  }

  /**
   * 控件配置
   *
   * @type {Object}
   */
  var ToolsConfig = GooFlow.prototype.ToolsConfig = (function () {
    return ToolsConfigJson
  })()

  GooFlow.prototype.addToolsConfig = function (ns, obj) {
    if (!(ns in this.ToolsConfig)) {
      this.ToolsConfig[ns] = obj;
    }
  }

  /**
   * 左边操作栏工具对象
   */
  GooFlow.Tools = function (type, options) {
    this.$el = '';
    this.id = GooFlow.getUID('TOOLS');
    this.type = type;
    this.options = options || {};

    // 继承config属性
    let obj = JSON.parse(JSON.stringify(ToolsConfig[type]))
    // if (!!this.options && !this.options.isEdit) {
    if (!window.isEditAttr || (!!this.options && !this.options.isEdit)) {
      obj.drag = false;
      obj.resize = false;
    }
    jq.extend(this, obj);

    this._init();
  }

  GooFlow.Tools.prototype = {
    constructor: GooFlow.Tools,

    _init: function () {
      var me = this;
      if (!(me.type in ToolsConfig)) {
        return
      };
      var templ = '<div id="' + me.id + '" data-type="' + me.type + '" class="tools tools_img"><img class="' + me.type + '" src="./' + me.options.toolsPath + '/' + ToolsConfig[me.type].img + '"></img><p>' + ToolsConfig[me.type].rename + '</p>'
      me.$el = jq(templ);

      if (me.drag) {
        var templSelector = me.templ || '#' + me.type + '_templ';
        me.helper = doT.template(jq(templSelector).text());
        me._initDrag();
      }

    },
    _initDrag: function () {
      var me = this;
      if (me.drag) {
        me.$el.draggable({
          helper: function () {
            // 这里返回的是拖拽到画布的节点
            return me.helper({
              id: me.id,
              name: me.name,
              type: me.type,
              width: me.width,
              height: me.height,
              img: me.img,
              isHelper: true
            });
          },
          opacity: 0.5,
          cursorAt: {
            left: 20,
            top: 0
          },
          containment: "document",
          zIndex: 9999
        });
      }
    }
  }



  /**
   * 右边控件对象
   */
  GooFlow.Control = function (obj, options) {
    //console.log(obj)
    //console.log(options)
    this.id = GooFlow.getUID('CONTROL');
    this.$el = null;
    this.name = this.id;
    this.type = obj.type;
    this.left = 0;
    this.top = 0;
    this.width = 0;
    this.height = 0;
    this.inputname = '';
    this.outputnamename = ''
    this.remark = ''

    let toolsobj = JSON.parse(JSON.stringify(ToolsConfig[obj.type]))
    toolsobj.toolsPath = options.toolsPath
    // if (!!options && !options.isEdit) {
    if (!window.isEditAttr || (!!options && !options.isEdit)) {
      toolsobj.drag = false;
      toolsobj.resize = false;
      obj.drag = false;
      obj.resize = false;
    }
    jq.extend(this, toolsobj, obj);
    this.inputname = obj.inputname ? obj.inputname : '';
    this.outputname = obj.outputname ? obj.outputname : '';
    this._init();

  }
  GooFlow.Control.prototype = {
    constructor: GooFlow.Control,

    _init: function () {
      var me = this;
      var templSelector = '#img_templ';

      me.templ = doT.template(jq(templSelector).text());
      me.$el = jq(me.templ(me));

      me.$el.css({
        width: me.width,
        height: me.height,
        left: me.left,
        top: me.top
      });

      if (me.drag) {
        me._initDrag();
      }

      if (me.resize) {
        me._initResize();
      }
    },
    _initDrag: function () {
      var me = this;
      me.$el.draggable({
        helper: 'clone',
        // snap: true ,
        cursor: 'move',
        opacity: 0.5,
        appendTo: 'body',
        containment: ".J_workArea",
        start: function (event, ui) {
          var id = jq(this).attr("id");
          var ids = JSON.parse(JSON.stringify(basFlow.curId));
          basFlow.initObj = JSON.parse(JSON.stringify(basFlow.controls[id]))
          if (
            !(basFlow.ctrlZlist[basFlow.ctrlZlist.length - 1] && !!basFlow.ctrlZlist[basFlow.ctrlZlist.length - 1].data && !!basFlow.ctrlZlist[basFlow.ctrlZlist.length - 1].data.ids && basFlow.ctrlZlist[basFlow.ctrlZlist.length - 1].data.ids.indexOf(id) > -1)
          ) {
            basFlow.ctrlZlist.push({
              method: 'move',
              type: 'control',
              id: id,
              data: {
                ids: ids,
                controls: JSON.parse(JSON.stringify(basFlow.controls)),
                lines: JSON.parse(JSON.stringify(basFlow.lines))
              }
            })
          }
        },
        stop: function (event, ui) {
          var id = jq(this).attr("id");
          // console.log(basFlow.referInnerLine(basFlow._getToWorkOffset(ui.offset), me.type, me.height), basFlow._getToWorkOffset(ui.offset), ui.offset, 'ui.offsetui.offsetui.offset', me.type, me.height)
          if (!basFlow.referInnerLine(basFlow._getToWorkOffset(ui.offset), me.type, me.height) && getCookie('qiehuanbgimg') === 'bg_img_grid') {
            basFlow.alertBox(jq.i18n.prop("addProcessRule") + "! ", 'danger');
            //console.log(me)
            //console.log(basFlow.initObj)
            me.left = JSON.parse(JSON.stringify(basFlow.initObj)).left
            me.top = JSON.parse(JSON.stringify(basFlow.initObj)).top
            jq("#" + me.id).css({
              "left": me.left * basFlow.scaleTo,
              "top": me.top * basFlow.scaleTo
            })
            basFlow.linkMove(id, 'moveAndResizeX');
          } else {
            // 链接泳道
            //console.log(this)
            basFlow.linkage(id)
          }
        }
        // drag: function (event, ui) {
        //   var id = jq(this).attr("id");
        //   console.log('12155', event, ui);
        //   console.log(jq('.J_workArea ').css('width'), jq('.J_workArea ').css('height'), basFlow._getToWorkOffset(ui.offset), basFlow.controls[id])
        //   if ((Number(jq('.J_workArea ').css('width').replace("px", "")) - 20) < (basFlow._getToWorkOffset(ui.offset).left + basFlow.controls[id].width)) {
        //     console.log(111111)
        //     var swimlaneY_length = jq(".swimlaneY-list .swimlaneY").length -1
        //     var swimlaneY_lastId = jq(".swimlaneY-list .swimlaneY").eq(swimlaneY_length).attr("id")
        //     console.log(swimlaneY_length)
        //     console.log(swimlaneY_lastId)
        //     var swimlaneY_lastWidth = basFlow.swimlanes[swimlaneY_lastId].width
        //     basFlow.swimlanes[swimlaneY_lastId].width = swimlaneY_lastWidth + 20
        //     jq(".swimlaneX-list .swimlaneX").eq(swimlaneY_length).css("width", swimlaneY_lastWidth + 20)
        //   } else {
        //     console.log(222222)
        //   }
        // }
      });
    },

    _initResize: function () {
      var me = this;
      me.$el.resizable({
        helper: "ui-resizable-helper",
        start: function (event, ui) {
          var id = jq(this).attr("id");
          var ids = JSON.parse(JSON.stringify(basFlow.curId));
          if (!!basFlow.ctrlZlist[basFlow.ctrlZlist.length - 1] && !!basFlow.ctrlZlist[basFlow.ctrlZlist.length - 1].data.ids && basFlow.ctrlZlist[basFlow.ctrlZlist.length - 1].data.ids.indexOf(id) > -1) return false
          basFlow.ctrlZlist.push({
            method: 'resize',
            type: 'control',
            id: id,
            data: {
              ids: ids,
              controls: JSON.parse(JSON.stringify(basFlow.controls)),
              lines: JSON.parse(JSON.stringify(basFlow.lines))
            }
          })
        },
        stop: function (event, ui) {
          var id = jq(this).attr("id");
          jq("#" + id).css({
            "width": ui.size.width / basFlow.scaleTo,
            "height": ui.size.height / basFlow.scaleTo
          })

          basFlow.controls[id].width = ui.size.width / basFlow.scaleTo
          basFlow.controls[id].height = ui.size.height / basFlow.scaleTo
          // 链接泳道
          basFlow.linkage(id)
        }
      });
    },

    getToJSON: function () {
      var me = this,
        pick = _.pick(me, _.keys(me)),
        json = _.omit(pick, ['$el', 'marked', 'templ']);
      return json;
    },

    syncUI: function (offset) {
      var $el = this.$el;
      if (offset) {
        $el.offset(offset);
      }
      var pos = $el.is(':hidden') ? offset : $el.position();
      jq.extend(this, pos, {
        width: $el.width(),
        height: $el.height()
      });
    },

    focus: function () {
      var me = this;
      //console.log(this.$el, this.$el.siblings())
      // this.$el.siblings().removeClass("cur");
      this.$el.addClass('cur');
    },

    blur: function () {
      jq('.control.cur').removeClass('cur');
      console.log('blur')
      // if (isCurClass()) {
      // } else {
      //    this.$el.removeClass('cur');
      // }
    },

    remove: function () {
      this.$el.resizable("destroy");
      this.$el.draggable("destroy");
      this.$el.remove();
    }

  }

  jq.fn.extend({
    createGooFlow: function (options) {
      // 创建一个实例对象
      return new GooFlow(this, options);
    }
  });

})(window, jQuery);

// 复制选择流程图 --------------------------------------------------- 结束
