import { fetch } from '../utils/utils.js'

// 获取发布的数据
export function getLast(id) {
  return fetch({
    url: '/listhistory/getLast/' + id,
    method: 'post'
  })
}

// 获取保存的数据
export function getMyJson(listid) {
  return fetch({
    url: '/listhistory/getMyJson/' + listid,
    method: 'post',
    async: false
  })
}

// 获取流程图的风格
// export async function getModelLegend(params) {
//   const res = await fetch({
//     url: `/modelLegend/get/1`,
//     method: 'get',
//     params
//   }).catch(e => Promise.reject(e))
//   return Promise.resolve(res)
// }

export function getModelLegend (params) {
  return new Promise((resolve, reject) => {
    fetch({
      url: `/modelLegend/get/1`,
      method: 'GET',
      toast: false,
      params
    }).then(rt => {
      resolve(rt)
    }).catch(e => {
      reject(e)
    })
  })
}

export function uploadFile(data) {
  return fetch({
    url: '/document/saveCopy',
    method: 'put',
    data
  })
}

export function deluploadFile(id) {
  return fetch({
    url: '/document/docdeleteCopy/' + id,
    method: 'get'
  })
}