import { fetch } from '../../utils/utils.js'
var username = JSON.parse(localStorage.getItem('portalCurrentUserInfo') || '{}').empuid

/**
 * 获取标签
 * @date 2021-09-27
 * @param {string} categoryId
 * @param {string} parentId
 */
export function getTab ({categoryId, parentId}) {
  console.log('categoryId, parentId',categoryId, parentId)
  const filters = []
    filters.push({
      "key": "categoryId",
      "value": categoryId,
      "sort": "desc"
    })

    filters.push({
      "key": "parentId",
      "value": parentId,
      "sort": "desc"
    })
  return fetch({
    url: '/dynamicAttribute/tab/query',
    method: 'post',
    data: {
      filters
    }
  })
}

/**
 * 获取分类
 * @date 2021-09-27
 */
export function getCategory () {
  return fetch({
    url: '/dynamicAttribute/category/',
    method: 'get'
  })
}

/**
 * 获取属性
 * @date 2021-09-27
 * @param {string} tabId
 */
export function getAttribute ({tabId}) {
  return fetch({
    url: '/dynamicAttribute/attribute/',
    method: 'get',
    params: {
      tabId
    }
  })
}
