import Vue from 'vue'
import ElementUI from 'element-ui'

import App from './index.vue'

/**
 * 左侧tab
 * @date 2021-06-27
 * @param {any}
 * @returns {any}
 */
export const menu = [
  { id: 'GooFlow_lft1', name: jq.i18n.prop('drawing') },
  { id: 'GooFlow_lft2', name: jq.i18n.prop('architecture') },
  // { id: 'GooFlow_lft3', name: jq.i18n.prop('icon') }
]

export let menuTemp = '<div class="GooFlow_lft">'
menu.map((v, index) => {
  menuTemp += `<div class="GooFlow_lft_item" id="${v.id}" title="${v.name}"><i class="GooFlow_lft_item${index + 1}"></i><span>${v.name}</span></div>`
})
menuTemp += '</div>';

/**
 * 左边栏
 * @date 2021-06-27
 * @param {any} tools
 * @returns {any}
 */
export const leftNavContent = (tools)=> {
    let templ = `<h4 class="tools-title titl-show0 titl-show">${jq.i18n.prop("base")}</h4>`;
      templ += `<ul class="tools-group tools-base titl-show0" id="${tools.id}"></ul>`;
      templ += `<h4 class="tools-title titl-show0 tools-title-current" >${jq.i18n.prop("swimLaneImg")}</h4>`;
      templ += `<ul class="tools-group titl-show0 tools-group-current" id="${tools.id}"></ul>`;
      templ += `<h4 class="tools-title titl-show0 tools-title-advanced" >${jq.i18n.prop("advanced")}</h4>`;
      templ += `<ul class="tools-group titl-show0 tools-group-process" id="${tools.id}"></ul>`;
      templ += `<h4 class="tools-title titl-show0 tools-title-node">${jq.i18n.prop("relatedElements")}</h4>`;
      templ += `<ul class="tools-group titl-show0 tools-group-node" id="${tools.id}"></ul>`;
      templ += `<h4 class="tools-title titl-show0 tools-title-bpmn">BPMN</h4>`;
      templ += `<ul class="tools-group titl-show0 tools-group-bpmn" id="${tools.id}"></ul>`;
      templ += `<h4 class="tools-title titl-show0 tools-title-architecture">${jq.i18n.prop("enterpriseArch")}</h4>`;
      templ += `<ul class="tools-group titl-show0 tools-group-architecture" id="${tools.id}"></ul>`;
      templ += `<h4 class="tools-title titl-show1" style="display: none">架构</h4>`;
      templ += `<div class="tools-group titl-show1" style="display: none"><div id="vueTree"></div></div>`;
      return templ;
}


Vue.use(ElementUI);

// setInterval(()=>{
//   tValue ++
//   console.log('tValue',tValue)
// },5000)


export const renderLeftNav = (el) => {
  new Vue({
    el: el,
    data: function(){
      return {}
    },
    // router,
    // store,
    // i18n,
    // template: '<App/>',
    // components: { App }
    render: h => h(App)
  })
}


export default {
  menuTemp,
  renderLeftNav,
  leftNavContent
}
