import Vue from 'vue'
import ElementUI from 'element-ui'
import VueI8n from 'vue-i18n'
import zhLocale from 'element-ui/lib/locale/lang/zh-CN' // 简体中文

import App from './index.vue'

Vue.use(VueI8n)

Vue.use(ElementUI);

const treeData = {}
const language = localStorage.getItem('language')
const localeCN = require('../../../../../i18n-locales/cn.js').default

const i18n = new VueI8n({
  locale: language || 'cn',
  messages: {
    'cn': Object.assign(localeCN, zhLocale)
  }
})
export const renderHtml = (el, control) => {
  setTimeout(() => {
    new Vue({
      el: el,
      data: function(){
        return {control}
      },
      i18n,
      render: h => h(App)
    })
  }, 1000);

}

export default {
  renderHtml,
}
