import Vue from 'vue'
import ElementUI from 'element-ui'
import VueI8n from 'vue-i18n'
import zhLocale from 'element-ui/lib/locale/lang/zh-CN' // 简体中文

import App from './index.vue'

Vue.use(VueI8n)

Vue.use(ElementUI);

const treeData = {}
const language = localStorage.getItem('language')
const localeCN = require('../../../../../i18n-locales/cn.js').default

const i18n = new VueI8n({
  locale: language || 'cn',
  messages: {
    'cn': Object.assign(localeCN, zhLocale),
    // 'en': Object.assign(require('../../../i18n-locales/cn.js'), enLocale),
    // 'de': Object.assign(require('@/assets/i18n-locales/de.js'), deLocale),
    // 'ja': Object.assign(require('@/assets/i18n-locales/ja.js'), jaLocale),
    // 'tw': Object.assign(require('@/assets/i18n-locales/tw.js'), twLocale),
    // 'it': Object.assign(require('@/assets/i18n-locales/it.js'), itLocale),
  }
})
export const renderHtml = (el, control) => {
  setTimeout(() => {
    new Vue({
      el: el,
      data: function(){
        return {control}
      },
      // router,
      // store,
      i18n,
      // template: '<App/>',
      // components: { App }
      render: h => h(App)
    })
  }, 1000);

}

export default {
  renderHtml,
}
