import propsActivityBase from './main'
import { getAttribute } from '../../api/userDefined'
import linkFile from './compoents/linkFile/index'
import fliedRecord from './compoents/fliedRecord/index'
import processGroup from './compoents/processGroup/index' // 引用流程
import system from './compoents/system/index' // 相关系统
import role from './compoents/role/index' // 角色
import enterpriseStandard from './compoents/enterpriseStandard/index' // 企业标准
import input from './compoents/input/index' // 输入
import output from './compoents/output/index' // 输出
import workResults from './compoents/workResults/index' // 工作成果

/**
 * 活动属性
 * @date 2021-10-08
 * @param {string} categoryId
 * @param {object} control
 */
class propsActivity extends propsActivityBase {
  constructor({categoryId, control}) {
    super({categoryId, control})
    console.log('initPropsActivity')
    this.keyControlPanel();
    this.control = control;
  }
  keyControlPanel() {

  }
  /**
   * 特殊面板进行自定义
   * @date 2021-10-08
   * @param {any} tabId
   * @param {any} tab
   * @returns {any}
   */
  async setContent({ tabId, tab }) {
    console.log('tabId.18', tabId, tab)
    if (tab.name === '关键风险控制点') {
      console.log('打开关键风险控制点')
      jq(`#${tabId}`).hide();
      jq('.addKeyControl').show()

      try {
        const res = await getAttribute({ tabId });
        jq('#keyControlForm').data(res[0])
        const keyControlFormData = doT.template(jq('#keyControlFormTemp').text())
        const dataList = jq('#keyControlForm').data('optionalValueDTOs')
        jq("#keyControlForm").html(keyControlFormData({
            attrList: this.control,
            dataList
        }))
      } catch (error) {
        console.log('error:setContent.getAttribute', error)
      }
    }
    if (tab.name === '活动说明') {
      console.log('打开活动说明')
      await this.timeInit()
      await this.file1Init()
      await this.file2Init()
      await this.processGroupInit();
      await this.systemInit();
      await this.roleInit();
      await this.enterpriseStandardInit();
      await this.inputInit();
      await this.outputInit();
      await this.workResultsInit();
    }
  }

  // 自定义模块

  timeInit() {
    const dotStr = doT.template(jq("#timeBoxTemp").text());
    const data = jq('#timeBox').data('info');
    console.log(jq('#timeBox'))
    console.log('this.control.56',this.control)

    jq('#timeBox').html(dotStr({
      data,
      control: this.control
    }))
  }
  file1Init() {
    // const dotStr = doT.template(jq("#zhiduTemp").text());
    // const data = jq('#linkFile').data('info');
    linkFile.renderHtml('#linkFile',this.control)
    // jq('#linkFile').html(dotStr({
    //   data,
    //   control: this.control
    // }))
    // $('#chooseZhiDu').click(()=>{
    //   alert(1)
    // })
  }

  file2Init() {
    // const dotStr = doT.template(jq("#file2Temp").text());
    // jq('#fliedRecord').html(dotStr)
    fliedRecord.renderHtml('#fliedRecord',this.control)
  }
  processGroupInit() {
    // const dotStr = doT.template(jq("#file2Temp").text());
    // jq('#fliedRecord').html(dotStr)
    processGroup.renderHtml('#processGroup',this.control)
  }
  systemInit() {
    // const dotStr = doT.template(jq("#file2Temp").text());
    // jq('#fliedRecord').html(dotStr)
    system.renderHtml('#system',this.control)
  }
  roleInit() {
    role.renderHtml('#role', this.control)
  }
  enterpriseStandardInit() {
    enterpriseStandard.renderHtml('#enterpriseStandard', this.control)
  }
  inputInit() {
    input.renderHtml('#input', this.control)
  }
  outputInit() {
    output.renderHtml('#output', this.control)
  }
  workResultsInit() {
    workResults.renderHtml('#workResults', this.control)
  }
}

export default propsActivity
