import { getTab, getAttribute } from '../../api/userDefined'


/**
 * 活动属性
 * @date 2021-09-28
 * @param {string} categoryId
 * @param {object} control
 */
class propsActivityBase  {
  constructor({categoryId, control}) {
    this.getTabInfoApi({categoryId})
    this.control = control;
    console.log('this.controlId',this.control)
  }

  /**
   * 获取动态标签
   * @date 2021-09-28
   * @param {string} categoryId 分类ID
   */
  async getTabInfoApi({categoryId}) {
    try {
      jq('#pointAttr').html('');
      const { list } = await getTab({ categoryId, parentId: 0 })
      let categoryList = [
        ...list,
        {
          dataid: 'addKeyKSFControl',
          id: 'addKeyKSFControl',
          name: '关键成功要素'
        },
        {
          dataid: 'isModelListBoDtos',
          id: 'isModelListBoDtos',
          name: '业务对象'
        },
        {
          dataid: 'modelListToolsDtos',
          id: 'modelListToolsDtos',
          name: '工具'
        },
        // {
        //   dataid: 'processTask',
        //   id: 'aboutProcess',
        //   name: '引用流程'
        // },
        {
          dataid: 'processTask',
          id: 'systemDocumentChapter',
          name: '引用制度'
        },
        {
          id: 'message-form',
          id: 'message-form',
          name: '企业标准'
        },
        {
          dataid: 'message-file-form',
          id: 'message-file-form',
          name: '信息文档'
        }
      ]
      const $tabs = categoryList.map((v, i) => {
        return jq(`<li class='${i === 0 && 'active'}' data-tabId='${v.id}' data-class='${i === 1 ? 'addKeyControl' : v.id}' data-id='${v.dataid || ''}' title='${v.name}'>${v.name}</li>`).click(() => {
          this.getMainContent({tabId: v.id, tab: v})
        })
      })
      console.log('window.categoryTab', window.categoryTab)
      if (!window.categoryTab) {
        window.categoryTab = categoryList[0]
      }
      this.getMainContent({ tabId: window.categoryTab.id, tab: window.categoryTab })
      // jq('#pointAttr').preppend($tabs)
      // jq('#pointAttr').html(jq('#pointAttr').html()).prepend($tabs)
      jq('#pointAttr').html($tabs).append('<i class="closeRightMoal"></i>')



    } catch (error) {
      console.log('getTabInfoApi.error')
    }
  }

  /**
   * 获取标签下的属性
   * @date 2021-09-28
   * @param {string} tabId
   */
  async getAttributeApi({tabId}){
    try {
      const res = await getAttribute({tabId});
      const dotStr = doT.template(jq("#propsTmpl").text());
      // 处理table
      const subTab = res.filter(v => v.element === 'tab')
      this.handleSubTab({subTab});
        jq(`#${tabId}`).append(dotStr({
          list: res,
          control: this.control
        }))
    } catch (error) {
      console.log('getTabInfoApi.error')
    }
  }

  /**
   * 处理子tab
   * @date 2021-09-29
   * @param {any} subTab
   */
  handleSubTab({subTab}) {

  }

  /**
   * 加载属性面板
   * @date 2021-09-28
   * @param {string} tabId
   * @param {string} tab 完整tab信息
   */
  async getMainContent({tabId, tab}) {
    window.categoryTab = tab
    const $currentTab = jq(`.${tabId}`);
    if(!$currentTab.length){
      $(`<div id='${tabId}' class='${tabId}'></div>`).appendTo($('#tabMainBox'))
      await this.getAttributeApi({tabId})
    }
    jq(`.${tabId}`).siblings().hide();
    jq(`.${tabId}`).show();
    setTimeout(() => {
      jq("[data-class=" + tabId + "]").addClass("active");
      jq("[data-class=" + tabId + "]").siblings().removeClass("active");
    }, 1);
    this.setContent({tabId,tab})
  }

  setContent({tabId, tab}) {
    console.log(tabId, tab)
  }

  getForm() {
    console.log('getForm')
  }
}
export default propsActivityBase
