import axios from 'axios'
import {
  getCookie
} from '../page/page'
import {
  baseUrl
} from './url'

const service = axios.create({
  baseURL: baseUrl,
  timeout: 100000
})

const isArray = data => Object.prototype.toString.call(data) === '[object Array]'
// const showToast = (type, msg, msg2) => {
//   if (type === 'success') {
//   }
// }
// 默认展示loading，如果不需要loading，将api里面的loading设置为false即可

service.interceptors.request.use((request) => {
  let username = getCookie("username")
  request.url = request.url.indexOf('?') === -1 ? (request.url + '?username=' + username) : request.url
  return request
})

service.interceptors.response.use(
  (response) => {
    const { data, config, headers } = response
    // 判断返回的是文件流
    if (headers['content-type'].indexOf('application/octet-stream') > -1) {
      return response.data
    } else if (data.hasOwnProperty('code') || data.hasOwnProperty('status')) {
      return data.data
    }
  },
  (err) => {
    // const data = { code: 1000, message: '网络异常', data: {} }
    // err.data = data
    // if (err.response.data.message) {
    //   showToast('error', err.response.data.message, err.response.data.message)
    // } else {
    //   showToast('error', data, '网络异常')
    // }
  }
)

const fetch = options => service.request(options)

export { fetch }
export default fetch
