import percentage from './percentage'
import {setCookie, delCookie, getCookie} from './cookie'
import {getParam, getParamUrl} from './getParam'

export function isSameData(existData,newData,type = "Object"){
    if(type ===  "Array"){
        if(Object.prototype.toString.call(existData) != "[object Array]" || Object.prototype.toString.call(newData) != "[object Array]"){
            // throw new Error("At least one of the inputs not an array");
        }

        if(existData.length != newData.length){
            return false;
        }
        }else{
            if(!(existData instanceof Object && newData instanceof Object)){
                // throw new Error("At least one of the inputs not an Object");
            }
        }

        for (const key in existData) {
            if (Object.prototype.hasOwnProperty.call(newData, key)) {
                if(existData[key] instanceof Array && newData[key] instanceof Array){
                    try{
                        if(!isSameData(existData[key], newData[key],"Array")){
                            return false;
                        }
                    }catch{
                        return false;
                    }
                }else if(existData[key] instanceof Object && newData[key] instanceof Object){
                    try{
                        if(!isSameData(existData[key],newData[key],"Object")){
                            return false;
                        }
                    }catch{
                        return false;
                    }

                }else if(existData[key] != newData[key]){
                    return false;
                }
            }else{
                return false;
            }
        }
        return true;
    }


const utils = {
    percentage,
    setCookie, 
    delCookie, 
    getCookie,
    getParam,
    getParamUrl
}
export {
    percentage,
    setCookie, 
    delCookie, 
    getCookie,
    getParam,
    getParamUrl
}

export { fetch } from './fetch'

export {
    baseUrl,
    bpmurl,
    pageurl
} from './url'

export default utils;

