import { fetch } from '@/utils'
import store from '@/store'

// 获取项目列表接口
export function queryProjectList(data) {
  return fetch({
    url: '/epapi/project/queryProject',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取项目列表接口
export function queryProjectLevel(code) {
  return fetch({
    url: `/epapi/project/queryProjectLevel/${code}`,
    method: 'GET'
  })
}

// 项目阶段的wbs查询接口
export function queryProjectWbs(data) {
  return fetch({
    url: '/epapi/project/queryProjectWbs',
    method: 'POST',
    toast: false,
    data
  })
}

// 需求单列表接口
export function queryRequirementList(data) {
  return fetch({
    url: '/epapi/requirement/queryRequirementList',
    method: 'POST',
    toast: false,
    data
  })
}

// 新增需求单接口
export function saveRequirement(data) {
  return fetch({
    url: `/epapi/requirement/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 需求单详情接口
export function queryRequirementDetail(id) {
  return fetch({
    url: `/epapi/requirement/queryRequirementDetail/${id}`,
    method: 'GET'
  })
}

// 需求单取消接口
export function cancelRequirement(id) {
  return fetch({
    url: `/epapi/requirement/cancelRequirement/${id}?username=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}

// 任务分配接口
export function distribute(data) {
  return fetch({
    url: `/epapi/requirement/distribute`,
    method: 'POST',
    toast: false,
    data
  })
}

// 生成任务单接口
export function saveTask(data) {
  return fetch({
    url: `/epapi/task/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 获取采购组和人员接口
export function queryGroupUserList(data) {
  return fetch({
    url: '/epapi/common/queryGroupUserList',
    method: 'POST',
    toast: false,
    data
  })
}

// 审批接口
export function approved(data) {
  return fetch({
    url: `/epapi/common/approved?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 撤回作废验证接口
export function reCallInvalidVerify(data) {
  return fetch({
    url: '/epapi/requirement/reCallInvalidVerify',
    method: 'POST',
    toast: false,
    data
  })
}

// 撤回作废接口
export function reCallInvalidTask(data) {
  return fetch({
    url: '/epapi/requirement/reCallInvalidTask',
    method: 'POST',
    toast: false,
    data
  })
}

// 根据商品id查询任务单接口
export function queryDetailByRequirementNumber(rid, number) {
  return fetch({
    url: `/epapi/requirement/queryDetailByRequirementNumber/${rid}/${number}`,
    method: 'GET'
  })
}
