import { fetch } from '@/utils'

// 所有询价列表
export function allList(data) {
  return fetch({
    url: '/inquiry/inquirylist',
    method: 'GET',
    params: data
  })
}
// 询价中列表
export function offerList(data) {
  return fetch({
    url: '/inquiry/queryofferinquirylist',
    method: 'GET',
    params: data
  })
}
// 询价已完成列表
export function resultList(data) {
  return fetch({
    url: '/inquiry/inquiryresultlist',
    method: 'GET',
    params: data
  })
}
// 查看询价对应供应商列表接口
export function offerSupplierList(data) {
  return fetch({
    url: '/inquiry/offersupplierlist',
    method: 'GET',
    params: data
  })
}
// 获取供应商类型、级别、注册资金
export function supplierTypelist(data) {
  return fetch({
    url: '/supplier/typelist',
    method: 'GET',
    params: data
  })
}
// 新增询价提交或保存
export function inquirySubmit(data) {
  return fetch({
    url: '/inquiry/insertinquiry',
    method: 'POST',
    data: data
  })
}
// 编辑询价提交或保存
export function updateSubmit(data) {
  return fetch({
    url: '/inquiry/updateinquiry',
    method: 'POST',
    data: data
  })
}
// 获取编辑询价详情
export function getInquiryDetail(data) {
  return fetch({
    url: '/inquiry/queryinquirydetail',
    method: 'GET',
    params: data
  })
}
// 提交询价
export function subInquiry(data) {
  return fetch({
    url: '/inquiry/submitinquiry',
    method: 'GET',
    params: data
  })
}
// 删除询价
export function delInquiry(data) {
  return fetch({
    url: '/inquiry/deleteinquiryByinquirynum',
    method: 'GET',
    params: data
  })
}
// 获取询价结果详情
export function getResultDetail(data) {
  return fetch({
    url: '/inquiry/inquiryresultdetail',
    method: 'GET',
    params: data
  })
}
// 获取单个询价详情
export function getOffernumDetail(data) {
  return fetch({
    url: '/inquiry/inquirydetailByoffernum',
    method: 'GET',
    params: data
  })
}
// 获取比价信息
export function getContrastPrice(data) {
  return fetch({
    url: '/inquiry/contrastprice',
    method: 'GET',
    params: data
  })
}
// 提交定价接口
export function submitprice(data) {
  return fetch({
    url: '/inquiry/submitprice',
    method: 'GET',
    params: data
  })
}
// 拒绝定价接口
export function refuseprice(data) {
  return fetch({
    url: '/inquiry/refuseprice',
    method: 'GET',
    params: data
  })
}
