import { fetch } from '@/utils'

// 查询全局变量  list
export function queryGlobalVariable(data) {
  return fetch({
    url: '/soa/globalvariable/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取变量详情 detaile
export function getVariableDetail(id) {
  return fetch({
    url: `soa/globalvariable/get/${id}`,
    method: 'GET',
    toast: false
  })
}

// 变量配置 保存 save
export function saveVariableDetail(data) {
  return fetch({
    url: '/soa/globalvariable/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 代理服务 根据ID删除服务 delete
export function deleteVariable(id) {
  return fetch({
    url: `/soa/globalvariable/delete/${id}`,
    method: 'DELETE'
  })
}

// sql构建器

// sql构建器列表
export function querySqlBuilderList(data) {
  return fetch({
    url: '/soa/sqlBuilder/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取存储过程
export function getProcedure(data) {
  return fetch({
    url: '/soa/sqlBuilder/getProcedure',
    method: 'POST',
    toast: false,
    data
  })
}

// 保存适配器配置信息
export function saveSqlBuilderDetail(data) {
  return fetch({
    url: '/soa/sqlBuilder/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 适配器 根据ID删除适配器 delete
export function deleteSqlBuilder(id) {
  return fetch({
    url: `/soa/sqlBuilder/delete/${id}`,
    method: 'DELETE'
  })
}

// 获取表名
export function getSqlSheelList(data) {
  return fetch({
    url: '/soa/sqlBuilder/getTables',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取库名
export function getSqlLibraryList(data) {
  return fetch({
    url: '/soa/sqlBuilder/getDataNames',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取列名
export function getSqlColumnList(data) {
  return fetch({
    url: '/soa/sqlBuilder/getColumn',
    method: 'POST',
    toast: false,
    data
  })
}

// 根据ID获取SQL构建器信息
export function getSqlBuilderDetail(id) {
  return fetch({
    url: `soa/sqlBuilder/get/${id}`,
    method: 'GET',
    toast: false
  })
}

// 根据id获取sql预览
export function createSql(data) {
  return fetch({
    url: '/soa/sqlBuilder/createSql',
    method: 'POST',
    toast: false,
    data
  })
}
// 根据页面配置生成sql
export function createSqlForm(data) {
  return fetch({
    url: '/soa/sqlBuilder/createSqlByConfig',
    method: 'POST',
    toast: false,
    data
  })
}
// 根据sql生成参数
export function createParams(data) {
  return fetch({
    url: '/soa/sqlBuilder/createParamsBySql',
    method: 'POST',
    toast: false,
    data
  })
}
// 执行sql
export function executSqlForm(data) {
  return fetch({
    url: '/soa/sqlBuilder/sqlExecut',
    method: 'POST',
    toast: false,
    data
  })
}
// 根据json报文生成Schema文件
export function jsonToSchema(data) {
  return fetch({
    url: '/soa/jsonSchema/jsonToJsonSchema',
    method: 'POST',
    toast: false,
    data
  })
}
// 根据id获取文件schema
export function getSchema(id, projectid) {
  return fetch({
    url: `/soa/sqlBuilder/generateSchemaFileById/${id}/${projectid}`,
    method: 'POST'
  })
}
// 解析定义文件
export function getFile(id) {
  return fetch({
    url: `/soa/resource/parseFile/${id}`,
    method: 'GET'
  })
}
