import { fetch } from '@/utils'
import axios from 'axios'

// 代理服务 查询注册的服务
export function queryProxyService(data) {
  return fetch({
    url: '/soa/proxyService/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 代理服务 保存服务
export function saveProxyService(data) {
  return fetch({
    url: '/soa/proxyService/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 代理服务 发布
export function publishProxyService(id) {
  return fetch({
    url: `/soa/proxyService/publish/${id}`,
    method: 'POST',
    toast: false
  })
}

// 代理服务 根据ID获取服务
export function getProxyServiceDetail(id) {
  return fetch({
    url: `/soa/proxyService/get/${id}`,
    method: 'GET'
  })
}
// 代理服务 根据ID获取服务授权人员列表
export function getServicePermission(id) {
  return fetch({
    url: `/soa/proxyService/getServicePermission/${id}`,
    method: 'GET'
  })
}
// 代理服务 根据ID删除服务
export function deleteProxyService(id) {
  return fetch({
    url: `/soa/proxyService/delete/${id}`,
    method: 'DELETE'
  })
}

// 业务服务 查询注册的服务
export function queryBusinessService(data) {
  return fetch({
    url: '/soa/businessService/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 业务服务 保存服务
export function saveBusinessService(data) {
  return fetch({
    url: '/soa/businessService/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取所有函数组集合
// export function getFuns(id) {
//   return fetch({
//     // url: `/soa/sapFunctionBuilder/getAllGroups/${id}`,
//     url: `http://maresking.qicp.vip/esbconsole/soa/sapFunctionBuilder/getAllGroups/${id}`,
//     method: 'GET'
//   })
// }

// 获取所有函数组集合
export function getFuns(id) {
  return fetch({
    // url: `http://maresking.qicp.vip/esbconsole/soa/sapFunctionBuilder/getAllGroups/${id}`,
    url: `/soa/sapFunctionBuilder/getAllGroups/${id}`,
    method: 'GET'
  })
}

// 获取所有函数组集合
export function getFunsName(id, functionName) {
  return fetch({
    // url: `http://maresking.qicp.vip/esbconsole/soa/sapFunctionBuilder/getAllGroups/${id}`,
    url: `/soa/sapFunctionBuilder/getFunctionsFunctionNameAndId/${id}?functionName=${functionName}`,
    method: 'GET'
  })
}

// 获取函数结构信息
export function getFunDetails(id, functionName) {
  return fetch({
    // url: `http://maresking.qicp.vip/esbconsole/soa/sapFunctionBuilder/getFcuntionFormats/${id}?functionName=${functionName}`,
    url: `/soa/sapFunctionBuilder/getFcuntionFormats/${id}?functionName=${functionName}`,
    method: 'GET'
  })
}

// 业务服务 根据ID获取服务
export function getBusinessServiceDetail(id) {
  return fetch({
    url: `/soa/businessService/get/${id}`,
    method: 'GET'
  })
}

// 业务服务 根据ID删除服务
export function deleteBusinessService(id) {
  return fetch({
    url: `/soa/businessService/delete/${id}`,
    method: 'DELETE'
  })
}

// 黑白名单获取
export function kongInfoGet(id) {
  return fetch({
    url: '/soa/kongInfo/get/' + id,
    method: 'get'
  })
}

// 黑白名单详情获取
export function kongInfosGet(id) {
  return fetch({
    url: '/soa/kongInfo/getKongInfoByServiceId/' + id,
    method: 'get'
  })
}

// 黑白名单详情获取
export function kongInfoQuery(data) {
  return fetch({
    url: '/soa/kongProxyInfo/query',
    method: 'post',
    data
  })
}

// 黑白名单批量保存
export function kongInfoAllQuery(data) {
  return fetch({
    url: '/soa/kongInfo/batchSave',
    method: 'post',
    data
  })
}

// 保存
export function kongInfoSave(data) {
  return fetch({
    url: '/soa/kongInfo/save',
    method: 'POST',
    data
  })
}

// 删除
export function kongInfoDelete(data) {
  return fetch({
    url: '/soa/kongInfo/delete',
    method: 'POST',
    data
  })
}

// 查询适配器配置信息
export function queryConnector(data) {
  return fetch({
    url: '/soa/connector/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 批量发布
export function publishByList(data) {
  return fetch({
    url: '/soa/proxyService/publishByList',
    method: 'POST',
    data
  })
}

// 根据ID获取适配器配置信息
export function getConnectorDetail(id) {
  return fetch({
    url: `/soa/connector/get/${id}`,
    method: 'GET'
  })
}

// 保存适配器配置信息
export function saveConnector(data) {
  return fetch({
    url: '/soa/connector/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 测试连通性
export function testConnector(id) {
  return fetch({
    url: `/soa/connector/test/${id}`,
    method: 'POST',
    toast: false
  })
}

// 根据ID删除适配器配置信息
export function deleteConnector(id) {
  return fetch({
    url: `/soa/connector/delete/${id}`,
    method: 'DELETE'
  })
}
// 适配器 保存后 跑一遍
export function deployConnector(id) {
  return fetch({
    url: `/soa/connector/deploy/${id}`,
    method: 'POST',
    toast: false
  })
}

// 消息流 查询注册的服务
export function queryFlow(data) {
  return fetch({
    url: '/soa/flow/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 消息流 保存服务
export function saveFlow(data) {
  return fetch({
    url: '/soa/flow/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 消息流 根据ID获取服务
export function getFlowDetail(id) {
  return fetch({
    url: `/soa/flow/get/${id}`,
    method: 'GET'
  })
}

// 消息流 根据ID删除服务
export function deleteFlow(id) {
  return fetch({
    url: `/soa/flow/delete/${id}`,
    method: 'DELETE'
  })
}

// 消息流 获取指定消息流中的节点信息
export function getNodeListForFlow(id) {
  return fetch({
    url: `/soa/node/listForFlow/${id}`,
    method: 'GET'
  })
}

// 消息流 保存消息流节点
export function saveNodeListForFlow(data, id) {
  return fetch({
    url: `/soa/node/save/${id}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 日志级别查询
export function listLogLevelget() {
  return fetch({
    url: `/soa/node/listLogLevel`,
    method: 'GET'
  })
}

// XSLT
export function getListFiles(type, data) {
  return fetch({
    url: `/soa/resource/listFiles/${type}${data}`,
    method: 'GET'
  })
}

// 查询可用的适配器类型
export function findAvailableConnectType(isSimple) {
  const simple = isSimple === undefined || null ? '' : '/' + isSimple
  return fetch({
    url: `/soa/connector/findAvailableConnectType${simple}`,
    method: 'GET'
  })
}

// 获取指定类型的文件列表
// export function listFiles (type, keyword) {
//   let data = keyword ? `/${keyword}` : ''
//   return fetch({
//     url: `/soa/resource/listFiles/${type}${data}`,
//     method: 'GET'
//   })
// }
export function listFiles(data) {
  return fetch({
    url: `/soa/resource/query`,
    method: 'POST',
    data
  })
}
// 保存资源文件
export function saveFiles(data) {
  return fetch({
    url: `/soa/resource/save`,
    method: 'POST',
    data
  })
}
// 保存资源文件
export function saveResourceCotent(data) {
  return fetch({
    url: `/soa/resource/saveResourceCotent`,
    method: 'POST',
    data
  })
}
// 删除文件
export function deleteResource(id) {
  return fetch({
    url: `/soa/resource/delete/${id}`,
    method: 'DELETE'
  })
}
// 资源文件 账户 查询账户
export function queryStaticAccount(data) {
  return fetch({
    url: '/soa/staticAccount/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 资源文件 账户 保存账户
export function staticAccountSave(data) {
  return fetch({
    url: `/soa/staticAccount/save`,
    method: 'POST',
    data
  })
}

// 资源文件 账户 根据ID获取
export function getAccountDetail(id) {
  return fetch({
    url: `/soa/staticAccount/get/${id}`,
    method: 'GET'
  })
}

// 资源文件 账户 根据ID删除账户
export function deleteAccount(id) {
  return fetch({
    url: `/soa/staticAccount/delete/${id}`,
    method: 'DELETE'
  })
}

// 解析文件内容
// export function parseFile (id) {
//   return fetch({
//     url: `/soa/resource/parseFile/${id}`,
//     method: 'GET'
//   })
// }
export function parseFile(id) {
  return fetch({
    url: `/soa/resource/get/${id}`,
    method: 'GET'
  })
}

// 展示文件内容
export function showFileContent(id) {
  return fetch({
    url: `/soa/resource/showFileContent/${id}`,
    method: 'GET'
  })
}

// 获取可用的文件类型列表
export function findAvailableResourceType() {
  return fetch({
    url: `/soa/resource/findAvailableResourceType`,
    method: 'GET'
  })
}

// 上传文件
export function uploadSave(type, name) {
  return fetch({
    url: `/soa/resource/upload/${type}/${name}`,
    method: 'POST'
  })
}

// 节点启动
export function nodeStart(id) {
  return fetch({
    url: `/soa/server/serverControl/start/${id}`,
    method: 'put'
  })
}

// 节点停止
export function nodeStop(id) {
  return fetch({
    url: `/soa/server/serverControl/stop/${id}`,
    method: 'put'
  })
}

// 节点强制停止
export function nodeStopNow(id) {
  return fetch({
    url: `/soa/server/serverControl/stopNow/${id}`,
    method: 'put'
  })
}

// 消息流中获取操作
export function listAvailableNodes() {
  return fetch({
    url: `/soa/node/listAvailableNodes`,
    // url: `http://maresking.qicp.vip/esbconsole/soa/node/listAvailableNodes`,
    method: 'GET'
  })
}

// sql 语句测试
export function saveSql(data) {
  return fetch({
    url: '/soa/connector/parseParameters',
    method: 'POST',
    data
  })
}
// sql 语句测试后解析可配置字段
export function scriptValidate(data) {
  return fetch({
    url: '/soa/connector/scriptValidate',
    method: 'POST',
    data
  })
}

// 获取sql
export function generateSql(data) {
  return fetch({
    url: '/soa/sqlBuilder/generateSql',
    method: 'POST',
    data
  })
}
// ---------------------------服务节点---------------------

// 查询服务节点
export function queryServer(data) {
  return fetch({
    url: '/soa/server/query',
    method: 'POST',
    data
  })
}
// 保存服务节点
export function saveServer(data) {
  return fetch({
    url: '/soa/server/save',
    method: 'POST',
    toast: false,
    data
  })
}
// 获取服务节点详情
export function getServerDetails(id) {
  return fetch({
    url: `/soa/server/get/${id}`,
    method: 'GET'
  })
}
// 删除服务节点
export function deleteServer(id) {
  return fetch({
    url: `/soa/server/delete/${id}`,
    method: 'DELETE'
  })
}
// ---------------------------服务器域---------------------

// 查询服务器域
export function queryDomaininfo(data) {
  return fetch({
    url: '/soa/domaininfo/query',
    method: 'POST',
    data
  })
}
// 保存服务器域
export function saveDomaininfo(data) {
  return fetch({
    url: '/soa/domaininfo/save',
    method: 'POST',
    toast: false,
    data
  })
}
// 获取服务器域详情
export function getDomaininfoDetails(id) {
  return fetch({
    url: `/soa/domaininfo/get/${id}`,
    method: 'GET'
  })
}
// 获取服务器域服务列表
export function getDomaininfoServiceList(data) {
  return fetch({
    url: `/soa/proxyService/query`,
    method: 'POST',
    data
  })
}
// 删除服务器域
export function deleteDomaininfo(id) {
  return fetch({
    url: `/soa/domaininfo/delete/${id}`,
    method: 'DELETE'
  })
}

// 依赖检测
// 代理服务依赖的服务资源
export function proxyservicedepent(id) {
  return fetch({
    url: `/soa/proxyService/listProxyServiceDependent/${id}`,
    method: 'GET'
  })
}

// 代理服务 被依赖的服务资源
export function proxyservicedepend(id) {
  return fetch({
    url: `/soa/proxyService/listProxyServiceDependened/${id}`,
    method: 'GET'
  })
}

//  业务服务依赖的服务资源
export function businessservicedependent(id) {
  return fetch({
    url: `/soa/businessService/listBusinessServiceDependent/${id}`,
    method: 'GET'
  })
}

// 业务服务  被依赖的服务资源
export function businessservicedependend(id) {
  return fetch({
    url: `/soa/businessService/listBusinessServiceDependened/${id}`,
    method: 'GET'
  })
}

// 消息流 被依赖的服务资源
export function listflowdependened(id) {
  return fetch({
    url: `/soa/flow/listFlowDependened/${id}`,
    method: 'GET'
  })
}

// 消息流 依赖的服务资源
export function listflowdependenet(id) {
  return fetch({
    url: `/soa/flow/listFlowDependent/${id}`,
    method: 'GET'
  })
}

// 适配器被依赖的服务资源
export function connectordependened(id) {
  return fetch({
    url: `/soa/connector/listConnectorDependened/${id}`,
    method: 'GET'
  })
}

// 文件被依赖的服务资源
export function resourcefiledepend(id) {
  return fetch({
    url: `/soa/resource/listResourceFileDependened/${id}`,
    method: 'GET'
  })
}

// ---------------------------状态码---------------------
// 状态码查询
export function queryStatus(data) {
  return fetch({
    url: `/soa/statuscode/query`,
    method: 'POST',
    data
  })
}

// 修改保存状态码
export function saveStatus(data) {
  return fetch({
    url: `/soa/statuscode/save`,
    method: 'POST',
    data
  })
}

// 根据id获取状态码
export function getStatus(id) {
  return fetch({
    url: `/soa/statuscode/get/${id}`,
    method: 'GET'
  })
}

// 删除状态码
export function deleteStatus(id) {
  return fetch({
    url: `/soa/statuscode/delete/${id}`,
    method: 'DELETE'
  })
}
// 根据id获取部署信息
export function getRuntimeInfo(id) {
  return fetch({
    url: `/soa/proxyService/getRuntimeInfo/${id}`,
    method: 'GET'
  })
}
// 根据id部署信息启动
// export function getPublish (id) {
//   return fetch({
//     url: `/soa/proxyService/control/publish/${id}`,
//     method: 'GET'
//   })
// }
// 部署信息发布
export function getPublish(data) {
  return fetch({
    url: `/soa/proxyService/control/publish/${data}`,
    method: 'POST',
    toast: false
  })
}
// 部署信息启动
export function startService(data) {
  // return fetch({
  //   url: `/soa/proxyService/control/startNode/${data}`,
  //   method: 'POST',
  //   toast: false
  // })
  return fetch({
    url: '/soa/proxyService/control/startNode',
    method: 'POST',
    data
  })
}
// 部署信息停止
export function stopService(data) {
  // return fetch({
  //   url: `/soa/proxyService/control/stopNode/${data}`,
  //   method: 'POST',
  //   toast: false
  // })
  return fetch({
    url: `/soa/proxyService/control/stopNode`,
    method: 'POST',
    toast: false,
    data
  })
}
// 部署信息暂停指定服务
export function suspendService(data) {
  // return fetch({
  //   url: `/soa/proxyService/control/suspendNode/${data}`,
  //   method: 'POST',
  //   toast: false
  // })
  return fetch({
    url: `/soa/proxyService/control/suspendNode`,
    method: 'POST',
    toast: false,
    data
  })
}
// 部署信息恢复指定服务
export function resumeService(data) {
  // return fetch({
  //   url: `/soa/proxyService/control/resumeNode/${data}`,
  //   method: 'POST',
  //   toast: false
  // })
  return fetch({
    url: `/soa/proxyService/control/resumeNode`,
    method: 'POST',
    toast: false,
    data
  })
}
// 部署信息重启指定服务
export function restartService(data) {
  // return fetch({
  //   url: `/soa/proxyService/control/restartNode/${data}`,
  //   method: 'POST',
  //   toast: false
  // })
  return fetch({
    url: `/soa/proxyService/control/restartNode`,
    method: 'POST',
    toast: false,
    data
  })
}
// 获取构建器关联的资源文件
export function getResourceFile(id, projectId) {
  return fetch({
    url: `/soa/sqlBuilder/getSchemaFileById/${id}/${projectId}`,
    method: 'GET',
    toast: false
  })
}
