import { fetch } from '@/utils'
import store from '@/store'

// 合同管理 ----------------------------start

// 合同列表
export function queryContractList(data) {
  return fetch({
    url: '/epapi/contract/queryInfo',
    method: 'POST',
    toast: false,
    data
  })
}

// 新增合同
export function saveContract(data) {
  return fetch({
    url: `/epapi/contract/saveContract?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 合同详情接口
export function getContractDetail(id) {
  return fetch({
    url: `/epapi/contract/getDetail/${id}`,
    method: 'GET'
  })
}

// 撤单/作废
export function revoke(id, status) {
  return fetch({
    url: `/epapi/contract/updateStatus/${id}/${status}?username=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}

// 上传扫描件
export function saveFile(data) {
  return fetch({
    url: `/epapi/contract/saveFile`,
    method: 'POST',
    toast: false,
    data
  })
}

// 弹框选择合同列表
export function queryContractInfo(data) {
  return fetch({
    url: `/epapi/contract/queryContractInfo`,
    method: 'POST',
    toast: false,
    data
  })
}

export function queryEnquiryContract(data) {
  return fetch({
    url: `/epapi/inquiry/createContract`,
    method: 'POST',
    toast: false,
    data
  })
}

// 合同管理 ----------------------------end

// 采购订单管理 ----------------------------start

// 查询收货地址列表接口
export function queryOrderList(data) {
  return fetch({
    url: '/epapi/order/queryOrderList',
    method: 'POST',
    toast: false,
    data
  })
}

// 订单信息详情
export function queryOrderDetail(id) {
  return fetch({
    url: `/epapi/order/queryOrder/${id}`,
    method: 'GET'
  })
}

// 保存订单信
export function saveOrder(data) {
  return fetch({
    url: `/epapi/order/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 订单状态修改
export function updateOrder(data) {
  return fetch({
    url: `/epapi/order/updateOrder`,
    method: 'POST',
    toast: false,
    data
  })
}

// 发货单详情
export function getDeliverDetail(id) {
  return fetch({
    url: `/epapi/deliver/getDetail/${id}`,
    method: 'GET'
  })
}

// 查询招标创建合同订单信息
export function queryTenderGoodsDetail(id) {
  return fetch({
    url: `/epapi/tender/queryTenderGoodsDetail/${id}`,
    method: 'GET'
  })
}

// 询价创建订单
export function queryEnquiryGoodsDetail(data) {
  return fetch({
    url: `/epapi/inquiry/createOrder`,
    method: 'POST',
    toast: false,
    data
  })
}

// 查看是否有发货信息
export function deliverTureOrFlase(id) {
  return fetch({
    url: `/epapi/deliver/tureOrFlase/${id}`,
    method: 'GET'
  })
}

// 采购订单管理 ----------------------------end

// 收货验货单 ----------------------------start

// 收货列表接口
export function receivingList(data) {
  return fetch({
    url: '/epapi/receiving/getInfo',
    method: 'POST',
    toast: false,
    data
  })
}

// 新增收货弹框选择订单信息列表   (商品) 接口
export function getListForDevList(data) {
  return fetch({
    url: '/epapi/order/getListForDeveiving',
    method: 'POST',
    toast: false,
    data
  })
}

// 订单信息列表接口
export function queryOrdersList(data) {
  return fetch({
    url: '/epapi/order/queryOrderList',
    method: 'POST',
    toast: false,
    data
  })
}

// 新增OR修改收货地址接口
export function saveReceiving(data) {
  return fetch({
    url: `/epapi/receiving/saveReceiving?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增OR修改收货地址接口
export function save(data) {
  return fetch({
    url: `/epsupplierapi/deliver/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 收货详情
export function getDetail(id) {
  return fetch({
    url: `/epapi/receiving/getDetial/${id}`,
    method: 'GET'
  })
}

// 收货作废
export function receivingToVoid(id, status) {
  return fetch({
    url: `/epapi/receiving/toVoid/${id}/${status}?username=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}

// 收货验货单 ----------------------------end

// 付款单 ----------------------------start
export function queryPaymentList(data) {
  return fetch({
    url: `/epapi/payment/queryPaymentList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增框选择付款单信息接口
export function getListForDeveiving(data) {
  return fetch({
    url: '/epapi/payment/getListForDeveiving',
    method: 'POST',
    toast: false,
    data
  })
}

// 付款单新增和编写接口
export function savePayment(data) {
  return fetch({
    url: `/epapi/payment/savePayment?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 付款单详情接口
export function queryPaymentDetail(id) {
  return fetch({
    url: `/epapi/payment/queryPayment/${id}`,
    method: 'GET'
  })
}

// 付款单撤单作废
export function updatePayment(req, status) {
  return fetch({
    url: `/epapi/payment/updatePayment/${req}/${status}?username=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}
// 付款单 ----------------------------end

// 退货单 ----------------------------start
// 列表
export function queryReturnList(data) {
  return fetch({
    url: `/epapi/return/queryReturnList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增退货单
export function saveReturn(data) {
  return fetch({
    url: `/epapi/return/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 退货单详情
export function queryReturnDetail(id) {
  return fetch({
    url: `/epapi/return/queryDetail/${id}`,
    method: 'GET'
  })
}

// 查询符合条件的收货单
export function queryReceiveReturnList(data) {
  return fetch({
    url: `/epapi/receiving/queryReceiveReturnList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 确认
export function confirmReturn(id) {
  return fetch({
    url: `/epapi/return/confirm/${id}`,
    method: 'GET'
  })
}

// 作废
export function invalidReturn(id) {
  return fetch({
    url: `/epapi/return/invalid/${id}`,
    method: 'GET'
  })
}
// 退货单 ----------------------------end

// 换货单 ----------------------------start
// 列表
export function queryChangeList(data) {
  return fetch({
    url: `/epapi/change/queryChangeList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增换货单
export function saveChange(data) {
  return fetch({
    url: `/epapi/change/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 换货单详情
export function queryChangeDetail(id) {
  return fetch({
    url: `/epapi/change/queryDetail/${id}`,
    method: 'GET'
  })
}

// 查询符合条件的收货单
export function queryReceiveChangeList(data) {
  return fetch({
    url: `/epapi/receiving/queryReceiveChangeList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 确认
export function confirmChange(id) {
  return fetch({
    url: `/epapi/change/confirm/${id}`,
    method: 'GET'
  })
}

// 作废
export function invalidChange(id) {
  return fetch({
    url: `/epapi/change/invalid/${id}`,
    method: 'GET'
  })
}
// 换货单 ----------------------------end
