import { fetch } from '@/utils'
import store from '@/store'

// 保存商品
export function saveGoods(data) {
  return fetch({
    url: `/epapi/goods/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 商品列表接口
export function queryGoodsList(data) {
  return fetch({
    url: '/epapi/goods/queryGoodsList',
    method: 'POST',
    toast: false,
    data
  })
}

// 商品列表接口
export function queryDetail(id) {
  return fetch({
    url: `/epapi/goods/queryDetail/${id}`,
    method: 'GET'
  })
}

// 上下架删除商品接口
export function upDownDelGoods(data) {
  return fetch({
    url: '/epapi/goods/upDownDelGoods',
    method: 'POST',
    toast: false,
    data
  })
}

// 目录转非目录接口
export function goodsTypeChange(id) {
  return fetch({
    url: `/epapi/goods/goodsTypeChange/${id}`,
    method: 'GET'
  })
}

// 目录商品解约和删除接口
export function disengageDeleteGoods(data) {
  return fetch({
    url: '/epapi/goods/disengageDeleteGoods',
    method: 'POST',
    toast: false,
    data
  })
}

// 价格记录列表接口
export function queryGoodsPriceList(data) {
  return fetch({
    url: '/epapi/goodsPrice/queryGoodsPriceList',
    method: 'POST',
    toast: false,
    data
  })
}

// 价格记录列表接口
export function queryGoodsPriceMinAvg(data) {
  return fetch({
    url: '/epapi/goodsPrice/queryGoodsPriceMinAvg',
    method: 'POST',
    toast: false,
    data
  })
}
