import { fetch } from '@/utils'
import store from '@/store'

// 订单跟踪
export function getOrderCount() {
  return fetch({
    url: `/epapi/home/getOrderCount/${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}

// 需求员采购需求单
export function getRequirementStatistical() {
  return fetch({
    url: `/epapi/home/getRequirementStatistical?empuid=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}

// 采购员采购需求单
export function getTaskStatistical() {
  return fetch({
    url: `/epapi/home/getTaskStatistical?empuid=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}

// 采购员寻源
export function getSourceStatistical() {
  return fetch({
    url: `/epapi/home/getSourceStatistical?empuid=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}

// 图表
export function getStatistical(data) {
  return fetch({
    url: `/epapi/home/getStatistical`,
    method: 'POST',
    toast: false,
    data
  })
}

// 首页头部数据统计
export function getCountStatistics() {
  return fetch({
    url: `soa/home/statistics/countStatistics`,
    method: 'GET'
  })
}

// 首页服务类型统计
export function getConnectorTypeStatistics() {
  return fetch({
    url: `/soa/home/statistics/connectorTypeStatistics`,
    method: 'GET'
  })
}

// 首页资源类型统计
export function getResourceTypeStatistics() {
  return fetch({
    url: `/soa/home/statistics/resourceTypeStatistics`,
    method: 'GET'
  })
}

// 首页常用项目
export function getProject(num) {
  return fetch({
    url: `/soa/home/statistics/getProject/${num}`,
    method: 'GET'
  })
}

// 首页常用服务
export function getProxyService(num) {
  return fetch({
    url: `/soa/home/statistics/getProxyService/${num}`,
    method: 'GET'
  })
}
