import { fetch } from '@/utils'

/**
esbconsole/migration/exportData 这是导出资源的接口
post方式 数据格式如下：
[{
    "id":"bas.esb.console.migrate.service.impl.ESBMigrateService",    （这个ID和name是确定的）
    "name":"ESB资源迁移",
    "migrates":[{
                    "id": "proxyService", (这个就前端自己给了)
                    "name": "代理服务",
                    "query":{      （过滤对象如果不给的话，就会默认把所有的代理服务都导出来）
                        "filters":[{
                            "key":"id",
                            "value":"669123153632428032"
                        }]
                    }
                }]
}]
**/

// 目前只导出，状态码和全局变量

// 导入导出 导出
export function exportData(data) {
  return fetch({
    url: '/migration/exportData',
    method: 'POST',
    toast: false,
    data,
    responseType: 'blob'
  })
}
// 导入导出 导入
export function importData(data) {
  return fetch({
    url: '/migration/importData',
    method: 'POST',
    toast: false,
    data
    // responseType: 'blob'
  })
}
// 导入导出 导入 oracle
export function importDatas(data) {
  return fetch({
    url: '/migration/importOracleData',
    method: 'POST',
    toast: false,
    data
    // responseType: 'blob'
  })
}
export function exportData2() {
  return fetch({
    url: `/migration/listModules`,
    method: 'GET'
  })
}
// 项目列表 根据ID获取项目详情
export function getProjectListDetail(id) {
  return fetch({
    url: `/soa/project/get/${id}`,
    method: 'GET'
  })
}
// 项目列表 保存项目详情
export function saveProjectList(data) {
  return fetch({
    url: '/soa/project/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 项目列表 根据ID删除项目
export function deleteProjectList(id) {
  return fetch({
    url: `/soa/project/delete/${id}`,
    method: 'DELETE'
  })
}
