import { fetch } from '@/utils'
import store from '@/store'

// 计划单列表
export function queryPlanList(data) {
  return fetch({
    url: '/epapi/plan/queryPlanList',
    method: 'POST',
    toast: false,
    data
  })
}

// 计划单详情
export function queryPlanDetail(id) {
  return fetch({
    url: `/epapi/plan/queryPlanDetail/${id}`,
    method: 'GET'
  })
}

// 勾选指定行查询详情
export function queryDetailByPlanNumber(id, number) {
  return fetch({
    url: `/epapi/plan/queryDetailByPlanNumber/${id}/${number}`,
    method: 'GET'
  })
}

// 下发计划生成需求
export function saveRequirement(data) {
  return fetch({
    url: `/epapi/plan/saveRequirement?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 作废
export function invalidPlan(id) {
  return fetch({
    url: `/epapi/plan/invalidPlan/${id}?username=${store.state.app.userInfo.empuid}`,
    method: 'GET'
  })
}
