import { fetch } from '@/utils'

// 项目列表 查询列表
export function queryProjectList(data) {
  return fetch({
    url: '/soa/project/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 项目查询
export function exportDatas(data) {
  return fetch({
    url: '/migrateQuery/query',
    method: 'POST',
    data
  })
}

// 项目列表 根据ID获取项目详情
export function getProjectListDetail(id) {
  return fetch({
    url: `/soa/project/get/${id}`,
    method: 'GET'
  })
}
// 项目列表 保存项目详情
export function saveProjectList(data) {
  return fetch({
    url: '/soa/project/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 项目列表 根据ID删除项目
export function deleteProjectList(id) {
  return fetch({
    url: `/soa/project/delete/${id}`,
    method: 'DELETE'
  })
}

// 项目首页头部信息
export function getCountStatistics(id) {
  return fetch({
    url: `/soa/project/statistics/countStatistics/${id}`,
    method: 'GET'
  })
}

// 项目首页常用代理服务
export function getProxyService(id, num) {
  return fetch({
    url: `/soa/project/statistics/getProxyService/${id}/${num}`,
    method: 'GET'
  })
}

// 项目首页服务类型统计
export function getConnectorTypeStatistics(id) {
  return fetch({
    url: `/soa/project/statistics/connectorTypeStatistics/${id}`,
    method: 'GET'
  })
}

// 项目首页服务类型统计
export function getResourceTypeStatistics(id) {
  return fetch({
    url: `/soa/project/statistics/resourceTypeStatistics/${id}`,
    method: 'GET'
  })
}
