import { fetch } from '@/utils'
import store from '@/store'

// 采购任务单 ----------------------------------------- start

// 任务单列表接口
export function queryTaskList(data) {
  return fetch({
    url: '/epapi/task/queryTaskList',
    method: 'POST',
    toast: false,
    data
  })
}

// 任务单列表接口
export function queryTaskDetail(id) {
  return fetch({
    url: `/epapi/task/queryTaskDetail/${id}`,
    method: 'GET'
  })
}

// 获取项目列表接口
export function queryProjectLevel(code) {
  return fetch({
    url: `/epapi/project/queryProjectLevel/${code}`,
    method: 'GET'
  })
}

// 项目阶段的wbs查询接口
export function queryProjectWbs(data) {
  return fetch({
    url: '/epapi/project/queryProjectWbs',
    method: 'POST',
    toast: false,
    data
  })
}

// 需求单列表接口
export function queryRequirementList(data) {
  return fetch({
    url: '/epapi/requirement/queryRequirementList',
    method: 'POST',
    toast: false,
    data
  })
}

// 新增需求单接口
export function saveRequirement(data) {
  return fetch({
    url: `/epapi/requirement/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 需求单详情接口
export function queryRequirementDetail(id) {
  return fetch({
    url: `/epapi/requirement/queryRequirementDetail/${id}`,
    method: 'GET'
  })
}

// 任务分配接口
export function distribute(data) {
  return fetch({
    url: `/epapi/requirement/distribute`,
    method: 'POST',
    toast: false,
    data
  })
}

// 生成任务单接口
export function saveTask(data) {
  return fetch({
    url: `/epapi/task/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 撤回验证接口
export function reCallVerify(data) {
  return fetch({
    url: '/epapi/task/reCallVerify',
    method: 'POST',
    toast: false,
    data
  })
}

// 撤回接口
export function reCallTask(data) {
  return fetch({
    url: '/epapi/task/reCallTask',
    method: 'POST',
    toast: false,
    data
  })
}

// 采购任务单 ----------------------------------------- end

// 询价 --------------------------------- start

// 新增/编辑询价接口
export function saveInquiry(data) {
  return fetch({
    url: '/epapi/inquiry/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取询价列表接口
export function queryInquiryList(data) {
  return fetch({
    url: '/epapi/inquiry/queryList',
    method: 'POST',
    toast: false,
    data
  })
}

// 询价单详情接口
export function getInquiryInfo(id) {
  return fetch({
    url: `/epapi/inquiry/getInquiryInfoById/${id}`,
    method: 'GET'
  })
}

// 获取提交报价所需信息接口
export function getQuotationBaseInfo(id) {
  return fetch({
    url: `/epapi/inquiry/getQuotationById/${id}`,
    method: 'GET'
  })
}

// 提交报价
export function saveQuoiry(data) {
  return fetch({
    url: `/epapi/inquiry/saveQuoiry`,
    method: 'POST',
    toast: false,
    data
  })
}

// 获取报价列表接口
export function queryQuotationList(data) {
  return fetch({
    url: `/epapi/inquiry/queryQuotationList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 获取报价详情接口
export function getQuotationInfo(id, supplierId) {
  return fetch({
    url: `/epapi/inquiry/getQuotationInfoById/${id}/${supplierId}`,
    method: 'GET'
  })
}

// 询价定价----------------------------
// 询价定价详情
export function queryPriceDetail(id) {
  return fetch({
    url: `/epapi/inquiry/queryPriceList/${id}`,
    method: 'GET'
  })
}

// 保存询价定价
export function savePrice(data) {
  return fetch({
    url: `/epapi/inquiry/savePrice`,
    method: 'POST',
    toast: false,
    data
  })
}

// 拒绝定价
export function refusalpricing(id) {
  return fetch({
    url: `/epapi/inquiry/refusalpricing/${id}`,
    method: 'GET'
  })
}

// 提交审核
export function submitAudit(data) {
  return fetch({
    url: `/epapi/inquiry/submitAudit?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 询价 --------------------------------- end

// 招标 --------------------------------- start

// 列表接口
export function queryTenderList(data) {
  return fetch({
    url: `/epapi/tender/queryTenderList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增和修改分类接口
export function saveTender(data) {
  return fetch({
    url: `/epapi/tender/save?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

export function queryCurrentStage(id) {
  return fetch({
    url: `/epapi/tender/queryCurrentStage/${id}`,
    method: 'GET'
  })
}

// 详情接口
export function queryTenderDetail(currentStage, id) {
  return fetch({
    url: `/epapi/tender/queryTenderDetail/${currentStage}/${id}`,
    method: 'GET'
  })
}

// 第二步 资格审查
// 邀请供应商接口
export function saveApplySupplier(data) {
  return fetch({
    url: `/epapi/tender/saveApplySupplier`,
    method: 'POST',
    toast: false,
    data
  })
}

// 资格审查接口
export function saveQualify(data) {
  return fetch({
    url: `/epapi/tender/saveQualify`,
    method: 'POST',
    toast: false,
    data
  })
}

// 退回需求，调整采购方式接口
export function adjustBuyWay(id) {
  return fetch({
    url: `/epapi/tender/adjustBuyWay/${id}`,
    method: 'GET'
  })
}

// 第三步 招标书编制
// 招标书编制接口
export function saveWriteTender(data) {
  return fetch({
    url: `/epapi/tender/saveWriteTender?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 第四步 发放招标书
// 发放招标书接口
export function saveSubmitTender(id) {
  return fetch({
    url: `/epapi/tender/saveSubmitTender/${id}`,
    method: 'GET'
  })
}

// 第五步 发放招标书
// 供应商投标接口
export function saveSendTender(data) {
  return fetch({
    url: `/epapi/tender/saveSendTender`,
    method: 'POST',
    toast: false,
    data
  })
}

// 终止招标接口
export function endTender(flag, id) {
  return fetch({
    url: `/epapi/tender/endTender/${flag}/${id}`,
    method: 'GET'
  })
}

// 第六步 技术评标
// 技术评标接口
export function saveJudgeTender(data) {
  return fetch({
    url: `/epapi/tender/saveJudgeTender`,
    method: 'POST',
    toast: false,
    data
  })
}

// 第七步 商务议标
// 查看本轮报价验证接口
export function showCurrentPriceVerify(id) {
  return fetch({
    url: `/epapi/tender/showCurrentPriceVerify/${id}`,
    method: 'GET'
  })
}

// 下一轮验证
export function nextVerify(id, type) {
  return fetch({
    url: `/epapi/tender/nextVerify/${id}/${type}`,
    method: 'GET'
  })
}

// 查看本轮报价接口
export function showCurrentPrice(id) {
  return fetch({
    url: `/epapi/tender/showCurrentPrice/${id}`,
    method: 'GET'
  })
}

// 报价失误，重新报价接口
export function againPrice(data) {
  return fetch({
    url: `/epapi/tender/againPrice`,
    method: 'POST',
    toast: false,
    data
  })
}

// 淘汰接口
export function eliminateOffer(data) {
  return fetch({
    url: `/epapi/tender/eliminateOffer`,
    method: 'POST',
    toast: false,
    data
  })
}

// 发起下一轮报价接口
export function nextOfferPrice(id) {
  return fetch({
    url: `/epapi/tender/nextOfferPrice/${id}`,
    method: 'GET'
  })
}

// 终止报价，评标接口
export function endTenderOffer(id) {
  return fetch({
    url: `/epapi/tender/endTenderOffer/${id}`,
    method: 'GET'
  })
}

// 第八步 评标结果
// 评标结果接口
export function saveAssessment(data) {
  return fetch({
    url: `/epapi/tender/saveAssessment?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 第九步 招标结束
// 招标结束接口
export function saveEnd(data) {
  return fetch({
    url: `/epapi/tender/saveEnd?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 退回保证金接口
export function returnMoney(data) {
  return fetch({
    url: `/epapi/tender/returnMoney?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 导入目录商品接口
export function importGoods(suid) {
  return fetch({
    url: `/epapi/goods/importGoods/${suid}`,
    method: 'GET'
  })
}
// 招标 --------------------------------- end

// 根据商品id查询任务单接口
export function queryDetailByTaskNumber(tid, number) {
  return fetch({
    url: `/epapi/task/queryDetailByTaskNumber/${tid}/${number}`,
    method: 'GET'
  })
}
