import { fetch } from '@/utils'
import store from '@/store'

// 弹框选择供应商列表接口
export function querySuplierInfo(data) {
  return fetch({
    url: '/epapi/supplier/querySuplierInfo',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取供应商列表
export function getSupplierList(data) {
  return fetch({
    url: `/epapi/supplier/query?username=${store.state.app.userInfo.empuid}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 供应商审批接口
export function approvalSupplier(data) {
  return fetch({
    url: '/epapi/supplier/saveProcessRecord',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取审批列表接口
export function queryApprovalRecordList(data) {
  return fetch({
    url: '/epapi/supplier/queryApprovalRecordList',
    method: 'POST',
    toast: false,
    data
  })
}

// 禁用启用
export function enableOrDisableSupplier(data) {
  return fetch({
    url: '/epapi/supplier/enableOrDisableSupplier',
    method: 'POST',
    toast: false,
    data
  })
}

// 供应商评级
export function supplierGrade(data) {
  return fetch({
    url: '/epapi/supplier/supplierGrade',
    method: 'POST',
    toast: false,
    data
  })
}

// 重置密码
export function resetPassword(data) {
  return fetch({
    url: '/epapi/supplier/resetPassword',
    method: 'POST',
    toast: false,
    data
  })
}

// 导出
export function exportsuser(data) {
  return fetch({
    url: '/epapi/supplier/exportsuser',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取供应商详情
export function getSupplierDetail(data) {
  return fetch({
    url: `/epapi/supplier/get`,
    method: 'POST',
    toast: false,
    data
  })
}

// 获取供应商供货记录
export function querySupplierOrderList(data) {
  return fetch({
    url: `/epapi/supplier/queryOrderList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 公告列表接口
export function queryNoticeList(data) {
  return fetch({
    url: '/epapi/notice/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 公告新增/编辑接口
export function saveNotice(data) {
  return fetch({
    url: '/epapi/notice/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 公告查看详情接口
export function getNoticeDetail(id) {
  return fetch({
    url: `/epapi/notice/get/${id}`,
    method: 'GET'
  })
}

// 删除公告
export function deleteNotice(id) {
  return fetch({
    url: `/epapi/notice/delete/${id}`,
    method: 'GET'
  })
}

// 黑名单列表接口
export function queryBlacklist(data) {
  return fetch({
    url: '/epapi/supplier/querySupplierDefriendList',
    method: 'POST',
    toast: false,
    data
  })
}

// 拉黑接口
export function saveSupplierDefriend(data) {
  return fetch({
    url: '/epapi/supplier/saveSupplierDefriend',
    method: 'POST',
    toast: false,
    data
  })
}

// 拉黑接口
export function shiftOutBlacklist(data) {
  return fetch({
    url: '/epapi/supplier/updateSupplierDefriendStatus',
    method: 'POST',
    toast: false,
    data
  })
}

// 拒绝供应商列表接口
export function queryTenderRejectSupplier(data) {
  return fetch({
    url: '/epapi/tender/queryTenderRejectSupplier',
    method: 'POST',
    toast: false,
    data
  })
}

// 分页查询可报价的供应商列表
export function queryQuoteSupplierList(data) {
  return fetch({
    url: '/epapi/inquiry/querySupplierList',
    method: 'POST',
    toast: false,
    data
  })
}

// 待审核供应商列表
export function approvalSupplierList(data) {
  return fetch({
    url: '/epapi/approvalSupplier/queryInfo',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取待审核供应商列表详情接口
export function getApprovalSupDetail(id) {
  return fetch({
    url: `/epapi/approvalSupplier/getTetails/${id}`,
    method: 'GET'
  })
}

// 待审核供应商审批接口
export function approvalSupSubmit(data) {
  return fetch({
    url: '/epapi/approvalSupplier/submit',
    method: 'POST',
    toast: false,
    data
  })
}
