import { fetch } from '@/utils'

// ---------------------用户管理--------------------
// 获取员工管理用户列表
export function queryEmployeeList(data) {
  return fetch({
    url: `/epapi/common/queryEmployeeList`,
    method: 'POST',
    toast: false,
    data
  })
}

// ---------------------组织管理--------------------
// 获取所有的根树
export function getAllRootTree() {
  return fetch({
    url: `/epapi/common/getAllRootTree`,
    method: 'GET'
  })
}
// 获取组织树型接口
export function getAllRoot(data) {
  return fetch({
    url: `/epapi/common/getAllRoot`,
    method: 'POST',
    toast: false,
    data
  })
}
// 获取分类的直属子分类
export function getChildren(id) {
  return fetch({
    url: `/epapi/org/tree/getChildren/${id}`,
    method: 'GET'
  })
}

// ---------------------采购关系管理-------------------- start
// 获取采购关系列表接口
export function queryRelationList(data) {
  return fetch({
    url: `/epapi/orgusergoods/queryList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增/修改采购关系
export function saveRelation(data) {
  return fetch({
    url: '/epapi/orgusergoods/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 获取采购关系详情
export function getRelationDetail(id) {
  return fetch({
    url: `/epapi/orgusergoods/get/${id}`,
    method: 'GET'
  })
}

// 删除采购关系
export function deleteRelation(id) {
  return fetch({
    url: `/epapi/orgusergoods/delete/${id}`,
    method: 'DELETE'
  })
}
// ---------------------采购关系管理-------------------- end

// ---------------------角色管理-------------------- start
// 获取角色列表
export function queryAuthroleList(data) {
  return fetch({
    url: '/epapi/authority/role/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 删除角色
export function deleteRole(id) {
  return fetch({
    url: `/epapi/authority/role/delete/${id}`,
    method: 'DELETE'
  })
}

// 授予用户角色
export function userAutoToRole(data) {
  return fetch({
    url: `/epapi/authority/user/assignUserToRole`,
    method: 'POST',
    toast: false,
    data
  })
}

// 给角色批量加用户接口
export function assignUsersToRole(data) {
  return fetch({
    url: `/epapi/common/assignUsersToRole`,
    method: 'POST',
    toast: false,
    data
  })
}

// 移除用户已授予的角色
export function removeUserFromRole(data) {
  return fetch({
    url: `/epapi/authority/user/removeUserFromRole`,
    method: 'DELETE',
    data
  })
}

// 返回被授予指定角色的用户
export function findRoleUsers(id, data) {
  return fetch({
    url: `/epapi/authority/user/findRoleUsers/${id}`,
    method: 'POST',
    toast: false,
    data
  })
}

// 保存角色信息
export function saveRole(data) {
  return fetch({
    url: '/epapi/authority/role/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 根据ID查询角色信息
export function assignPermissions(data) {
  return fetch({
    url: `/epapi/authority/role/assignPermissions`,
    method: 'POST',
    toast: false,
    data
  })
}
// 根据角色ID以及指定类型，获取角色所拥有的该组件的相关权限
export function findPermissions(id) {
  return fetch({
    url: `/epapi/authority/role/findPermissions/${id}/nav`,
    method: 'GET'
  })
}

// 移除角色的权限
export function removePermissions(data) {
  return fetch({
    url: `/epapi/authority/role/removePermissions`,
    method: 'DELETE',
    data
  })
}

// 保存角色的权限
export function reAssignPermissions(data) {
  return fetch({
    url: `/epapi/authority/role/reAssignPermissions`,
    method: 'POST',
    toast: false,
    data
  })
}

// ---------------------角色管理-------------------- end

// ---------------------采购组织-------------------- start
// 采购组列表接口
export function queryProList(data) {
  return fetch({
    url: `/epapi/orgusergoods/queryProList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增/修改采购关系
export function saveProOrg(data) {
  return fetch({
    url: `/epapi/orgusergoods/saveProOrg`,
    method: 'POST',
    toast: false,
    data
  })
}

// 删除采购组
export function deleteProOrg(id) {
  return fetch({
    url: `/epapi/orgusergoods/deleteProOrg/${id}`,
    method: 'DELETE'
  })
}

// 获取采购组下的人员列表接口
export function queryProUserList(data) {
  return fetch({
    url: `/epapi/orgusergoods/queryProUserList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 向采购组添加人员
export function saveProUser(data) {
  return fetch({
    url: `/epapi/orgusergoods/saveProUser`,
    method: 'POST',
    toast: false,
    data
  })
}

// 采购组删除人员
export function deleteProUser(id) {
  return fetch({
    url: `/epapi/orgusergoods/deleteProUser/${id}`,
    method: 'DELETE'
  })
}

// ---------------------采购组织-------------------- end

// ---------------------供应商权限设置-------------------- start

// 查询供应商权限设置接口
export function querySuppermList(data) {
  return fetch({
    url: `/epapi/jurisdictionsettings/getInfo`,
    method: 'POST',
    toast: false,
    data
  })
}

// 查询供应商权限设置详情
export function querySuppermDetail(id) {
  return fetch({
    url: `/epapi/jurisdictionsettings/get/${id}`,
    method: 'GET'
  })
}

// 新增编辑
export function saveSupperm(data) {
  return fetch({
    url: `/epapi/jurisdictionsettings/saveOrUpdate`,
    method: 'POST',
    toast: false,
    data
  })
}

// 启用/禁用
export function enableOrProhibit(data) {
  return fetch({
    url: `/epapi/jurisdictionsettings/enableOrProhibit`,
    method: 'POST',
    toast: false,
    data
  })
}

// 启用/禁用
export function deleteSupperm(id) {
  return fetch({
    url: `/epapi/jurisdictionsettings/delete/${id}`,
    method: 'GET'
  })
}

// ---------------------供应商权限设置-------------------- end

// ---------------------收货地址-------------------- start

// 查询收货地址列表接口
export function queryAddresList(data) {
  return fetch({
    url: `/epapi/addres/queryAddresList`,
    method: 'POST',
    toast: false,
    data
  })
}

// 新增修改收货地址接口
export function saveAddres(data) {
  return fetch({
    url: `/epapi/addres/save`,
    method: 'POST',
    toast: false,
    data
  })
}

// 查询收货地址接口
export function queryAddresInfo(id) {
  return fetch({
    url: `/epapi/addres/queryAddres/${id}`,
    method: 'GET'
  })
}

// 查询收货地址接口
export function deleteAddres(id) {
  return fetch({
    url: `/epapi/addres/deleteAddres/${id}`,
    method: 'DELETE'
  })
}

// 用户ID获取地址信息
export function queryUserIdAddres(data) {
  return fetch({
    url: `/epapi/addres/queryUserIdAddres`,
    method: 'POST',
    toast: false,
    data
  })
}

// ---------------------收货地址-------------------- end

// ---------------------单据设定-------------------- start

// 单据设定页面
export function getOrderset(params) {
  return fetch({
    url: `/epapi/orderset/get`,
    method: 'GET',
    params
  })
}

// 提交单据设定
export function saveOrderset(data) {
  return fetch({
    url: `/epapi/orderset/save`,
    method: 'POST',
    toast: false,
    data
  })
}

// 单据设定记录
export function queryOrdersetRecord(data) {
  return fetch({
    url: `/epapi/orderset/query`,
    method: 'POST',
    toast: false,
    data
  })
}

// ---------------------单据设定-------------------- end

// ---------------------导航配置-------------------- start
// 获取所有导航组
export function getAllGroups(id) {
  return fetch({
    url: `/epapi/navigation/get/${id}/default`,
    method: 'GET'
  })
}
// 根据id获取子导航组
export function getNavigations(id) {
  return fetch({
    url: `/epapi/navigation/getSubTree/${id}/default`,
    method: 'GET'
  })
}
// 根据ID获取导航组（无关权限）
export function getNavAll() {
  return fetch({
    url: `/epapi/navigation/getNavigations/0/default`,
    method: 'GET'
  })
}
// 更换PID
export function changepid(id, pid) {
  return fetch({
    url: `/epapi/navigationext/changepid/${id}/${pid}/default`,
    method: 'GET'
  })
}
// 根据id获取子导航组
export function getList(id) {
  return fetch({
    url: `/epapi/navigation/get/${id}`,
    method: 'GET'
  })
}
// 根据Id获取导航链接
export function getNavigationId(id) {
  return fetch({
    url: `/epapi/navigation/get/${id}`,
    method: 'GET'
  })
}
// 根据Id获取展示编辑页面
export function getNavigationIdShow(id) {
  return fetch({
    url: `/epapi/navigation/show/${id}`,
    method: 'GET'
  })
}
// 保存修改导航
export function saveNavigation(data) {
  return fetch({
    url: `/epapi/navigation/save`,
    method: 'POST',
    toast: false,
    data
  })
}
// 根据ID删除导航以及该导航的子项
export function deleteFull(id) {
  return fetch({
    url: `/epapi/navigation/deleteFull/${id}/default`,
    method: 'DELETE'
  })
}
// ---------------------导航配置-------------------- end
