import { fetch } from '@/utils'

// 版本管理保存
export function versionSave(data) {
  return fetch({
    url: '/consoleversioncontrol/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 版本管理回退
export function versionBackup(data) {
  return fetch({
    url: '/consoleversioncontrol/backup',
    method: 'POST',
    toast: false,
    data
  })
}
// 版本数据查询接口
export function versionQuery(data) {
  return fetch({
    url: '/versionControl/query',
    method: 'POST',
    toast: false,
    data
  })
}


// 查询用户
export function queryUser(data) {
  return fetch({
    url: '/user/v2/query',
    method: 'POST',
    toast: false,
    data
  })
}

// 保存用户
export function saveUser(data) {
  return fetch({
    url: '/user/v2/save',
    method: 'POST',
    toast: false,
    data
  })
}

// 添加用户
export function addUser(data) {
  return fetch({
    url: '/portal/account/new',
    method: 'POST',
    toast: false,
    data
  })
}

// 修改密码
export function resetPw(data) {
  return fetch({
    url: '/portal/security/pwd/reset',
    method: 'PUT',
    toast: false,
    data
  })
}

// 管理员密码重置为默认密码
export function adminResetPw(data) {
  return fetch({
    url: '/portal/security/pwd/reset/admin',
    method: 'PUT',
    toast: false,
    data
  })
}

// 密码重置为默认密码
// /portal/security/pwd/reset/default
// export function resetDefault (params) {
//   return fetch({
//     url: `/portal/security/pwd/reset/default`,
//     method: 'put',
//     params
//   })
// }

// 根据id获取用户
export function getUserDetail(id) {
  return fetch({
    url: `/user/v2/get/${id}`,
    method: 'GET'
  })
}

// 根据id删除用户
export function deleteUser(id) {
  return fetch({
    url: `/user/v2/delete/${id}`,
    method: 'DELETE'
  })
}
// 查询角色
export function queryRole(data) {
  return fetch({
    url: '/authority/role/query',
    method: 'POST',
    toast: false,
    data
  })
}
// 保存角色
export function saveRole(data) {
  return fetch({
    url: '/authority/role/save',
    method: 'POST',
    toast: false,
    data
  })
}
// 删除角色
export function deleteRole(id) {
  return fetch({
    url: `/authority/role/delete/${id}`,
    method: 'DELETE'
  })
}

// 批量删除角色
export function batchDeleteRole(data) {
  return fetch({
    url: `/authority/role/batchDelete`,
    method: 'DELETE',
    data
  })
}
// 移除角色的权限
export function removePermissions(data) {
  return fetch({
    url: `/authority/role/removePermissions`,
    method: 'DELETE',
    data
  })
}
// 根据ID查询角色信息
export function getRoleMsg(id) {
  return fetch({
    url: `/authority/role/get/${id}/`,
    method: 'GET'
  })
}
// 根据ID查询角色信息
export function assignPermissions(data) {
  return fetch({
    url: `/authority/role/assignPermissions`,
    method: 'POST',
    data
  })
}

// 根据
export function reAssignPermissions(data) {
  return fetch({
    url: `/authority/role/reAssignPermissions`,
    method: 'POST',
    data
  })
}

// 根据角色ID以及指定类型，获取角色所拥有的该组件的相关权限
export function findPermissions(id) {
  return fetch({
    url: `/authority/role/findPermissions/${id}/nav`,
    method: 'GET'
  })
}
// 返回被授予指定角色的用户
export function findRoleUsers(id, data) {
  return fetch({
    url: `/authority/user/findRoleUsers/${id}`,
    method: 'POST',
    data
  })
}
// 移除用户已授予的角色
export function removeUserFromRole(data) {
  return fetch({
    url: `/authority/user/removeUserFromRole`,
    method: 'DELETE',
    data
  })
}

// 授予用户角色
export function userAutoToRole(data) {
  return fetch({
    url: `/authority/user/batchAssignUserToRole`,
    method: 'POST',
    data
  })
}
// 批量移除角色中的用户
export function removeRoleUser(data) {
  return fetch({
    url: `/userModel/removeRoleUser`,
    method: 'POST',
    data
  })
}
// 获取所有导航组
export function getAllGroups2(id) {
  return fetch({
    url: `/navigation/getAllGroups`,
    method: 'GET'
  })
}
// 根据ID获取导航组（无关权限）
export function getNavAll2(id) {
  return fetch({
    url: `/navigation/getNavigations/${id}/default`,
    method: 'GET'
  })
}
// 根据ID获取导航组
export function getUserAll3(id) {
  return fetch({
    url: `/navigation/getUserNavigations/0/${id}/default`,
    method: 'GET'
  })
}
// 根据ID获取导航组
export function getNavAll3(id) {
  return fetch({
    url: `/navigation/getCurrentUserNav/${id}/default`,
    method: 'GET'
  })
}
// 根据ID获取导航组
export function getSubTree(id) {
  return fetch({
    url: `/navigation/getSubTree/${id}/default`,
    method: 'GET'
  })
}
// 根据ID删除导航以及该导航的子项
export function deleteFull(id) {
  return fetch({
    url: `/navigation/deleteFull/${id}/default`,
    method: 'DELETE'
  })
}
// 更换PID
export function changepid(id, pid) {
  return fetch({
    url: `/navigationext/changepid/${id}/${pid}/default`,
    method: 'GET'
  })
}
// 根据Id获取展示编辑页面
export function getNavigationIdShow(id) {
  return fetch({
    url: `/bpm/navigation/show/${id}`,
    method: 'GET'
  })
}
// 保存修改导航
export function saveNavigation(data) {
  return fetch({
    url: `/navigation/save`,
    method: 'POST',
    data
  })
}
// 根据id获取子导航组
export function getNavigations(id) {
  return fetch({
    url: `/navigation/getSubTree/${id}/default`,
    method: 'GET'
  })
}

// 根据Id将服务器从域中移除
export function removeServer(id) {
  return fetch({
    url: `/soa/server/remove/${id}`,
    method: 'DELETE'
  })
}

// 查找替换查找文件
export function findQuery(data) {
  return fetch({
    url: `soa/findReplace/query`,
    method: 'POST',
    data
  })
}

// 获取所有环境变量分类
export function getVariables() {
  return fetch({
    url: `soa/findReplace/getType`,
    method: 'GET'
  })
}

// 替换文件
export function replaceRecord(data) {
  return fetch({
    url: `soa/findReplace/replace`,
    method: 'POST',
    data
  })
}