import { createNamespacedHelpers } from 'vuex'
const { mapMutations } = createNamespacedHelpers('app')
export default {
  data() {
    return {
      searchForm: {},
      tableList: [],
      currentRow: {
        id: null
      },
      page: {
        pageNum: 1,
        pageSize: 10,
        total: 0
      },
      quickData: {},
      searchType: '',
      filters: [],
      fullFilters: [],
      searchKey: '',
      logic: 'or',
      quickQueryKeys: [],
      sort: {},
      tableLoading: false,
      dialogFormVisible: false,
      toGetDataCurrent: true,
      dialogClone: false,
      dialogDebug: false,
      rows: {},
      cloneType: ''
    }
  },
  methods: {
    ...mapMutations(['setProjectID', 'setProjectName']),
    search() {
      this.getDataCurrent()
    },
    // 快速搜索
    quickSearch(data) {
      this.quickData = data
      this.searchType = 'quick'
      this.page.pageNum = 1
      this.filters = []
      this.quickQueryKeys.forEach(key => {
        const filter = {
          key,
          opt: 'LIKE',
          type: 'S',
          logic: this.logic,
          value: this.quickData.searchData
        }
        if (filter.value) {
          this.filters.push(filter)
        }
      })
      this.quickQueryData()
    },
    // 高级搜索
    powerSearch() {
      this.searchType = 'power'
      this.page.pageNum = 1
      if (this.$refs.quick) {
        this.$refs.quick.quickReset() // 清除快速查询
      }
      this.filterData(this.searchForm)
      this.getData()
    },
    // 搜索过滤
    filterData(obj) {
      this.filters = []
      Object.keys(obj).forEach(key => {
        const filter = {
          key,
          opt: 'LIKE',
          type: 'S',
          logic: this.logic,
          value: obj[key]
        }
        if (filter.value) {
          this.filters.push(filter)
        }
      })
    },
    userHandle(type, item, cloneType) {
      if (type === 'add') {
        this.handleCurrentChange({})
      } else if (type === 'edit') {
        this.handleCurrentChange(item)
      } else {
        this.rows = item
        this.cloneType = cloneType
      }
      if (type === 'clone') {
        this.dialogClone = true
      } else if (type === 'debug') {
        this.dialogDebug = true
      } else {
        this.dialogFormVisible = true
      }
    },
    cloneEnd(statu) {
      this.dialogClone = false
      this.rows = {}
      this.cloneType = ''
      if (statu) {
        this.rest()
      }
    },
    debugEnd() {
      this.dialogDebug = false
      this.rows = {}
      this.cloneType = ''
    },
    getDataCurrent() {
      this.getData().then((rt) => {
        if (this.tableList.length > 0) {
          this.handleCurrentChange(this.tableList[0])
        }
      })
    },
    handleCurrentChange(val) {
      this.currentRow = val || {}
      if (this.$refs.singleTable) {
        this.$refs.singleTable.setCurrentRow(this.currentRow)
      }
    },
    handleSubmit() {
      if (this.dialogFormVisible) {
        this.dialogFormVisible = false
      }
      this.getData().then((rt) => {
        this.handleCurrentChange({})
        if (this.$route.path === '/esb_service/full_page') {
          console.log(rt)
          this.setProjectID(rt.data[0].id)
          this.setProjectName(rt.data[0].name)
          localStorage.setItem('projectID', rt.data[0].id)
          localStorage.setItem('projectName', rt.data[0].name)
          this.$router.push({
            path: '/project_list/project_page'
          })
        }
      })
    },
    // 重置
    rest() {
      this.searchKey = ''
      this.page.pageNum = 1
      this.searchForm = {}
      this.powerSearch()
    }
  },
  mounted() {
    if (this.toGetDataCurrent) {
      this.getDataCurrent()
    }
  }
}
